/******************************************************************************
File:       smartSetCmd.h
Purpose:    Windows CE. Elo SmartSet command definitions.

Copyright 2008 Elo TouchSystems
All rights reserved

Updated:    2008-09-04

............ notes .........................................................
#define SS_WANT_DEVTYPENAMES to instantiate controllerTypes[]
#define SS_WANT_DEVCLASSNAMES to instantiate controllerClass[]
#define SS_WANT_NVNUMS to instantiate nvClass[] 
******************************************************************************/

#ifndef SMARTSETCMD_H
#define SMARTSETCMD_H

#define CONTROLLER_CLASS_2200		0
#define CONTROLLER_CLASS_2210		1
#define CONTROLLER_CLASS_2310		3
#define CONTROLLER_CLASS_2310B		5
#define CONTROLLER_CLASS_2500S		6
#define CONTROLLER_CLASS_2500U		7
#define CONTROLLER_CLASS_3000U		8
#define CONTROLLER_CLASS_4000U		9	
#define CONTROLLER_CLASS_4000S		10
#define CONTROLLER_CLASS_NgrCoachS	11
#define CONTROLLER_CLASS_NgrCoachU	12
#define CONTROLLER_CLASS_CarSsLite	13
#define CONTROLLER_CLASS_COAChIIs	14
#define CONTROLLER_CLASS_2500SG		15
#define CONTROLLER_CLASS_2701		32 // 27001S & 27001U have the same id
#define CONTROLLER_CLASS_2515_00	34 // 0x22
#define CONTROLLER_CLASS_2515_05	35 // 0x23
#define CONTROLLER_CLASS_2515_07	38 // 0x22? bug? should be 0x26
#define CONTROLLER_CLASS_2521		39 // 0x27
#define CONTROLLER_CLASS_4500U		48
#define CONTROLLER_CLASS_4500S		49
#define CONTROLLER_CLASS_ProjCap	64
#define CONTROLLER_CLASS_5000RSU	65
#define CONTROLLER_CLASS_5020		66
#define CONTROLLER_CLASS_2216		80
#define CONTROLLER_CLASS_Force		96
#define CONTROLLER_CLASS_Apr		113
#define CONTROLLER_CLASS_7010		122

#define isIrController(C) \
C == CONTROLLER_CLASS_4500U || C == CONTROLLER_CLASS_4500S

#ifdef SS_WANT_DEVCLASSNAMES
struct { UCHAR mNum; WCHAR *mName; } controllerClass[] = {
    { 0, _T("2200") },
    { 1, _T("2210") },
    { 3, _T("2310") },
    { 5, _T("2310B") },
    { 6, _T("2500S") },
    { 7, _T("2500U") },
    { 8, _T("3000U") },
    { 9, _T("4000U") },
    { 10, _T("4000S") },
    { 11, _T("NgrCoachS") },
    { 12, _T("NgrCoachU") },
    { 13, _T("CarSsLite") },
    { 14, _T("COACh IIs") },
    { 15, _T("2500SG") },
    { 32, _T("2701") },
    { 34, _T("2515") },
    { 35, _T("2515") },
    { 38, _T("2515") },
    { 39, _T("2521") },
    { 48, _T("4500U") },
    { 49, _T("4500S") },
    { 64, _T("ProjCap") },
    { 65, _T("5000RSU") },
    { 66, _T("5020") },
    { 80, _T("2216") },
    { 96, _T("Force") },
    { 113, _T("Apr") },
    { 122, _T("7010") },
};
#endif

#ifdef SS_WANT_NVNUMS

UCHAR nvClass[] = { 
    CONTROLLER_CLASS_2216,
    CONTROLLER_CLASS_2500SG,
    CONTROLLER_CLASS_2701,    
    CONTROLLER_CLASS_4500S,
    CONTROLLER_CLASS_4500U,
    CONTROLLER_CLASS_5000RSU,
    CONTROLLER_CLASS_2515_00,
    CONTROLLER_CLASS_2515_05,
    CONTROLLER_CLASS_2515_07,
    CONTROLLER_CLASS_2521,
    //9, //CONTROLLER_CLASS_4000U,
    //10, //CONTROLLER_CLASS_4000S,
};

#endif

#ifdef SS_WANT_DEVTYPENAMES

WCHAR Unknown[] = _T("Unknown");

WCHAR *controllerTypes[] = { 
    _T("AccuTouch"),    // '0'
    _T("DuraTouch"),    // '1'
    _T("IntelliTouch"), // '2'
    _T("CarrollTouch"), // '3'
};
WCHAR *controllerIo[] = {
    _T("Serial"),   // '0'
    _T("ISA"),      // '1'
    _T("MCA"),      // '2'
    _T("ADB"),      // '3'
    _T("USB"),      // '4'
};

#endif

enum { FEATURES_ZAXIS = 0x80, FEATURES_RAM = 0x40, FEATURES_RAM32K = 0x20,
FEATURES_XADC = 0x10 };

#pragma pack(1)
// ID response
typedef struct { 
    UCHAR   mI;     // 'I' ID 
    UCHAR   mType;  // '0' = "AccuTouch", '1' = "DuraTouch", '2' = "IntelliTouch", 3 = "CarrollTouch"
    UCHAR   mIo;    // '0' = "Serial", '1' = "ISA", '2' = "MCA", '3' = "ADB", '4' = "USB"
    UCHAR   mFeatures;
    UCHAR   mMinorRev;
    UCHAR   mMajorRev;
    UCHAR   mCfgPktCnt;
    UCHAR   mClass; // 0 = "E271-2200", 1 = "E271-2210"...
}   RxPktId;            

// Mode command and response
typedef struct {
    UCHAR   cmd;        // 'M' Mode
    UCHAR   zero;
    UCHAR   mMask1;
    UCHAR   mMask2;
    UCHAR   dum0;
    UCHAR   dum1;
    UCHAR   dum2;
    UCHAR   dum3;
}   PktMode;            // Transmit and receive.

typedef enum { CS_READ, CS_WRITE } CsDir;

const UCHAR SS_READ_CALIB       = 'c';
const UCHAR SS_READ_SCALING     = 's';
const UCHAR SS_WRITE_CALIB      = 'C';
const UCHAR SS_WRITE_SCALING    = 'S';
const UCHAR SS_WRITE_RX         = 'X';
const UCHAR SS_WRITE_RY         = 'Y';
const UCHAR SS_WRITE_RZ         = 'Z';
const UCHAR SS_WRITE_ONDX       = 'x';
const UCHAR SS_WRITE_ONDY       = 'y';
const UCHAR SS_WRITE_ONDZ       = 'z';
const UCHAR SS_READ_X           = 'x';
const UCHAR SS_READ_Y           = 'y';
const UCHAR SS_READ_Z           = 'z';
const UCHAR SS_WRITE_NV			= 'N'; // We only write this command. mDir refers to in controller.

const UCHAR SS_WRITERANGE_CALIB = 'C';
const UCHAR SS_WRITERANGE_SCALING = 'S';

typedef struct 
{ 
    UCHAR mCmd; // Write = 'C' Calibrate or 'S' Scaling; read = 'c' or 's'.
    UCHAR mAxis;
    void getCmdAxis( CsDir dir, UCHAR axisBase );
}   CsAxis; 

// Read/Write Calibration/Scaling by Offset-Numerator-Denominator
class PktCsOnd : public CsAxis //  axis = 'x', 'y', or 'z'
{
public:
    USHORT  mOffset;
    USHORT  mNumerator;
    USHORT  mDenominator;
    void put( USHORT *src ) { memcpy( &mOffset, src, 6 ); }
    void get( USHORT *src ) { memcpy( src, &mOffset, 6 ); }
};  // Transmit and receive.

// Write Calibration/Scaling by High-Low command
typedef struct : public CsAxis // axis = 'X', 'Y', or 'Z'
{
    USHORT  mLow;
    USHORT  mHigh;
    UCHAR   dum0;
    UCHAR   dum1;
}   TxPktCsRange;       // Only Transmit.

// NVRam read/write command
enum { NVREAD = 0, NVWRITE = 1 };
enum { NVPAGE0 = 0, NVPAGE1 = 1 };
enum { NVA_SETUP = 1, NVA_CALIB = 2, NVA_SCALING = 4 };
typedef struct {
    UCHAR   mCmd;	// 'N' NVRam read/write command
    UCHAR   mDir;   // NVREAD or NVWRITE (transfer direction within controller)
    UCHAR   mArea;  // NVA_SETUP +   NVA_CALIB + NVA_SCALING
    UCHAR   mPage;  // NVPAGE0 or NVPAGE1
    UCHAR   dum0;
    UCHAR   dum1;
    UCHAR   dum2;
    UCHAR   dum3;
}   TxPktNv;		// Transmit only. mDir refers to direction inside controller.

#pragma pack()

typedef union { 
	PktCsOnd		mCsOnd;		// Tx/Rx
	PktMode			mMode;		// Tx/Rx
	TxPktNv			mNv;		// Tx
	TxPktCsRange	mCsRange;	// Tx
	RxPktId			mId;		// Rx
}	SsPkt;

#define SsPktCsOnd(P)		((SsPkt&)P).mCsOnd  
#define SsPktMode(P)		((SsPkt&)P).mMode  
#define SsPktNv(P)			((SsPkt&)P).mNv 
#define SsPktCsRange(P)		((SsPkt&)P).mCsRange
#define SsPktId(P)			((SsPkt&)P).mId  

#endif // ndef SMARTSETCMD_H
