/******************************************************************************
File:        eloRegNames.h
Purpose:     Windows CE. Registry key and value names used by Elo touchscreen
drivers and applications.

Copyright 2008 Elo TouchSystems
All rights reserved

Updated:    2008-09-04
******************************************************************************/

#ifndef ELOREGNAMES_H
#define ELOREGNAMES_H

#define ELOREG_TOUCH_DRIVER     _T("\\HARDWARE\\DEVICEMAP\\TOUCH")
#define ELOREG_TOUCH_DRIVER_SER _T("\\HARDWARE\\DEVICEMAP\\TOUCH\\SER")
#define ELOREG_TOUCH_DRIVER_USB _T("\\HARDWARE\\DEVICEMAP\\TOUCH\\USB")
#define ELOREG_TOUCH_SOUND      _T("\\HARDWARE\\DEVICEMAP\\TOUCH\\SOUND")
#define ELOREG_ELOVA            _T("\\HARDWARE\\DEVICEMAP\\TOUCH\\ELOVA")

#define ELOREG_ElovaTime1		_T("Time1")
#define ELOREG_ElovaTime2		_T("Time2")
#define ELOREG_ElovaTime3		_T("Time3")
#define ELOREG_ElovaCal		    _T("Cal")
#define ELOREG_ElovaDTH		    _T("DisableTouch-Hold")
#define ELOREG_ElovaGEHC	    _T("GEHC")                  // for GE Healthcare

enum { CAL_FLUSHREG = 0x100, CAL_ALWAYSWRITE = 0x200, 
    CAL_IF_3PT = 0, CAL_IF_EDGE = 1, CAL_UNCONDITIONAL = 2 }; // EloVa Cal flags

#define ELOREG_Multimon         _T("Multimon")
#define ELOREG_Orient			_T("Orient")
typedef enum {
    EloRegIdxMultimon,
    EloRegIdxOrient,
}   EloRegGlobalId;

// ......... Cfg group must match order in EloDev:regDev.cpp ...........
#define ELOREG_Priority         _T("Priority256")
#define ELOREG_HighPriority     _T("HighPriority256")
#define ELOREG_AntiBounce       _T("AntiBounce")
#define ELOREG_MouseMode        _T("MouseMode")
#define ELOREG_OnTouch          _T("OnTouch")
#define ELOREG_TouchTick        _T("TouchTick")       
#define ELOREG_HoldJiggle       _T("HoldJiggle")      
#define ELOREG_UntouchTickCount _T("UntouchTickCount")
#define ELOREG_HoldEventTick    _T("HoldEventTick")   
#define ELOREG_HoldShowTick     _T("HoldShowTick")    
#define ELOREG_HoldShowStep     _T("HoldShowStep")    
#define ELOREG_CalStore         _T("CalStore" )
//................. Cal group ...........................
#define ELOREG_Cal              _T("Cal" )
#define ELOREG_EdgeCalCfg       _T("EdgeCalCfg")
#define ELOREG_EdgeTarget       _T("EdgeTarget")
#define ELOREG_LinCor           _T("LinCor")
#define ELOREG_LinCorType       _T("LinCorType")
#define ELOREG_EdgeAcc          _T("EdgeAcc")
#define ELOREG_CornerAcc        _T("CornerAcc")
#define ELOREG_SWAPXY           _T("SWAPXY") 
#define ELOREG_OFFX             _T("OFFX")            
#define ELOREG_TSDX             _T("TSDX")            
#define ELOREG_VIDX             _T("VIDX")            
#define ELOREG_OFFY             _T("OFFY")            
#define ELOREG_TSDY             _T("TSDY")            
#define ELOREG_VIDY             _T("VIDY")  
//................. Serial group ............... 
#define ELOREG_ComPort          _T("ComPort")     
#define ELOREG_HWHandShaking    _T("HWHandShaking")
         
typedef enum { 
// items accessible through IOCTL_ELO_CFGITEM
    EloRegIdxPriority,          
    EloRegIdxHighPriority,          
    EloRegIdxAntiBounce,          
    EloRegIdxMouseMode,          
    EloRegIdxOnTouch,  
    EloRegIdxTouchTick,         // HoldParms.mP[ HPIDX_TICK ]        
    EloRegIdxHoldJiggle,        // HoldParms.mP[ HPIDX_JIGGLE ]  
    EloRegIdxUntouchTickCount,  // HoldParms.mP[ HPIDX_UNTOUCH_TICKS ]        
    EloRegIdxHoldEventTick,     // HoldParms.mP[ HPIDX_EVENT_TICKS ]     
    EloRegIdxHoldShowTick,      // HoldParms.mP[ HPIDX_SHOW_TICKS ]    
    EloRegIdxHoldShowStep,      // HoldParms.mP[ HPIDX_SHOW_STEP ]    
    EloRegIdxCalStore, 
// items not accessible through IOCTL_ELO_CFGITEM
    EloRegIdxCal, 
    EloRegIdxEdgeCalCfg,          
    EloRegIdxEdgeTarget,          
    EloRegIdxLinCor,          
    EloRegIdxLinCorType,          
    EloRegIdxEdgeAcc,          
    EloRegIdxCornerAcc,          
    EloRegIdxSWAPXY,          
    EloRegIdxOFFX,          
    EloRegIdxTSDX,          
    EloRegIdxVIDX,          
    EloRegIdxOFFY,          
    EloRegIdxTSDY,          
    EloRegIdxVIDY,          
    EloRegIdxComPort, 
    EloRegIdxHWHandShaking,          
}	EloRegItemId;

enum { ECFG_LEFT = 1, ECFG_TOP = 2, ECFG_RIGHT = 4, ECFG_BOTTOM = 8, 
        ECFG_ADJEDGE = 16 }; // EdgeCalCfg flags.

enum { CALSTORE_READNV = 1, CALSTORE_READREG = 2, CALSTORE_WRITENV = 0x10, 
    CALSTORE_WRITEREG = 0x20, CALSTORE_FLUSHREG = 0x100 }; // CalStore flags

#define MIN_PRIORITY 3 
#define MAX_PRIORITY 255
#define DEFAULT_PRIORITY 109

#define MAX_ANTIBOUNCE 775

#endif  // ndef ELOREGNAMES_H



