/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.viewmodel

import android.annotation.SuppressLint
import android.content.Context
import android.content.IntentFilter
import android.os.Build
import android.os.Handler
import android.os.Looper
import android.provider.Settings
import android.util.Log
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.lifecycle.ViewModel
import com.eloview.sdk.accountManager.AccountManager
import com.eloview.sdk.systemManager.ServiceConnectionCallback
import com.eloview.sdk.systemManager.System
import com.eloview.sdk.testapp.GlobalClass
import com.eloview.sdk.testapp.systemActivity.KeyReceiver
import com.eloview.sdk.testapp.systemActivity.SystemActivity
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import java.io.File
import java.io.FileOutputStream
import java.io.IOException
import java.io.InputStream
import java.lang.ref.WeakReference

data class SystemActivityState(
    var serviceConnected: Boolean = false,
    var noRebootOrientationChecked: Boolean = true,
    var noRebootPollIntervalChecked: Boolean = false,
    var adbPort: Int? = null,
    var brightness: Int? = null,
    var accessibilityServiceComponentName: String = "pkgname/classname",
    var screenWakeUpDelay: Int? = null,
    var selectedFontSize: String = "Default",
    var selectedDisplaySize: String = "Select a Display Size",
    var selectedBacklightTimeout: String = "Never",
    var selectedLockType: String = "Swipe",
    var isGetLockeTypePressed: Boolean = false,
    var selectedDPI: String = "Select DPI",
    var resolutionWidth: Int? = null,
    var resolutionHeight: Int? = null,
    var selectedCFDDPI: String = "Select External display DPI",
    var selectedWiFiMacAddress: String = "Use randomized MAC",
    var noRebootNtpUrlChecked: Boolean = false,
    var ntpUrl: String = "",
    var hostName: String = "",
    var selectedVolumeType: String = "All",
    var screenShotPath: String = "",
    var output: String = "",
    var selectedOrientation: String = "landscape (0)",
    var selectedExternalScreenOrientation: String = "0",
    var selectedNonBPOrientation: String = "auto-rotate",
    var silentShutdownDelay: Int = 3,
    var selectedReservedLogSpaceIndex: Int = 0,
    var barcodeReaderEnabled: Boolean = false,
    var selectedInstallPermissionForSpecificAppEnabled: Boolean = false,
    var selectedInstallPermissionForSpecificAppPackageName: String = "",
    var setAccessibilityServiceEnabled: Boolean = false,
    var firmwareLocked: Boolean = false,
    var clearAppCacheAndUserDataPackages: String = "",
    var clearAllAppCacheAndUserDataPackages: String = "",
    var silentDefaultLauncher: String = "",
    var getInstallPermissionToSpecificApp: String = "",
    var setVolumeValue: Int? = null,
    var setTimezone: String = "",
    var setLanguage: String = "",
    var showSetLanguageDialog: Boolean = false,
    var ntpPollInterval: String = "",
    var oldPassword: String = "",
    var newPassword: String = "",
    var askForPasswordOnBoot: Boolean = true,
    var oldPin: String = "",
    var newPin: String = "",
    var askForPinOnBoot: Boolean = true,
    var deviceOwnerPackage: String = "",
    var deviceOwnerReceiver: String = "",
    var foregroundServicePackageName: String = "",
    var smallestPixelWidth: Int? = null,
    var showSilentShutdownDialog: Boolean = false,
    var showDatePickerDialog: Boolean = false,
    var showFactoryResetDialog: Boolean = false,
    var showScreenWakeUpDialog: Boolean = false,
    var showCaptureScreenshotDialog: Boolean = false,
    var showSetInstallPermissionForSpecificAppDialog: Boolean = false,
    var showGetInstallPermissionForSpecificAppDialog: Boolean = false,
    var showAccessibilityDialog: Boolean = false,
    var showSetTimeZoneDialog: Boolean = false,
    var showSetDpiDialog: Boolean = false,
    var showSetCFDDpiDialog: Boolean = false,
    var showReservedLogSpaceDialog: Boolean = false,
    var showSetLockTypeDialog: Boolean = false,
    var showSetAdbPortDialog: Boolean = false,
    var showSetDeviceBrightnessDialog: Boolean = false,
    var showClearAppCacheAndUserDataDialog: Boolean = false,
    var showClearAllAppCacheAndUserDataDialog: Boolean = false,
    var showSetSilentDefaultLauncherDialog: Boolean = false,
    var showSetVolumeDialog: Boolean = false,
    var showSetWiFiMacAddressDialog: Boolean = false,
    var showSetFontSizeDialog: Boolean = false,
    var showDisplaySizeDialog: Boolean = false,
    var showSetBacklightTimeoutDialog: Boolean = false,
    var showSetPollIntervalDialog: Boolean = false,
    var showSetPasswordDialog: Boolean = false,
    var showSetPinDialog: Boolean = false,
    var showSetDeviceOwnerDialog: Boolean = false,
    var showSetResolutionDialog: Boolean = false,
    var showStartActivityFromForegroundServiceDialog: Boolean = false,
    var showSetSmallestWidthDialog: Boolean = false,
    var showSetNtpUrlDialog: Boolean = false,
    var showSetHostNameDialog: Boolean = false,
    var showSetKeyListenerDialog: Boolean = false,
    var showSetKeyInterceptionDialog: Boolean = false,
    var selectedKeyListenerValues: Array<String> = emptyArray(),
    var showSetOrientationDialog: Boolean = false,
    var showSetExternalOrientationDialog: Boolean = false,
    val showRebootWarningDialog: Boolean = false,
    var showGetSystemPropertyDialog: Boolean = false,
    var getSystemProperty: String = "",
    var showSetMediaProjectionPermissionForPackageDialog: Boolean = false,
    var mediaProjectionPermissionPackage: String = "",
    var showGetMD5ChecksumDialog: Boolean = false,
    var currentLockPassword: String? = null,
    var showSetLockTypeWithPasswordDialog: Boolean = false,
    @SuppressLint("SdCardPath") var getMD5ChecksumFilePath: String = "",
    var showDownloadAndConvertZipFileToByteArrayDialog: Boolean = false,
)

class SystemActivityViewModel(val applicationContext: Context, preview: Boolean = false) :
    ViewModel(),
    ServiceConnectionCallback {
    companion object {
        private const val TAG = "SystemActivityViewModel"
        var isPreview: Boolean = false
        internal const val SUCCESS_CODE = 0
        const val ERROR_SINGLE_APP_MODE = -400
        const val ERROR_OTHER = -401
    }

    val systemServiceManager = if (preview) {
        isPreview = true
        null
    } else {
        isPreview = false
        System()
    }

    private val systemHandler: Handler = Handler(Looper.getMainLooper()) { msg ->
        val b = msg.data
        val key = msg.what.toString()
        var `val` = b.getString(key)
        when (msg.what) {
            AccountManager.TOKEN_VERIFY_FAIL -> {
                Log.v(TAG, "Invalid accessToken")
                `val` = "INVALID TOKEN\n$`val`"
                unbindService()
            }

            AccountManager.TOKEN_VERIFY_SUCCESS -> {
                Log.v(TAG, "Token available")
                `val` = "Token: $`val`"
            }

            System.RECEIVE_KEY_EVENT -> {
                Log.d(TAG, "RECEIVE_KEY_EVENT $`val`")
                `val` = "KEY EVENT:\n$`val`"
            }
        }
        if (`val` != null) {
            setOutput(`val`)
        }
        false
    }

    private val keyReceiver: KeyReceiver = KeyReceiver(WeakReference<Handler>(systemHandler))

    private val _systemActivityState = MutableStateFlow(SystemActivityState())
    val systemActivityState: StateFlow<SystemActivityState> = _systemActivityState.asStateFlow()
    private fun setServiceConnected(serviceConnected: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(serviceConnected = serviceConnected)
    }

    @SuppressLint("UnspecifiedRegisterReceiverFlag")
    fun registerKeyReceiver(register: Boolean) {
        try {
            if (register) {
                val filter = IntentFilter("com.elo.secure.action.INTERCEPT_KEY_EVENT")
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                    applicationContext.registerReceiver(
                        keyReceiver, filter,
                        Context.RECEIVER_EXPORTED
                    )
                } else {
                    applicationContext.registerReceiver(keyReceiver, filter)
                }
            } else {
                applicationContext.unregisterReceiver(keyReceiver)
            }
        } catch (e: Exception) {
            Log.e(TAG, "registerKeyReceiver: ${e.message}")
        }
    }

    // Check if the user is in Single App mode
    fun isInSingleAppMode(): Boolean {
        val multiApp = Settings.Secure.getInt(applicationContext.contentResolver, "eloview_multiapp_mode", -1)
        val connect = Settings.Secure.getString(applicationContext.contentResolver, "elo_device_mode")
        Log.d(TAG, "multiApp sdk - $multiApp")
        Log.e(TAG, "connect = $connect")
        return multiApp == 0 && connect != null && connect != "connect"
    }

    fun setNoRebootOrientationChecked(noRebootChecked: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(noRebootOrientationChecked = noRebootChecked)
    }

    fun getServiceConnected(): Boolean {
        return _systemActivityState.value.serviceConnected
    }

    fun getNoRebootOrientationChecked(): Boolean {
        return _systemActivityState.value.noRebootOrientationChecked
    }

    fun setAdbPort(adbPort: Int) {
        _systemActivityState.value = _systemActivityState.value.copy(adbPort = adbPort)
    }

    fun getAdbPort(): Int {
        return _systemActivityState.value.adbPort!!
    }

    fun setDeviceBrightness(brightness: Int) {
        _systemActivityState.value = _systemActivityState.value.copy(brightness = brightness)
    }

    fun getDeviceBrightness(): Int {
        return _systemActivityState.value.brightness!!
    }

    fun setAccessibilityServiceComponentName(accessibilityServiceComponentName: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(accessibilityServiceComponentName = accessibilityServiceComponentName)
    }

    fun getAccessibilityServiceComponentName(): String {
        return _systemActivityState.value.accessibilityServiceComponentName
    }

    fun setScreenWakeUpDelay(delay: Int) {
        _systemActivityState.value = _systemActivityState.value.copy(screenWakeUpDelay = delay)
    }

    fun getScreenWakeUpDelay(): Int {
        return _systemActivityState.value.screenWakeUpDelay!!
    }

    fun setSelectedFontSize(fontSize: String) {
        _systemActivityState.value = _systemActivityState.value.copy(selectedFontSize = fontSize)
    }

    fun getSelectedFontSize(): String {
        return _systemActivityState.value.selectedFontSize
    }

    fun setSelectedDisplaySize(displaySize: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedDisplaySize = displaySize)
    }

    fun getSelectedDisplaySize(): String {
        return _systemActivityState.value.selectedDisplaySize
    }

    fun setSelectedBacklightTimeout(backlightTimeout: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedBacklightTimeout = backlightTimeout)
    }

    fun getSelectedBacklightTimeout(): String {
        return _systemActivityState.value.selectedBacklightTimeout
    }

    fun setSelectedLockType(lockType: String) {
        _systemActivityState.value = _systemActivityState.value.copy(selectedLockType = lockType)
    }

    fun getSelectedLockType(): String {
        return _systemActivityState.value.selectedLockType
    }

    fun setIsGetLockTypePressed(isPressed : Boolean) {
        _systemActivityState.value.isGetLockeTypePressed = isPressed
        _systemActivityState.value = _systemActivityState.value.copy(isGetLockeTypePressed = isPressed)
    }

    fun getIsGetLockTypePressed(): Boolean {
        return _systemActivityState.value.isGetLockeTypePressed
    }

    fun setNoRebootPollIntervalChecked(noRebootPollIntervalChecked: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(noRebootPollIntervalChecked = noRebootPollIntervalChecked)
    }

    fun getNoRebootPollIntervalChecked(): Boolean {
        return _systemActivityState.value.noRebootPollIntervalChecked
    }

    fun setSelectedDPI(dpi: String) {
        _systemActivityState.value = _systemActivityState.value.copy(selectedDPI = dpi)
    }

    fun getSelectedDPI(): String {
        return _systemActivityState.value.selectedDPI
    }

    fun setSelectedCFDDPI(dpi: String) {
        _systemActivityState.value = _systemActivityState.value.copy(selectedCFDDPI = dpi)
    }

    fun getSelectedCFDDPI(): String {
        return _systemActivityState.value.selectedCFDDPI
    }

    fun setResolutionWidth(resolutionWidth: Int) {
        _systemActivityState.value =
            _systemActivityState.value.copy(resolutionWidth = resolutionWidth)
    }

    fun getResolutionWidth(): Int {
        return _systemActivityState.value.resolutionWidth!!
    }

    fun setResolutionHeight(resolutionHeight: Int) {
        _systemActivityState.value =
            _systemActivityState.value.copy(resolutionHeight = resolutionHeight)
    }

    fun getResolutionHeight(): Int {
        return _systemActivityState.value.resolutionHeight!!
    }

    fun setSelectedWiFiMacAddress(wiFiMacAddress: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedWiFiMacAddress = wiFiMacAddress)
    }

    fun getSelectedWiFiMacAddress(): String {
        return _systemActivityState.value.selectedWiFiMacAddress
    }

    fun setNoRebootNtpUrlChecked(noRebootNtpUrlChecked: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(noRebootNtpUrlChecked = noRebootNtpUrlChecked)
    }

    fun getNoRebootNtpUrlChecked(): Boolean {
        return _systemActivityState.value.noRebootNtpUrlChecked
    }

    fun setNtpUrl(ntpUrl: String) {
        _systemActivityState.value = _systemActivityState.value.copy(ntpUrl = ntpUrl)
    }

    fun getNtpUrl(): String {
        return _systemActivityState.value.ntpUrl
    }

    fun setHostName(hostName: String) {
        _systemActivityState.value = _systemActivityState.value.copy(hostName = hostName)
    }

    fun getHostName(): String {
        return _systemActivityState.value.hostName
    }

    fun setMediaProjectionPermissionPackage(pkgName: String){
        _systemActivityState.value = _systemActivityState.value.copy(mediaProjectionPermissionPackage = pkgName)
    }

    fun getMediaProjectionPermissionPackage(): String {
        return _systemActivityState.value.mediaProjectionPermissionPackage
    }

    fun setSelectedVolumeType(volumeType: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedVolumeType = volumeType)
    }

    fun getSelectedVolumeType(): String {
        return _systemActivityState.value.selectedVolumeType
    }

    fun setScreenShotPath(screenShotPath: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(screenShotPath = screenShotPath)
    }

    fun getScreenShotPath(): String {
        return _systemActivityState.value.screenShotPath
    }

    fun setOutput(output: String) {
        _systemActivityState.value = _systemActivityState.value.copy(output = output)
    }

    fun getOutput(): String {
        return _systemActivityState.value.output
    }

    fun setSelectedOrientation(orientation: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedOrientation = orientation)
    }

    fun getSelectedOrientation(): String {
        return _systemActivityState.value.selectedOrientation
    }

    fun setSelectedExternalOrientation(orientation: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedExternalScreenOrientation = orientation)
    }

    fun getSelectedExternalOrientation(): String {
        return _systemActivityState.value.selectedExternalScreenOrientation
    }

    fun setSelectedNonBPOrientation(nonBPOrientation: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedNonBPOrientation = nonBPOrientation)
    }

    fun getSelectedNonBPOrientation(): String {
        return _systemActivityState.value.selectedNonBPOrientation
    }

    fun setSilentShutdownDelay(delay: Int) {
        _systemActivityState.value = _systemActivityState.value.copy(silentShutdownDelay = delay)
    }

    fun getSilentShutdownDelay(): Int {
        return _systemActivityState.value.silentShutdownDelay
    }

    fun setReservedLogSpaceIndex(index: Int) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedReservedLogSpaceIndex = index)
    }

    fun getReservedLogSpaceIndex(): Int {
        return _systemActivityState.value.selectedReservedLogSpaceIndex
    }

    fun setBarcodeReaderEnabled(enabled: Boolean) {
        _systemActivityState.value = _systemActivityState.value.copy(barcodeReaderEnabled = enabled)
    }

    fun getBarcodeReaderEnabled(): Boolean {
        return _systemActivityState.value.barcodeReaderEnabled
    }

    fun setSelectedInstallPermissionForSpecificAppEnabled(enabled: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedInstallPermissionForSpecificAppEnabled = enabled)
    }

    fun getSelectedInstallPermissionForSpecificAppEnabled(): Boolean {
        return _systemActivityState.value.selectedInstallPermissionForSpecificAppEnabled
    }

    fun setSelectedInstallPermissionForSpecificAppPackageName(packageName: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedInstallPermissionForSpecificAppPackageName = packageName)
    }

    fun getSelectedInstallPermissionForSpecificAppPackageName(): String {
        return _systemActivityState.value.selectedInstallPermissionForSpecificAppPackageName
    }

    fun setSetAccessibilityServiceEnabled(enabled: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(setAccessibilityServiceEnabled = enabled)
    }

    fun getSetAccessibilityServiceEnabled(): Boolean {
        return _systemActivityState.value.setAccessibilityServiceEnabled
    }

    fun setFirmwareLocked(locked: Boolean) {
        _systemActivityState.value = _systemActivityState.value.copy(firmwareLocked = locked)
    }

    fun getFirmwareLocked(): Boolean {
        return _systemActivityState.value.firmwareLocked
    }

    fun setClearAppCacheAndUserDataPackages(packages: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(clearAppCacheAndUserDataPackages = packages)
    }

    fun getClearAppCacheAndUserDataPackages(): String {
        return _systemActivityState.value.clearAppCacheAndUserDataPackages
    }

    fun setClearAllAppCacheAndUserDataPackages(packages: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(clearAllAppCacheAndUserDataPackages = packages)
    }

    fun getClearAllAppCacheAndUserDataPackages(): String {
        return _systemActivityState.value.clearAllAppCacheAndUserDataPackages
    }

    fun setSilentDefaultLauncher(packageName: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(silentDefaultLauncher = packageName)
    }

    fun getSilentDefaultLauncher(): String {
        return _systemActivityState.value.silentDefaultLauncher
    }

    fun setGetInstallPermissionToSpecificApp(packageName: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(getInstallPermissionToSpecificApp = packageName)
    }

    fun getGetInstallPermissionToSpecificApp(): String {
        return _systemActivityState.value.getInstallPermissionToSpecificApp
    }

    fun setSetVolumeValue(volumeValue: Int) {
        _systemActivityState.value = _systemActivityState.value.copy(setVolumeValue = volumeValue)
    }

    fun getSetVolumeValue(): Int {
        return _systemActivityState.value.setVolumeValue!!
    }

    fun setSetTimezone(timezone: String) {
        _systemActivityState.value = _systemActivityState.value.copy(setTimezone = timezone)
    }

    fun getSetTimezone(): String {
        return _systemActivityState.value.setTimezone
    }

    fun setSetLanguage(language: String) {
        _systemActivityState.value = _systemActivityState.value.copy(setLanguage = language)
    }

    fun getSetLanguage(): String {
        return _systemActivityState.value.setLanguage
    }

    fun setNtpPollInterval(interval: String) {
        _systemActivityState.value = _systemActivityState.value.copy(ntpPollInterval = interval)
    }

    fun getNtpPollInterval(): String {
        return _systemActivityState.value.ntpPollInterval
    }

    fun setOldPassword(password: String) {
        _systemActivityState.value = _systemActivityState.value.copy(oldPassword = password)
    }

    fun getOldPassword(): String {
        return _systemActivityState.value.oldPassword
    }

    fun setNewPassword(password: String) {
        _systemActivityState.value = _systemActivityState.value.copy(newPassword = password)
    }

    fun getNewPassword(): String {
        return _systemActivityState.value.newPassword
    }

    fun setAskForPasswordOnBoot(askForPasswordOnBoot: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(askForPasswordOnBoot = askForPasswordOnBoot)
    }

    fun getAskForPasswordOnBoot(): Boolean {
        return _systemActivityState.value.askForPasswordOnBoot
    }

    fun setOldPin(pin: String) {
        _systemActivityState.value = _systemActivityState.value.copy(oldPin = pin)
    }

    fun getOldPin(): String {
        return _systemActivityState.value.oldPin
    }

    fun setNewPin(pin: String) {
        _systemActivityState.value = _systemActivityState.value.copy(newPin = pin)
    }

    fun getNewPin(): String {
        return _systemActivityState.value.newPin
    }

    fun setAskForPinOnBoot(askForPinOnBoot: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(askForPinOnBoot = askForPinOnBoot)
    }

    fun getAskForPinOnBoot(): Boolean {
        return _systemActivityState.value.askForPinOnBoot
    }

    fun setDeviceOwnerPackage(packageName: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(deviceOwnerPackage = packageName)
    }

    fun getDeviceOwnerPackage(): String {
        return _systemActivityState.value.deviceOwnerPackage
    }

    fun setDeviceOwnerReceiver(receiver: String) {
        _systemActivityState.value = _systemActivityState.value.copy(deviceOwnerReceiver = receiver)
    }

    fun getDeviceOwnerReceiver(): String {
        return _systemActivityState.value.deviceOwnerReceiver
    }

    fun setForegroundServicePackageName(packageName: String) {
        _systemActivityState.value =
            _systemActivityState.value.copy(foregroundServicePackageName = packageName)
    }

    fun getForegroundServicePackageName(): String {
        return _systemActivityState.value.foregroundServicePackageName
    }

    fun setSmallestPixelWidth(width: Int?) {
        _systemActivityState.value = _systemActivityState.value.copy(smallestPixelWidth = width)
    }

    fun getSmallestPixelWidth(): Int {
        return _systemActivityState.value.smallestPixelWidth!!
    }

    fun setShowSilentShutdownDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSilentShutdownDialog = showDialog)
    }

    fun getShowSilentShutdownDialog(): Boolean {
        return _systemActivityState.value.showSilentShutdownDialog
    }

    fun setShowDatePickerDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showDatePickerDialog = showDialog)
    }

    fun getShowDatePickerDialog(): Boolean {
        return _systemActivityState.value.showDatePickerDialog
    }

    fun setShowFactoryResetDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showFactoryResetDialog = showDialog)
    }

    fun getShowFactoryResetDialog(): Boolean {
        return _systemActivityState.value.showFactoryResetDialog
    }

    fun setShowScreenWakeUpDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showScreenWakeUpDialog = showDialog)
    }

    fun getShowScreenWakeUpDialog(): Boolean {
        return _systemActivityState.value.showScreenWakeUpDialog
    }

    fun setShowCaptureScreenshotDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showCaptureScreenshotDialog = showDialog)
    }

    fun getShowCaptureScreenshotDialog(): Boolean {
        return _systemActivityState.value.showCaptureScreenshotDialog
    }

    fun setShowSetInstallPermissionForSpecificAppDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetInstallPermissionForSpecificAppDialog = showDialog)
    }

    fun getShowSetInstallPermissionForSpecificAppDialog(): Boolean {
        return _systemActivityState.value.showSetInstallPermissionForSpecificAppDialog
    }

    fun setShowGetInstallPermissionForSpecificAppDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showGetInstallPermissionForSpecificAppDialog = showDialog)
    }

    fun getShowGetInstallPermissionForSpecificAppDialog(): Boolean {
        return _systemActivityState.value.showGetInstallPermissionForSpecificAppDialog
    }

    fun setShowAccessibilityDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showAccessibilityDialog = showDialog)
    }

    fun getShowAccessibilityDialog(): Boolean {
        return _systemActivityState.value.showAccessibilityDialog
    }

    fun setShowSetLanguageDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetLanguageDialog = showDialog)
    }

    fun getShowSetLanguageDialog(): Boolean {
        return _systemActivityState.value.showSetLanguageDialog
    }

    fun setShowSetTimeZoneDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetTimeZoneDialog = showDialog)
    }

    fun getShowSetTimeZoneDialog(): Boolean {
        return _systemActivityState.value.showSetTimeZoneDialog
    }

    fun setShowSetDpiDialog(showDialog: Boolean) {
        _systemActivityState.value = _systemActivityState.value.copy(showSetDpiDialog = showDialog)
    }

    fun getShowSetDpiDialog(): Boolean {
        return _systemActivityState.value.showSetDpiDialog
    }

    fun setShowSetCFDDpiDialog(showDialog: Boolean) {
        _systemActivityState.value = _systemActivityState.value.copy(showSetCFDDpiDialog = showDialog)
    }

    fun getShowSetCFDDpiDialog(): Boolean {
        return _systemActivityState.value.showSetCFDDpiDialog
    }

    fun setShowReservedLogSpaceDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showReservedLogSpaceDialog = showDialog)
    }

    fun getShowReservedLogSpaceDialog(): Boolean {
        return _systemActivityState.value.showReservedLogSpaceDialog
    }

    fun setShowSetLockTypeDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetLockTypeDialog = showDialog)
    }

    fun getShowSetLockTypeDialog(): Boolean {
        return _systemActivityState.value.showSetLockTypeDialog
    }

    fun setShowSetAdbPortDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetAdbPortDialog = showDialog)
    }

    fun getShowSetAdbPortDialog(): Boolean {
        return _systemActivityState.value.showSetAdbPortDialog
    }

    fun setDeviceBrightnessDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetDeviceBrightnessDialog = showDialog)
    }

    fun setShowClearAppCacheAndUserDataDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showClearAppCacheAndUserDataDialog = showDialog)
    }

    fun getShowClearAppCacheAndUserDataDialog(): Boolean {
        return _systemActivityState.value.showClearAppCacheAndUserDataDialog
    }

    fun setShowClearAllAppCacheAndUserDataDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showClearAllAppCacheAndUserDataDialog = showDialog)
    }

    fun getShowClearAllAppCacheAndUserDataDialog(): Boolean {
        return _systemActivityState.value.showClearAllAppCacheAndUserDataDialog
    }

    fun setShowSetSilentDefaultLauncherDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetSilentDefaultLauncherDialog = showDialog)
    }

    fun getShowSetSilentDefaultLauncherDialog(): Boolean {
        return _systemActivityState.value.showSetSilentDefaultLauncherDialog
    }

    fun setShowSetVolumeDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetVolumeDialog = showDialog)
    }

    fun getShowSetVolumeDialog(): Boolean {
        return _systemActivityState.value.showSetVolumeDialog
    }

    fun setShowSetWiFiMacAddressDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetWiFiMacAddressDialog = showDialog)
    }

    fun getShowSetWiFiMacAddressDialog(): Boolean {
        return _systemActivityState.value.showSetWiFiMacAddressDialog
    }

    fun setShowSetFontSizeDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetFontSizeDialog = showDialog)
    }

    fun getShowSetFontSizeDialog(): Boolean {
        return _systemActivityState.value.showSetFontSizeDialog
    }

    fun setShowDisplaySizeDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showDisplaySizeDialog = showDialog)
    }

    fun getShowDisplaySizeDialog(): Boolean {
        return _systemActivityState.value.showDisplaySizeDialog
    }

    fun setShowSetBacklightTimeoutDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetBacklightTimeoutDialog = showDialog)
    }

    fun getShowSetBacklightTimeoutDialog(): Boolean {
        return _systemActivityState.value.showSetBacklightTimeoutDialog
    }

    fun setShowSetPollIntervalDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetPollIntervalDialog = showDialog)
    }

    fun getShowSetPollIntervalDialog(): Boolean {
        return _systemActivityState.value.showSetPollIntervalDialog
    }

    fun setShowSetPasswordDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetPasswordDialog = showDialog)
    }

    fun getShowSetPasswordDialog(): Boolean {
        return _systemActivityState.value.showSetPasswordDialog
    }

    fun setShowSetPinDialog(showDialog: Boolean) {
        _systemActivityState.value = _systemActivityState.value.copy(showSetPinDialog = showDialog)
    }

    fun getShowSetPinDialog(): Boolean {
        return _systemActivityState.value.showSetPinDialog
    }

    fun setShowSetDeviceOwnerDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetDeviceOwnerDialog = showDialog)
    }

    fun getShowSetDeviceOwnerDialog(): Boolean {
        return _systemActivityState.value.showSetDeviceOwnerDialog
    }

    fun setShowSetResolutionDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetResolutionDialog = showDialog)
    }

    fun getShowSetResolutionDialog(): Boolean {
        return _systemActivityState.value.showSetResolutionDialog
    }

    fun setShowStartActivityFromForegroundServiceDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showStartActivityFromForegroundServiceDialog = showDialog)
    }

    fun getShowStartActivityFromForegroundServiceDialog(): Boolean {
        return _systemActivityState.value.showStartActivityFromForegroundServiceDialog
    }

    fun setShowSetSmallestWidthDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetSmallestWidthDialog = showDialog)
    }

    fun getShowSetSmallestWidthDialog(): Boolean {
        return _systemActivityState.value.showSetSmallestWidthDialog
    }

    fun setShowSetNtpUrlDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetNtpUrlDialog = showDialog)
    }

    fun getShowSetNtpUrlDialog(): Boolean {
        return _systemActivityState.value.showSetNtpUrlDialog
    }

    fun setShowSetHostNameDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetHostNameDialog = showDialog)
    }

    fun getShowSetHostNameDialog(): Boolean {
        return _systemActivityState.value.showSetHostNameDialog
    }

    fun setShowSetKeyListenerDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetKeyListenerDialog = showDialog)
    }

    fun getShowSetKeyListenerDialog(): Boolean {
        return _systemActivityState.value.showSetKeyListenerDialog
    }

    fun setShowSetKeyInterceptionDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetKeyInterceptionDialog = showDialog)
    }

    fun getShowSetKeyInterceptionDialog(): Boolean {
        return _systemActivityState.value.showSetKeyInterceptionDialog
    }

    fun setSelectedKeyListenerValues(values: Array<String>) {
        _systemActivityState.value =
            _systemActivityState.value.copy(selectedKeyListenerValues = values)
    }

    fun getSelectedKeyListenerValues(): Array<String> {
        return _systemActivityState.value.selectedKeyListenerValues
    }

    fun setShowSetOrientationDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetOrientationDialog = showDialog)
    }

    fun getShowSetOrientationDialog(): Boolean {
        return _systemActivityState.value.showSetOrientationDialog
    }

    fun setExternalOrientationDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetExternalOrientationDialog = showDialog)
    }

    fun setRebootWarningDialog(show: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showRebootWarningDialog = show)
    }

    fun setShowGetSystemPropertyDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showGetSystemPropertyDialog = showDialog)
    }

    fun setShowMediaProjectionPermissionForPackageDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetMediaProjectionPermissionForPackageDialog = showDialog)
    }

    fun setShowGetMD5ChecksumDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showGetMD5ChecksumDialog = showDialog)
    }

    fun getShowGetMD5ChecksumDialog(): Boolean {
        return _systemActivityState.value.showGetMD5ChecksumDialog
    }

    fun getShowGetSystemPropertyDialog(): Boolean {
        return _systemActivityState.value.showGetSystemPropertyDialog
    }

    fun setGetSystemProperty(value: String) {
        _systemActivityState.value = _systemActivityState.value.copy(getSystemProperty = value)
    }

    fun getGetSystemProperty(): String {
        return _systemActivityState.value.getSystemProperty
    }

    fun setCurrentLockPassword(value: String) {
        _systemActivityState.value = _systemActivityState.value.copy(currentLockPassword = value)
    }

    fun getCurrentLockPassword(): String? {
        return _systemActivityState.value.currentLockPassword
    }

    fun setShowSetLockTypeWithPasswordDialog(showDialog: Boolean) {
        _systemActivityState.value =
            _systemActivityState.value.copy(showSetLockTypeWithPasswordDialog = showDialog)
    }

    fun getShowSetLockTypeWithPasswordDialog(): Boolean {
        return _systemActivityState.value.showSetLockTypeWithPasswordDialog
    }

    fun setDownloadAndConvertZipFileToByteArrayDialog(showDialog: Boolean){
        _systemActivityState.value =
            _systemActivityState.value.copy(showDownloadAndConvertZipFileToByteArrayDialog = showDialog)
    }

    fun setGetMD5ChecksumFilePath(value: String) {
        _systemActivityState.value = _systemActivityState.value.copy(getMD5ChecksumFilePath = value)
    }

    fun getGetMD5ChecksumFilePath(): String {
        return _systemActivityState.value.getMD5ChecksumFilePath
    }

    fun verifyFileSignature(isValidFileCheck: Boolean = true): String {
        var fileName = "bin100.bin"
        var sha256 = "bin100.bin.sha256"

        if (!isValidFileCheck) {
            fileName = fileName + "_invalid"
        }
        var absoluteFilePath =
            saveAssetsFileToEloConf(fileName, fileName)
        val absoluteSha256Path =
            saveAssetsFileToEloConf(sha256, sha256)

        if (systemServiceManager != null) {
            return systemServiceManager.verifyFileSignature(
                absoluteFilePath,
                absoluteSha256Path,
            )
        }

        return "Service not connected"


    }

    /**
     * This method is used to save Assets file to Eloconf
     * @param string orgFileName file name to Assets file in Eloconf
     * @param string eloConfFileName name of file to store in device eloConf
     */
    private fun saveAssetsFileToEloConf(
        orgFileName: String,
        eloConfFileName: String
    ): String? {
        val filePath = "/sdcard/elo/$eloConfFileName"

        val fl = File(filePath)
        if (fl.exists()) {
            fl.delete()
        }

        try {
            fl.createNewFile()
        } catch (e: IOException) {
            Log.e(SystemActivity.TAG, "IOException in creating new file")
            return null
        }

        var fos: FileOutputStream? = null
        var inputStream: InputStream? = null
        try {
            inputStream = applicationContext.assets.open(orgFileName!!)

            fos = FileOutputStream(fl)

            val buffer = ByteArray(4096) // Buffer size of 4KB
            var bytesRead: Int
            while ((inputStream.read(buffer).also { bytesRead = it }) != -1) {
                fos.write(buffer, 0, bytesRead) // Write bytes read to the output stream
            }

            fl.setReadable(true, false)
        } catch (e: java.lang.Exception) {
            Log.w(SystemActivity.TAG, "saveAssetsFileToEloConf: " + e.message)
        } finally {
            if (fos != null) {
                try {
                    fos.close()
                } catch (e: IOException) {
                    e.printStackTrace()
                    return null
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close()
                } catch (e: IOException) {
                    e.printStackTrace()
                    return null
                }
            }
        }
        return filePath
    }

    fun bindService() {
        systemServiceManager?.bindService(
            applicationContext,
            this,
            GlobalClass.globalViewModel.getAccessToken()
        )
    }

    private fun unbindService() {
        systemServiceManager?.unbindService(applicationContext)
    }

    override fun onServiceConnected() {
        setServiceConnected(true)
        Log.d(TAG, "onServiceConnected: Service connected")
    }

    override fun onServiceDisconnected() {
        setServiceConnected(false)
        Log.d(TAG, "onServiceDisconnected: Service disconnected")
    }

    override fun onTokenVerifyFailed() {
        setServiceConnected(false)
        Log.e(TAG, "onTokenVerifyFailed: Token verify failed")
    }
}