/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.viewmodel

import android.content.Context
import android.util.Log
import androidx.lifecycle.ViewModel
import com.eloview.sdk.peripheralManager.Peripheral
import com.eloview.sdk.systemManager.ServiceConnectionCallback
import com.eloview.sdk.testapp.GlobalClass
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow

data class PeripheralActivityState(
    var serviceConnected: Boolean = false,
    var output: String = "",
    var usb1Enabled: Boolean = false,
    var usb2Enabled: Boolean = false,
    var usb3Enabled: Boolean = false,
    var usb4Enabled: Boolean = false,
    var usb5Enabled: Boolean = false,
    var usb6Enabled: Boolean = false,
    var extUsb1Enabled: Boolean = false,
    var extUsb2Enabled: Boolean = false,
    var extUsb3Enabled: Boolean = false,
    var extUsb4Enabled: Boolean = false,
    var extUsb5Enabled: Boolean = false,
    var extUsb6Enabled: Boolean = false,
    var setUsbAudioDeviceDialog: Boolean = false,
    var selectedUsbAudioDevice: Int = 1
)

class PeripheralActivityViewModel(val applicationContext: Context, preview: Boolean = false) :
    ViewModel(),
    ServiceConnectionCallback {
    companion object {
        private const val TAG = "PeripheralActivityViewModel"
        var isPreview: Boolean = false
    }

    val peripheralServiceManager = if (preview) {
        isPreview = true
        null
    } else {
        isPreview = false
        Peripheral()
    }

    init {
        isPreview = preview
    }

    private val _peripheralActivityState = MutableStateFlow(PeripheralActivityState())
    val peripheralActivityState: StateFlow<PeripheralActivityState> =
        _peripheralActivityState.asStateFlow()

    fun bindService() {
        peripheralServiceManager?.bindService(
            applicationContext,
            this,
            GlobalClass.globalViewModel.getAccessToken()
        )
    }

    fun unbindService() {
        peripheralServiceManager?.unbindService(applicationContext)
    }

    private fun setServiceConnected(serviceConnected: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(serviceConnected = serviceConnected)
    }

    fun getServiceConnected(): Boolean {
        return _peripheralActivityState.value.serviceConnected
    }

    fun setOutput(output: String) {
        _peripheralActivityState.value = _peripheralActivityState.value.copy(output = output)
    }

    fun getOutput(): String {
        return _peripheralActivityState.value.output
    }

    fun getUsb1Enabled(): Boolean {
        return _peripheralActivityState.value.usb1Enabled
    }

    fun getUsb2Enabled(): Boolean {
        return _peripheralActivityState.value.usb2Enabled
    }

    fun getUsb3Enabled(): Boolean {
        return _peripheralActivityState.value.usb3Enabled
    }

    fun getUsb4Enabled(): Boolean {
        return _peripheralActivityState.value.usb4Enabled
    }

    fun getUsb5Enabled(): Boolean {
        return _peripheralActivityState.value.usb5Enabled
    }

    fun getUsb6Enabled(): Boolean {
        return _peripheralActivityState.value.usb6Enabled
    }

    fun setUsb1Enabled(usb1Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(usb1Enabled = usb1Enabled)
    }

    fun setUsb2Enabled(usb2Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(usb2Enabled = usb2Enabled)
    }

    fun setUsb3Enabled(usb3Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(usb3Enabled = usb3Enabled)
    }

    fun setUsb4Enabled(usb4Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(usb4Enabled = usb4Enabled)
    }

    fun setUsb5Enabled(usb5Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(usb5Enabled = usb5Enabled)
    }

    fun setUsb6Enabled(usb6Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(usb6Enabled = usb6Enabled)
    }

    fun getExtUsb1Enabled(): Boolean {
        return _peripheralActivityState.value.extUsb1Enabled
    }

    fun getExtUsb2Enabled(): Boolean {
        return _peripheralActivityState.value.extUsb2Enabled
    }

    fun getExtUsb3Enabled(): Boolean {
        return _peripheralActivityState.value.extUsb3Enabled
    }

    fun getExtUsb4Enabled(): Boolean {
        return _peripheralActivityState.value.extUsb4Enabled
    }

    fun getExtUsb5Enabled(): Boolean {
        return _peripheralActivityState.value.extUsb5Enabled
    }

    fun getExtUsb6Enabled(): Boolean {
        return _peripheralActivityState.value.extUsb6Enabled
    }

    fun setExtUsb1Enabled(extUsb1Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(extUsb1Enabled = extUsb1Enabled)
    }

    fun setExtUsb2Enabled(extUsb2Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(extUsb2Enabled = extUsb2Enabled)
    }

    fun setExtUsb3Enabled(extUsb3Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(extUsb3Enabled = extUsb3Enabled)
    }

    fun setExtUsb4Enabled(extUsb4Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(extUsb4Enabled = extUsb4Enabled)
    }

    fun setExtUsb5Enabled(extUsb5Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(extUsb5Enabled = extUsb5Enabled)
    }

    fun setExtUsb6Enabled(extUsb6Enabled: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(extUsb6Enabled = extUsb6Enabled)
    }

    fun setSetUsbAudioDeviceDialog(setUsbAudioDeviceDialog: Boolean) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(setUsbAudioDeviceDialog = setUsbAudioDeviceDialog)
    }

    fun getSetUsbAudioDeviceDialog(): Boolean {
        return _peripheralActivityState.value.setUsbAudioDeviceDialog
    }

    fun setSelectedUsbAudioDevice(selectedUsbAudioDevice: Int) {
        _peripheralActivityState.value =
            _peripheralActivityState.value.copy(selectedUsbAudioDevice = selectedUsbAudioDevice)
    }

    fun getSelectedUsbAudioDevice(): Int {
        return _peripheralActivityState.value.selectedUsbAudioDevice
    }

    override fun onServiceConnected() {
        setServiceConnected(true)
        Log.d(TAG, "onServiceConnected: Service connected")
    }

    override fun onServiceDisconnected() {
        setServiceConnected(false)
        Log.d(TAG, "onServiceDisconnected: Service disconnected")
    }

    override fun onTokenVerifyFailed() {
        setServiceConnected(false)
        Log.e(TAG, "onTokenVerifyFailed: Token verify failed")
    }
}