/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.viewmodel

import android.annotation.SuppressLint
import android.content.Context
import android.os.Handler
import android.os.Looper
import android.os.Message
import android.util.Log
import androidx.lifecycle.ViewModel
import com.eloview.sdk.accountManager.AccountManager
import com.eloview.sdk.otaManager.OTA
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow

data class OtaActivityState(
    var output: String = "",
    var showCheckEloOtaStatusDialog: Boolean = false,
    var checkEloOtaStatusUrl: String = "",
    var checkEloOtaStatusLocalFile: String = "",
    var showGetAvailableVersionsDialog: Boolean = false,
    var selectedAvailableVersion: String = "Device Default",
    var showDownloadEloOtaPackageFromUrlDialog: Boolean = false,
    var downloadEloOtaPackageFromUrl: String = "",
    var showDownloadEloOtaPackageFromLocalPathDialog: Boolean = false,
    var downloadEloOtaPackageFromLocalPath: String = "",
    var showDownloadSpecificEloOtaVersionDialog: Boolean = false,
    var selectedSpecificEloOtaVersion: String = ""
)

class OtaActivityViewModel(val applicationContext: Context, preview: Boolean = false) :
    ViewModel() {
    companion object {
        private const val TAG = "OtaActivityViewModel"
        var isPreview: Boolean = false
    }

    val otaHandler: Handler = object : Handler(Looper.getMainLooper()) {
        @SuppressLint("SetTextI18n")
        override fun handleMessage(msg: Message) {
            super.handleMessage(msg)
            val b = msg.data
            val key = msg.what.toString()
            val `val` = b.getString(key)
            when (msg.what) {
                OTA.OTA_DOWNLOAD_REMOTE_FILE_PERCENTAGE -> {
                    Log.i(TAG, "Remote file download percentage := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_REMOTE_FILE_PERCENTAGE \n\n Percentage : $`val`")
                }

                OTA.OTA_DOWNLOAD_REMOTE_FILE_SUCCESS -> {
                    Log.i(TAG, "Remote file download success := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_REMOTE_FILE_SUCCESS \n\n Info : $`val`")
                }

                OTA.OTA_DOWNLOAD_REMOTE_FILE_ERROR -> {
                    Log.i(TAG, "Remote file download error := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_REMOTE_FILE_ERROR \n\n Error : $`val`")
                }

                OTA.OTA_DOWNLOAD_LOCAL_FILE_PERCENTAGE -> {
                    Log.i(TAG, "Local file download percentage := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_LOCAL_FILE_PERCENTAGE \n\n Percentage : $`val`")
                }

                OTA.OTA_DOWNLOAD_LOCAL_FILE_SUCCESS -> {
                    Log.i(TAG, "Local file download success := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_LOCAL_FILE_SUCCESS \n\n Info : $`val`")
                }

                OTA.OTA_DOWNLOAD_LOCAL_FILE_ERROR -> {
                    Log.i(TAG, "Local file download error := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_LOCAL_FILE_ERROR \n\n Error : $`val`")
                }

                OTA.OTA_DOWNLOAD_GENERIC_ERROR -> {
                    Log.i(TAG, "Download error := $`val`")
                    setOutput("Code : OTA_DOWNLOAD_GENERIC_ERROR \n\n Error : $`val`")
                }

                OTA.OTA_VERIFY_SIGN_PERCENTAGE -> {
                    Log.i(TAG, "Verify sign percentage := $`val`")
                    setOutput("Code : OTA_VERIFY_SIGN_PERCENTAGE \n\n Percentage : $`val`")
                }

                OTA.OTA_VERIFY_SIGN_SUCCESS -> {
                    Log.i(TAG, "Verify sign success := $`val`")
                    setOutput("Code : OTA_VERIFY_SIGN_SUCCESS \n\n Info : $`val`")
                }

                OTA.OTA_VERIFY_SIGN_ERROR -> {
                    Log.i(TAG, "Verify sign error := $`val`")
                    setOutput("Code : OTA_VERIFY_SIGN_ERROR \n\n Error : $`val`")
                }

                OTA.OTA_VERIFY_FILE_ERROR -> {
                    Log.i(TAG, "Verify file error := $`val`")
                    setOutput("Code : OTA_VERIFY_FILE_ERROR \n\n Error : $`val`")
                }

                OTA.OTA_CHECK_STATUS_OLD -> {
                    Log.i(TAG, "OTA check : Version is old := $`val`")
                    setOutput("Code : OTA_CHECK_STATUS_OLD \n\n Status : $`val`")
                }

                OTA.OTA_CHECK_STATUS_NEW -> {
                    Log.i(TAG, "OTA Check : Version is new := $`val`")
                    setOutput("Code : OTA_CHECK_STATUS_NEW \n\n Status : $`val`")
                }

                OTA.OTA_CHECK_STATUS_SAME -> {
                    Log.i(TAG, "OTA Check : Version is same  := $`val`")
                    setOutput("Code : OTA_CHECK_STATUS_SAME \n\n Status : $`val`")
                }

                OTA.OTA_CHECK_STATUS_GENERIC_ERROR -> {
                    Log.i(TAG, "OTA Check : Status error  := $`val`")
                    setOutput("Code : OTA_CHECK_STATUS_GENERIC_ERROR \n\n Status : $`val`")
                }

                OTA.OTA_APPLY_FILE_ERROR -> {
                    Log.i(TAG, "OTA apply file error := $`val`")
                    setOutput("Code : OTA_APPLY_FILE_ERROR \n\n Status : $`val`")
                }

                OTA.OTA_APPLY_IN_PROGRESS -> {
                    Log.i(TAG, "OTA apply file progress := $`val`")
                    setOutput("Code : OTA_APPLY_IN_PROGRESS \n\n Status : $`val`")
                }

                AccountManager.TOKEN_VERIFY_FAIL -> {
                    Log.v(TAG, "Invalid accessToken")
                    setOutput("INVALID TOKEN\n$`val`")
                }

                OTA.OTA_VERSION_RESPONSE_AVAILABLE -> {
                    Log.v(TAG, "OTA_VERSION_RESPONSE_AVAILABLE")
                    setOutput("OTA versions:\n$`val`")
                }

                OTA.GENERIC_ERROR -> {
                    Log.v(TAG, "OTA_GENERIC_ERROR")
                    setOutput("OTA_GENERIC_ERROR: OTA Error:\n$`val`")
                }

                AccountManager.TOKEN_VERIFY_SUCCESS -> {
                    Log.v(TAG, "TOKEN_VERIFY_RESPONSE_AVAILABLE")
                    if (`val` != null) {
                        setOutput(`val`)
                    }
                }

                OTA.OTA_DOWNLOAD_REMOTE_FILE_ALREADY_DOWNLOADED -> {
                    Log.v(TAG, "OTA_DOWNLOAD_REMOTE_FILE_ALREADY_DOWNLOADED")
                    setOutput("Code : OTA_DOWNLOAD_REMOTE_FILE_ALREADY_DOWNLOADED \n\n Status : $`val`")
                }

                OTA.OS360_RESPONSE_AVAILABLE -> {
                    Log.v(TAG, "OS360_RESPONSE_AVAILABLE")
                    setOutput("Code : OS360_RESPONSE_AVAILABLE \n\n Status : $`val`")
                }

                OTA.EV_RESPONSE -> {
                    Log.v(TAG, "ELOVIEW_PORTAL_RESPONSE")
                    setOutput("Code: ELOVIEW_PORTAL_RESPONSE: \n$`val`")
                }

                OTA.OS360_RESPONSE_UNAVAILABLE -> {
                    Log.v(TAG, "OS360_RESPONSE_UNAVAILABLE")
                    setOutput("Code : OS360_RESPONSE_UNAVAILABLE \n\n Status : $`val`")
                }
            }
        }
    }

    private val _otaActivityState = MutableStateFlow(OtaActivityState())
    val otaActivityState: StateFlow<OtaActivityState> = _otaActivityState.asStateFlow()

    fun setOutput(output: String) {
        _otaActivityState.value = _otaActivityState.value.copy(output = output)
    }

    fun getOutput(): String {
        return _otaActivityState.value.output
    }

    fun setShowCheckEloOtaStatusDialog(showCheckEloOtaStatusDialog: Boolean) {
        _otaActivityState.value =
            _otaActivityState.value.copy(showCheckEloOtaStatusDialog = showCheckEloOtaStatusDialog)
    }

    fun getShowCheckEloOtaStatusDialog(): Boolean {
        return _otaActivityState.value.showCheckEloOtaStatusDialog
    }

    fun setCheckEloOtaStatusUrl(checkEloOtaStatusUrl: String) {
        _otaActivityState.value =
            _otaActivityState.value.copy(checkEloOtaStatusUrl = checkEloOtaStatusUrl)
    }

    fun getCheckEloOtaStatusUrl(): String {
        return _otaActivityState.value.checkEloOtaStatusUrl
    }

    fun setCheckEloOtaStatusLocalFile(checkEloOtaStatusLocalFile: String) {
        _otaActivityState.value =
            _otaActivityState.value.copy(checkEloOtaStatusLocalFile = checkEloOtaStatusLocalFile)
    }

    fun getCheckEloOtaStatusLocalFile(): String {
        return _otaActivityState.value.checkEloOtaStatusLocalFile
    }

    fun setShowGetAvailableVersionsDialog(showGetAvailableVersionsDialog: Boolean) {
        _otaActivityState.value =
            _otaActivityState.value.copy(showGetAvailableVersionsDialog = showGetAvailableVersionsDialog)
    }

    fun getShowGetAvailableVersionsDialog(): Boolean {
        return _otaActivityState.value.showGetAvailableVersionsDialog
    }

    fun setSelectedAvailableVersion(selectedAvailableVersion: String) {
        _otaActivityState.value =
            _otaActivityState.value.copy(selectedAvailableVersion = selectedAvailableVersion)
    }

    fun getSelectedAvailableVersion(): String {
        return _otaActivityState.value.selectedAvailableVersion
    }

    fun setShowDownloadEloOtaPackageFromUrlDialog(showDownloadEloOtaPackageFromUrlDialog: Boolean) {
        _otaActivityState.value =
            _otaActivityState.value.copy(showDownloadEloOtaPackageFromUrlDialog = showDownloadEloOtaPackageFromUrlDialog)
    }

    fun getShowDownloadEloOtaPackageFromUrlDialog(): Boolean {
        return _otaActivityState.value.showDownloadEloOtaPackageFromUrlDialog
    }

    fun setDownloadEloOtaPackageFromUrl(downloadEloOtaPackageFromUrl: String) {
        _otaActivityState.value =
            _otaActivityState.value.copy(downloadEloOtaPackageFromUrl = downloadEloOtaPackageFromUrl)
    }

    fun getDownloadEloOtaPackageFromUrl(): String {
        return _otaActivityState.value.downloadEloOtaPackageFromUrl
    }

    fun setShowDownloadEloOtaPackageFromLocalPathDialog(showDownloadEloOtaPackageFromLocalPathDialog: Boolean) {
        _otaActivityState.value =
            _otaActivityState.value.copy(showDownloadEloOtaPackageFromLocalPathDialog = showDownloadEloOtaPackageFromLocalPathDialog)
    }

    fun getShowDownloadEloOtaPackageFromLocalPathDialog(): Boolean {
        return _otaActivityState.value.showDownloadEloOtaPackageFromLocalPathDialog
    }

    fun setDownloadEloOtaPackageFromLocalPath(downloadEloOtaPackageFromLocalPath: String) {
        _otaActivityState.value =
            _otaActivityState.value.copy(downloadEloOtaPackageFromLocalPath = downloadEloOtaPackageFromLocalPath)
    }

    fun getDownloadEloOtaPackageFromLocalPath(): String {
        return _otaActivityState.value.downloadEloOtaPackageFromLocalPath
    }

    fun setShowDownloadSpecificEloOtaVersionDialog(showDownloadSpecificEloOtaVersionDialog: Boolean) {
        _otaActivityState.value =
            _otaActivityState.value.copy(showDownloadSpecificEloOtaVersionDialog = showDownloadSpecificEloOtaVersionDialog)
    }

    fun getShowDownloadSpecificEloOtaVersionDialog(): Boolean {
        return _otaActivityState.value.showDownloadSpecificEloOtaVersionDialog
    }

    fun setSelectedSpecificEloOtaVersion(selectedSpecificEloOtaVersion: String) {
        _otaActivityState.value =
            _otaActivityState.value.copy(selectedSpecificEloOtaVersion = selectedSpecificEloOtaVersion)
    }

    fun getSelectedSpecificEloOtaVersion(): String {
        return _otaActivityState.value.selectedSpecificEloOtaVersion
    }

}