/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.viewmodel

import android.annotation.SuppressLint
import androidx.lifecycle.ViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow

data class LocalCertificateActivityState(
    var localCertName: String = "",
    var localCertPassword: String = "",
    @SuppressLint("SdCardPath") var localCertPath: String = "",
    var localCaUserSwitch: Boolean = true
)

class LocalCertificateActivityViewModel : ViewModel() {
    private val _estCertificateActivityState = MutableStateFlow(LocalCertificateActivityState())
    val estCertificateActivityState: StateFlow<LocalCertificateActivityState> =
        _estCertificateActivityState.asStateFlow()

    fun setLocalCertName(localCertName: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(localCertName = localCertName)
    }

    fun getLocalCertName(): String {
        return _estCertificateActivityState.value.localCertName
    }

    fun setLocalCertPassword(localCertPassword: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(localCertPassword = localCertPassword)
    }

    fun getLocalCertPassword(): String {
        return _estCertificateActivityState.value.localCertPassword
    }

    fun setLocalCertPath(certificatePath: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(localCertPath = certificatePath)
    }

    fun getLocalCertPath(): String {
        return _estCertificateActivityState.value.localCertPath
    }

    fun setLocalCaUserSwitch(localCaUserSwitch: Boolean) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(localCaUserSwitch = localCaUserSwitch)
    }

    fun getLocalCaUserSwitch(): Boolean {
        return _estCertificateActivityState.value.localCaUserSwitch
    }
}