/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.viewmodel

import androidx.lifecycle.ViewModel
import com.eloview.sdk.testapp.AccountManagerActivity
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update

data class ApplicationState(
    var authorized: Boolean = AccountManagerActivity.isTokenVerified,
    var accessToken: String = "",
    var email: String = "",
    var password: String = "",
    var clientId: String = "",
    var secretKey: String = "",
    var emailPass: Boolean = false,
    var clientSecret: Boolean = false,
    var verifyFromFile: Boolean = false,
    var tokenFromApi: Boolean = false,
    var isResealed: Boolean = false,
    var isPolaris: Boolean = false
)

class GlobalViewModel : ViewModel() {
    private val _globalState = MutableStateFlow(ApplicationState())
    val globalState: StateFlow<ApplicationState> = _globalState.asStateFlow()
    fun setAuthorized(authorized: Boolean) {
        _globalState.update { it.copy(authorized = authorized) }
    }

    fun getAuthorized(): Boolean {
        return _globalState.value.authorized
    }

    fun setEmail(email: String) {
        _globalState.update { it.copy(email = email) }
    }

    fun setPassword(password: String) {
        _globalState.update { it.copy(password = password) }
    }

    fun setClientId(clientId: String) {
        _globalState.update { it.copy(clientId = clientId) }
    }

    fun setSecretKey(secretKey: String) {
        _globalState.update { it.copy(secretKey = secretKey) }
    }

    fun setAccessToken(accessToken: String) {
        _globalState.update { it.copy(accessToken = accessToken) }
    }

    fun setEmailPass(emailPass: Boolean) {
        _globalState.update { it.copy(emailPass = emailPass) }
    }

    fun setClientSecret(clientSecret: Boolean) {
        _globalState.update { it.copy(clientSecret = clientSecret) }
    }

    fun setTokenFromApi(tokenFromApi: Boolean) {
        _globalState.update { it.copy(tokenFromApi = tokenFromApi) }
    }

    fun setIsPolaris(isPolaris: Boolean) {
        _globalState.update { it.copy(isPolaris = isPolaris) }
    }

    fun setIsResealed(isResealed: Boolean) {
        _globalState.update { it.copy(isResealed = isResealed) }
    }

    fun getAccessToken(): String {
        return _globalState.value.accessToken
    }
}