/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.viewmodel

import android.annotation.SuppressLint
import androidx.lifecycle.ViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow

data class ESTCertificateActivityState(
    var estAlias: String = "",
    var estUrl: String = "",
    var estPort: Int? = null,
    var estUserName: String = "",
    var estPassword: String = "",
    @SuppressLint("SdCardPath") var estCertificatePath: String = ""
)

class ESTCertificateActivityViewModel : ViewModel() {
    private val _estCertificateActivityState = MutableStateFlow(ESTCertificateActivityState())
    val estCertificateActivityState: StateFlow<ESTCertificateActivityState> =
        _estCertificateActivityState.asStateFlow()

    fun setEstAlias(estAlias: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(estAlias = estAlias)
    }

    fun getEstAlias(): String {
        return _estCertificateActivityState.value.estAlias
    }

    fun setEstUrl(estUrl: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(estUrl = estUrl)
    }

    fun getEstUrl(): String {
        return _estCertificateActivityState.value.estUrl
    }

    fun setEstPort(port: Int) {
        _estCertificateActivityState.value = _estCertificateActivityState.value.copy(estPort = port)
    }

    fun getEstPort(): Int {
        return _estCertificateActivityState.value.estPort!!
    }

    fun setEstUserName(userName: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(estUserName = userName)
    }

    fun getEstUserName(): String {
        return _estCertificateActivityState.value.estUserName
    }

    fun setEstPassword(password: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(estPassword = password)
    }

    fun getEstPassword(): String {
        return _estCertificateActivityState.value.estPassword
    }

    fun setEstCertificatePath(certificatePath: String) {
        _estCertificateActivityState.value =
            _estCertificateActivityState.value.copy(estCertificatePath = certificatePath)
    }

    fun getEstCertificatePath(): String {
        return _estCertificateActivityState.value.estCertificatePath
    }

}