package com.eloview.sdk.testapp.ui.theme

import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.dimensionResource
import androidx.compose.ui.text.style.TextAlign
import com.eloview.sdk.testapp.R

val AvenirHeavy = FontFamily(
    Font(R.font.avenir_heavy)
)
val AvenirMedium = FontFamily(
    Font(R.font.avenir_medium)
)
val AvenirNormal = FontFamily(
    Font(R.font.avenir_normal)
)

// Define the TextStyle for each of your styles
val EloTextTitle1 = TextStyle(
    fontFamily = AvenirHeavy,
    fontWeight = FontWeight.Bold,
    fontSize = 20.sp,
    color = Color.White // Assuming default black text, can be changed later

)

@Composable
fun getEloOutputText():TextStyle {
    return EloTextTitle1.copy(
        textAlign = TextAlign.Start,
        fontFamily = AvenirNormal,
        color = MaterialTheme.colorScheme.primary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._11sdp).value.sp,
    )
}


@Composable
fun getEloNormalStdText():TextStyle {
   return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        color = Color.White,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
       textAlign = TextAlign.Center
    )
}

@Composable
fun getEloNormalRadioLabel():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        color = Color.White,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
        textAlign = TextAlign.Start
    )
}

@Composable
fun getEloBoldStdText():TextStyle {
    return EloTextTitle1.copy(
        color = Color.White,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
        textAlign = TextAlign.Center

    )
}

@Composable
fun getEloBoldStdSecondaryText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirHeavy,
        fontWeight = FontWeight.Bold,
        color =  MaterialTheme.colorScheme.secondary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
        textAlign = TextAlign.Center

    )
}

@Composable
fun getEloBoldStdSecondaryTextstart():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirHeavy,
        fontWeight = FontWeight.Bold,
        color =  MaterialTheme.colorScheme.secondary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
        textAlign = TextAlign.Start

    )
}

@Composable
fun getEloNormalStdPrimaryText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        color = MaterialTheme.colorScheme.primary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
    )
}

@Composable
fun getEloNormalStdSecondaryText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        color = MaterialTheme.colorScheme.secondary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._12sdp).value.sp,
    )
}

@Composable
fun getEloHighSizePrimaryText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        color = MaterialTheme.colorScheme.primary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._14sdp).value.sp,
    )
}
@Composable
fun getEloHighSizeWhiteBoldText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirHeavy,
        color = Color.White,
        fontWeight = FontWeight.Bold ,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._14sdp).value.sp,
    )
}

@Composable
fun getEloHighSizePrimaryBoldText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirHeavy,
        color = MaterialTheme.colorScheme.primary,
        fontWeight = FontWeight.Bold ,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._14sdp).value.sp,
    )
}

@Composable
fun getEloSmallText():TextStyle {
   return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        fontWeight = FontWeight.Normal,
        color = MaterialTheme.colorScheme.primary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._10sdp).value.sp,
    )
}

@Composable
fun getEloSmallWhiteText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        fontWeight = FontWeight.Normal,
        color = Color.White,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._10sdp).value.sp,
    )
}

@Composable
fun getEloSmallSecondaryText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirNormal,
        fontWeight = FontWeight.Normal,
        color = MaterialTheme.colorScheme.secondary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._10sdp).value.sp,
    )
}

@Composable
fun getEloSmallBoldSecondaryText():TextStyle {
    return EloTextTitle1.copy(
        fontFamily = AvenirHeavy,
        fontWeight = FontWeight.Bold,
        color = MaterialTheme.colorScheme.secondary,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._10sdp).value.sp,
    )
}

@Composable
fun getEloLargeBoldTextPrimary():TextStyle {
   return EloTextTitle1.copy(
       textAlign = TextAlign.Center,
       color = MaterialTheme.colorScheme.primary,
       letterSpacing = 0.sp,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._18sdp).value.sp,
    )
}

@Composable
fun getEloLargeBoldTextWhite():TextStyle {
    return EloTextTitle1.copy(
        textAlign = TextAlign.Center,
        color =Color.White,
        letterSpacing = 0.sp,
        fontSize = dimensionResource(id = com.intuit.sdp.R.dimen._18sdp).value.sp,
    )
}







