/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.systemActivity

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.util.Log
import android.view.KeyEvent
import com.eloview.sdk.systemManager.System
import java.lang.ref.WeakReference

class KeyReceiver : BroadcastReceiver {
    constructor(systemHandler: WeakReference<Handler>?) {
        mSystemHandler = systemHandler
    }

    constructor()

    override fun onReceive(context: Context, intent: Intent) {
        if (intent.action == "com.elo.secure.action.INTERCEPT_KEY_EVENT") {
            val keyEvent: KeyEvent? = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                intent.getParcelableExtra("KEY_EVENT", KeyEvent::class.java)
            } else {
                @Suppress("DEPRECATION")
                intent.getParcelableExtra("KEY_EVENT") as? KeyEvent
            }
            if (keyEvent != null) {
                try {
                    Log.d(TAG, keyEvent.toString())
                    val msg = mSystemHandler!!.get()!!.obtainMessage()
                    msg.what = System.RECEIVE_KEY_EVENT
                    val bundle = Bundle()
                    bundle.putString(System.RECEIVE_KEY_EVENT.toString(), keyEvent.toString())
                    msg.data = bundle
                    mSystemHandler!!.get()!!.sendMessage(msg)
                } catch (e: Exception) {
                    e.printStackTrace()
                    Log.d(TAG, "Exception: " + e.message)
                }
            }
        }
    }

    companion object {
        private const val TAG = "KeyReceiver"
        var mSystemHandler: WeakReference<Handler>? = null
    }
}