/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.peripheralActivity

import android.app.Activity
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.text.input.KeyboardType
import androidx.compose.ui.tooling.preview.Preview
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.SingleTextFieldTwoButtonDialog
import com.eloview.sdk.testapp.viewmodel.PeripheralActivityViewModel

class PeripheralActivityDialogs {
    @Composable
    @Preview(showBackground = true)
    fun SetUsbAudioDeviceDialogPreview() {
        SetUsbAudioDeviceDialog()
    }

    companion object {
        private const val TAG = "PeripheralActivityDialogs"

        @Composable

        fun SetUsbAudioDeviceDialog(
            peripheralActivityViewModel: PeripheralActivityViewModel = PeripheralActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val peripheralActivityDetails by peripheralActivityViewModel.peripheralActivityState.collectAsState()
            if (PeripheralActivityViewModel.isPreview) {
                peripheralActivityViewModel.setSetUsbAudioDeviceDialog(true)
            }
            if (peripheralActivityDetails.setUsbAudioDeviceDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Enter an Integer ID for the USB Device",
                    textFieldKeyboardType = KeyboardType.NumberPassword,
                    isPinField = true,
                    textFieldValueHint = "1",
                    textFieldValue = "",
                    onValueChange = {
                        try {
                            peripheralActivityViewModel.setSelectedUsbAudioDevice(it.toInt())
                        } catch (_: NumberFormatException) {
                            peripheralActivityViewModel.setSelectedUsbAudioDevice(1)
                        }
                    },
                    onConfirmClick = {
                        peripheralActivityViewModel.setSetUsbAudioDeviceDialog(false)
                        PeripheralActivityOnClickListeners.onSetUsbAudioDeviceClick(
                            peripheralActivityViewModel
                        )
                    },
                    onCancelClick = {
                        peripheralActivityViewModel.setSetUsbAudioDeviceDialog(false)
                    }
                )
            }
        }
    }
}
