/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.packageActivity

import android.app.Activity
import android.util.Log
import android.widget.Toast
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.platform.LocalContext
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.DoubleTextFieldTwoButtonDialog
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.SingleTextFieldDoubleCheckBoxTwoButtonDialog
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.SingleTextFieldSingleCheckBoxTwoButtonDialog
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.SingleTextFieldTwoButtonDialog
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.TripleTextFieldTwoButtonDialog
import com.eloview.sdk.testapp.viewmodel.PackageActivityViewModel

class PackageActivityDialogs {
    companion object {
            private const val TAG = "PackageActivityDialogs"
        @Composable
        fun SilentUninstallDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowSilentUninstallDialog(true)
            }
            if (packageActivityDetails.showSilentUninstallDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Silent Uninstall Package",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.silentUninstallPackage,
                    onValueChange = {
                        packageActivityViewModel.setSilentUninstallPackage(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowSilentUninstallDialog(false)
                        PackageActivityOnClickListeners.onSilentUninstallClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowSilentUninstallDialog(false)
                    }
                )
            }
        }

        @Composable
        fun StopPackageDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowStopPackageDialog(true)
            }
            if (packageActivityDetails.showStopPackageDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Stop Package",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.stopPackageName,
                    onValueChange = {
                        packageActivityViewModel.setStopPackageName(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowStopPackageDialog(false)
                        PackageActivityOnClickListeners.onStopPackageClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowStopPackageDialog(false)
                    }
                )
            }
        }

        @Composable
        fun EnablePackageDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowEnablePackageDialog(true)
            }
            if (packageActivityDetails.showEnablePackageDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Enable Package",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.enablePackageName,
                    onValueChange = {
                        packageActivityViewModel.setEnablePackageName(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowEnablePackageDialog(false)
                        PackageActivityOnClickListeners.onEnablePackageClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowEnablePackageDialog(false)
                    }
                )
            }
        }

        @Composable
        fun DisablePackageDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowDisablePackageDialog(true)
            }
            if (packageActivityDetails.showDisablePackageDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Disable Package",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.disablePackageName,
                    onValueChange = {
                        packageActivityViewModel.setDisablePackageName(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowDisablePackageDialog(false)
                        PackageActivityOnClickListeners.onDisablePackageClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowDisablePackageDialog(false)
                    }
                )
            }
        }

        @Composable
        fun GetPackageStatusDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowGetPackageStatusDialog(true)
            }
            if (packageActivityDetails.showGetPackageStatusDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Get Package Status",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.packageStatusPackageName,
                    onValueChange = {
                        packageActivityViewModel.setPackageStatusPackageName(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowGetPackageStatusDialog(false)
                        PackageActivityOnClickListeners.onGetPackageStatusClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowGetPackageStatusDialog(false)
                    }
                )
            }
        }

        @Composable
        fun AddWhiteListPackagePermissionDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowAddWhiteListPackagePermissionDialog(true)
            }
            if (packageActivityDetails.showAddWhiteListPackagePermissionDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Add White List Package Permission",
                    textFieldValueHint = "Enter Package Permission",
                    textFieldValue = packageActivityDetails.whiteListPackagePermission,
                    onValueChange = {
                        packageActivityViewModel.setWhiteListPackagePermission(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowAddWhiteListPackagePermissionDialog(false)
                        PackageActivityOnClickListeners.onAddWhiteListPackagePermissionClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowAddWhiteListPackagePermissionDialog(false)
                    }
                )
            }
        }

        @Composable
        fun SetPackageNameAndPermissionDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowSetPackageNameAndPermissionDialog(true)
            }
            if (packageActivityDetails.showSetPackageNameAndPermissionDialog) {
                DoubleTextFieldTwoButtonDialog(
                    title = "Elo Set Package Name And Permission",
                    textFieldValue1Hint = "android.example.PERMISSION",
                    textFieldValue2Hint = "com.example.example",
                    textFieldValue1 = packageActivityDetails.packagePermission,
                    onValueChange1 = {
                        packageActivityViewModel.setPackagePermission(it)
                    },
                    textFieldValue2 = packageActivityDetails.packageName,
                    onValueChange2 = {
                        packageActivityViewModel.setPackageName(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowSetPackageNameAndPermissionDialog(false)
                        PackageActivityOnClickListeners.onSetPackageNameAndPermissionClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowSetPackageNameAndPermissionDialog(false)
                    }
                )
            }
        }

        @Composable
        fun ClearPackagePermissionDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowClearPackagePermissionDialog(true)
            }
            if (packageActivityDetails.showClearPackagePermissionDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Elo Clear Package Permission",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.clearPackagePermission,
                    onValueChange = {
                        packageActivityViewModel.setClearPackagePermission(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowClearPackagePermissionDialog(false)
                        PackageActivityOnClickListeners.onClearPackagePermissionClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowClearPackagePermissionDialog(false)
                    }
                )
            }
        }

        @Composable
        fun EnablePackageWhitelistingDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowEnablePackageWhitelistingDialog(true)
            }
            if (packageActivityDetails.showEnablePackageWhitelistingDialog) {
                SingleTextFieldSingleCheckBoxTwoButtonDialog(
                    title = "Elo Enable Package Whitelisting",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = packageActivityDetails.enablePackageWhitelisting,
                    onValueChange = {
                        packageActivityViewModel.setEnablePackageWhitelisting(it)
                    },
                    checkBoxValue = packageActivityDetails.enablePackageWhitelistingBlockPackageCheckBox,
                    checkBoxText = "Block Package",
                    onCheckBoxChange = {
                        packageActivityViewModel.setEnablePackageWhitelistingBlockPackageCheckBox(it)
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowEnablePackageWhitelistingDialog(false)
                        PackageActivityOnClickListeners.onEnablePackageWhitelistingClick(
                            packageActivityViewModel
                        )
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowEnablePackageWhitelistingDialog(false)
                    }
                )
            }
        }

        @Composable
        fun AutoStartAppAndLockItDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            var packageName by remember { mutableStateOf("") } // Holds the package name
            var oldPassword by remember { mutableStateOf("") } // Holds the old password
            var newPassword by remember { mutableStateOf("") } // Holds the new password

            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowAutoStartAppAndLockItDialog(true)
            }
            if (packageActivityDetails.showAutoStartAppAndLockItDialog) {
                TripleTextFieldTwoButtonDialog(
                    title = "Elo Auto Start App And Lock It",
                    textFieldValue1 = packageName,
                    textFieldValue1Hint = packageActivityDetails.autoStartAppAndLockItPackageNameHint,
                    onValueChange1 = {
                        packageName = it
                        packageActivityViewModel.setAutoStartAppAndLockItPackageName(it)
                        Log.d(TAG, "AutoStartAppAndLockItDialog: setAutoStartAppAndLockItPackageName $it")
                    },
                    textFieldValue2 = oldPassword,
                    textFieldValue2Hint = packageActivityDetails.autoStartAppAndLockItOldPasswordHint,
                    onValueChange2 = {
                        oldPassword = it
                        packageActivityViewModel.setAutoStartAppAndLockItOldPassword(it)
                        Log.d(TAG, "AutoStartAppAndLockItDialog: setAutoStartAppAndLockItOldPassword $it")

                    },
                    textFieldValue3 = newPassword,
                    textFieldValue3Hint = packageActivityDetails.autoStartAppAndLockItNewPasswordHint,
                    onValueChange3 = {
                        newPassword=it
                        packageActivityViewModel.setAutoStartAppAndLockItNewPassword(it)
                        Log.d(TAG, "AutoStartAppAndLockItDialog: setAutoStartAppAndLockItNewPassword $it")
                        Log.d(TAG, "AutoStartAppAndLockItDialog: setAutoStartAppAndLockItNewPassword ${packageActivityViewModel.getAutoStartAppAndLockItNewPassword()}")
                    },
                    onConfirmClick = {
                        packageActivityViewModel.setShowAutoStartAppAndLockItDialog(false)
                        PackageActivityOnClickListeners.onAutoStartAppAndLockItClick(
                            packageActivityViewModel
                        )
                        packageName = ""
                        oldPassword = ""
                        newPassword = ""
                    },
                    onCancelClick = {
                        packageName = ""
                        oldPassword = ""
                        newPassword = ""
                        packageActivityViewModel.setShowAutoStartAppAndLockItDialog(false)
                    }
                )
            }
        }

        @Composable
        fun RemoveTaskAutoStartAndLockingDialog(
            packageActivityViewModel: PackageActivityViewModel = PackageActivityViewModel(
                applicationContext = Activity(),
                true
            )
        ) {
            val context = LocalContext.current
            val packageActivityDetails by packageActivityViewModel.packageActivityState.collectAsState()
            if (PackageActivityViewModel.isPreview) {
                packageActivityViewModel.setShowRemoveTaskAutoStartAndLockingDialog(true)
            }
            if (packageActivityDetails.showRemoveTaskAutoStartAndLockingDialog) {
                SingleTextFieldDoubleCheckBoxTwoButtonDialog(
                    title = "Elo Remove Task Auto Start And Locking",
                    textFieldValue = packageActivityDetails.removeTaskAutoStartAndLockingPassword,
                    textFieldHint = "Password",
                    onValueChange = {
                        packageActivityViewModel.setRemoveTaskAutoStartAndLockingPassword(it)
                    },
                    checkBoxValue1 = packageActivityDetails.temporaryUnpinCheckBox,
                    checkBoxText1 = "Temporary unpin",
                    onCheckBoxChange1 = {
                        packageActivityViewModel.setTemporaryUnpinCheckBox(it)
                        packageActivityViewModel.setPermanentUnpinCheckBox(!it)
                    },
                    checkBoxValue2 = packageActivityDetails.permanentUnpinCheckBox,
                    checkBoxText2 = "Permanent unpin",
                    onCheckBoxChange2 = {
                        packageActivityViewModel.setPermanentUnpinCheckBox(it)
                        packageActivityViewModel.setTemporaryUnpinCheckBox(!it)
                    },
                    onConfirmClick = {
                        if (packageActivityDetails.removeTaskAutoStartAndLockingPassword.isEmpty()) {
                            Toast.makeText(context, "Password can't be empty", Toast.LENGTH_SHORT).show()
                            packageActivityViewModel.setShowRemoveTaskAutoStartAndLockingDialog(false)
                            PackageActivityOnClickListeners.onRemoveTaskAutoStartAndLockingClick(
                                packageActivityViewModel
                            )
                        } else {
                            packageActivityViewModel.setShowRemoveTaskAutoStartAndLockingDialog(false)
                            PackageActivityOnClickListeners.onRemoveTaskAutoStartAndLockingClick(
                                packageActivityViewModel
                            )
                        }
                    },
                    onCancelClick = {
                        packageActivityViewModel.setShowRemoveTaskAutoStartAndLockingDialog(false)
                    }
                )
            }
        }

    }
}