/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.otaActivity

import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import com.eloview.sdk.testapp.common.CommonDialogComposables
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.SingleTextFieldTwoButtonDialog
import com.eloview.sdk.testapp.viewmodel.OtaActivityViewModel

class OtaActivityDialogs {
    companion object {

        @Composable
        fun CheckEloOtaStatusDialog(otaActivityViewModel: OtaActivityViewModel) {
            val otaActivityDetails by otaActivityViewModel.otaActivityState.collectAsState()
            if (OtaActivityViewModel.isPreview) {
                otaActivityViewModel.setShowCheckEloOtaStatusDialog(true)
            }
            if (otaActivityDetails.showCheckEloOtaStatusDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Check Elo OTA Status",
                    textFieldValue = otaActivityDetails.checkEloOtaStatusUrl,
                    onValueChange = {
                        otaActivityViewModel.setCheckEloOtaStatusUrl(it)
                    },
                    onCancelClick = {
                        otaActivityViewModel.setShowCheckEloOtaStatusDialog(false)
                    },
                    onConfirmClick = {
                        otaActivityViewModel.setShowCheckEloOtaStatusDialog(false)
                        OtaActivityOnClickListeners.onCheckEloOtaStatusClick(otaActivityViewModel)
                    }
                )
            }
        }

        @Composable
        fun GetAvailableVersionsDialog(otaActivityViewModel: OtaActivityViewModel) {
            val otaActivityDetails by otaActivityViewModel.otaActivityState.collectAsState()
            if (OtaActivityViewModel.isPreview) {
                otaActivityViewModel.setShowGetAvailableVersionsDialog(true)
            }
            if (otaActivityDetails.showGetAvailableVersionsDialog) {
                CommonDialogComposables.SingleDropDownTwoButtonDialog(
                    title = "Get Available Versions",
                    dropDownValues = arrayOf(
                        "Device Default",
                        "Q GMS Perf",
                        "Q AOSP Perf",
                        "Q GMS Val",
                        "Q AOSP Val",
                        "S GMS Perf",
                        "S AOSP Perf",
                        "S GMS Val",
                        "S AOSP Val",
                        "S 7 Inch Pay",
                        "S M100",
                        "U GMS Rigel Perf"
                    ),
                    selectedValue = otaActivityDetails.selectedAvailableVersion,
                    onValueSelected = {
                        otaActivityViewModel.setSelectedAvailableVersion(it)
                    },
                    onConfirmClick = {
                        otaActivityViewModel.setShowGetAvailableVersionsDialog(false)
                        OtaActivityOnClickListeners.onGetAvailableVersionsClick(otaActivityViewModel)
                    },
                    onCancelClick = {
                        otaActivityViewModel.setShowGetAvailableVersionsDialog(false)
                    }
                )
            }
        }

        @Composable
        fun DownloadEloOtaPackageFromUrlDialog(otaActivityViewModel: OtaActivityViewModel) {
            val otaActivityDetails by otaActivityViewModel.otaActivityState.collectAsState()
            if (OtaActivityViewModel.isPreview) {
                otaActivityViewModel.setShowDownloadEloOtaPackageFromUrlDialog(true)
            }
            if (otaActivityDetails.showDownloadEloOtaPackageFromUrlDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Download Elo OTA Package From URL",
                    textFieldValue = otaActivityDetails.downloadEloOtaPackageFromUrl,
                    onValueChange = {
                        otaActivityViewModel.setDownloadEloOtaPackageFromUrl(it)
                    },
                    onCancelClick = {
                        otaActivityViewModel.setShowDownloadEloOtaPackageFromUrlDialog(false)
                    },
                    onConfirmClick = {
                        otaActivityViewModel.setShowDownloadEloOtaPackageFromUrlDialog(false)
                        OtaActivityOnClickListeners.onDownloadEloOtaPackageFromUrlClick(
                            otaActivityViewModel
                        )
                    }
                )
            }
        }

        @Composable
        fun DownloadEloOtaPackageFromLocalPathDialog(otaActivityViewModel: OtaActivityViewModel) {
            val otaActivityDetails by otaActivityViewModel.otaActivityState.collectAsState()
            if (OtaActivityViewModel.isPreview) {
                otaActivityViewModel.setShowDownloadEloOtaPackageFromLocalPathDialog(true)
            }
            if (otaActivityDetails.showDownloadEloOtaPackageFromLocalPathDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Download Elo OTA Package From Local Path",
                    textFieldValue = otaActivityDetails.downloadEloOtaPackageFromLocalPath,
                    onValueChange = {
                        otaActivityViewModel.setDownloadEloOtaPackageFromLocalPath(it)
                    },
                    onCancelClick = {
                        otaActivityViewModel.setShowDownloadEloOtaPackageFromLocalPathDialog(false)
                    },
                    onConfirmClick = {
                        otaActivityViewModel.setShowDownloadEloOtaPackageFromLocalPathDialog(false)
                        OtaActivityOnClickListeners.onDownloadEloOtaPackageFromLocalPathClick(
                            otaActivityViewModel
                        )
                    }
                )
            }
        }

        @Composable
        fun DownloadSpecificEloOtaVersionDialog(otaActivityViewModel: OtaActivityViewModel) {
            val otaActivityDetails by otaActivityViewModel.otaActivityState.collectAsState()
            if (OtaActivityViewModel.isPreview) {
                otaActivityViewModel.setShowDownloadSpecificEloOtaVersionDialog(true)
            }
            if (otaActivityDetails.showDownloadSpecificEloOtaVersionDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Download Specific Elo OTA Version",
                    textFieldValue = otaActivityDetails.selectedSpecificEloOtaVersion,
                    onValueChange = {
                        otaActivityViewModel.setSelectedSpecificEloOtaVersion(it)
                    },
                    onCancelClick = {
                        otaActivityViewModel.setShowDownloadSpecificEloOtaVersionDialog(false)
                    },
                    onConfirmClick = {
                        otaActivityViewModel.setShowDownloadSpecificEloOtaVersionDialog(false)
                        OtaActivityOnClickListeners.onDownloadSpecificEloOtaVersionClick(
                            otaActivityViewModel
                        )
                    }
                )
            }
        }

    }
}