/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.infoActivity

import android.util.Log
import com.eloview.sdk.infoManager.Info
import com.eloview.sdk.testapp.viewmodel.InfoActivityViewModel

class InfoActivityOnClickListeners {
    companion object {
        private const val TAG = "InfoActivityOnClickListeners"
        fun onGetDeviceInfoClick(infoActivityViewModel: InfoActivityViewModel) {
            if (infoActivityViewModel.getServiceConnected()) {
                infoActivityViewModel.setOutput("Device info: ${infoActivityViewModel.infoServiceManager?.deviceInfo}")
            } else {
                infoActivityViewModel.setOutput("Service not connected")
            }
        }

        fun onIsSdkSupportedClick(infoActivityViewModel: InfoActivityViewModel) {
            infoActivityViewModel.setOutput("Checking if SDK is supported...")
            if (infoActivityViewModel.infoServiceManager?.isSDKSupported == true) {
                infoActivityViewModel.setOutput("SDK is supported.")
            } else {
                infoActivityViewModel.setOutput("SDK is not supported.")
            }
        }

        fun onGetSdkVersionClick(infoActivityViewModel: InfoActivityViewModel) {
            infoActivityViewModel.setOutput(
                "SDK version: ${
                    infoActivityViewModel.infoServiceManager?.sdkVersion
                }"
            )
        }

        fun onGetSystemCpuUsageClick(infoActivityViewModel: InfoActivityViewModel) {
            if (infoActivityViewModel.getServiceConnected()) {
                infoActivityViewModel.setOutput(infoActivityViewModel.infoServiceManager?.systemCpuUsage.toString())
            } else {
                infoActivityViewModel.setOutput("Service not connected")
            }
        }

        fun onRegisterDeviceInfoReceiverClick(infoActivityViewModel: InfoActivityViewModel) {
            if (infoActivityViewModel.getServiceConnected()) {
                val stdAndroid: Boolean =
                    infoActivityViewModel.infoServiceManager?.readSystemProperty("persist.sys.stdandroid")
                        .equals("true")
                if (stdAndroid) {
                    infoActivityViewModel.setOutput("This feature is only applicable for Control and Core Mode.")
                    Log.i(
                        TAG,
                        "This feature is only applicable for Control and Core Mode."
                    )
                    return
                }
                val results =
                    infoActivityViewModel.infoServiceManager?.registerDeviceInfoReceiver(
                        infoActivityViewModel.applicationContext,
                        infoActivityViewModel.mDeviceInfoReceiver
                    )
                when (results) {
                    Info.REGISTERED_SUCCESSFULLY_CODE -> {
                        infoActivityViewModel.setOutput("Device Info Receiver registered successfully.")
                    }

                    Info.REGISTER_CTX_NULL_CODE -> {
                        infoActivityViewModel.setOutput("Failed to register Device Info Manager.")
                    }

                    Info.REGISTERED_EXCEPTION_CODE -> {
                        infoActivityViewModel.setOutput("Failed to register Device Info Manager.")
                    }

                    else -> {
                        infoActivityViewModel.setOutput("Failed to register Device Info Manager.")
                    }
                }
                Log.d(TAG, "registerDeviceInfoReceiver: $results")
            } else {
                infoActivityViewModel.setOutput("Service not connected")
            }
        }

        fun onUnregisterDeviceInfoReceiverClick(infoActivityViewModel: InfoActivityViewModel) {
            if (infoActivityViewModel.getServiceConnected()) {
                val stdAndroid: Boolean =
                    infoActivityViewModel.infoServiceManager?.readSystemProperty("persist.sys.stdandroid")
                        .equals("true")
                if (stdAndroid) {
                    infoActivityViewModel.setOutput("This feature is only applicable for Control and Core Mode.")
                    Log.i(
                        TAG,
                        "This feature is only applicable for Control and Core Mode."
                    )
                    return
                }
                val result = infoActivityViewModel.infoServiceManager?.unregisterDeviceInfoReceiver(
                    infoActivityViewModel.applicationContext,
                    infoActivityViewModel.mDeviceInfoReceiver
                )
                Log.d(TAG, "unregisterDeviceInfoReceiver: $result")
                when (result) {
                    Info.UNREGISTERED_SUCCESSFULLY_CODE -> {
                        infoActivityViewModel.setOutput("Device Info Receiver unregistered successfully.")
                    }

                    Info.UNREGISTER_CTX_NULL_CODE -> {
                        infoActivityViewModel.setOutput("Failed to unregister Device info Manager.")
                    }

                    Info.UNREGISTERED_EXCEPTION_CODE -> {
                        infoActivityViewModel.setOutput("Failed to unregister Device info Manager.")
                    }

                    else -> {
                        infoActivityViewModel.setOutput("Failed to unregister Device info Manager.")
                    }
                }
                Log.d(TAG, "unregisterDeviceInfoReceiver: $result")
            } else {
                infoActivityViewModel.setOutput("Service not connected")
            }
        }
    }
}