/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.eloActivity

import com.eloview.sdk.testapp.viewmodel.EloActivityViewModel

class EloActivityOnClickListeners {
    companion object {
        fun onSetOfflinePlayContentClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val offlinePlayContentPackageName =
                    eloActivityViewModel.getOfflinePlayContentPackageName()

                val status = eloActivityViewModel.eloviewServiceManager?.setOfflinePlayContent(
                    offlinePlayContentPackageName
                )
                if (!status.isNullOrEmpty()) {
                    eloActivityViewModel.setOutput(status)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onGetOfflinePlayContentClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.playContent
                if (!status.isNullOrEmpty()) {
                    eloActivityViewModel.setOutput(status)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onGetOfflinePlayContentStatusClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.playContentStatus
                if (!status.isNullOrEmpty()) {
                    eloActivityViewModel.setOutput(status)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onGetDeviceOnlineStatusClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.deviceCloudStatus
                if (!status.isNullOrEmpty()) {
                    eloActivityViewModel.setOutput(status)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onEnableWifiOptionInQuickSettingsWithoutAdminPasswordClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.toggleWifi(true)
                val messageText = eloActivityViewModel.wifiStatus(status)
                if (messageText.isNotEmpty()) {
                    eloActivityViewModel.setOutput(messageText)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onDisableWifiOptionInQuickSettingsWithoutAdminPasswordClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.toggleWifi(false)
                val messageText = eloActivityViewModel.wifiStatus(status)
                if (messageText.isNotEmpty()) {
                    eloActivityViewModel.setOutput(messageText)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onEnableBluetoothOptionInQuickSettingsWithoutAdminPasswordClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.toggleBT(true)
                val messageText = eloActivityViewModel.bluetoothStatus(status)
                if (messageText.isNotEmpty()) {
                    eloActivityViewModel.setOutput(messageText)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onDisableBluetoothOptionInQuickSettingsWithoutAdminPasswordClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val status = eloActivityViewModel.eloviewServiceManager?.toggleBT(false)
                val messageText = eloActivityViewModel.bluetoothStatus(status)
                if (messageText.isNotEmpty()) {
                    eloActivityViewModel.setOutput(messageText)
                } else {
                    eloActivityViewModel.setOutput("Connection not established")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }

        fun onSwitchToAndroidHomeModeClick(eloActivityViewModel: EloActivityViewModel) {
            if (eloActivityViewModel.getServiceConnected()) {
                val deviceMode: String? =
                    eloActivityViewModel.eloviewServiceManager?.readSystemProperty("persist.sys.devicemode")
                if (deviceMode.equals("core", ignoreCase = true) || deviceMode.equals(
                        "control",
                        ignoreCase = true
                    ) || deviceMode.equals("connect", ignoreCase = true)
                ) {

                    if (eloActivityViewModel.eloviewServiceManager?.switchToAndroidHomeMode() == true) {
                        eloActivityViewModel.setOutput("Switched to Android Home Mode")
                    } else {
                        eloActivityViewModel.setOutput("Failed to switch to Android Home Mode")
                    }
                } else {
                    eloActivityViewModel.setOutput("Action only supported in EloView mode")
                }
            } else {
                eloActivityViewModel.setOutput("Service not Connected")
            }
        }
    }
}