/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp.eloActivity

import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import com.eloview.sdk.testapp.common.CommonDialogComposables.Companion.SingleTextFieldTwoButtonDialog
import com.eloview.sdk.testapp.viewmodel.EloActivityViewModel

class EloActivityDialogs {
    companion object {
        @Composable
        fun OfflinePlayContentDialog(eloActivityViewModel: EloActivityViewModel) {
            val eloActivityDetails by eloActivityViewModel.eloActivityState.collectAsState()
            if (EloActivityViewModel.isPreview) {
                eloActivityViewModel.setShowOfflinePlayContentDialog(true)
            }
            if (eloActivityDetails.showOfflinePlayContentDialog) {
                SingleTextFieldTwoButtonDialog(
                    title = "Set Offline Play Content",
                    textFieldValueHint = "com.example.example",
                    textFieldValue = eloActivityDetails.offlinePlayContentPackageName,
                    onValueChange = {
                        eloActivityViewModel.setOfflinePlayContentPackageName(it)
                    },
                    onConfirmClick = {
                        eloActivityViewModel.setShowOfflinePlayContentDialog(false)
                        EloActivityOnClickListeners.onSetOfflinePlayContentClick(
                            eloActivityViewModel
                        )
                    },
                    onCancelClick = {
                        eloActivityViewModel.setShowOfflinePlayContentDialog(false)
                    }
                )
            }
        }
    }
}