/*
 * Copyright (c) 2014-2025. Elo Touch Solution
 * License Terms
 *     - License does not expire
 *     - Source-code or binary products cannot be resold or distributed
 *     - Should be used only on Elo products
 *     - Cannot modify source-code for any purpose (cannot create derivative works)
 */

package com.eloview.sdk.testapp

import android.content.Context
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.eloview.sdk.testapp.viewmodel.AccountManagerViewModel

/**
 * Factory class for creating instances of AccountManagerViewModel.
 * Ensures that the ViewModel is initialized with the necessary parameters.
 *
 * @param applicationContext The application context required by the ViewModel.
 * @param preview A flag to determine if the ViewModel is in preview mode (default: false).
 */
class AccountManagerViewModelFactory(
    private val applicationContext: Context, // Application context needed by the ViewModel
    private val preview: Boolean = false
) : ViewModelProvider.Factory {

    /**
     * Creates a new instance of the given ViewModel class.
     * Verifies if the requested ViewModel is of type AccountManagerViewModel and provides it.
     *
     * @param modelClass The class of the ViewModel to create.
     * @return An instance of the requested ViewModel.
     * @throws IllegalArgumentException if the ViewModel class is not recognized.
     */
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(AccountManagerViewModel::class.java)) {
            @Suppress("UNCHECKED_CAST")
            return AccountManagerViewModel(applicationContext, preview) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}
