package com.eloview.homesdk.testapp;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import com.eloview.homesdk.common.PrintLog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Util {

    public final static String TAG = "Util";

    public static void hideKeyboard(Activity activity) {
        InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
        //Find the currently focused view, so we can grab the correct window token from it.
        View view = activity.getCurrentFocus();
        //If no view currently has focus, create a new one, just so we can grab a window token from it
        if (view == null) {
            view = new View(activity);
        }
        assert imm != null;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    /**
     * @param name property to read
     * @return value of the property
     */
    protected static String readSystemProperty(String name) {
        InputStreamReader in = null;
        BufferedReader reader = null;
        try {
            Process proc = Runtime.getRuntime().exec(new String[]{"/system/bin/getprop", name});
            in = new InputStreamReader(proc.getInputStream());
            reader = new BufferedReader(in);
            return reader.readLine();
        } catch (IOException e) {
            PrintLog.e("readSystemProperty - IOException" + e);
            return "";
        } finally {
            try {
                assert in != null;
                in.close();
                assert reader != null;
                reader.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isAndroidQDevice() {
        Log.v(TAG, "Model " + Build.MODEL);
        switch (Build.MODEL) {
            case "10in-I-Series-4":
            case "15in-I-Series-4":
            case "22in-I-Series-4":
            case "10in-I-Series-4-Value":
            case "15in-I-Series-4-Value":
            case "22in-I-Series-4-Value":
            case "15in-I-Series-4-USB-C":
            case "Backpack-4":
            case "Backpack-4-Value":
            case "15in-I-Series-4-LS":
            case "15in-I-Series-4-USBC-V":
            case "M50":
            case "M50C":
            case "M60-Pay":
            case "M60C-Pay":
            case "7in-I-Series-Pay":
            case "M100":
            case "M100C": {
                return true;
            }
            default:
                return false;
        }
    }

    public static boolean isValueDevice() {
        return Build.DISPLAY.toLowerCase().contains("5.") && Build.DISPLAY.toLowerCase().contains("+v") ||
                (Build.DISPLAY.toLowerCase().contains("5.") && Build.DISPLAY.toLowerCase().contains("+av")) ||
                (Build.DISPLAY.toLowerCase().contains("6.") && Build.DISPLAY.toLowerCase().contains("+v")) ||
                (Build.DISPLAY.toLowerCase().contains("6.") && Build.DISPLAY.toLowerCase().contains("+av"));
    }
}
