package com.eloview.homesdk.testapp;

import android.os.Bundle;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import org.json.JSONArray;
import org.json.JSONObject;

public class UsbInfoActivity extends AppCompatActivity {
    public static final int HUB_PORT = 10;
    String jsonString = "";
    JSONObject jObject = null;
    private LinearLayout linearUsbBtns;
    private TextView txtSelectedUsbInfo, txtPeripheralAttached;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_usb_info);
        init();
    }

    public void init() {
        linearUsbBtns = findViewById(R.id.linear_usb_btns);
        txtSelectedUsbInfo = findViewById(R.id.txt_selected_usb_info);
        txtPeripheralAttached = findViewById(R.id.txt_peripheral_attached);
        Button btnBack = findViewById(R.id.btn_back);
        btnBack.setOnClickListener(view -> onBackPressed());
        if (getIntent().hasExtra("PeripheralInfo") && getIntent().getStringExtra("PeripheralInfo") != null) {
            jsonString = getIntent().getStringExtra("PeripheralInfo");
        }
        parseUsbInfo();
    }

    public void parseUsbInfo() {
        try {
            jObject = new JSONObject(jsonString);
            JSONObject peripheralDeviceObj = jObject.getJSONObject("peripheral_device");
            JSONArray usbArray;
            usbArray = peripheralDeviceObj.getJSONArray("usb");
            final int listofUsbDevices = usbArray.length();
            if (listofUsbDevices == 0) {
                txtPeripheralAttached.setText("PERIPHERAL NOT ATTACHED");
            }
            // Required to add the view according the attached USB Ports
            if (listofUsbDevices > 0) {
                for (int index = 0; index < listofUsbDevices; index++) {
                    final JSONObject usb = usbArray.getJSONObject(index);
                    Button btnTag = new Button(this);
                    LinearLayout.LayoutParams buttonLayoutParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
                    buttonLayoutParams.setMargins(0, 10, 0, 10);
                    String hubType = (String) peripheralDeviceObj.opt("hubType");
                    btnTag.setTextSize(18);
                    Integer usbPort = ((Integer) usb.opt("usbPort"));
                    assert usbPort != null;
                    if (usbPort > HUB_PORT) {
                        usbPort = usbPort - HUB_PORT;
                    }
                    if (hubType != null) {
                        if (usb.opt("attachedWith") == null) {
                            btnTag.setText("USB 0" + usbPort + " [Device]");
                        } else {
                            btnTag.setText("USB 0" + usbPort + " [" + hubType + "]");
                        }
                    } else {
                        btnTag.setText("USB 0" + usbPort + " [Device]");
                    }
                    String usbInfo = "DeviceName : " + usb.opt("deviceName") +
                            "\nProduct Id : " + usb.opt("product") +
                            "\nProductName : " + usb.opt("productName") +
                            "\nDeviceID : " + usb.opt("deviceID") +
                            "\nSerial Number : " + usb.opt("serialNumber") +
                            "\nVendorId : " + usb.opt("vendorId") +
                            "\nManufacturer : " + usb.opt("manufacturerName") +
                            "\nVersion : " + usb.opt("version") +
                            "\nClass : " + usb.opt("class") +
                            "\nSubclass : " + usb.opt("subclass") +
                            "\nProtocol : " + usb.opt("deviceProtocol") +
                            "\nInterfaceType : " + usb.opt("interfaceType") +
                            "\nUsbPort : " + usbPort +
                            "\nHubType : " + hubType;
                    btnTag.setTag(R.string.btn_tag_usbinfo, usbInfo);
                    btnTag.setOnClickListener(view -> {
                        String info = btnTag.getTag(R.string.btn_tag_usbinfo).toString();
                        if (!info.equals("")) {
                            showUsbInfoDialog(info);
                        }
                    });
                    linearUsbBtns.addView(btnTag, buttonLayoutParams);
                }
                if (linearUsbBtns.getChildCount() > 0) {
                    txtSelectedUsbInfo.setText(linearUsbBtns.getChildAt(0).getTag(R.string.btn_tag_usbinfo).toString());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showUsbInfoDialog(String usbInfo) {
        txtSelectedUsbInfo.setText(usbInfo);
    }
}