package com.eloview.homesdk.testapp;

import static android.widget.LinearLayout.VERTICAL;
import static com.eloview.homesdk.testapp.Util.hideKeyboard;
import static com.eloview.homesdk.testapp.Util.readSystemProperty;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.Service;
import android.app.TimePickerDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.StatFs;
import android.provider.Settings;
import android.text.InputType;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.method.DigitsKeyListener;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.work.WorkManager;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.packageManager.Package;
import com.eloview.homesdk.systemManager.System;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

class ShutdownReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (Objects.equals(intent.getAction(), Intent.ACTION_SHUTDOWN)) {
            Log.d("ShutdownReceiver", "onReceive: ");
            WorkManager.getInstance(context).cancelAllWork();
        }
    }
}

public class SystemActivity extends Activity implements DatePickerDialog.OnDateSetListener, TimePickerDialog.OnTimeSetListener {

    private static final String TAG = SystemActivity.class.getSimpleName();
    private static final String LOG_TAG = "SystemActivity";
    static boolean isTokenVerified = false;
    static boolean listenerSet = false;
    private static int backlightTimeoutSelection = -1;
    private static int dpiSelection = 0;
    private static int macSelection = -1;
    private static String mDisplaySelection = " ";
    private static String mLockSelection = " ";
    private static String mFontSelection = " ";
    private static String volumeType = "";
    private static boolean isLogsEnable = false;
    private final String[] orientations = {"landscape (0)", "portrait (90)", "landscape-reverse (180)", "portrait-reverse (270)"};
    private final int ACTIVITY_RESULT_SUCCESS = 123;
    Button scanbcr;
    Button setbcr;
    Button bt_account_manager;
    Button bt_enable_vp_show_more;
    Button bt_disable_vp_show_more;
    Button bt_enable_txt_assist;
    Button bt_disable_txt_assist;
    CheckBox mCheckBox;
    boolean AutoDateTime = false;
    Switch wifiSwitch, swPlayProtect;
    ShutdownReceiver mReceiver;
    private String responseKey = "";
    private String responseValue = "";
    private boolean isVerified = false;
    private boolean callFromSdk = false;
    private TextView txt_result;
    private String accessToken = "";
    private RadioButton rbEnable;
    private RadioGroup rgSetAudio;
    private String Screen_lock_type = "NULL";
    private int myday;
    private int myMonth;
    private int myYear;
    private EditText etVolumeRange;
    private EditText setNtpEditText;
    private Button toggleDarkModeBtn;
    private Button btnSpFirmware;
    private Button btnUnlock;
    private Button btnLock;
    private String ReservedLogSpace;
    private String CurrentLogSpace;
    private Boolean HasChangedLogSize;
    private CheckBox mNoRebootsetNTPURLCheckBox;
    private CheckBox mNTPPollnoRebootCheckBox;
    private CheckBox mNoRebootsetOriCheckBox;
    private CheckBox mNoRebootMultiClientIME;
    private String selectedWifiMacAddress = "";
    private RadioButton rbDisableBluetooth, rbExternalSpeaker, rbInvalidFileSignature;
    private RadioButton rbDisableScreenLockSound;
    private RadioButton rbDisableChargingSoundandVibration;
    private Button btnSetMagMode;
    private RadioButton rbDisableMagMode;
    private static final String ACTION_UPDATE_TEXT_RESULT = "com.eloview.homesdk.testapp.ACTION_UPDATE_TEXT_RESULT";
    private static final String AOSP_PACKAGE_NAME = "com.android.inputmethod.latin";
    private static final String GOOGLE_KEYBOARD_PACKAGE = "com.google.android.inputmethod.latin";
    boolean isAOSPKeyboardPresent = false;
    boolean isGboardPresent = false;
    private Button btnSetShowTaps;
    private RadioButton rbDisableShowTaps;
    private String absoluteFilePath = "";
    private BroadcastReceiver pairingRequestReceiver;
    private String enteredMacAddress = "";
    private boolean isEnableSelected = true;


    private final BroadcastReceiver updateTextResultReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            String result = intent.getStringExtra("result");
            txt_result.setText(result);
        }
    };
    public final Handler systemHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {
            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            boolean show_toast = (responseValue != null && !responseValue.equals(val)) || callFromSdk;
            if (!b.getBoolean("RESENT_DATA")) {
                responseKey = key;
                responseValue = val;
            } else {
                responseValue = "";
                responseKey = "";
            }
            if (val == null) {
                val = "";
            }
            Log.d("SystemActivity", "key " + msg.what);
            Log.d("SystemActivity", "val " + val);
            switch (msg.what) {
                case AccountManager.TOKEN_VERIFY_FAIL:
                    Log.v(TAG, "INVALID_TOKEN");
                    val = "INVALID_TOKEN :\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, getResources().getString(R.string.invalid_token_msg), Toast.LENGTH_LONG).show();
                    }
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case System.CAPTURE_RESULT_CODE:
                    Log.v(TAG, "CAPTURE_RESULT_CODE");
                    val = "CAPTURE_RESULT_CODE :\n" + val;
                    //Toast.makeText(StdAndPkgInstActivity.this, "Please use getToken  to receive a valid accessToken", Toast.LENGTH_LONG).show();
                    break;
                case System.GENERIC_ERROR:
                    Log.v(TAG, "ELOSDK_GENERIC_ERROR");
                    val = "ELOSDK_GENERIC_ERROR :\n" + val;
                    break;
                case System.GET_ORIENTATION_RESULT_CODE:
                    Log.v(TAG, "GET_ORIENTATION_RESULT_CODE");
                    val = "GET_ORIENTATION_RESULT_CODE :\n" + val;
                    break;
                case System.SET_ORIENTATION_RESULT_CODE:
                    Log.v(TAG, "SET_ORIENTATION_RESULT_CODE");
                    val = "SET_ORIENTATION_RESULT_CODE :\n" + val;
                    break;
                case System.SET_RESERVED_LOG_SPACE_RESULT_CODE:
                    Log.v(TAG, "SET_RESERVED_LOG_SPACE_RESULT_CODE");
                    val = "SET_RESERVED_LOG_SPACE_RESULT_CODE : \n" + val;
                    break;
                case System.GET_RESERVED_LOG_SPACE_RESULT_CODE:
                    Log.v(TAG, "GET_RESERVED_LOG_SPACE_RESULT_CODE " + val);
                    if (val.equalsIgnoreCase("UNKNOWN")) {
                        val = "GET_RESERVED_LOG_SPACE_RESULT_CODE : \n144 MB";
                    } else {
                        val = "GET_RESERVED_LOG_SPACE_RESULT_CODE : \n" + val;
                    }
                    break;
                case System.SET_MULTI_CLIENT_IME_RESULT_CODE:
                    Log.v(TAG, "SET_MULTI_CLIENT_IME_RESULT_CODE");
                    val = "SET_MULTI_CLIENT_IME_RESULT_CODE : \n" + val;
                    break;
                case System.GET_MULTI_CLIENT_IME_RESULT_CODE:
                    Log.v(TAG, "GET_MULTI_CLIENT_IME_RESULT_CODE");
                    val = "GET_MULTI_CLIENT_IME_RESULT_CODE : \n" + val;
                    break;
                case System.SET_NAVIGATION_BAR_RESULT_CODE:
                    Log.v(TAG, "SET_NAVIGATION_BAR_RESULT_CODE");
                    val = "SET_NAVIGATION_BAR_RESULT_CODE :\n" + val;
                    break;
                case System.GET_NAVIGATION_BAR_RESULT_CODE:
                    Log.v(TAG, "GET_NAVIGATION_BAR_RESULT_CODE");
                    val = "GET_NAVIGATION_BAR_RESULT_CODE :\n" + val;
                    break;
                case System.SET_STATUS_BAR_RESULT_CODE:
                    Log.v(TAG, "SET_STATUS_BAR_RESULT_CODE");
                    val = "SET_STATUS_BAR_RESULT_CODE :\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_SHORT).show();
                    }
                    break;
                case System.GET_STATUS_BAR_RESULT_CODE:
                    Log.v(TAG, "GET_STATUS_BAR_RESULT_CODE");
                    val = "GET_STATUS_BAR_RESULT_CODE :\n" + val;
                    break;
                case System.SET_GRANT_PERMISSION_RESULT_CODE:
                    Log.v(TAG, "SET_GRANT_PERMISSION_RESULT_CODE");
                    val = "SET_GRANT_PERMISSION_RESULT_CODE :\n" + val;
                    break;
                case System.GET_GRANT_PERMISSION_RESULT_CODE:
                    Log.v(TAG, "GET_GRANT_PERMISSION_RESULT_CODE");
                    val = "GET_GRANT_PERMISSION_RESULT_CODE :\n" + val;
                    break;
                case System.BACKLIGHT_TIMEOUT:
                    Log.v(TAG, "BACKLIGHT_TIMEOUT");
                    val = "BACKLIGHT_TIMEOUT RESPONSE:\n" + val;
                    break;
                case System.PASSWORD_LOCK_CODE:
                    Log.v(TAG, "PASSWORD_LOCK_CODE");
                    val = "PASSWORD_LOCK_CODE RESPONSE:\n" + val;
                    break;
                case System.PIN_LOCK_CODE:
                    Log.v(TAG, "PIN_LOCK_CODE");
                    val = "PIN_LOCK_CODE RESPONSE:\n" + val;
                    break;
                case System.SET_PLAYPROTECT_RESULT_CODE:
                    Log.v(TAG, "SET_PLAYPROTECT_RESULT_CODE");
                    val = "SET_PLAYPROTECT_RESULT_CODE :\nPlayProtect:" + val;
                    break;
                case System.GET_PLAYPROTECT_RESULT_CODE:
                    Log.v(TAG, "GET_PLAYPROTECT_RESULT_CODE");
                    val = "GET_PLAYPROTECT_RESULT_CODE :\nPlayProtect:" + val;
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    isVerified = true;
                    isTokenVerified = false;
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    break;
                case System.HOME_BUTTON_RESPONSE_CODE:
                    Log.d(TAG, "HOME_BUTTON_RESPONSE_CODE");
                    val = "HOME_BUTTON_RESPONSE_CODE :\n" + val;
                    break;
                case System.SET_ACCESSIBILITY_SERVICE_RESULT_CODE:
                    Log.d(TAG, "SET_ACCESSIBILITY_SERVICE_RESULT_CODE");
                    val = "SET_ACCESSIBILITY_SERVICE_RESULT_CODE :\n" + val;
                    break;
                case System.POWER_BUTTON_RESPONSE_CODE:
                    Log.d(TAG, "POWER_BUTTON_RESPONSE_CODE");
                    val = "POWER_BUTTON_RESPONSE_CODE :\n" + val;
                    break;
                case System.EDITOR_SHOW_OPTION_CODE:
                    Log.d(TAG, "EDITOR_SHOW_OPTIONS_CODE");
                    val = "EDITOR_SHOW_OPTION_CODE :\n" + val;
                    break;
                case System.TIMEZONE_CODE:
                    Log.d(TAG, "TIMEZONE_CODE");
                    val = "TIMEZONE_CODE :\n" + val;
                    break;
                case System.LOCALE_CODE:
                    Log.d(TAG, "LOCAL_CODE");
                    val = "LOCAL_CODE :\n" + val;
                    break;
                case System.DPI_CODE:
                    Log.d(TAG, "DPI_CODE");
                    val = "DPI_CODE :\n" + val;
                    break;
                case System.SET_DISPLAY_RESOLUTION_CODE:
                    Log.d(TAG, "SET_DISPLAY_RESOLUTION_CODE");
                    val = "DISPLAY_RESOLUTION :\n" + val;
                    break;
                case System.NTP_SERVER_TIME_CODE:
                    Log.d(TAG, "NTP_SERVER_TIME_CODE");
                    val = "NTP_SERVER_TIME_CODE :\n" + val;
                    break;
                case System.SET_MICROPHONE_MUTE_CODE:
                    Log.d(TAG, "SET_MICROPHONE_MUTE_CODE");
                    val = "SET_MICROPHONE_CODE :\n" + val;
                    break;
                case System.SET_BCR_STATUS:
                    Log.d(TAG, "SET_BCR_STATUS");
                    val = "SET_BCR_STATUS :\n" + val;
                    break;
                case System.SET_SCAN_STATUS:
                    Log.d(TAG, "SET_SCAN_STATUS");
                    val = "SET_SCAN_STATUS :\n" + val;
                case System.GET_LOCK_TYPE_CODE:
                    Log.d(TAG, "Get Screen lock type");
                    Screen_lock_type = val;
                    break;
                case System.AUTO_USB_PERMISSION_CODE:
                    Log.d(TAG, "AUTO_USB_PERMISSION_CODE");
                    val = "AUTO_USB_PERMISSION_CODE: \n" + val;
                    break;
                case System.SILENT_SET_DEFAULT_LAUNCHER_CODE:
                    Log.d(TAG, "SILENT_SET_DEFAULT_LAUNCHER_CODE");
                    val = "SILENT_SET_DEFAULT_LAUNCHER_CODE: \n" + val;
                    break;
                case System.SILENT_SHUTDOWN_CODE:
                    Log.d(TAG, "SILENT_SHUTDOWN_CODE");
                    val = "SILENT_SHUTDOWN_CODE: \n" + val;
                    break;
                case System.SET_TOUCH_SOUND_CODE:
                    Log.d(TAG, "SET_TOUCH_SOUND_CODE");
                    val = "SET_TOUCH_SOUND_CODE: \n" + val;
                    break;
                case System.SCREEN_WAKE_UP:
                    Log.d(TAG, "SCREEN_WAKE_UP");
                    val = "SCREEN_WAKE_UP: \n" + val;
                    break;
                case System.GET_WIFI_MAC_ADDRESS:
                    Log.d(TAG, "GET_WIFI_MAC_CODE");
                    val = "GET_WIFI_MAC_CODE: \n" + val;
                    break;
                case System.GET_HOSTNAME_ADDRESS:
                    Log.d(TAG, "GET_HOSTNAME");
                    val = "GET_HOSTNAME: \n" + val;
                    break;
                case System.SET_HOSTNAME:
                    Log.d(TAG, "RESPONSE_SET_HOSTNAME");
                    val = "RESPONSE_SET_HOSTNAME:\n" + val;
                    break;
                case System.STATUSBAR_SWIPE_LOCK:
                    Log.d(TAG, "RESPONSE_STATUSBAR_SWIPE_LOCK");
                    val = "STATUSBAR_SWIPE_LOCK\n" + val;
                    break;
                case System.HOTSPOT_STATE_CODE:
                    Log.d(TAG, "RESPONSE_HOTSPOT_ACCESSIBLITY_ENABLE_DISABLE");
                    val = "HOTSPOT_ACCESSIBLITY_ENABLE_DISABLE\n" + val;
                    break;
                case System.WIFI_SCANNING_CODE:
                    Log.d(TAG, "RESPONSE_WIFI_SCANNING_ENABLE_DISABLE");
                    val = "WIFI_SCANNING_ENABLE_DISABLE\n" + val;
                    break;
                case System.BLUETOOTH_SCANNING_CODE:
                    Log.d(TAG, "RESPONSE_BLUETOOTH_SCANNING_ENABLE_DISABLE");
                    val = "BLUETOOTH_SCANNING_ENABLE_DISABLE\n" + val;
                    break;
                case System.IME_STATE_CODE:
                    Log.d(TAG, "RESPONSE_SET_IME_POLICY_SECONDARYDISPLAY");
                    val = "SET_IME_POLICY_SECONDARYDISPLAY\n" + val;
                    break;
                case System.SET_RANDOMIZED_WIFI_MAC:
                    Log.d(TAG, "SET_RANDOMIZED_WIFI_MAC");
                    val = selectedWifiMacAddress + " \n" + val;
                    break;
                case System.VP_SHOW_MORE_RESPONSE_CODE:
                    Log.d(TAG, "VP_SHOW_MORE_RESPONSE_CODE");
                    val = "VP_SHOW_MORE_RESPONSE_CODE :\n" + val;
                    break;
                case System.DEVICE_OWNER_STATUS:
                    Log.d(TAG, "DEVICE_OWNER_STATUS");
                    val = "DEVICE_OWNER_STATUS :\n" + val;
                    break;
                case System.ERROR_DEVICE_OWNER_STATUS:
                    Log.d(TAG, "ERROR_DEVICE_OWNER_STATUS");
                    val = "ERROR_DEVICE_OWNER_STATUS :\n" + val;
                    break;
                case System.NTP_POLL_INTERVAL_CODE:
                    Log.d(TAG, "NTP_POLL_INTERVAL_CODE");
                    val = "NTP_POLL_INTERVAL_CODE :\n" + val;
                    break;
                case System.SET_VOLUME_CONTROL_CODE:
                    Log.d(TAG, "SET_VOLUME_CONTROL_CODE");
                    val = "SET_VOLUME_CONTROL_CODE :\n" + val;
                    break;
                case System.SET_LOGS_ENABLE_OR_DISBLE_CODE:
                    Log.d(TAG, "SET_LOGS_ENABLE_OR_DISBLE_CODE");
                    if (isLogsEnable) {
                        val = "SET_LOGS_ENABLE :\n" + val;
                    } else {
                        val = "SET_LOGS_DISABLE :\n" + val;
                    }
                    break;
                case System.SMALLEST_PIXEL_WIDTH_CODE:
                    Log.d(TAG, "SMALLEST_PIXEL_WIDTH_CODE " + val);
                    val = "SMALLEST_PIXEL_WIDTH_CODE :\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_LONG).show();
                    }
                    break;
                case System.FILE_SIGNING_AND_INTEGRITY_CHECK_CODE:
                    Log.d(TAG, "FILE_SIGNING_AND_INTEGRITY_CHECK_CODE");
                    val = "File Integrity Result : \n" + val;
                    break;
                case System.SET_INSTALL_ALL_APP_PERMISSION_CODE:
                    Log.v(TAG, "SET_INSTALL_ALL_APP_PERMISSION_CODE");
                    val = "SET_INSTALL_ALL_APP_PERMISSION_CODE :\n" + val;
                    break;
                case System.GET_INSTALL_SPECIFIC_APP_PERMISSION_CODE:
                    Log.v(TAG, "GET_INSTALL_SPECIFIC_APP_PERMISSION_CODE");
                    val = "GET_INSTALL_SPECIFIC_APP_PERMISSION_CODE:\n" + val;
                    break;
                case System.SET_INSTALL_SPECIFIC_APP_PERMISSION_CODE:
                    Log.v(TAG, "SET_INSTALL_SPECIFIC_APP_PERMISSION_CODE");
                    val = "SET_INSTALL_SPECIFIC_APP_PERMISSION_CODE:\n" + val;
                    break;
                case System.CHANGE_WIFI_STATE_RESULT_CODE:
                    Log.d(TAG, "CHANGE_WIFI_STATE_RESULT_CODE");
                    val = "CHANGE_WIFI_STATE_RESULT_CODE :\n" + val;
                    break;
                case System.CUSTOM_PORT_ADB:
                    Log.d(TAG, "RESPONSE_SET_CUSTOM_PORT_ADB");
                    val = "RESPONSE_SET_CUSTOM_PORT_ADB:\n" + val;
                    break;
                case System.ENABLE_ADB:
                    Log.d(TAG, "RESPONSE_ENABLE_ADB");
                    val = "RESPONSE_ENABLE_ADB:\n" + val;
                    break;
                case System.DISABLE_ADB:
                    Log.d(TAG, "RESPONSE_DISABLE_ADB");
                    val = "RESPONSE_DISABLE_ADB:\n" + val;
                    break;
                case System.SET_DISPLAY_SIZE_CODE:
                    Log.d(TAG, "RESPONSE_SET_DISPLAY_SIZE_CODE");
                    val = "RESPONSE_SET_DISPLAY_SIZE:\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_LONG).show();
                    }
                    break;
                case System.SET_FONT_SIZE_CODE:
                    Log.d(TAG, "RESPONSE_SET_FONT_SIZE_CODE");
                    val = "RESPONSE_SET_FONT_SIZE:\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_LONG).show();
                    }
                    break;
                case System.SET_DATE_TIME:
                    Log.d(TAG, "RESPONSE_SET_DATE_TIME");
                    val = "RESPONSE_SET_DATE_TIME:\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_LONG).show();
                    }
                    break;
                case System.SET_DARK_THEME_RESULT_CODE:
                    Log.d(TAG, "RESPONSE_SET_DARK_THEME_RESULT_CODE" + val);
                    val = "RESPONSE_SET_DARK_THEME_RESULT_CODE: " + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_LONG).show();
                    }
                    break;
                case System.NOTIFICATIONS_STATUS:
                    Log.d(TAG, "NOTIFICATIONS_STATUS " + val);
                    val = "Status:\n" + val;
                    if (show_toast) {
                        Toast.makeText(SystemActivity.this, val, Toast.LENGTH_LONG).show();
                    }
                    break;
                case System.REGISTER_KEY_EVENT_LISTENER_RESULT_CODE:
                    Log.d(TAG, "KEY_EVENT_CODE " + val);
                    val = "KEY_EVENT_CODE:\n" + val;
                    break;
                case System.GET_FIRMWARE_STATUS:
                    Log.d(TAG, "GET_FIRMWARE_STATUS " + val);
                    setFirmwareStatus(val);
                    val = "";
                    break;
                case System.SET_FIRMWARE_STATUS:
                    Log.d(TAG, "SET_FIRMWARE_STATUS " + val);
                    setFirmwareStatus(val);
                    val = "Status:\n" + val;
                    break;
                case System.RECEIVE_KEY_EVENT:
                    Log.d(TAG, "RECEIVE_KEY_EVENT " + val);
                    val = "KEY EVENT:\n" + val;
                    break;
                case System.SHOW_USB_INFO_CODE:
                    Log.d(TAG, "RECEIVE_KEY_EVENT " + val);
                    final String value = val;
                    val = "";
                    Intent intent = new Intent(SystemActivity.this, UsbInfoActivity.class);
                    intent.putExtra("PeripheralInfo", value);
                    startActivity(intent);
                    break;
                case System.SET_APPMODE:
                    Log.d(TAG, "SET_APPMODE " + val);
                    val = "KEY EVENT:\n" + val;
                    break;
                case System.STICKY_BOOT_CODE:
                    Log.d(TAG, "STICKY_BOOT_CODE: " + val);
                    val = "STICKY_BOOT_CODE: " + val;
                    break;
                case System.ENABLE_IDLE_MODE_TILE_CODE:
                    Log.d(TAG, "ENABLE_IDLE_MODE_TILE_CODE" + val);
                    break;
                case System.BLUETOOTH_STATE_CODE:
                    Log.d(TAG, "BLUETOOTH_STATE_CODE" + val);
                    val = "BLUETOOTH_STATE_CODE: " + val;
                    break;
		        case System.SET_SILENT_SHUTDOWN_RESULT_CODE:
                    Log.d(TAG,"SHUT_DOWN_SETED"+responseValue);
                    val="Device will shutdown after "+val+" seconds";
                    break;
                case System.SHOWTAPS_STATE_CODE:
                    Log.d(TAG, "SHOWTAPS_STATE_CODE" + val);
                    val = "SHOWTAPS_STATE_CODE: " + val;
                    break;
                case System.AUDIO_STATE_CODE:
                    Log.d(TAG, "AUDIO_STATE_CODE" + val);
                    val = "AUDIO_STATE_CODE: " + val;
                    break;
                case System.GET_SYSTEM_PROPERTY_CODE:
                    Log.d(TAG, "GET_SYSTEM_PROPERTY_CODE" + val);
                    val = "Get System Property Value: " + val;
                    break;
                case System.MAGNIFYING_MODE_STATUS:
                    Log.d(TAG, "MAGNIFYING_MODE_STATUS" + val);
                    val = "MAGNIFYING_MODE_STATUS" + val;
                    break;
                case System.SET_BLUETOOTH_PAIRING_CONFIRMATION_RESULT_CODE:
                    Log.d(TAG, "SET_BLUETOOTH_PAIRING_CONFIRMATION_RESULT_CODE" + val);
                    val = "SET_BLUETOOTH_PAIRING_CONFIRMATION_RESULT_CODE " + val;
                    break;
                }

            if (SystemActivity.this.isFinishing() || SystemActivity.this.isDestroyed()) {
                // Context is not valid (generally caused by receiving msg at the same time as a UI update),
                // update text result via text result receiver
                Intent intent = new Intent(ACTION_UPDATE_TEXT_RESULT);
                intent.putExtra("result", val);
                sendBroadcast(intent);
            } else {
                txt_result.setText(val);
            }
            callFromSdk = false;
            return false;
        }

    });
    final KeyReceiver keyReceiver = new KeyReceiver(new WeakReference<>(systemHandler));
    private EditText packageName;
    private RadioButton rb_enable_accessibility, rb_disable_accessibility;
    private String packageNameString;
    private boolean enable_accessibility;

    public static Date getDate(int year, int month, int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month);
        cal.set(Calendar.DAY_OF_MONTH, day);
        cal.set(Calendar.HOUR_OF_DAY, hour);
        cal.set(Calendar.MINUTE, minute);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime();
    }

    public static boolean isPackageInstalled(String packageName, PackageManager packageManager) {
        try {
            return packageManager.getApplicationInfo(packageName, 0).enabled;
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            responseKey = savedInstanceState.getString("responseKey");
            responseValue = savedInstanceState.getString("responseValue");
            isVerified = true;
        }
        setContentView(R.layout.activity_system);
        init();
        try {
            registerReceiver(updateTextResultReceiver, new IntentFilter(ACTION_UPDATE_TEXT_RESULT));
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (savedInstanceState != null && responseKey != null && !responseKey.isEmpty()) {
            bt_account_manager.setBackgroundColor(Color.GREEN);
            if (AccountManagerActivity.emailPass) {
                bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
            } else if (AccountManagerActivity.clientSecret) {
                bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
            } else if (AccountManagerActivity.tokenFromApi) {
                bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
            }
            Message msg = systemHandler.obtainMessage();
            int code = Integer.parseInt(responseKey);
            msg.what = code;
            // IC-31131 , restrict creating bundle (IC-30058 set language code) when USB Peripheral details page is opened,
            if (code != System.SHOW_USB_INFO_CODE) {
                Bundle bundle = new Bundle();
                bundle.putString(Integer.toString(code), responseValue);
                bundle.putBoolean("RESENT_DATA", true);
                msg.setData(bundle);
                systemHandler.sendMessage(msg);
            }
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        IntentFilter filter = new IntentFilter(Intent.ACTION_SHUTDOWN);
        if (mReceiver == null) {
            mReceiver = new ShutdownReceiver();
        }
        registerReceiver(mReceiver, filter);
        accessToken = AccountManagerActivity.accessToken;
        if (!isVerified) {
            AccountManager.instance.verifyEloToken(SystemActivity.this, accessToken, systemHandler);
        }
        setPlayProtectSwitch();
        setTimeFormatSwitch();
        mCheckBox = findViewById(R.id.checkbox_date);
        String timeSettings = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.JELLY_BEAN_MR1) {
            timeSettings = android.provider.Settings.Global.getString(
                    this.getContentResolver(),
                    android.provider.Settings.Global.AUTO_TIME);
        }
        if (timeSettings != null && timeSettings.contentEquals("1")) {
            Log.d(TAG, "default auto setting");
            mCheckBox.setChecked(true);
        } else {
            mCheckBox.setChecked(false);
        }
        setbcr.setEnabled(System.instance.isM60Device() || System.instance.isM50Device() || System.instance.isM100Device());
        if (Settings.Global.getInt(getApplicationContext().getContentResolver(), "low_power", 0) == 1) {
            Log.d(TAG, "Dark Mode cannot be enabled during Energy saver Mode");
            toggleDarkModeBtn.setEnabled(false);
        }
        updateWifiStatus();
        setNtpEditText.clearFocus();
        checkDeviceType();
    }

    private void checkDeviceType() {
        if (!System.instance.isM60Device()) { // only show in m60 device.
            btnSpFirmware.setEnabled(false);
            btnUnlock.setEnabled(false);
            btnLock.setEnabled(false);
        } else {
            getSpFirmwareStatus(); // get firmware status lock or unlock.
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mReceiver != null) {
            unregisterReceiver(mReceiver);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            System.instance.unregisterSystemAPIListener(SystemActivity.this);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        try {
            unregisterReceiver(updateTextResultReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateWifiStatus() {
        boolean wifiState = System.instance.getWifiState(SystemActivity.this, accessToken);
        if (wifiSwitch != null) {
            wifiSwitch.setChecked(wifiState);
        }
    }

    private void init() {
        txt_result = findViewById(R.id.txt_result);
        rb_enable_accessibility = findViewById(R.id.accessibilityEnable);
        rb_disable_accessibility = findViewById(R.id.accessibilityDisable);
        packageName = findViewById(R.id.packageName);
        Button setAccessibility = findViewById(R.id.setAccessibility);
        bt_account_manager = findViewById(R.id.btAccManagerSystem);
        bt_enable_vp_show_more = findViewById(R.id.button_enable_vp_show_more);
        bt_disable_vp_show_more = findViewById(R.id.button_disable_vp_show_more);
        bt_enable_txt_assist = findViewById(R.id.button_enable_text_editor_assist);
        bt_disable_txt_assist = findViewById(R.id.button_disable_text_editor_assist);
        wifiSwitch = findViewById(R.id.toggle_Wifi);
        scanbcr = findViewById(R.id.btnScanBCR);
        setbcr = findViewById(R.id.btnEnableBCR);
        mNoRebootsetOriCheckBox = findViewById(R.id.checkbox_OrinoReboot);
        mNoRebootsetNTPURLCheckBox = findViewById(R.id.checkbox_NtpURLnoReboot);
        mNTPPollnoRebootCheckBox = findViewById(R.id.checkbox_NTPPollnoReboot);
        mNoRebootMultiClientIME = findViewById(R.id.checkBox_MultiClientIMEReboot);
        Button btnSetNotification = findViewById(R.id.btnSetNotification);
        Button btnLockStatusBar = findViewById(R.id.btnLockStatusBar);
        Button btnHotspotState = findViewById(R.id.btnHotspotState);
        Button btnWifiScanning = findViewById(R.id.btnWifiScanning);
        Button btnBluetoothScanning = findViewById(R.id.btnBluetoothScanning);
        Button btnSetIMEPolicy = findViewById(R.id.btnSetIMEPolicy);
        btnSpFirmware = findViewById(R.id.btnSpFirmware);
        btnLock = findViewById(R.id.btnLock);
        btnUnlock = findViewById(R.id.btnUnlock);
        swPlayProtect = findViewById(R.id.sw_play_protect);
        Button getPlayProtect = findViewById(R.id.getPlayProtect);
        Button btnChangeAppMode = findViewById(R.id.btnChangeAppMode);
        Button btnStickyEloViewMode = findViewById(R.id.btnSetStickyEloViewMode);
        Button btnGetStickyEloViewMode = findViewById(R.id.btnGetStickyEloViewMode);
        Button btnGetUsbInfo = findViewById(R.id.btnGetUsbInfo);
        Button btnSetVirtualKeyboardAOSP = findViewById(R.id.btnSetVirtualKeyboardAOSP);
        Button btnSetVirtualKeyboardGboard = findViewById(R.id.btnSetVirtualKeyboardGboard);
	    rbDisableBluetooth = findViewById(R.id.rbDisableBluetooth);
        rbDisableShowTaps = findViewById(R.id.rbDisableShowTaps);
        rbDisableScreenLockSound = findViewById(R.id.rbDisableScreenLockSound);
        rbDisableChargingSoundandVibration = findViewById(R.id.rbDisableChargingSoundandVibration);
        rbExternalSpeaker = findViewById(R.id.rbExternalSpeaker);
        rbInvalidFileSignature = findViewById(R.id.rbInvalidFileSignature);
        rgSetAudio  = findViewById(R.id.rgSetAudio);
        rbDisableMagMode = findViewById(R.id.rbDisableMagMode);
        if("true".equals(readSystemProperty("persist.sys.elo.ExternalSpeakerState"))) {
            rgSetAudio.check(R.id.rbExternalSpeaker);
        }
        //IC-31599, IC-31956: Checking if AOSP keyboard is present in the InputMethodLists and then setting the visisbility of the button.
        InputMethodManager mImm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        List<InputMethodInfo> inputMethods = mImm.getInputMethodList();

        for (InputMethodInfo inputMethodInfo : inputMethods) {
	    if (AOSP_PACKAGE_NAME.equals(inputMethodInfo.getPackageName())) {
                isAOSPKeyboardPresent = true;
            }
	    if (GOOGLE_KEYBOARD_PACKAGE.equals(inputMethodInfo.getPackageName())) {
                isGboardPresent = true;
            }
        }
        if (isAOSPKeyboardPresent) {
            Log.d(TAG, "init: appStatus is true");
            btnSetVirtualKeyboardAOSP.setVisibility(View.VISIBLE);
        } else {
            Log.d(TAG, "init: appStatus is false");
            btnSetVirtualKeyboardAOSP.setVisibility(View.GONE);
        }
	
        if (isGboardPresent) {
            Log.d(TAG, "init: Gboard appStatus is true");
            btnSetVirtualKeyboardGboard.setVisibility(View.VISIBLE);
        } else {
            Log.d(TAG, "init: Gboard appStatus is false");
            btnSetVirtualKeyboardGboard.setVisibility(View.GONE);
        }

        btnGetUsbInfo.setOnClickListener(view -> System.instance.ShowUsbPortInfo(SystemActivity.this, accessToken, systemHandler));

        btnSpFirmware.setOnClickListener(view -> spFirmwareUpgrade());
        btnUnlock.setOnClickListener(view -> changeFirmwareStatus(false));
        btnLock.setOnClickListener(view -> changeFirmwareStatus(true));

        setAccessibility.setOnClickListener(view -> {
            packageNameString = packageName.getText().toString().trim();
            enable_accessibility = rb_enable_accessibility.isChecked();
            if(packageNameString == null){
                return;
            }
            String[] pn = packageNameString.split("/");
            PackageManager pm = getApplicationContext().getPackageManager();
            if (isPackageInstalled(pn[0], pm) && (rb_enable_accessibility.isChecked() || rb_disable_accessibility.isChecked())) {
                System.instance.setAccessibilityService(getApplicationContext(), accessToken, packageNameString, enable_accessibility, systemHandler);
            } else {
               Toast.makeText(SystemActivity.this, (packageNameString.isEmpty()) ? getString(R.string.package_name_empty) : getString(R.string.package_not_installed_invalid), Toast.LENGTH_LONG).show();
            }
        });

        // IC-27010 - These option will disable only for EloView Mode
        String vpShowMore = Util.readSystemProperty("persist.sys.stdandroid");
        if (vpShowMore != null && vpShowMore.equals("false")) {
            bt_enable_vp_show_more.setEnabled(false);
            bt_disable_vp_show_more.setEnabled(false);
        } else {
            bt_enable_vp_show_more.setEnabled(true);
            bt_disable_vp_show_more.setEnabled(true);
        }

        bt_enable_vp_show_more.setOnClickListener(view -> toggleVPShowMore(true));
        bt_disable_vp_show_more.setOnClickListener(view -> toggleVPShowMore(false));
        bt_enable_txt_assist.setOnClickListener(view -> toggleTextAssistMenu(true));
        bt_disable_txt_assist.setOnClickListener(view -> toggleTextAssistMenu(false));
        btnSetNotification.setOnClickListener(view -> setNotificationStatus());
        btnLockStatusBar.setOnClickListener(view -> setLockStatusBar());
        btnHotspotState.setOnClickListener(view -> setHotspot());
        btnWifiScanning.setOnClickListener(view -> setWifiScan());
        btnBluetoothScanning.setOnClickListener(view -> setBluetoothScan());
        btnSetIMEPolicy.setOnClickListener(view -> setIME());

        btnChangeAppMode.setOnClickListener(view -> changeAppMode());

        btnStickyEloViewMode.setOnClickListener(view -> System.instance.setStickyEloviewMode(SystemActivity.this, accessToken, getSystemPropertyValuebool(), systemHandler));

        btnGetStickyEloViewMode.setOnClickListener(view -> System.instance.getStickyEloviewMode(SystemActivity.this, accessToken, systemHandler));

        if (Util.readSystemProperty("ro.vendor.build.oem.prjname").equals("AOSP")) {
            swPlayProtect.setEnabled(false);
            getPlayProtect.setEnabled(false);
        }
        if (!Build.MODEL.toLowerCase().contains("backpack") && !Build.MODEL.toLowerCase().contains("bpack")) {
            mNoRebootsetOriCheckBox.setChecked(true);
            mNoRebootsetOriCheckBox.setEnabled(false);
        }
        setPlayProtectSwitch();
        rbEnable = findViewById(R.id.rbEnable);
        accessToken = AccountManagerActivity.accessToken;
        if (!isVerified || isTokenVerified) {
            isTokenVerified = false;
            AccountManager.instance.verifyEloToken(SystemActivity.this, accessToken, systemHandler);
        }
        setBackLightTimerOptions();
        setDisplaySizeOptions();
        setLocktypeOptions();
        setFontSizeOptions();
        setDPIOptions();
        setCFDDPIOptions();
        setWifiMacAddress();
        setSpinnerForVolumeType();
        etVolumeRange = findViewById(R.id.etVolumeValue);
        setNtpEditText = findViewById(R.id.EditText_set_ntp);
        toggleDarkModeBtn = findViewById(R.id.darkModeToggleBtn);
        toggleDarkModeBtn.setOnClickListener(v -> toggleDarkMode());
    }

    private void toggleDarkMode() {
        txt_result.setText("");
        callFromSdk = true;
        System.instance.toggleDarkMode(getApplicationContext(), accessToken, systemHandler);
    }

    private void setSpinnerForVolumeType() {
        Spinner spVolumeType = findViewById(R.id.spVolumeType);
        ArrayList<String> items = new ArrayList<>();
        items.add("All");
        items.add("Alarm");
        items.add("Call");
        items.add("Media");
        items.add("Notification");
        ArrayAdapter<String> dataAdapter = new ArrayAdapter<>(this,
                android.R.layout.simple_spinner_item, items);
        //set the view for the Drop down list
        dataAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spVolumeType.setAdapter(dataAdapter);
        spVolumeType.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {
                volumeType = parent.getItemAtPosition(position).toString();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    private void setFirmwareStatus(String status) {
        btnSpFirmware.setEnabled(!status.equals("lock"));
        btnLock.setEnabled(!status.equals("lock"));
        btnUnlock.setEnabled(status.equals("lock"));
    }

    /*get Firmware status*/
    private void getSpFirmwareStatus() {
        System.instance.getSpFirmwareStatus(SystemActivity.this, accessToken, systemHandler);
    }

    /*change Firmware status
    status true -> lock
    status false -> unlock  */
    private void changeFirmwareStatus(boolean b) {
        System.instance.changeFirmwareStatus(SystemActivity.this, accessToken, systemHandler, b);
    }

    /*upgrade firmware version
+    * First add QE1000_new.uld in /sdcard/Download/ folder
+    * After its work*/
    private void spFirmwareUpgrade() {
        txt_result.setText("");
        File f = new File("/sdcard/Download/QE1000_new.uld");
        if (f.exists()) {
            System.instance.spFirmwareUpgrade(SystemActivity.this, accessToken, systemHandler);
        } else {
            txt_result.setText("QE1000_new.uld file is not available.");
        }
    }

    private void toggleVPShowMore(Boolean value) {
        String vpShowMore = Util.readSystemProperty("persist.sys.volumepanel.showmore");
        if (value) {
            if (vpShowMore.equals("true")) {
                Toast.makeText(SystemActivity.this, getResources().getString(R.string.show_more_already_enabled), Toast.LENGTH_SHORT).show();
                return;
            }
            System.instance.enableVPShowMore(SystemActivity.this, accessToken, systemHandler);
        } else {
            if (vpShowMore.equals("false")) {
                Toast.makeText(SystemActivity.this, getResources().getString(R.string.show_more_already_disabled), Toast.LENGTH_SHORT).show();
                return;
            }
            System.instance.disableVPShowMore(SystemActivity.this, accessToken, systemHandler);
        }

    }

    /* Enable/disable statusbar with notification view*/
    private void setNotificationStatus() {
        callFromSdk = true;
        System.instance.setNotificationStatus(SystemActivity.this, accessToken, systemHandler, !getSystemPropertyValuebool());
    }

    private void setLockStatusBar() {
        callFromSdk = true;
        System.instance.setLockStatusBar(SystemActivity.this, accessToken, systemHandler, getSystemPropertyValuebool());
    }
    private void setHotspot() {
        callFromSdk = true;
        System.instance.setHotspotAccessibility(SystemActivity.this, accessToken, systemHandler, !getSystemPropertyValuebool());
    }
    private void setWifiScan() {
        callFromSdk = true;
        System.instance.setWifiScanning(SystemActivity.this, accessToken, systemHandler, getSystemPropertyValuebool());
    }
    private void setBluetoothScan() {
        callFromSdk = true;
        System.instance.setBluetoothScanning(SystemActivity.this, accessToken, systemHandler, getSystemPropertyValuebool());
    }
    private void setIME() {
        callFromSdk = true;
        System.instance.setIMEPolicySecondaryDisplay(SystemActivity.this, accessToken, systemHandler, getSystemPropertyValuebool());
    }

    private void changeAppMode() {
        System.instance.changeAppMode(SystemActivity.this, accessToken, systemHandler, getSystemPropertyValuebool() ? "Enable" : "Disable");
    }

    private void toggleTextAssistMenu(Boolean value) {
        String enabled = Util.readSystemProperty("persist.vendor.sys.disable.assistmenu");
        if (value) {
            if (enabled.equals("false")) {
                Toast.makeText(SystemActivity.this, getResources().getString(R.string.text_editor_assist_already_enabled), Toast.LENGTH_SHORT).show();
                return;
            }
            System.instance.enableTextEditorAssistMenu(SystemActivity.this, accessToken, systemHandler);
        } else {
            if (enabled.equals("true")) {
                Toast.makeText(SystemActivity.this, getResources().getString(R.string.text_editor_assist_disabled), Toast.LENGTH_SHORT).show();
                return;
            }
            System.instance.disableTextEditorAssistMenu(SystemActivity.this, accessToken, systemHandler);
        }

    }

    private void setPlayProtectSwitch() {
        String playProtect = Util.readSystemProperty("persist.sys.playprotect");
        if (TextUtils.isEmpty(playProtect) || playProtect.equals("true")) {
            swPlayProtect.setChecked(true);
        } else if (playProtect.equals("false")) {
            swPlayProtect.setChecked(false);
        }
    }

    private void setTimeFormatSwitch() {
        boolean format = DateFormat.is24HourFormat(getApplicationContext());
        Log.d(TAG, "format" + format);
        Switch swTimeFormat = findViewById(R.id.timeformat);
        swTimeFormat.setChecked(format);
    }

    public void setScreenWakeUp(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter a delay for screen wake-up");
        final EditText input = new EditText(SystemActivity.this);
        input.setText("30000");
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            Log.d(TAG, "Delay: " + input.getText().toString());
            long delay;
            try {
                delay = Long.parseLong(input.getText().toString());
            } catch (NumberFormatException e) {
                txt_result.setText("Invalid number");
                e.printStackTrace();
                return;
            }
            txt_result.setText("");
            System.instance.setScreenWakeUp(SystemActivity.this, accessToken, delay, systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void setInstallSpecificAppPerm(View view) {
        boolean state = getSystemPropertyValuebool();
        Log.d(TAG, "changeAppState: " + state);
        hideKeyboard(SystemActivity.this);
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter package name");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_app_source_name));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String sourcePkg = input.getText().toString();
            txt_result.setText("");
            System.instance.installSpecificAppPerm(SystemActivity.this, accessToken, sourcePkg, state,
                    systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void getInstallSpecificAppPerm(View view) {
        hideKeyboard(SystemActivity.this);
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter package name");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_app_source_name));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String sourcePkgs = input.getText().toString();
            txt_result.setText("");
            System.instance.getPermToSpecificApps(SystemActivity.this, accessToken, sourcePkgs,
                    systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void captureScreenShot(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter a file name for the screenshot");
        final EditText input = new EditText(SystemActivity.this);
        input.setText(getResources().getString(R.string.default_screenshot_name));
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String fileName = input.getText().toString().replaceAll("\\s", "");
            txt_result.setText("");
            System.instance.captureScreenShot(SystemActivity.this, accessToken, systemHandler, fileName);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void silentReboot(View view) {
        System.instance.silentReboot(this, accessToken, systemHandler);
    }

    public void silentShutDown(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter a delay in seconds for shutdown");
        final EditText input = new EditText(SystemActivity.this);
        input.setText(getResources().getString(R.string.default_delay_value));
        input.setInputType(InputType.TYPE_CLASS_NUMBER);
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String delay = input.getText().toString().trim();
            txt_result.setText("");
            if (TextUtils.isEmpty(delay)) {
                txt_result.setText("Empty Field Is Not Allowd");
            } else {
                int delay_int = Integer.parseInt(delay);
                System.instance.silentShutDown(SystemActivity.this, accessToken, delay_int, systemHandler);
            }
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void setOrientation(View view) {
        boolean isBackpack = Build.MODEL.toLowerCase(Locale.ENGLISH).contains("bpack") ||
                Build.MODEL.toLowerCase(Locale.ENGLISH).contains("backpack");
        if (!isBackpack) {
            setOrientationNonBackpack();
            return;
        }

        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Select Orientation");
        builder.setItems(orientations, (dialog, which) -> {
            switch (which) {
                case 0:
                    System.instance.setOrientation(SystemActivity.this, accessToken, "0",
                            mNoRebootsetOriCheckBox.isChecked(), systemHandler);
                    break;
                case 1:
                    System.instance.setOrientation(SystemActivity.this, accessToken, "90",
                            mNoRebootsetOriCheckBox.isChecked(), systemHandler);
                    break;
                case 2:
                    System.instance.setOrientation(SystemActivity.this, accessToken, "180",
                            mNoRebootsetOriCheckBox.isChecked(), systemHandler);
                    break;
                case 3:
                    System.instance.setOrientation(SystemActivity.this, accessToken, "270",
                            mNoRebootsetOriCheckBox.isChecked(), systemHandler);
                    break;
                default:
                    break;
            }
        });
        builder.setNegativeButton("CANCEL", (dialog, which) -> dialog.dismiss());
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void setOrientationNonBackpack() {
        String[] orientations = {"auto-rotate", "landscape", "portrait", "landscape-reverse", "portrait-reverse"};
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Select Orientation");
        boolean isPerformance = Build.DISPLAY.toLowerCase().contains("5.") && Build.DISPLAY.toLowerCase().contains("+p") ||
                (Build.DISPLAY.toLowerCase().contains("5.") && Build.DISPLAY.toLowerCase().contains("+ap")) ||
                (Build.DISPLAY.toLowerCase().contains("6.") && Build.DISPLAY.toLowerCase().contains("+p")) ||
                (Build.DISPLAY.toLowerCase().contains("6.") && Build.DISPLAY.toLowerCase().contains("+ap")) ||
                (Build.DISPLAY.toLowerCase().contains("7.") && Build.DISPLAY.toLowerCase().contains("+p")) ||
                (Build.DISPLAY.toLowerCase().contains("7.") && Build.DISPLAY.toLowerCase().contains("+ap")) ||
                (Build.DISPLAY.toLowerCase().contains("release-keys"));
        boolean isHandHeld = Build.MODEL.contains("M50") || Build.MODEL.contains("M60")
                || Build.MODEL.contains("m50") || Build.MODEL.contains("m60");

        boolean is10inch = Build.MODEL.toLowerCase().contains("10in");
        boolean is7inch = Build.MODEL.toLowerCase().contains("7in");
        boolean is15inch = Build.MODEL.toLowerCase().contains("15in");
        boolean is22inch = Build.MODEL.toLowerCase().contains("22in");        

        builder.setItems(orientations, (dialog, which) -> {
            switch (which) {
                case 0:     //auto-rotate
                    System.instance.setOrientation(SystemActivity.this, accessToken, "-1",
                            mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    break;
                case 1:         //landscape
                    if (isPerformance && is10inch || isHandHeld) {
                        System.instance.setOrientation(SystemActivity.this, accessToken, "90",
                                mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    } else {
                        System.instance.setOrientation(SystemActivity.this, accessToken, "0",
                                mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    }
                    break;
                case 2:         //portrait
                    if (isPerformance) {
                        if (is10inch || isHandHeld) {
                            System.instance.setOrientation(SystemActivity.this, accessToken, "0",
                                    mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                        } else if (is7inch || is15inch || is22inch) {
                            System.instance.setOrientation(SystemActivity.this, accessToken, "90",
                                    mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                        } else {
                            System.instance.setOrientation(SystemActivity.this, accessToken, "270",
                                    mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                        }
                    } else {
                        System.instance.setOrientation(SystemActivity.this, accessToken, "90",
                                mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    }
                    break;
                case 3:         //landscape-reverse
                    if (isPerformance && is10inch || isHandHeld) {
                        System.instance.setOrientation(SystemActivity.this, accessToken, "270",
                                mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    } else {
                        System.instance.setOrientation(SystemActivity.this, accessToken, "180",
                                mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    }
                    break;
                case 4:     //portrait-reverse
                    if (isPerformance) {
                        if (is10inch || isHandHeld) {
                            System.instance.setOrientation(SystemActivity.this, accessToken, "180",
                                    mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                        } else if (is7inch || is15inch || is22inch) {
                            System.instance.setOrientation(SystemActivity.this, accessToken, "270",
                                    mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                        } else {
                            System.instance.setOrientation(SystemActivity.this, accessToken, "90",
                                    mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                        }
                    } else {
                        System.instance.setOrientation(SystemActivity.this, accessToken, "270",
                                mNoRebootsetOriCheckBox.isChecked(), systemHandler, true);
                    }
                    break;
                default:
                    break;
            }
        });
        builder.setNegativeButton("CANCEL", (dialog, which) -> dialog.dismiss());
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public void getOrientation(View view) {
        System.instance.getOrientation(this, accessToken, systemHandler);
    }

    public void enableRecentButton(View view) {
        txt_result.setText("");
        System.instance.enableRecentBtn(getApplicationContext(), accessToken, systemHandler);
    }

    public void disableRecentButton(View view) {
       txt_result.setText("");
       System.instance.disableRecentBtn(getApplicationContext(), accessToken, systemHandler);
    }

    public void factoryReset(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle(getResources().getString(R.string.alert_factory_reset_title))
                .setMessage(getResources().getString(R.string.alert_factory_reset_msg))
                .setPositiveButton("Reset", (dialog, which) -> {
                    dialog.cancel();
                    System.instance.factoryReset(SystemActivity.this, accessToken, true, systemHandler);
                })
                .setNegativeButton("Cancel", (dialog, which) -> dialog.cancel())
                .show();
    }

    public void setReservedLogSpace(View view) {
        final String[] LogSizes = {"144MB", "256MB", "512MB", "756MB", "1GB", "2GB"};
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        HasChangedLogSize = false;
        CurrentLogSpace = "144";
        hideKeyboard(SystemActivity.this);
        txt_result.setText("");
        builder.setTitle(getResources().getString(R.string.EnterLogSpace));

        if (!TextUtils.isEmpty(readSystemProperty("persist.sys.reserved_log_space"))) {
            CurrentLogSpace = readSystemProperty("persist.sys.reserved_log_space");
        }

        builder.setSingleChoiceItems(LogSizes, PreSelectedChoice(), (dialog, which) -> {        //recording user's selection here when they tap a radio button
            ReservedLogSpace = GetSelectedLogSpace(which);
            HasChangedLogSize = !ReservedLogSpace.equals(CurrentLogSpace);
        });

        //applying user's selection here
        builder.setPositiveButton("OK", (dialog, which) -> {
            if (!HasChangedLogSize) {        //when user didn't tap a different button, or taps back on original button and hits "OK"
                txt_result.setText("No Change in Selection");
                return;
            }

            if (isSpaceAvailable() > (Integer.parseInt(ReservedLogSpace) + (Integer.parseInt(ReservedLogSpace) / 6))) {    // Reserved space / 6 for zip file()
                if (Integer.parseInt(ReservedLogSpace) < Integer.parseInt(CurrentLogSpace)) {            //if newly set log space smaller than current space
                    AlertDialog.Builder builder2 = new AlertDialog.Builder(SystemActivity.this);
                    builder2.setTitle(getResources().getString(R.string.DeleteLogsWarning));
                    builder2.setPositiveButton("Yes", (dialog12, which12) -> {        //will decrease log size
                        System.instance.setReservedLogSpace(SystemActivity.this, accessToken, ReservedLogSpace, systemHandler);
                    });
                    builder2.setNegativeButton("No", (dialog1, which1) -> dialog1.dismiss());
                    builder2.show();
                } else {       //will increase log size
                    System.instance.setReservedLogSpace(SystemActivity.this, accessToken, ReservedLogSpace, systemHandler);
                }
            } else {
                Log.e(TAG, "Not enough free space on device to reserve " + ReservedLogSpace + "MB");
            }
        });

        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.dismiss());
        builder.show();
    }

    private String GetSelectedLogSpace(int index) {   //Getting log space amount after user makes selection by tapping radio button
        if (index == 0) {
            return "144";
        } else if (index == 1) {
            return "256";
        } else if (index == 2) {
            return "512";
        } else if (index == 3) {
            return "756";
        } else if (index == 4) {
            return "1024";
        }
        return "2048";
    }

    private int PreSelectedChoice() {    //Used to fill in correct radio button for the user's current set log space before they have tapped anything
        if (TextUtils.isEmpty(CurrentLogSpace) || CurrentLogSpace.equals("144")) {
            return 0;
        }
        if (CurrentLogSpace.equals("256")) {
            return 1;
        }
        if (CurrentLogSpace.equals("512")) {
            return 2;
        }
        if (CurrentLogSpace.equals("756")) {
            return 3;
        }
        if (CurrentLogSpace.equals("1024")) {
            return 4;
        }
        return 5;
    }

    private long isSpaceAvailable() {            //EAD-1659-checking space on device for new log size amount
        int SIZE_MB = 1024;
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long availableSpace = stat.getBlockSizeLong() * stat.getAvailableBlocksLong();
        Log.d(TAG, "Available Space in MB : " + availableSpace);
        return availableSpace / (SIZE_MB * SIZE_MB);
    }

    public void silentSetDefaultLauncher(View view) {
        hideKeyboard(SystemActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter Package name of app to set as launcher");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_launcher_app));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String launcherApp = input.getText().toString().trim();
            Log.d(LOG_TAG, "Entered launcher app " + launcherApp);
            txt_result.setText("");
            if (!launcherApp.isEmpty()) {
                Log.d(TAG, "Access token: " + accessToken);
                System.instance.silentSetDefaultLauncher(SystemActivity.this, accessToken, launcherApp, systemHandler);
            } else {
                Toast.makeText(getApplicationContext(), "Please enter a value for default launcher application", Toast.LENGTH_SHORT).show();
            }

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clearAppDataCache(View view) {
        hideKeyboard(SystemActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter package names to clear cache and userdata separated by commas");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_clear_app_cache_userdata));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String packageNames = input.getText().toString().trim();
            Log.d(LOG_TAG, "Entered packages " + packageNames);
            txt_result.setText("");
            if (!packageNames.isEmpty()) {
                System.instance.clearAppCacheUserData(SystemActivity.this, accessToken, packageNames, systemHandler);
            } else {
                Toast.makeText(getApplicationContext(), "Please enter a package name", Toast.LENGTH_SHORT).show();
            }

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clearAllAppDataCache(View view) {
        hideKeyboard(SystemActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter package names to be excepted from clearing cache and userdata");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_clear_app_cache_userdata));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String packageNames = input.getText().toString().trim();
            Log.d(LOG_TAG, "Entered packages " + packageNames);
            txt_result.setText("");
            if (packageNames.isEmpty()) {
                packageNames = "";
                Toast.makeText(getApplicationContext(), getResources().getString(R.string.no_package_exception_set), Toast.LENGTH_LONG).show();
            }
            System.instance.clearAllAppCacheUserData(SystemActivity.this, accessToken, packageNames, systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void getReservedLogSpace(View view) {
        System.instance.getReservedLogSpace(SystemActivity.this, accessToken, systemHandler);
    }

    public void returnMainSystem(View view) {
        Intent intent = new Intent(SystemActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
    }

    public void exitAppSystem(View view) {
        moveTaskToBack(true);
    }

    public void accountManagerSystem(View view) {
        Intent intent = new Intent(SystemActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }

    public void getGrantAutoUSBPermission(View view) {
        System.instance.getautoAllowUSBPermission(SystemActivity.this, accessToken, systemHandler);
    }

    public void clearOutputSystem(View view) {
        responseKey = "";
        responseValue = "";
        txt_result.setText("");
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.d(TAG, "onSaveInstanceState: responseKey - " + responseKey + ", responseValue - " + responseValue);
        if (!TextUtils.isEmpty(responseKey) && !TextUtils.isEmpty(responseValue)) {
            outState.putString("responseKey", responseKey);
            outState.putString("responseValue", responseValue);
        }
    }

    public void setNavigationBar(View view) {
        System.instance.setNavigationBar(SystemActivity.this, accessToken, getSystemPropertyValue(), systemHandler);
    }

    public void enableBCR(View view) {
        boolean status = false;
        if (getSystemPropertyValue().equals("false")) {
            scanbcr.setEnabled(true);
            status = true;

        } else {
            scanbcr.setEnabled(false);
        }
        System.instance.enableBCR(SystemActivity.this, accessToken, status, systemHandler);

    }

    public void scanBCR(View view) {
        boolean status;

        if (getSystemPropertyValue().equals("true")) {
            scanbcr.setEnabled(false);
            status = false;

        } else {
            status = true;
        }
        System.instance.scanBCR(SystemActivity.this, accessToken, status, systemHandler);
    }

    public void clickSetLocktype(View view) {
        txt_result.setText("");
        if (!Screen_lock_type.equals("NULL")) {
            if (!mLockSelection.equals(" ")) {

                if ((Screen_lock_type.substring(Screen_lock_type.lastIndexOf(":") + 1).equals("None")) || (Screen_lock_type.substring(Screen_lock_type.lastIndexOf(":") + 1).equals("Swipe"))) {
                    System.instance.setLocktype(getApplicationContext(), accessToken,
                            null, mLockSelection,
                            systemHandler);
                } else if (Screen_lock_type.contains("Pattern")) {
                    txt_result.setText("Currently Pattern Not Supported !! ");
                } else if (Screen_lock_type.contains("Password")) {
                    showEnterPasswordDialog();
                } else if (Screen_lock_type.contains("Pin")) {
                    showEnterPinDialog();
                }
                Screen_lock_type = "NULL";

            } else {
                txt_result.setText(R.string.system_lock_type_select);
            }
        } else {
            try {
                showGetLockScreenTypeFirstDialog();
            } catch (Exception e) {
                Log.e(TAG, "Error displaying showGetLockScreenTypefirstDialog");
                Toast.makeText(SystemActivity.this, "Get Lock Type First", Toast.LENGTH_SHORT).show();
            }
            txt_result.setText("Get lock screen type first");
        }
    }

    private void showEnterPinDialog() {
        final Dialog pwdDialog = new Dialog(SystemActivity.this, R.style.CustomTheme);
        pwdDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        pwdDialog.setContentView(R.layout.dialog_screen_lock_pin);
        if (pwdDialog.getWindow() != null) {
            pwdDialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            pwdDialog.getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
            pwdDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
            pwdDialog.getWindow().setDimAmount(0.3f);
        }
        pwdDialog.setCancelable(false);
        final EditText Pin = pwdDialog.findViewById(R.id.Pin);
        Button btnOk = pwdDialog.findViewById(R.id.btnConfirm);
        Button btncan = pwdDialog.findViewById(R.id.btnCancel);
        btnOk.setOnClickListener(v -> {
            txt_result.setText("");
            Log.d(TAG, "Pin entered " + Pin.getText().toString());

            if (Pin.getText().toString().equals("")) {
                txt_result.setText("Error: Pin cannot be null");
            } else {
                System.instance.setLocktype(getApplicationContext(), accessToken,
                        Pin.getText().toString(), mLockSelection,
                        systemHandler);
            }

            pwdDialog.dismiss();
        });
        btncan.setOnClickListener(view -> {
            txt_result.setText("Set Locktype Cancelled");
            pwdDialog.dismiss();
        });
        pwdDialog.show();
    }

    private void showGetLockScreenTypeFirstDialog() {
        final Dialog getDialog = new Dialog(SystemActivity.this, R.style.CustomTheme);
        getDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        getDialog.setContentView(R.layout.dialog_get_lock_type_first);
        if (getDialog.getWindow() != null) {
            getDialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            getDialog.getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
            getDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
            getDialog.getWindow().setDimAmount(0.3f);
        }
        getDialog.setCancelable(false);
        Button btnOk = getDialog.findViewById(R.id.btnConfirm);
        btnOk.setOnClickListener(v -> getDialog.dismiss());
        getDialog.show();
    }

    private void showEnterPasswordDialog() {
        final Dialog pwdDialog = new Dialog(SystemActivity.this, R.style.CustomTheme);
        pwdDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        pwdDialog.setContentView(R.layout.dialog_screen_lock_passwrord);
        if (pwdDialog.getWindow() != null) {
            pwdDialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            pwdDialog.getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
            pwdDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
            pwdDialog.getWindow().setDimAmount(0.3f);
        }
        pwdDialog.setCancelable(false);
        final EditText Password = pwdDialog.findViewById(R.id.Password);
        Button btnOk = pwdDialog.findViewById(R.id.btnConfirm);
        Button btncan = pwdDialog.findViewById(R.id.btnCancel);
        btnOk.setOnClickListener(v -> {
            txt_result.setText("");
            Log.d(TAG, "Password entered " + Password.getText().toString());

            if (Password.getText().toString().equals("")) {
                txt_result.setText("Error: Password cannot be null");
            } else {
                System.instance.setLocktype(getApplicationContext(), accessToken,
                        Password.getText().toString(), mLockSelection,
                        systemHandler);
            }

            pwdDialog.dismiss();
        });
        btncan.setOnClickListener(view -> {
            txt_result.setText("Set Locktype Cancelled");
            pwdDialog.dismiss();
        });
        pwdDialog.show();
    }

    public void clickGetLocktype(View view) {
        txt_result.setText("");
        System.instance.getLocktype(getApplicationContext(), accessToken, systemHandler);
    }

    private void setLocktypeOptions() {
        Spinner spLocktype = findViewById(R.id.spLocktype);
        String[] items = new String[]{"Swipe", "None"};
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spLocktype.setAdapter(adapter);
        spLocktype.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {
                switch (position) {
                    case 0:
                        mLockSelection = "Swipe";
                        break;
                    case 1:
                        mLockSelection = "None";
                        break;
                    default:
                        Log.d(TAG, "No selection of lock type");
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    public void setLocationOn(View view) {
        System.instance.setLocation(SystemActivity.this, accessToken, true, systemHandler);
    }

    public void setAudioDevice (View view) {
        Boolean btExternalSpeaker = false;
        if (rbExternalSpeaker.isChecked()) {
            btExternalSpeaker = true;
        }
        System.instance.setAudioDevice(SystemActivity.this, accessToken, btExternalSpeaker, systemHandler);
    }

    public void ChargingSoundandVibration (View view) {
        Boolean BtnState = true;
        if(rbDisableChargingSoundandVibration.isChecked()) {
            BtnState = false;
        }
        System.instance.setChargingSoundandVibration(SystemActivity.this, accessToken, BtnState, systemHandler);
    }
    
    public void clickGetChargingSoundandVibrationState(View view) {
        System.instance.getChargingSoundandVibrationState(SystemActivity.this, accessToken, systemHandler);
    }
    
    public void SetScreenLockSound (View view) {
        Boolean BtnState = true;
        if(rbDisableScreenLockSound.isChecked()) {
            BtnState = false;
        }
        System.instance.setScreenLockSound(SystemActivity.this, accessToken, BtnState, systemHandler);
    }

    public void setBluetooth (View view) {
        Boolean btState = true;
        if(rbDisableBluetooth.isChecked()) {
            btState = false;
        }
        System.instance.setBluetooth(SystemActivity.this, accessToken, btState, systemHandler);
    }
    public void setShowTaps(View view) {
        Boolean stState = true;
        if(rbDisableShowTaps.isChecked()) {
            stState = false;
        }
        System.instance.setShowTaps(SystemActivity.this,accessToken,stState,systemHandler);

    }



    public void verifyFileSignature(View view) {
        boolean isValidFileCheck = true;
        if (rbInvalidFileSignature.isChecked()){
            Log.d(TAG, "setVerifyFileIntegrity: >> ");
            isValidFileCheck = false;
        }

        String fileName = "bin100.bin";
        String sha256 = "bin100.bin.sha256";
        Toast.makeText(this, "isValidFileCheck. "+isValidFileCheck, Toast.LENGTH_SHORT).show();

        Log.d(TAG, "isValidFileCheck: " + isValidFileCheck);
        if(!isValidFileCheck){
            fileName = fileName + "_invalid";
        }
        absoluteFilePath = saveAssetsFileToEloConf(getApplicationContext(), fileName, fileName);
        String absoluteSha256Path = saveAssetsFileToEloConf(getApplicationContext(), sha256, sha256);

        System.instance.verifyFileSignature(SystemActivity.this,accessToken, absoluteFilePath, absoluteSha256Path, systemHandler);
    }

    /**
     * This method is used to save Assets file to Eloconf
     * @param context A context object of the calling class (Activity/Service)
     * @param string orgFileName file name to Assets file in Eloconf
     * @param string eloConfFileName name of file to store in device eloConf
     */
    public static String saveAssetsFileToEloConf(Context context, String orgFileName, String eloConfFileName) {
        String filePath = "/sdcard/elo/" + eloConfFileName;

        File fl = new File(filePath);
        if (fl.exists()) {
            fl.delete();
        }

        try {
            fl.createNewFile();
        } catch (IOException e) {
            Log.e(TAG, "IOException in creating new file");
            return null;
        }

        FileOutputStream fos = null;
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(orgFileName);

            fos = new FileOutputStream(fl);

            byte[] buffer = new byte[4096];  // Buffer size of 4KB
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);  // Write bytes read to the output stream
            }

            fl.setReadable(true, false);

        } catch (Exception e) {
            Log.w(TAG, "saveAssetsFileToEloConf: " + e.getMessage());
        } finally {
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return filePath;
    }

    public void getMD5(View view){
        Log.d(TAG, "absoluteFilePath: " + absoluteFilePath);
        String md5Result = System.instance.getMD5Checksum(SystemActivity.this,accessToken, absoluteFilePath);
        txt_result.setText(md5Result);
    }

    public void setLocationOff(View view) {
        System.instance.setLocation(SystemActivity.this, accessToken, false, systemHandler);
    }

    public void setStatusBar(View view) {
        callFromSdk = true;
        System.instance.setStatusBar(SystemActivity.this, accessToken, getSystemPropertyValue(), systemHandler);

    }

    public void setPasswordStat(View view) {
        System.instance.setPasswordStat(SystemActivity.this, accessToken, getSystemPropertyValuebool(), systemHandler);
    }

    public void setStatusBarVisible(View view) {
        System.instance.setStatusBarInvisible(SystemActivity.this, accessToken, getSystemPropertyValue(), systemHandler);
    }

    public void SetIdleMode(View view) {
        System.instance.setIdleMode(SystemActivity.this, accessToken, getSystemPropertyValuebool(), systemHandler);
    }

    public void enableIdleModeTile(View view) {
        System.instance.enableIdleModeTile(SystemActivity.this, accessToken, getSystemPropertyValuebool(), systemHandler);
    }

    public void setMicrophone(View view) {
        System.instance.setMicrophoneMute(SystemActivity.this, accessToken, !getSystemPropertyValuebool(), systemHandler);
    }

    public void grantPermission(View view) {
        System.instance.grantAllAppPermission(SystemActivity.this, accessToken, grantPermissionValue(), systemHandler);
    }

    public void grantUSBPermission(View view) {
        System.instance.autoAllowUSBPermission(SystemActivity.this, accessToken, grantUSBPermissionValue(), systemHandler);
    }

    public void getNavigationBar(View view) {
        System.instance.getNavigationBar(SystemActivity.this, accessToken, systemHandler);
    }

    public void getStatusBar(View view) {
        System.instance.getStatusBar(SystemActivity.this, accessToken, systemHandler);
    }

    public void getGrantPermission(View view) {
        System.instance.getGrantAllAppPermission(SystemActivity.this, accessToken, systemHandler);
    }

    public void setTextSelection(View view) {
        System.instance.showTextEditorShareMenu(SystemActivity.this, accessToken, grantPermissionValue(), systemHandler);
    }

    public void setInstallAllAppPerm(View view) {
        System.instance.installAllAppPermission(SystemActivity.this, accessToken, getSystemPropertyValuebool(), systemHandler);
    }

    public void setWebViewHardwareInterface(View view) {
        System.instance.setWebViewHardwareInterface(SystemActivity.this, accessToken, grantPermissionValue(), systemHandler);
    }

    public void enableStarHardwareInterface(View view) {
        System.instance.enableStarHardwareInterface(SystemActivity.this, accessToken, grantPermissionValue(), systemHandler);
    }

    public void setVolumes(View view) {
        int volumeValue = 0;
        if (etVolumeRange.getText().toString().trim().isEmpty()) {
            Toast.makeText(this, getString(R.string.default_volume), Toast.LENGTH_SHORT).show();
        } else {
            volumeValue = Integer.parseInt(etVolumeRange.getText().toString().trim());
        }
        if (volumeValue > 100) {
            Toast.makeText(this, getString(R.string.enter_volume_range_between), Toast.LENGTH_SHORT).show();
        } else {
            System.instance.setVolumeLevel(SystemActivity.this, accessToken, systemHandler, volumeType.toLowerCase(), volumeValue);
        }
    }

    public void clickSetTimezone(View view) {
        hideKeyboard(SystemActivity.this);
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter TimeZone ID");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_set_timezone));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String timeZone = input.getText().toString();
            txt_result.setText("");
            System.instance.setTimeZone(SystemActivity.this, accessToken, timeZone,
                    systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clickSetLanguage(View view) {
        hideKeyboard(SystemActivity.this);
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter Language code");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_set_language));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String language = input.getText().toString();
            txt_result.setText("");
            System.instance.setLanguage(SystemActivity.this, accessToken, language.trim(), systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clickGetLanguage(View view) {
        System.instance.getLanguage(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickSetNTPPollInterval(View view) {
        hideKeyboard(SystemActivity.this);
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter POLL Interval");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_FLAG_MULTI_LINE);
        input.setSingleLine(false);
        input.setImeOptions(EditorInfo.IME_FLAG_NO_ENTER_ACTION);
        input.setHint("Enter Time in Milliseconds. Minimum Value should be greater than 900000");
        input.setKeyListener(DigitsKeyListener.getInstance("0123456789"));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        final AlertDialog dialog = builder.create();
        dialog.show();
        dialog.getButton(AlertDialog.BUTTON_POSITIVE).setOnClickListener(v -> {
            String interval = input.getText().toString();
            if (!TextUtils.isEmpty(interval) && Long.parseLong(interval) >= 900000) {
                System.instance.setNTPPollInterval(SystemActivity.this, accessToken, interval,
                        !mNTPPollnoRebootCheckBox.isChecked(), systemHandler);
                dialog.dismiss();
            } else {
                if (TextUtils.isEmpty(interval)) {
                    Toast.makeText(getApplicationContext(), "Please enter the interval value", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(getApplicationContext(), "Please enter valid interval", Toast.LENGTH_SHORT).show();
                }
            }
            txt_result.setText("");
        });
    }

    public void clickGetTimezone(View view) {
        System.instance.getTimeZone(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickGetNTPPollInterval(View view) {
        System.instance.getNTPPollInterval(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickSetDateTime(View view) {
        mCheckBox.setChecked(false);
        Log.d(TAG, "clickSetDateTime");
        hideKeyboard(SystemActivity.this);
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        int day = calendar.get(Calendar.DAY_OF_MONTH);
        DatePickerDialog datePickerDialog = new DatePickerDialog(this, this, year, month, day);
        datePickerDialog.show();
    }

    public void onCheckboxClicked(View view) {
        // Is the view now checked?
        boolean checked = ((CheckBox) view).isChecked();

        if (view.getId() == R.id.checkbox_date) {
            AutoDateTime = checked;
            System.instance.setAutoDateTime(SystemActivity.this, accessToken, AutoDateTime,
                    systemHandler);
        }
    }

    @Override
    public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
        myYear = year;
        myday = dayOfMonth;
        myMonth = month;
        Calendar c = Calendar.getInstance();
        int hour = c.get(Calendar.HOUR);
        int minute = c.get(Calendar.MINUTE);
        Log.d(TAG, "Date picker" + myYear + myday + myMonth);
        TimePickerDialog timePickerDialog = new TimePickerDialog(this, this, hour, minute, DateFormat.is24HourFormat(this));
        timePickerDialog.show();
    }

    @Override
    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        Date date = getDate(myYear, myMonth, myday, hourOfDay, minute);
        Log.d(TAG, "Date input to epoch" + date);
        long epoch = date.getTime();
        Log.d(TAG, "epoch" + epoch);
        callFromSdk = true;
        System.instance.setDateTime(SystemActivity.this, accessToken, epoch,
                systemHandler);
    }

    private String getSystemPropertyValue() {
        if (rbEnable.isChecked()) {
            return "false";
        } else {
            return "true";
        }
    }

    private boolean getSystemPropertyValuebool() {
        return rbEnable.isChecked();
    }

    private String grantPermissionValue() {
        if (rbEnable.isChecked()) {
            return "true";
        } else {
            return "false";
        }
    }

    private boolean grantUSBPermissionValue() {
        return rbEnable.isChecked();
    }

    private void setDPIOptions() {
        Spinner spDPI = findViewById(R.id.spDPI);
        String[] items;
        if (Build.MODEL.equalsIgnoreCase("7in-I-Series-Pay") || Build.MODEL.equalsIgnoreCase("M100")) {
            items = new String[]{"Select DPI", "160", "240", "320", "400", "640"};
        } else {
            items = new String[]{"Select DPI", "160", "240", "320", "480", "640"};
        }
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spDPI.setAdapter(adapter);
        spDPI.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {

                switch (position) {
                    case 1:
                        dpiSelection = 160;
                        break;
                    case 2:
                        dpiSelection = 240;
                        break;
                    case 3:
                        dpiSelection = 320;
                        break;
                    case 4:
                        if (Build.MODEL.equalsIgnoreCase("7in-I-Series-Pay") || Build.MODEL.equalsIgnoreCase("M100")) {
                            dpiSelection = 400;
                        } else {
                            dpiSelection = 480;
                        }
                        break;
                    case 5:
                        dpiSelection = 640;
                        break;
                    case 0:
                    default:
                        dpiSelection = 0;
                        break;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }
    
    private void setCFDDPIOptions() {
        Spinner spcfdDPI = findViewById(R.id.spcfdDPI);
        String[] items;
        items = new String[]{"Select DPI", "160", "240", "320", "480", "640"};
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spcfdDPI.setAdapter(adapter);
        spcfdDPI.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {
                switch (position) {
                    case 1:
                        dpiSelection = 160;
                        break;
                    case 2:
                        dpiSelection = 240;
                        break;
                    case 3:
                        dpiSelection = 320;
                        break;
                    case 4:
                        dpiSelection = 480;
                        break;
                    case 5:
                        dpiSelection = 640;
                        break;
                    case 0:
                    default:
                        dpiSelection = 0;
                        break;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    private void setBackLightTimerOptions() {
        Spinner spBackLightTime = findViewById(R.id.spBackLightTime);
        String[] items = new String[]{"Never", "15 seconds", "30 seconds", "1 minute", "2 minutes", "5 minutes", "10 minutes", "30 minutes"};
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spBackLightTime.setAdapter(adapter);
        spBackLightTime.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {

                switch (position) {
                    case 0:
                        backlightTimeoutSelection = 0;
                        break;
                    case 1:
                        backlightTimeoutSelection = 15000;
                        break;
                    case 2:
                        backlightTimeoutSelection = 30000;
                        break;
                    case 3:
                        backlightTimeoutSelection = 60000;
                        break;
                    case 4:
                        backlightTimeoutSelection = 2 * 60000;
                        break;
                    case 5:
                        backlightTimeoutSelection = 5 * 60000;
                        break;
                    case 6:
                        backlightTimeoutSelection = 10 * 60000;
                        break;
                    case 7:
                        backlightTimeoutSelection = 30 * 60000;
                        break;
                    default:
                        backlightTimeoutSelection = -1;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    private void setDisplaySizeOptions() {
        Spinner spDisplaySize = findViewById(R.id.spDisplaySize);
        String[] items = new String[]{"Select a Display Size", "Small", "Default", "Large", "Larger", "Largest"};

        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spDisplaySize.setAdapter(adapter);
        spDisplaySize.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {

                switch (position) {
                    case 1:
                        mDisplaySelection = "small";
                        break;
                    case 2:
                        mDisplaySelection = "Default";
                        break;
                    case 3:
                        mDisplaySelection = "Large";
                        break;
                    case 4:
                        mDisplaySelection = "Larger";
                        break;
                    case 5:
                        mDisplaySelection = "Largest";
                        break;
                    default:
                        mDisplaySelection = " ";
                        Log.d(TAG, "No selection of displaysize");
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    public void clickSetResolution(View view) {
        txt_result.setText("");
        try {
            int width = Integer.parseInt(((EditText) findViewById(R.id.textResolutionWidth)).getText().toString());
            int height = Integer.parseInt(((EditText) findViewById(R.id.textResolutionHeight)).getText().toString());
            System.instance.setScreenSize(getApplicationContext(), accessToken, width, height, systemHandler);
        } catch (Exception e) {
            e.printStackTrace();
            txt_result.setText("Please enter integer values for width and height.");
        }
    }

    public void clickGetResolution(View view) {
        txt_result.setText("");
        System.instance.getScreenSize(getApplicationContext(), accessToken, systemHandler);
    }

    private void setFontSizeOptions() {
        Spinner spFontSize = findViewById(R.id.spFontSize);
        float[] density_scale = {0.85f, 1.0f, 1.15f, 1.3f};
        String[] items = new String[]{"Small", "Default", "Large", "Largest"};
        float current_scale = getResources().getConfiguration().fontScale;
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spFontSize.setAdapter(adapter);
        spFontSize.setSelection(Arrays.binarySearch(density_scale, current_scale));
        spFontSize.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {

                switch (position) {
                    case 0:
                        mFontSelection = "Small";
                        break;
                    case 1:
                        mFontSelection = "Default";
                        break;
                    case 2:
                        mFontSelection = "Large";
                        break;
                    case 3:
                        mFontSelection = "Largest";
                        break;
                    default:
                        Log.d(TAG, "No selection of fontsize");
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    public void clickSetDPI(View view) {
        txt_result.setText("");
        switch (dpiSelection) {
            case 160:
            case 240:
            case 320:
            case 400:
            case 480:
            case 640:
                System.instance.setDPI(getApplicationContext(), accessToken, dpiSelection, systemHandler);
                break;
            default:
                txt_result.setText(R.string.system_set_dpi_msg);
                break;
        }
    }
    
    public void clickSetCfdDPI(View view) {
        txt_result.setText("");
        switch (dpiSelection) {
            case 160:
            case 240:
            case 320:
            case 400:
            case 480:
            case 640:
                System.instance.setCfdDPI(getApplicationContext(), accessToken, dpiSelection, systemHandler);
                break;
            default:
                txt_result.setText(R.string.system_set_dpi_msg);
                break;
        }
    }

    public void clickGetDPI(View view) {
        txt_result.setText("");
        System.instance.getDPI(getApplicationContext(), accessToken, systemHandler);
    }

    public void clickSetNtp(View view) {
        txt_result.setText("");
        String ntpUrl = setNtpEditText.getText().toString().trim();
        System.instance.setNtpServerURL(getApplicationContext(), accessToken, ntpUrl,
                !mNoRebootsetNTPURLCheckBox.isChecked(), systemHandler);
    }

    public void clickGetNtp(View view) {
        txt_result.setText("");
        System.instance.getNtpServerURL(getApplicationContext(), accessToken, systemHandler);
    }

    public void clickSetHostName(View view) {
        txt_result.setText("");
        EditText input = findViewById(R.id.hostname);
        String hostname = input.getText().toString();
        if (hostname.length() > 91) {
            Toast.makeText(this, "Host name cannot exceed 91 characters", Toast.LENGTH_SHORT).show();
            return;
        }
        if (!hostname.equals("")) {
            System.instance.setHostName(getApplicationContext(), accessToken, systemHandler, hostname);
            txt_result.setText("SET HOSTNAME: " + hostname);
        } else
            txt_result.setText("Please enter a valid hostname");
    }

    public void clickGetHostName(View view) {
        System.instance.getHostName(SystemActivity.this, accessToken, systemHandler);
    }
    
    public void clickGetScreenLockingSoundState(View view) {
        System.instance.getScreenLockingSoundState(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickGetAutoIdleModeStatus(View view) {
        System.instance.getAutoIdleModeStatus(SystemActivity.this, accessToken, systemHandler);
    }
    
    public void clickGetTouchSoundState(View view) {
        System.instance.getTouchSoundState(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickSetSmallestWidth(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter smallest pixel width");
        final EditText input = new EditText(getApplicationContext());
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_set_smallest_width));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String smallestWidth = input.getText().toString();
            txt_result.setText("");
            callFromSdk = true;
            System.instance.setSmallestPixelWidth(getApplicationContext(), accessToken, smallestWidth,
                    systemHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clickGetSmallestWidth(View view) {
        System.instance.getSmallestPixelWidth(getApplicationContext(), accessToken, systemHandler);
    }

    public void clickSetKeyListener(View view) {
        if (listenerSet) {
            // to prevent user from accidentally clicking multiple key listener buttons without unregistering
            System.instance.setKeyListener(getApplicationContext(), accessToken, "", "", new ArrayList<>(), new ArrayList<>(), null);
            listenerSet = false;
        }
        MultiSelectSpinner spinner = findViewById(R.id.key_listener_spinner);
        List<String> items = spinner.getItems();
        boolean[] selected = spinner.getSelected();
        ArrayList<Integer> keys = new ArrayList<>();
        ArrayList<String> intercept = new ArrayList<>();

        for (int i = 0; i < selected.length; i++) {
            if (selected[i]) {
                keys.add(KeyEvent.keyCodeFromString(items.get(i)));
                intercept.add("false");
            }
        }

        System.instance.setKeyListener(getApplicationContext(), accessToken, "com.eloview.homesdk.testapp", KeyReceiver.class.getName(), keys, intercept, systemHandler);
        listenerSet = true;
        try {
            getApplicationContext().registerReceiver(keyReceiver, new IntentFilter("com.elo.secure.action.INTERCEPT_KEY_EVENT"));
        } catch (Exception ignored) {
        }
    }


    private void registerPairingRequestReceiver() {
        IntentFilter filter = new IntentFilter(BluetoothDevice.ACTION_PAIRING_REQUEST);
        Log.d(TAG, "Receiver state -> enteredMacAddress=" + enteredMacAddress
                + ", isEnableSelected=" + isEnableSelected);
        filter.setPriority(999);
        pairingRequestReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                Log.d(TAG, "Received broadcast: " + intent.getAction());

                if (BluetoothDevice.ACTION_PAIRING_REQUEST.equals(intent.getAction())) {
                    BluetoothDevice receivedDevice = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);

                    if (receivedDevice != null) {
                        String receivedMac = receivedDevice.getAddress();
                        Log.d(TAG, "Expected MAC: " + enteredMacAddress + ", Received MAC: " + receivedMac);
                        Log.d(TAG, "Enable selected: " + isEnableSelected);

                        if (isEnableSelected && enteredMacAddress.equalsIgnoreCase(receivedMac)) {
                            try {
                                // Call system API when both conditions match
                               System.instance.setBluetoothDevicePairingConfirmation(getApplicationContext(), accessToken, receivedDevice, true,systemHandler);
                                Log.d(TAG, "Pairing confirmation enabled for " + enteredMacAddress);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            disablePairingRequestReceiver(getApplicationContext());
                            txt_result.setText("Pairing confirmation set Disabled for  " + enteredMacAddress);
                            Log.d(TAG, "Pairing confirmation not applied");
                        }
                    }


                }
            }

        };
        getApplicationContext().registerReceiver(pairingRequestReceiver, filter);

    }

    public void disablePairingRequestReceiver(Context context) {
        try {
            if (pairingRequestReceiver != null) {
                context.unregisterReceiver(pairingRequestReceiver);
                Log.d(TAG, "Receiver unregistered (disabled)");
            } else {
                Log.d(TAG, "disablePairingRequestReceiver is null");
            }
        } catch (Exception ex) {
            Log.w(TAG, "Receiver already unregistered", ex);
        }
    }

    public void clickSetKeyIntercept(View view) {
        if (listenerSet) {
            // to prevent user from accidentally clicking multiple key listener buttons without unregistering
            System.instance.setKeyListener(getApplicationContext(), accessToken, "", "", new ArrayList<>(), new ArrayList<>(), null);
            listenerSet = false;
        }
        MultiSelectSpinner spinner = findViewById(R.id.key_listener_spinner);
        List<String> items = spinner.getItems();
        boolean[] selected = spinner.getSelected();
        ArrayList<Integer> keys = new ArrayList<>();
        ArrayList<String> intercept = new ArrayList<>();

        for (int i = 0; i < selected.length; i++) {
            if (selected[i]) {
                keys.add(KeyEvent.keyCodeFromString(items.get(i)));
                intercept.add("true");
            }
        }

        System.instance.setKeyListener(getApplicationContext(), accessToken, "com.eloview.homesdk.testapp", KeyReceiver.class.getName(), keys, intercept, systemHandler);
        listenerSet = true;
        try {
            getApplicationContext().registerReceiver(keyReceiver, new IntentFilter("com.elo.secure.action.INTERCEPT_KEY_EVENT"));
        } catch (Exception ignored) {
        }
    }

    public void clickUnsetKeyListener(View view) {
        System.instance.setKeyListener(getApplicationContext(), accessToken, "", "", new ArrayList<>(), new ArrayList<>(), systemHandler);
        listenerSet = false;
        try {
            getApplicationContext().unregisterReceiver(keyReceiver);
        } catch (Exception ignored) {
        }
    }

    private void setWifiMacAddress() {

        Spinner spMAC = findViewById(R.id.spMAC);
        String[] items = new String[]{"Use randomized MAC", "Use device MAC"};
        ArrayAdapter<String> adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_dropdown_item, items);
        spMAC.setAdapter(adapter);
        spMAC.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View v, int position, long id) {

                switch (position) {
                    case 0:
                        macSelection = 1;
                        selectedWifiMacAddress = "SET_RANDOMIZED_WIFI_MAC";
                        break;
                    case 1:
                        macSelection = 0;
                        selectedWifiMacAddress = "SET_DEVICE_WIFI_MAC";
                        break;
                    default:
                        macSelection = -1;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // TODO Auto-generated method stub
            }
        });
    }

    public void clickSetMac(View view) {
        txt_result.setText("");
        if (macSelection == 1 || macSelection == 0) {
            System.instance.enableRandomWifiMacAddress(getApplicationContext(), accessToken, macSelection, systemHandler);
        }
    }

    public void clickSetTimeout(View view) {
        txt_result.setText("");
        if (backlightTimeoutSelection >= 0) {
            System.instance.setBacklightTimeOut(getApplicationContext(), accessToken, backlightTimeoutSelection, systemHandler);
        } else {
            txt_result.setText(R.string.system_back_light_time_select);
        }
    }

    public void clickSetDisplaySize(View view) {
        txt_result.setText("");
        if (!mDisplaySelection.equals(" ")) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                callFromSdk = true;
                System.instance.setDisplaySize(getApplicationContext(), accessToken, mDisplaySelection, systemHandler);
            }, 500);
        } else {
            txt_result.setText(R.string.system_display_size_select);
        }
    }

    public void clickSetFontSize(View view) {
        txt_result.setText("");
        if (!mFontSelection.equals(" ")) {
            callFromSdk = true;
            System.instance.setFontSize(getApplicationContext(), accessToken, mFontSelection, systemHandler);
        } else {
            txt_result.setText(R.string.system_font_size_select);
        }
    }

    public void clickGetTimeout(View view) {
        txt_result.setText("");
        System.instance.getBacklightTimeOut(getApplicationContext(), accessToken, systemHandler);
    }

    public void enableHomeButton(View view) {
        txt_result.setText("");
        System.instance.enableHomeButton(getApplicationContext(), accessToken, systemHandler);
    }

    public void disableHomeButton(View view) {
        txt_result.setText("");
        System.instance.disableHomeButton(getApplicationContext(), accessToken, systemHandler);
    }

    public void enableTouchSound(View view) {
        txt_result.setText("");
        System.instance.setTouchSound(getApplicationContext(), accessToken, true, systemHandler);
    }

    public void disableTouchSound(View view) {
        txt_result.setText("");
        System.instance.setTouchSound(getApplicationContext(), accessToken, false, systemHandler);
    }

    public void enablePowerButton(View view) {
        txt_result.setText("");
        System.instance.enablePowerButton(getApplicationContext(), accessToken, systemHandler);
    }

    public void disablePowerButton(View view) {
        txt_result.setText("");
        System.instance.disablePowerButton(getApplicationContext(), accessToken, systemHandler);
    }
    public void setMagnifyingMode(View view) {
        boolean magModeState = true;
        if (rbDisableMagMode.isChecked()) {
            magModeState = false;
        }
        System.instance.setMagnifyingMode(SystemActivity.this, accessToken, magModeState, systemHandler);
    }
    public void SetNetworkConfig(View view) {
        //txt_result.setText("");
        Intent intent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        intent.setType("*/*");
        try {
            startActivityForResult(intent, ACTIVITY_RESULT_SUCCESS);
        } catch (android.content.ActivityNotFoundException ex) {
            Toast.makeText(this, "Please install a File Manager.", Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ACTIVITY_RESULT_SUCCESS && resultCode == RESULT_OK) {
            final Uri selectedFile = data.getData();
            try {
                assert selectedFile != null;
                String type = getApplicationContext().getContentResolver().getType(selectedFile);
                Log.d(TAG, "Set Network Config: mimetype: " + type);
                assert type != null;
                if (type.equals("text/csv") || type.equals("text/comma-separated-values")) {
                    txt_result.setText(String.format(getResources().getString(R.string.select_file_msg), selectedFile));
                    Toast.makeText(this, getString(R.string.Using_local_Csv_File), Toast.LENGTH_SHORT).show();
                    System.instance.setEloNetworkConf(getApplicationContext(), accessToken, selectedFile, systemHandler);
                } else {
                    txt_result.setText(R.string.Only_local_csv_file);
                    Toast.makeText(getApplicationContext(), R.string.Only_local_csv_file, Toast.LENGTH_LONG).show();
                }
            } catch (Exception e) {
                e.printStackTrace();
                txt_result.setText("Unexpected Error has occurred");
                Toast.makeText(getApplicationContext(), "Unexpected Error has occurred", Toast.LENGTH_LONG).show();
            }
        }
    }

    public void clickSetPassword(View view) {
        showScreenLockPasswordDialog();
    }

    private void showScreenLockPasswordDialog() {
        final Dialog pwdDialog = new Dialog(SystemActivity.this, R.style.CustomTheme);
        pwdDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        pwdDialog.setContentView(R.layout.dialog_set_passwrord);
        if (pwdDialog.getWindow() != null) {
            pwdDialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            pwdDialog.getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
            pwdDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
            pwdDialog.getWindow().setDimAmount(0.3f);
        }
        pwdDialog.setCancelable(false);

        final EditText etOldPassword = pwdDialog.findViewById(R.id.etOldPassword);
        final EditText etNewPassword = pwdDialog.findViewById(R.id.etNewPassword);
        final CheckBox cbAskOnBoot = pwdDialog.findViewById(R.id.cbAskOnBoot);

        Button btnCancel = pwdDialog.findViewById(R.id.btnCancel);
        Button btnApply = pwdDialog.findViewById(R.id.btnApply);

        btnApply.setOnClickListener(v -> {
            txt_result.setText("");
            Log.d(TAG, "onClick: old >>" + etOldPassword.getText().toString() +
                    " new >> " + etNewPassword.getText().toString() +
                    " askOnBoot" + cbAskOnBoot.isChecked());
            System.instance.changeLockScreenPassword(getApplicationContext(), accessToken,
                    etOldPassword.getText().toString(),
                    etNewPassword.getText().toString(),
                    cbAskOnBoot.isChecked(),
                    systemHandler);
            pwdDialog.dismiss();
        });

        btnCancel.setOnClickListener(v -> pwdDialog.dismiss());

        pwdDialog.show();
    }

    public void clickSetPin(View view) {
        showScreenLockPinDialog();
    }

    private void showScreenLockPinDialog() {
        final Dialog pwdDialog = new Dialog(SystemActivity.this, R.style.CustomTheme);
        pwdDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        pwdDialog.setContentView(R.layout.dialog_set_pin);
        if (pwdDialog.getWindow() != null) {
            pwdDialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            pwdDialog.getWindow().setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.MATCH_PARENT);
            pwdDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
            pwdDialog.getWindow().setDimAmount(0.3f);
        }
        pwdDialog.setCancelable(false);

        final EditText etOldPin = pwdDialog.findViewById(R.id.etOldPin);
        final EditText etNewPin = pwdDialog.findViewById(R.id.etNewPin);
        final CheckBox cbAskOnBootpin = pwdDialog.findViewById(R.id.cbAskOnBootPin);

        Button btnCancel = pwdDialog.findViewById(R.id.btnCancel);
        Button btnApply = pwdDialog.findViewById(R.id.btnApply);

        btnApply.setOnClickListener(v -> {
            txt_result.setText("");
            Log.d(TAG, "onClick: old >>" + etOldPin.getText().toString() +
                    " new >> " + etNewPin.getText().toString() +
                    " askOnBoot" + cbAskOnBootpin.isChecked());
            System.instance.changeLockScreenPin(getApplicationContext(), accessToken,
                    etOldPin.getText().toString(),
                    etNewPin.getText().toString(),
                    cbAskOnBootpin.isChecked(),
                    systemHandler);
            pwdDialog.dismiss();
        });

        btnCancel.setOnClickListener(v -> pwdDialog.dismiss());

        pwdDialog.show();
    }

    public void setPlayProtect(View view) {
        Switch swPlayProtect = findViewById(R.id.sw_play_protect);
        manageSwitchState(swPlayProtect);
        System.instance.setPlayProtect(SystemActivity.this, accessToken, swPlayProtect.isChecked() ? "true" : "false", systemHandler);
    }

    /**
     * This method is used to Set Device Backlight TurnOn or TurnOFF
     */
    public void setBacklight(View view) {
        Switch swBacklight = findViewById(R.id.sw_backlight);

        // if BACKLIGHT toggle switch is checked
        if (swBacklight.isChecked()) {
            txt_result.setText(R.string.backlight_TURNED_ON);
            System.instance.backlightTurnOn(SystemActivity.this, accessToken, systemHandler);
        } else {
            // if BACKLIGHT toggle switch is off, Turn-OFF screen backlight
            swBacklight.setChecked(false);
            txt_result.setText(R.string.backlight_TURNED_OFF);
            System.instance.backlightTurnOff(SystemActivity.this, accessToken, systemHandler);
            swBacklight.setChecked(true);
        }
    }

    public void changeWifiState(View view) {
        manageSwitchState(wifiSwitch);
        System.instance.changeWifiState(SystemActivity.this, accessToken, wifiSwitch.isChecked(), systemHandler);
    }

    public void setTimeFormat(View view) {
        Switch swTimeFormat = findViewById(R.id.timeformat);
        manageSwitchState(swTimeFormat);
        System.instance.setTimeFormat(SystemActivity.this, accessToken, swTimeFormat.isChecked(), systemHandler);
    }

    public void getPlayProtect(View view) {
        System.instance.getPlayProtect(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickGetMac(View view) {
        System.instance.getWifiMac(SystemActivity.this, accessToken, systemHandler);
    }

    public void clickGetDeviceOwner(View view) {
        try {
            System.instance.getDeviceOwnerStatus(getApplicationContext(), accessToken, systemHandler);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clickSetDeviceOwner(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter package name");
        final EditText input_package = new EditText(SystemActivity.this);
        final EditText input_package_receiver = new EditText(SystemActivity.this);
        input_package.setInputType(InputType.TYPE_CLASS_TEXT);
        input_package_receiver.setInputType(InputType.TYPE_CLASS_TEXT);
        input_package.setHint(getResources().getString(R.string.hint_pkg_name));
        input_package_receiver.setHint(getResources().getString(R.string.hint_device_admin_receiver));
        LinearLayout container = new LinearLayout(SystemActivity.this);
        container.setOrientation(VERTICAL);
        container.addView(input_package);
        container.addView(input_package_receiver);
        builder.setView(container);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String edt_pkgName_stat_change = input_package.getText().toString().trim();
            String edt_pkg_receiver_class_name = input_package_receiver.getText().toString().trim();
            txt_result.setText("");
            if (TextUtils.isEmpty(edt_pkgName_stat_change)) {
                Toast.makeText(getApplicationContext(), getResources().getString(R.string.enter_package_name), Toast.LENGTH_LONG).show();
            } else if (TextUtils.isEmpty(edt_pkg_receiver_class_name)) {
                Toast.makeText(getApplicationContext(), getResources().getString(R.string.enter_class_name), Toast.LENGTH_LONG).show();
            } else {
                txt_result.setText("");
                System.instance.setDeviceOwner(SystemActivity.this, accessToken, edt_pkgName_stat_change, edt_pkg_receiver_class_name, systemHandler);
            }
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clickStartForegroundService(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Enter package name to start from foreground service");
        final EditText input = new EditText(SystemActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint("com.example.app");
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String packageName = input.getText().toString();
            if (packageName.isEmpty()) {
                txt_result.setText("Please enter a package name.");
                return;
            }
            PackageManager pm = getApplicationContext().getPackageManager();
            if (!isPackageInstalled(packageName, pm)) {
                Log.d(TAG, packageName + " is not installed");
                txt_result.setText(packageName + " is not installed");
                return;
            }

            if (accessToken.isEmpty()) {
                txt_result.setText("Empty Token");
                return;
            }

            Intent serviceIntent = new Intent(getApplicationContext(), ForegroundService.class);
            serviceIntent.putExtra("pkgName", packageName);
            serviceIntent.putExtra("accessToken", accessToken);
            ContextCompat.startForegroundService(getApplicationContext(), serviceIntent);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void clickStopForegroundService(View view) {
        Intent serviceIntent = new Intent(this, ForegroundService.class);
        stopService(serviceIntent);
        txt_result.setText("Stopped the foreground service that was used to launch a different activity from EloView Home SDK.");
    }

    public void setMultiClientIME(View view) {
        txt_result.setText("");
        Log.d(TAG, "Access token: " + accessToken);
        System.instance.setMultiClientIME(SystemActivity.this, accessToken, getSystemPropertyValuebool(), !mNoRebootMultiClientIME.isChecked(), systemHandler);
    }

    public void getMultiClientIME(View view) {
        System.instance.getMultiClientIME(SystemActivity.this, accessToken, systemHandler);
    }

    public void disableCopyPaste(View view) {
        Log.i(TAG, "Copy/Paste Mode: " + "disable");
        System.instance.setCopyPasteMode(getApplicationContext(), accessToken, systemHandler, "disable");
    }

    public void enableCopyPaste(View view) {
        Log.i(TAG, "Copy/Paste Mode: " + "enable");
        System.instance.setCopyPasteMode(getApplicationContext(), accessToken, systemHandler, "enable");
    }

    public void setKeyboardAOSP(View view) {
        Log.i(TAG, "Virtual Keyboard " + "AOSP");
        System.instance.setVirtualKeyBoard(getApplicationContext(), accessToken, systemHandler, "aosp");
    }

    public void setKeyboardGboard(View view) {
        Log.i(TAG, "Virtual Keyboard: " + "Gboard");
        System.instance.setVirtualKeyBoard(getApplicationContext(), accessToken, systemHandler, "gboard");
    }

    public void setLogsEnable(View view) {
        if (accessToken.isEmpty()) {
            txt_result.setText("Empty Token");
        } else {
            isLogsEnable = true;
            System.instance.enableEloLogging(getApplicationContext(), accessToken, systemHandler, true);
        }
    }

    public void setLogsDisable(View view) {
        if (accessToken.isEmpty()) {
            txt_result.setText("Empty Token");
        } else {
            isLogsEnable = false;
            System.instance.enableEloLogging(getApplicationContext(), accessToken, systemHandler, false);
        }
    }

    public void enableADB(View view) {
        txt_result.setText("");
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.JELLY_BEAN_MR1) {
            try {
                int isAdbEnabled = Settings.Global.getInt(getApplicationContext().getContentResolver(), Settings.Global.ADB_ENABLED);
                if (isAdbEnabled == 0) {
                    txt_result.setText("");
                    showUSBDebugAuthenticationDialog();
                } else {
                    txt_result.setText("ADB already enabled");
                }
            } catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void getSystemProperty(View view) {
        txt_result.setText("");
        EditText input = findViewById(R.id.systemPropertyName);
        String property = input.getText().toString();
        if (property.isEmpty()) {
            txt_result.setText("Please enter a property name");
        } else {
            System.instance.getSystemProperty(getApplicationContext(), accessToken, systemHandler, property);
        }
    }

    public void enableADBWithoutAuthnetication(View view) {
        System.instance.enableAdb(getApplicationContext(), accessToken, systemHandler);
    }

    public void disableADB(View view) {
        txt_result.setText("");
        System.instance.disableAdb(getApplicationContext(), accessToken, systemHandler);
    }

    private boolean isValidNumber(String num) {
        if (num.length() < 4 || num.length() > 5) {
            return false;
        }
        for (int i = 0; i < num.length(); i++) {
            if (!Character.isDigit(num.charAt(i))) {
                return false;
            }
        }
        int number = Integer.parseInt(num);
        return number >= 1024 && number <= 65535;
    }

    public void customAdbPort(View view) {
        EditText input = findViewById(R.id.customPort);
        String port = input.getText().toString();
        if (port.isEmpty() || !isValidNumber(port)) {
            txt_result.setText("Invalid Port Number");
        } else {
            txt_result.setText("");
            System.instance.customPortAdb(getApplicationContext(), accessToken, systemHandler, port);
        }
        input.setText("");
    }

    private void showUSBDebugAuthenticationDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(SystemActivity.this);
        builder.setTitle("Allow USB debugging?");
        builder.setMessage(getString(R.string.usb_debugging_authentication_dialog));
        builder.setPositiveButton(getString(R.string.ok_text), (dialog, which) -> System.instance.enableAdb(getApplicationContext(), accessToken, systemHandler));
        builder.setNegativeButton(getString(R.string.cancel_text), (dialog, which) -> dialog.cancel());
        builder.show();

    }

    /**
     * @param switchView prevents a switch View from toggling its state is token is not verified
     */
    private void manageSwitchState(Switch switchView) {
        if (!isVerified) {
            switchView.setChecked(!switchView.isChecked());
        }
    }

    public void setBtDevicePairingConfirmation(View view) {

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Set Bluetooth Device Pairing Confirmation");

        // Input for MAC address
        final EditText inputBtMac = new EditText(this);
        inputBtMac.setHint("Enter MAC Address");
        // Radio buttons
        String[] items = {"Enabled", "Disabled"};
        final RadioButton radioButton1 = new RadioButton(this);
        radioButton1.setText(items[0]);

        final RadioButton radioButton2 = new RadioButton(this);
        radioButton2.setText(items[1]);

        RadioGroup radioGroup = new RadioGroup(this);
        radioGroup.setOrientation(RadioGroup.HORIZONTAL);
        radioGroup.addView(radioButton1);
        radioGroup.addView(radioButton2);
        radioButton1.setChecked(true);

        LinearLayout container = new LinearLayout(this);
        container.setOrientation(LinearLayout.VERTICAL);
        container.addView(inputBtMac);
        container.addView(radioGroup);
        builder.setView(container);

        builder.setPositiveButton("OK", (dialog, which) -> {
            String inputMac = inputBtMac.getText().toString().trim();
            Log.d(TAG, "setBtDevicePairingConfirmation:inputBtMac  "+inputBtMac);
            boolean isValidMac = inputMac.matches("^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$");
            isEnableSelected = radioButton1.isChecked();

            if (inputMac.isEmpty() || !isValidMac) {
                Toast.makeText(getApplicationContext(), "MAC address is empty or invalid", Toast.LENGTH_SHORT).show();
                return; // Exit if invalid
            }
            enteredMacAddress = inputMac;
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            BluetoothDevice device = bluetoothAdapter.getRemoteDevice(enteredMacAddress);
            if (device == null) {
                Toast.makeText(this, "Bluetooth device not found for MAC", Toast.LENGTH_SHORT).show();
                return;
            }

            if (!isEnableSelected || radioButton2.isChecked()) {
                // If Disabled selected, unregister receiver
                disablePairingRequestReceiver(getApplicationContext());
                txt_result.setText("SET_BLUETOOTH_PAIRING_CONFIRMATION_RESULT_CODE Disabled");
            }else {
                registerPairingRequestReceiver();
                // Start bonding
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    boolean bondStarted = device.createBond();
                    Toast.makeText(this, "Bonding started: " + bondStarted + " for " + enteredMacAddress, Toast.LENGTH_SHORT).show();
                    Log.d(TAG, "Bonding started (delayed): " + bondStarted + " for " + enteredMacAddress);
                }, 1500);
            }


        });


        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public static class ForegroundService extends Service {
        private static final String TAG = "ForegroundService";

        @Override
        public int onStartCommand(Intent intent, int flags, int startId) {
            Log.d(TAG, "onStartCommand");
            String pkgName = intent.getStringExtra("pkgName");
            String accessToken = intent.getStringExtra("accessToken");
            PackageManager pm = getApplicationContext().getPackageManager();
            try {
                assert pkgName != null;
                Intent activityIntent = pm.getLaunchIntentForPackage(pkgName);
                System.instance.startActivityFromForegroundService(getApplicationContext(), accessToken, activityIntent, ForegroundService.this);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return START_NOT_STICKY;
        }

        @Nullable
        @Override
        public IBinder onBind(Intent intent) {
            return null;
        }
    }

}
