package com.eloview.homesdk.testapp;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.peripheralManager.Peripheral;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


public class PeripheralActivity extends Activity {

    private static final String TAG = Peripheral.class.getSimpleName();
    /* This is device type list which indicates list of devices supports USB enabled disabled feature.
     * The device type name helps in getting JSON object, which we get from  GetDevicePortStatus API call
     */
    final JSONObject usb1 = new JSONObject();
    final JSONObject usb2 = new JSONObject();
    /* This flag is useful in mGetDevicePortStatusReceiver by which we come to know
     * whether to update Get USB port API Output or Set USB port API Output box
     */
    final JSONObject usb3 = new JSONObject();
    final JSONObject usb4 = new JSONObject();
    final JSONObject usb5 = new JSONObject();
    final JSONObject usb6 = new JSONObject();
    private final List<ToggleButton> setToggleButtonList = new ArrayList<>();
    private final List<ToggleButton> setExtToggleButtonList = new ArrayList<>();
    /* Below array lists holds Toggle button object, so that we can easy perform multiple UI
     * operation  on these toggle buttons.
     */
    ToggleButton toggleButtonSet1, toggleButtonSet2, toggleButtonSet3, toggleButtonSet4, toggleButtonSet5, toggleButtonSet6;
    ToggleButton toggleButtonSetExt1, toggleButtonSetExt2, toggleButtonSetExt3, toggleButtonSetExt4, toggleButtonSetExt5, toggleButtonSetExt6;
    private String accessToken = "";
    private JSONObject setDevicePortjson = new JSONObject();
    private Button returnMain, clearOutPut, bt_account_manager;
    private Button getDevicePortStatus, setDevicePortStatus, getMaxPortCount, getMaxExtPortCount;
    private TextView txtGetResult, txtSetResult;
    private boolean isResumed = false;
    public final Handler peripheralHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {
            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            switch (msg.what) {
                case AccountManager.TOKEN_VERIFY_FAIL:
                    Log.v(TAG, "INVALID_TOKEN");
                    val = "INVALID_TOKEN :\n" + val;
                    txtSetResult.setText(val);
                    if (isResumed) {
                        Toast.makeText(PeripheralActivity.this, getResources().getString(R.string.invalid_token_msg), Toast.LENGTH_LONG).show();
                    }
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case Peripheral.GET_USB_PORTS_RESULT_CODE:
                    txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), "GET_USB_PORTS_RESULT_CODE" + val));
                    break;
                case Peripheral.SET_USB_PORTS_RESULT_CODE:
                    txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), "SET_USB_PORTS_RESULT_CODE" + val));
                    break;
                case Peripheral.START_USB_MONITOR_RESULT_CODE:
                    Log.v(TAG, "START_USB_MONITOR_RESULT_CODE");
                    val = "START_USB_MONITOR_RESULT_CODE :\n:" + val;
                    txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), val));
                    break;
                case Peripheral.STOP_USB_MONITOR_RESULT_CODE:
                    Log.v(TAG, "STOP_USB_MONITOR_RESULT_CODE");
                    val = "STOP_USB_MONITOR_RESULT_CODE :\n:" + val;
                    txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), val));
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    break;
            }
            return false;
        }
    });

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "PeripheralManagerActivity: onCreate()");
        setContentView(R.layout.activity_peripheral);
        try {
            String usbPortJsonString = "{\"port1\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port2\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port3\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port4\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port5\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port6\":{\"value\":\"Disabled\",\"type\":\"USB\"}}";
            setDevicePortjson = new JSONObject(usbPortJsonString);
        } catch (JSONException ignored) {

        }
        InitializedUI();
        SetClickListener();
    }

    public void exitAppSystem(View view) {
        moveTaskToBack(true);
    }

    @Override
    protected void onResume() {
        super.onResume();
        accessToken = AccountManagerActivity.accessToken;
        AccountManager.instance.verifyEloToken(PeripheralActivity.this, accessToken, peripheralHandler);
        isResumed = true;
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d(TAG, "DevicePortStatusActivity: onPause()");
        Peripheral.instance.unregisterPeripheralAPIListener(PeripheralActivity.this);
        isResumed = false;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.e(TAG, "DevicePortStatusActivity: onDestroy()");
        Peripheral.instance.unregisterPeripheralAPIListener(PeripheralActivity.this);
        isResumed = false;
    }

    /**
     * Initialized all UI component
     */

    void InitializedUI() {
        returnMain = findViewById(R.id.button_return_main);
        clearOutPut = findViewById(R.id.clearOutPut);
        bt_account_manager = findViewById(R.id.btAccManagerSystem);
        getDevicePortStatus = findViewById(R.id.button_get_device_port_status);
        setDevicePortStatus = findViewById(R.id.button_set_device_port_status);
        getMaxPortCount = findViewById(R.id.button_get_max_port);
        getMaxExtPortCount = findViewById(R.id.button_get_max_ext_port);

        txtGetResult = findViewById(R.id.txt_result);
        txtSetResult = findViewById(R.id.txt_set_result);

        toggleButtonSet1 = findViewById(R.id.toggleButtonSet1);
        setToggleButtonList.add(toggleButtonSet1);
        toggleButtonSet2 = findViewById(R.id.toggleButtonSet2);
        setToggleButtonList.add(toggleButtonSet2);
        toggleButtonSet3 = findViewById(R.id.toggleButtonSet3);
        setToggleButtonList.add(toggleButtonSet3);
        toggleButtonSet4 = findViewById(R.id.toggleButtonSet4);
        setToggleButtonList.add(toggleButtonSet4);
        toggleButtonSet5 = findViewById(R.id.toggleButtonSet5);
        setToggleButtonList.add(toggleButtonSet5);
        toggleButtonSet6 = findViewById(R.id.toggleButtonSet6);
        setToggleButtonList.add(toggleButtonSet6);

        toggleButtonSetExt1 = findViewById(R.id.toggleButtonSetExt1);
        setExtToggleButtonList.add(toggleButtonSetExt1);
        toggleButtonSetExt2 = findViewById(R.id.toggleButtonSetExt2);
        setExtToggleButtonList.add(toggleButtonSetExt2);
        toggleButtonSetExt3 = findViewById(R.id.toggleButtonSetExt3);
        setExtToggleButtonList.add(toggleButtonSetExt3);
        toggleButtonSetExt4 = findViewById(R.id.toggleButtonSetExt4);
        setExtToggleButtonList.add(toggleButtonSetExt4);
        toggleButtonSetExt5 = findViewById(R.id.toggleButtonSetExt5);
        setExtToggleButtonList.add(toggleButtonSetExt5);
        toggleButtonSetExt6 = findViewById(R.id.toggleButtonSetExt6);
        setExtToggleButtonList.add(toggleButtonSetExt6);

        accessToken = AccountManagerActivity.accessToken;
        AccountManager.instance.verifyEloToken(PeripheralActivity.this, accessToken, peripheralHandler);
        txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), ""));
        txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), ""));

        SetToggleButtonVisibilityByDeviceType();

    }

    public void accountManagerSystem(View view) {
        Intent intent = new Intent(PeripheralActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }

    private void SetClickListener() {
        returnMain.setOnClickListener(v -> {
            Intent intent = new Intent(PeripheralActivity.this, MainActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            startActivity(intent);
        });

        toggleButtonSet1.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                if (isChecked) {
                    usb1.put("value", "Enabled");
                } else {
                    usb1.put("value", "Disabled");
                }

                usb1.put("type", "USB");
                setDevicePortjson.put("port1", usb1);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSet2.setOnCheckedChangeListener((buttonView, isChecked) -> {

            try {
                if (isChecked) {
                    usb2.put("value", "Enabled");
                } else {
                    usb2.put("value", "Disabled");
                }

                usb2.put("type", "USB");
                setDevicePortjson.put("port2", usb2);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSet3.setOnCheckedChangeListener((buttonView, isChecked) -> {

            try {
                if (isChecked) {
                    usb3.put("value", "Enabled");
                } else {
                    usb3.put("value", "Disabled");
                }

                usb3.put("type", "USB");
                setDevicePortjson.put("port3", usb3);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSet4.setOnCheckedChangeListener((buttonView, isChecked) -> {

            try {
                if (isChecked) {
                    usb4.put("value", "Enabled");
                } else {
                    usb4.put("value", "Disabled");
                }

                usb4.put("type", "USB");
                setDevicePortjson.put("port4", usb4);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSet5.setOnCheckedChangeListener((buttonView, isChecked) -> {

            try {
                if (isChecked) {
                    usb5.put("value", "Enabled");
                } else {
                    usb5.put("value", "Disabled");
                }

                usb5.put("type", "USB");
                setDevicePortjson.put("port5", usb5);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSet6.setOnCheckedChangeListener((buttonView, isChecked) -> {

            try {
                if (isChecked) {
                    usb6.put("value", "Enabled");
                } else {
                    usb6.put("value", "Disabled");
                }

                usb6.put("type", "USB");
                setDevicePortjson.put("port6", usb6);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSetExt1.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                JSONObject extUsb1 = new JSONObject();
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                if (isChecked) {
                    extUsb1.put("value", "Enabled");
                } else {
                    extUsb1.put("value", "Disabled");
                }

                extUsb1.put("type", "USB");
                extJson.put("port1", extUsb1);
                if (setDevicePortjson.has("ext")) {
                    setDevicePortjson.remove("ext");
                }
                setDevicePortjson.put("ext", extJson);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSetExt2.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                JSONObject extUsb2 = new JSONObject();
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                if (isChecked) {
                    extUsb2.put("value", "Enabled");
                } else {
                    extUsb2.put("value", "Disabled");
                }

                extUsb2.put("type", "USB");
                extJson.put("port2", extUsb2);
                if (setDevicePortjson.has("ext")) {
                    setDevicePortjson.remove("ext");
                }
                setDevicePortjson.put("ext", extJson);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSetExt3.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                JSONObject extUsb3 = new JSONObject();
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                if (isChecked) {
                    extUsb3.put("value", "Enabled");
                } else {
                    extUsb3.put("value", "Disabled");
                }

                extUsb3.put("type", "USB");
                extJson.put("port3", extUsb3);
                if (setDevicePortjson.has("ext")) {
                    setDevicePortjson.remove("ext");
                }
                setDevicePortjson.put("ext", extJson);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSetExt4.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                JSONObject extUsb4 = new JSONObject();
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                if (isChecked) {
                    extUsb4.put("value", "Enabled");
                } else {
                    extUsb4.put("value", "Disabled");
                }

                extUsb4.put("type", "USB");
                extJson.put("port4", extUsb4);
                if (setDevicePortjson.has("ext")) {
                    setDevicePortjson.remove("ext");
                }
                setDevicePortjson.put("ext", extJson);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSetExt5.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                JSONObject extUsb5 = new JSONObject();
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                if (isChecked) {
                    extUsb5.put("value", "Enabled");
                } else {
                    extUsb5.put("value", "Disabled");
                }

                extUsb5.put("type", "USB");
                extJson.put("port5", extUsb5);
                if (setDevicePortjson.has("ext")) {
                    setDevicePortjson.remove("ext");
                }
                setDevicePortjson.put("ext", extJson);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        toggleButtonSetExt6.setOnCheckedChangeListener((buttonView, isChecked) -> {
            try {
                JSONObject extUsb6 = new JSONObject();
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                if (isChecked) {
                    extUsb6.put("value", "Enabled");
                } else {
                    extUsb6.put("value", "Disabled");
                }

                extUsb6.put("type", "USB");
                extJson.put("port6", extUsb6);
                if (setDevicePortjson.has("ext")) {
                    setDevicePortjson.remove("ext");
                }
                setDevicePortjson.put("ext", extJson);
                txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            } catch (JSONException ignored) {

            }
        });
        setDevicePortStatus.setOnClickListener(v -> {
            Log.d(TAG, "@@@@@@@@@@@@@ setDevicePortStatus @@@@@@@@@@@@");
            String outputstring = "";
            String[] outputKeyValue = null;
            if (txtSetResult.getText().toString().contains(getString(R.string.str_usb_ports_set_status))) {
                outputKeyValue = txtSetResult.getText().toString().trim().split(getString(R.string.str_usb_ports_set_status));

            }
            if (outputKeyValue != null && outputKeyValue.length >= 1) {
                outputstring = outputKeyValue[1];
            }
            if (!outputstring.isEmpty()) {
                Log.d(TAG, "onclick json" + outputstring);
                Peripheral.instance.setUSBPorts(PeripheralActivity.this, accessToken, outputstring, peripheralHandler);
            }
        });

        getDevicePortStatus.setOnClickListener(v -> {
            Log.d(TAG, "!!!!!!!!! getDevicePortStatus !!!!!!!!!!!!!!!!!!!");
            Peripheral.instance.getUSBPorts(PeripheralActivity.this, accessToken, peripheralHandler);
        });
        getMaxPortCount.setOnClickListener(v -> txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), String.valueOf(Peripheral.instance.getMaxUSBPort()))));
        getMaxExtPortCount.setOnClickListener(v -> txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), String.valueOf(Peripheral.instance.getMaxExtUSBPort(PeripheralActivity.this)))));
    }

    private void SetToggleButtonVisibilityByDeviceType() {
        int initializedIndex = Peripheral.instance.getMaxUSBPort();
        int initializedExtIndex = Peripheral.instance.getMaxExtUSBPort(PeripheralActivity.this);
        Log.d(TAG, "initializedIndex" + initializedIndex);

        for (int buttonIndex = initializedIndex; buttonIndex < setToggleButtonList.size(); buttonIndex++) {
            setToggleButtonList.get(buttonIndex).setVisibility(View.GONE);
            setDevicePortjson.remove("port" + (buttonIndex + 1));
        }

        // Initialize external Usb port values to "Disabled" state
        if (initializedExtIndex > 0) {
            for (int buttonIndex = initializedExtIndex; buttonIndex < setExtToggleButtonList.size(); buttonIndex++) {
                setExtToggleButtonList.get(buttonIndex).setVisibility(View.GONE);
                try {
                    if (setDevicePortjson.has("ext")) {
                        JSONObject extJson = setDevicePortjson.getJSONObject("ext");
                        if (extJson.has("port" + (buttonIndex + 1))) {
                            extJson.remove("port" + (buttonIndex + 1));
                        }
                        setDevicePortjson.remove("ext");
                        setDevicePortjson.put("ext", extJson);
                    }
                } catch (JSONException e) {
                    Log.e(TAG, "JSONException" + e);
                }
            }
            try {
                JSONObject extJson = new JSONObject();
                if (setDevicePortjson.has("ext")) {
                    extJson = setDevicePortjson.getJSONObject("ext");
                }
                for (int i = 0; i < initializedIndex; i++) {
                    if (extJson.has("port" + (i + 1))) {
                        extJson.remove("port" + (i + 1));
                    }
                    JSONObject port = new JSONObject();
                    port.put("value", "Disabled");
                    port.put("type", "USB");
                    extJson.put("port" + (i + 1), port);
                }
                setDevicePortjson.put("ext", extJson);
            } catch (JSONException e) {
                Log.e(TAG, "JSONException" + e);
            }
        } else {
            LinearLayout extUsbLayout = findViewById(R.id.ll_set_ext_device_port_status);
            extUsbLayout.setVisibility(View.GONE);
        }

        if (initializedIndex == 0) {
            txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), "This device does not support USB On OFF feature"));
            txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), "This device does not support USB On OFF feature"));
            getDevicePortStatus.setClickable(false);
            setDevicePortStatus.setClickable(false);
            clearOutPut.setClickable(false);
        } else {
            txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
            clearOutPut.setOnClickListener(v -> {
                txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), ""));
                if (txtSetResult.getText().toString().contains("SET_USB_PORTS_RESULT_CODE")) {
                    txtSetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_set_status), setDevicePortjson.toString()));
                }
            });
        }

        Log.e(TAG, "port" + setDevicePortjson.toString());
        //Excute the for loop to set visibility of toggle button.
    }

    public void startUSBMonitor(View view) {
        txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), ""));
        Peripheral.instance.startUsbMonitoring(getApplicationContext(), accessToken, peripheralHandler);
    }

    public void stopUSBMonitor(View view) {
        txtGetResult.setText(getStringWithBoldSpan(getString(R.string.str_usb_ports_status_count_output), ""));
        Peripheral.instance.stopUsbMonitoring(getApplicationContext(), accessToken, peripheralHandler);
    }

    public SpannableString getStringWithBoldSpan(String strToDoBold, String strNormal) {
        SpannableString spannableStr = new SpannableString(strToDoBold + " " + strNormal);
        StyleSpan styleSpanBold = new StyleSpan(Typeface.BOLD);
        spannableStr.setSpan(styleSpanBold, 0, strToDoBold.length(), Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
        return spannableStr;
    }
}

