package com.eloview.homesdk.testapp;

import static android.widget.LinearLayout.VERTICAL;
import static com.eloview.homesdk.testapp.Util.hideKeyboard;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.InputType;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.packageManager.Package;

import org.json.JSONArray;
import org.json.JSONObject;

public class PackageActivity extends Activity {

    private static final String LOG_TAG = PackageActivity.class.getSimpleName();
    Button bt_account_manager;
    private String responseKey = "";
    private String responseValue = "";
    private boolean isVerified = false;
    static boolean isTokenVerified = false;
    private Button unsecureInstall, silentInstall, silentUninstall,
            button_stop_package, button_enablePackage, button_disablePackage, btnWhitelistPackage, btnGetPackageStatus, btnPackageNameandPermission, button_settingsPackage;
    private RadioButton blockPackage, disableSettings;
    private TextView txt_result;
    public final Handler packageHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {
            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            responseKey = key;
            responseValue = val;
            switch (msg.what) {
                case AccountManager.TOKEN_VERIFY_FAIL:
                    Log.v(LOG_TAG, "Invalid accessToken");
                    val = "INVALID TOKEN\n" + val;
                    Toast.makeText(PackageActivity.this, "Invalid accessToken, please enter your credentials and get a new accessToken", Toast.LENGTH_SHORT).show();
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case Package.INSTALL_LISTENER_REGISTERED:
                    Log.v(LOG_TAG, "INSTALL_LISTENER_REGISTERED");
                    val = "INSTALL_LISTENER_REGISTERED\n" + val;
                    //Toast.makeText(StdAndPkgInstActivity.this, "Please use getToken API to receive a valid accessToken", Toast.LENGTH_LONG).show();
                    break;
                case Package.UNINSTALL_LISTENER_REGISTERED:
                    Log.v(LOG_TAG, "UNINSTALL_LISTENER_REGISTERED");
                    val = "UNINSTALL_LISTENER_REGISTERED\n" + val;
                    //Toast.makeText(StdAndPkgInstActivity.this, "Please use getToken API to receive a valid accessToken", Toast.LENGTH_LONG).show();
                    break;
                case Package.INSTALL_LISTENER_UNREGISTERED:
                    Log.v(LOG_TAG, "INSTALL_LISTENER_UNREGISTERED");
                    val = "INSTALL_LISTENER_UNREGISTERED\n" + val;
                    //Toast.makeText(StdAndPkgInstActivity.this, "Please use getToken API to receive a valid accessToken", Toast.LENGTH_LONG).show();
                    break;
                case Package.UNINSTALL_LISTENER_UNREGISTERED:
                    Log.v(LOG_TAG, "UNINSTALL_LISTENER_UNREGISTERED");
                    val = "UNINSTALL_LISTENER_UNREGISTERED\n" + val;
                    //Toast.makeText(StdAndPkgInstActivity.this, "Please use getToken API to receive a valid accessToken", Toast.LENGTH_LONG).show();
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    Log.v(LOG_TAG, "Token available");
                    val = "Token: " + val;
                    isVerified = true;
                    isTokenVerified = false;
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    break;
                case Package.LISTENER_REGISTRATION_ERROR:
                    Log.d(LOG_TAG, "LISTENER_REGISTRATION_ERROR: \n" + val);
                    val = "Internal Error : " + val;
                    break;
                case Package.INSTALLER_RESULT_CODE:
                    Log.d(LOG_TAG, "INSTALLER_RESULT_CODE: \n" + val);
                    val = "INSTALLER_RESULT_CODE: " + val;
                    break;
                case Package.PACKAGE_STATUS_CHANGE_LISTENER_CODE:
                    Log.d(LOG_TAG, "PACKAGE_STATUS_CHANGE_LISTENER_CODE: " + val);
                    val = "PACKAGE_STATUS_CHANGE_LISTENER_CODE: \n" + val;
                    break;
                case Package.PACKAGE_STATUS_CHANGE_CODE:
                    Log.d(LOG_TAG, "PACKAGE_STATUS_CHANGE_CODE: " + val);
                    val = "PACKAGE_STATUS_CHANGE_CODE: \n" + val;
                    break;
                case Package.STOP_PROCESS_CODE:
                    Log.d(LOG_TAG, "STOP_PROCESS_CODE: \n" + val);
                    val = "STOP_PROCESS_CODE: " + val;
                    break;
                case Package.SET_WHITELIST_APP_PERMISSION_RESULT_CODE:
                    Log.d(LOG_TAG, "SET_WHITELIST_APP_PERMISSION_RESULT_CODE: \n" + val);
                    val = "SET_WHITELIST_APP_PERMISSION_RESULT_CODE: " + val;
                    break;
                case Package.SET_WHITELIST_RULE_RESULT_CODE:
                    Log.d(LOG_TAG, "SET_WHITELIST_RULE_RESULT_CODE: \n" + val);
                    val = "SET_WHITELIST_RULE_RESULT_CODE: " + val;
                    break;
                case Package.APP_AUTO_START_PINNING_CODE:
                    Log.d(LOG_TAG, "APP_AUTO_START_PINNING_CODE: \n" + val);
                    val = "APP_AUTO_START_PINNING_CODE " + val;
                    break;
                case Package.SET_PACKAGE_NAME_PERMISSION_RESULT_CODE:
                    Log.d(LOG_TAG, "SET_PACKAGE_NAME_PERMISSION_RESULT_CODE: \n" + val);
                    val = "SET_PACKAGE_NAME_PERMISSION_RESULT_CODE: \n" + val;
                    break;
                case Package.PACKAGE_STATUS_RESULT_CODE:
                    Log.d(LOG_TAG, "PACKAGE_STATUS_rESULT_CODE: \n" + val);
                    val = "PACKAGE_STATUS_RESULT_CODE " + val;
                    break;
            }
            txt_result.setText(val);
            return false;
        }
    });
    private String accessToken = "";
    private EditText packageName;
    private EditText packagePermission;
    boolean blockPackage_radioFlag = false;

    private void initView() {
        if (Util.isValueDevice()) {
            findViewById(R.id.llSettingsPackage).setVisibility(View.GONE);
        }
        txt_result = findViewById(R.id.txt_result);
        unsecureInstall = findViewById(R.id.button_unsecureInstall);
        silentInstall = findViewById(R.id.button_silentInstall);
        silentUninstall = findViewById(R.id.button_silentUninstall);
        button_stop_package = findViewById(R.id.button_stop_Package);
        button_disablePackage = findViewById(R.id.button_disablePackage);
        button_settingsPackage = findViewById(R.id.button_disableSettingsPackage);
        button_enablePackage = findViewById(R.id.button_enablePackage);
        bt_account_manager = findViewById(R.id.btAccManagerPackage);
        btnWhitelistPackage = findViewById(R.id.btnWhitelistPackage);
        blockPackage = findViewById(R.id.blockPackage);
        // hide unsecure install button
        unsecureInstall.setVisibility(View.GONE);
        btnGetPackageStatus = findViewById(R.id.button_getPackageStatus);
        btnPackageNameandPermission = findViewById(R.id.btnSetPackageNameandPermission);
        packageName = findViewById(R.id.editText_PackageName);
        packagePermission = findViewById(R.id.editText_PackagePermission);
        disableSettings = findViewById(R.id.rbDisableSettings);

        accessToken = AccountManagerActivity.accessToken;
        if (!isVerified || isTokenVerified) {
            isTokenVerified = false;
            AccountManager.instance.verifyEloToken(PackageActivity.this, accessToken, packageHandler);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            responseKey = savedInstanceState.getString("responseKey");
            responseValue = savedInstanceState.getString("responseValue");
            isVerified = true;
        }
        setContentView(R.layout.activity_package);
        initView();
        bt_account_manager = findViewById(R.id.btAccManagerPackage);

        if (savedInstanceState != null && responseKey != null){
            bt_account_manager.setBackgroundColor(Color.GREEN);
            if (AccountManagerActivity.emailPass) {
                bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
            } else if (AccountManagerActivity.clientSecret) {
                bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
            } else if(AccountManagerActivity.tokenFromApi) {
                bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
            }
            Message msg = packageHandler.obtainMessage();
            int code = Integer.parseInt(responseKey);
            msg.what = code;
            if (code == Package.PACKAGE_STATUS_RESULT_CODE) {
                Bundle bundle = new Bundle();
                bundle.putString(Integer.toString(code), responseValue);
                msg.setData(bundle);
                packageHandler.sendMessage(msg);
            }
        }
        unsecureInstall.setOnClickListener(v -> {
            hideKeyboard(PackageActivity.this);
//                String uri = edt_pkgUri.getText().toString();
            txt_result.setText("");
//				Package.unsecurePackageInstall(StdAndPkgInstActivity.this, uri);
        });

        //IC-31200: Fixed [Android 12] The user is unable to disable the “BLOCK PACKAGE” radio button in the EloViewHomeSDK app.
        //Used flag variable to alternate the check value of radio button when clicked.
        blockPackage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                blockPackage_radioFlag = !blockPackage_radioFlag;
                blockPackage.setChecked(blockPackage_radioFlag);
            }
        });

        silentInstall.setOnClickListener(v -> {
            hideKeyboard(PackageActivity.this);
            AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
            builder.setTitle("Enter package url");
            final EditText input = new EditText(PackageActivity.this);
            input.setInputType(InputType.TYPE_CLASS_TEXT);
            input.setHint(getResources().getString(R.string.hint_pkg_apkPath));
            builder.setView(input);
            builder.setPositiveButton("OK", (dialog, which) -> {
                String uri = input.getText().toString();
                txt_result.setText("");
                Package.instance.silentPackageInstall(PackageActivity.this, accessToken, uri,
                        packageHandler);
            });
            builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());

            builder.show();
        });
        silentUninstall.setOnClickListener(v -> {
            hideKeyboard(PackageActivity.this);
            AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
            builder.setTitle("Enter package name");
            final EditText input = new EditText(PackageActivity.this);
            input.setInputType(InputType.TYPE_CLASS_TEXT);
            input.setHint(getResources().getString(R.string.hint_pkg_name));
            builder.setView(input);
            builder.setPositiveButton("OK", (dialog, which) -> {
                String packageName = input.getText().toString();
                txt_result.setText("");
                Package.instance.silentPackageUninstall(PackageActivity.this, accessToken,
                        packageName, packageHandler);
            });
            builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
            builder.show();

        });

        btnWhitelistPackage.setOnClickListener(v -> whiteListPackageDialog(true));

        btnPackageNameandPermission.setOnClickListener(view -> {
            txt_result.setText("");
            String PackageName = packageName.getText().toString().trim();
            String PacakagePermission = packagePermission.getText().toString().trim();
            Package.instance.SetPackageNameandPermission(PackageActivity.this, accessToken, PackageName, PacakagePermission,
                    packageHandler);
        });


        button_enablePackage.setOnClickListener(v -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
            builder.setTitle("Enter package name");
            final EditText input = new EditText(PackageActivity.this);
            input.setInputType(InputType.TYPE_CLASS_TEXT);
            input.setHint(getResources().getString(R.string.hint_pkg_name));
            builder.setView(input);
            builder.setPositiveButton("OK", (dialog, which) -> {
                String edt_pkgName_stat_change = input.getText().toString().trim();
                if (edt_pkgName_stat_change.isEmpty()) {
                    txt_result.setText("Input cannot be empty.");
                    return;
                }
                txt_result.setText("");
                Package.instance.enablePackage(PackageActivity.this, accessToken, edt_pkgName_stat_change, packageHandler);
            });
            builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
            builder.show();

        });

        button_disablePackage.setOnClickListener(v -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
            builder.setTitle("Enter package name");
            final EditText input = new EditText(PackageActivity.this);
            input.setInputType(InputType.TYPE_CLASS_TEXT);
            input.setHint(getResources().getString(R.string.hint_pkg_name));
            builder.setView(input);
            builder.setPositiveButton("OK", (dialog, which) -> {
                String edt_pkgName_stat_change = input.getText().toString().trim();
                if (edt_pkgName_stat_change.isEmpty()) {
                    txt_result.setText("Input cannot be empty.");
                    return;
                }
                txt_result.setText("");
                Package.instance.disablePackage(PackageActivity.this, accessToken, edt_pkgName_stat_change, packageHandler);
            });
            builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
            builder.show();
        });

        button_settingsPackage.setOnClickListener(view -> {
            String packageState = "enable";
            if (disableSettings.isChecked()) {
                packageState = "disable";
            }
            Package.instance.enableDisableSettingsPackage(accessToken, PackageActivity.this, packageState, packageHandler);
        });

        button_stop_package.setOnClickListener(v -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
            builder.setTitle("Enter package name");
            final EditText input = new EditText(PackageActivity.this);
            input.setInputType(InputType.TYPE_CLASS_TEXT);
            input.setHint(getResources().getString(R.string.hint_pkg_name));
            builder.setView(input);
            builder.setPositiveButton("OK", (dialog, which) -> {
                String edt_pkgName_stat_change = input.getText().toString().trim();
                txt_result.setText("");
                Package.instance.stopPackage(PackageActivity.this, accessToken, edt_pkgName_stat_change, packageHandler);
            });
            builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
            builder.show();
        });

        btnGetPackageStatus.setOnClickListener(v -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
            builder.setTitle("Enter package name");
            final EditText input = new EditText(PackageActivity.this);
            input.setInputType(InputType.TYPE_CLASS_TEXT);
            input.setHint(getResources().getString(R.string.hint_pkg_name));
            builder.setView(input);
            builder.setPositiveButton("OK", (dialog, which) -> {
                String edt_pkgName_stat_change = input.getText().toString().trim();
                txt_result.setText("");
                Package.instance.getPackageStatus(PackageActivity.this, accessToken, edt_pkgName_stat_change, packageHandler);
            });
            builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
            builder.show();
        });
    }

    @Override
    protected void onPause() {
        super.onPause();
        Package.instance.unregisterPackageStatusChangeListener(PackageActivity.this);
        Package.instance.unregisterPackageInstallAPIListener(PackageActivity.this);
        Package.instance.unregisterPackageUninstallAPIListener(PackageActivity.this);
        Package.instance.unregisterWhitelistAPIListener(PackageActivity.this);
        Package.instance.unregisterWhitelistAppPermissionListener(PackageActivity.this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Package.instance.unregisterPackageStatusChangeListener(PackageActivity.this);
        Package.instance.unregisterPackageInstallAPIListener(PackageActivity.this);
        Package.instance.unregisterPackageUninstallAPIListener(PackageActivity.this);
        Package.instance.unregisterWhitelistAPIListener(PackageActivity.this);
        Package.instance.unregisterWhitelistAppPermissionListener(PackageActivity.this);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState); // the UI component values are saved here.
        Log.d("PackageActivity", "onSaveInstanceState: responseKey - "+responseKey+", responseValue - "+responseValue);
        if (!TextUtils.isEmpty(responseKey) && !TextUtils.isEmpty(responseValue)) {
            outState.putString("responseKey", responseKey);
            outState.putString("responseValue", responseValue);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (!isVerified) {
            accessToken = AccountManagerActivity.accessToken;
            AccountManager.instance.verifyEloToken(PackageActivity.this, accessToken, packageHandler);
        }
    }

    public void removeAppAutoStartPinned(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
        builder.setTitle("Enter password and select temp or permanent unlock");
        final EditText inputpassword = new EditText(PackageActivity.this);
        inputpassword.setHint("Enter password here");

        String[] items = {"Temporary unpin", "Permanent unpin"};
        final RadioButton radioButton1 = new RadioButton(this);
        radioButton1.setText(items[0]);


        final RadioButton radioButton2 = new RadioButton(this);
        radioButton2.setText(items[1]);

        RadioGroup radioGroup = new RadioGroup(this);
        radioGroup.setOrientation(RadioGroup.HORIZONTAL);
        radioGroup.addView(radioButton1);
        radioGroup.addView(radioButton2);
        radioButton1.setChecked(true);

        LinearLayout container = new LinearLayout(PackageActivity.this);
        container.setOrientation(VERTICAL);
        container.addView(inputpassword);
        container.addView(radioGroup);
        builder.setView(container);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String password = inputpassword.getText().toString().trim();
            boolean tempUnlock = radioButton1.isChecked() || !radioButton2.isChecked();
            if (password.isEmpty()) {
                Toast.makeText(getApplicationContext(), "Password can't be empty", Toast.LENGTH_SHORT).show();
            } else {
                txt_result.setText("");
            }
            Package.instance.removeAppAutostartPinned(getApplicationContext(), accessToken, password, tempUnlock, packageHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();


    }

    public void setAppAutoStartPinned(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
        builder.setTitle("Enter package name");
        final EditText input_package_name = new EditText(PackageActivity.this);
        final EditText input_new_password = new EditText(PackageActivity.this);
        final EditText input_old_password = new EditText(PackageActivity.this);
        input_package_name.setInputType(InputType.TYPE_CLASS_TEXT);
        input_package_name.setHint(getResources().getString(R.string.hint_pkg_name));
        input_new_password.setInputType(InputType.TYPE_CLASS_TEXT);
        input_new_password.setHint("New Password");
        input_old_password.setInputType(InputType.TYPE_CLASS_TEXT);
        input_old_password.setHint("Current Password");
        LinearLayout container = new LinearLayout(PackageActivity.this);
        container.setOrientation(VERTICAL);
        container.addView(input_package_name);
        container.addView(input_new_password);
        container.addView(input_old_password);
        builder.setView(container);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String pkgName = input_package_name.getText().toString().trim();
            String newPwd = input_new_password.getText().toString().trim();
            String oldPwd = input_old_password.getText().toString().trim();
            if (pkgName.isEmpty()) {
                txt_result.setText("Please enter a valid package name.");
                return;
            }
            if (oldPwd.isEmpty()) {
                oldPwd = "";
            }
            if (newPwd.isEmpty()) {
                newPwd = "";
            }
            txt_result.setText("");
            Package.instance.setAppAutostartPinned(PackageActivity.this, accessToken, newPwd, oldPwd, pkgName, packageHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void getPinnedAppStatus(View view) {
        Package.instance.getAppAutoStartPinnedStatus(PackageActivity.this, accessToken, packageHandler);
    }

    public void returnMainPackage(View view) {
        Intent intent = new Intent(PackageActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
    }

    public void exitAppPackage(View view) {
        moveTaskToBack(true);
    }

    public void accountManagerPackage(View view) {
        Intent intent = new Intent(PackageActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }

    public void clearOutputPackage(View view) {
        txt_result.setText("");
    }

    public void removeWhitelistApp(View view) {
        whiteListPackageDialog(false);
    }

    public void removeAllWhitelistApp(View view) {
        Package.instance.clearAllWhitelistAppPermission(getApplicationContext(), accessToken,
                true, packageHandler);
    }

    public void enablePackageWhitelisting(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(PackageActivity.this);
        builder.setTitle("Enter package name");
        final EditText input = new EditText(PackageActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_pkg_name));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            try {
                String pkgName = input.getText().toString().trim();
                if (!pkgName.isEmpty()) {
                    String action;
                    if (blockPackage.isChecked()) {
                        action = "block";
                    } else {
                        action = "allow";
                    }
                    JSONObject whitelistrule1 = new JSONObject();
                    whitelistrule1.put("name", pkgName);
                    whitelistrule1.put("type", "package launching");
                    whitelistrule1.put("action", action);

                    JSONObject whitelistrule2 = new JSONObject();
                    whitelistrule2.put("name", "com.eloview.homesdk.testapp");
                    whitelistrule2.put("type", "package launching");
                    whitelistrule2.put("action", "allow");

                    JSONArray jsonArray = new JSONArray();
                    jsonArray.put(whitelistrule2);
                    jsonArray.put(whitelistrule1);

                    txt_result.setText("");
                    Package.instance.enableWhitelistPackages(getApplicationContext(), accessToken, jsonArray.toString(), packageHandler);
                } else {
                    Package.instance.enableWhitelistPackages(getApplicationContext(), accessToken, "", packageHandler);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void disablePackageWhitelisting(View view) {
        Package.instance.disableWhitelistPackages(getApplicationContext(), accessToken, packageHandler);
    }

    private void whiteListPackageDialog(final boolean addToWhitelist) {
        hideKeyboard(this);
        final AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Enter package name");
        final EditText input = new EditText(this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_pkg_name));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String packageName = input.getText().toString();
            txt_result.setText("");
            if (addToWhitelist) {
                Package.instance.setWhitelistAppPermission(PackageActivity.this, accessToken,
                        packageName, packageHandler);
            } else {
                Package.instance.clearWhitelistAppPermission(getApplicationContext(), accessToken,
                        packageName, packageHandler);
            }
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }
}
