package com.eloview.homesdk.testapp;

import static com.eloview.homesdk.testapp.Util.TAG;
import static com.eloview.homesdk.testapp.Util.hideKeyboard;
import static com.eloview.homesdk.testapp.Util.isAndroidQDevice;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.InputType;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.otaManager.AndroidVersion;
import com.eloview.homesdk.otaManager.OTA;

import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class OtaActivity extends Activity implements View.OnClickListener {

    private static final String LOG_TAG = OtaActivity.class.getSimpleName();
    public static final String ACTION_OTA_PROGRESS = "com.elo.otaupdater.ACTION_OTA_PROGRESSBAR";
    private static String accessToken = "";
    private boolean showProgressFlag = true;
    private final int ACTIVITY_RESULT_SUCCESS = 123;
    private Button returnMain, clearOutPut, secureCheckOTA,
            secureDownloadOTA, secureVerifyOTA, getAvailableVersions, secureDownloadOTAVersion,
            downloadOtaFromUrl, downloadOtaFromLocalPath, secureApplyOTA, checkOS360Details, checkOtaStatusLocal;
    private TextView txt_result;
    private Button bt_account_manager;
    AlertDialog otaProgressDialog;
    @SuppressLint("HandlerLeak")
    public final Handler otaHandler = new Handler(Looper.getMainLooper()) {
        @SuppressLint("SetTextI18n")
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            switch (msg.what) {
                case OTA.OTA_DOWNLOAD_REMOTE_FILE_PERCENTAGE:
                    Log.i(LOG_TAG, "Remote file download percentage := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_PERCENTAGE \n\n Percentage : " + val);
                    break;
                case OTA.OTA_DOWNLOAD_REMOTE_FILE_SUCCESS:
                    Log.i(LOG_TAG, "Remote file download success := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_SUCCESS \n\n Info : " + val);
                    break;
                case OTA.OTA_DOWNLOAD_REMOTE_FILE_ERROR:
                    Log.i(LOG_TAG, "Remote file download error := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_ERROR \n\n Error : " + val);
                    break;
                case OTA.OTA_DOWNLOAD_LOCAL_FILE_PERCENTAGE:
                    Log.i(LOG_TAG, "Local file download percentage := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_LOCAL_FILE_PERCENTAGE \n\n Percentage : " + val);
                    break;
                case OTA.OTA_DOWNLOAD_LOCAL_FILE_SUCCESS:
                    Log.i(LOG_TAG, "Local file download success := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_LOCAL_FILE_SUCCESS \n\n Info : " + val);
                    break;
                case OTA.OTA_DOWNLOAD_LOCAL_FILE_ERROR:
                    Log.i(LOG_TAG, "Local file download error := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_LOCAL_FILE_ERROR \n\n Error : " + val);
                    break;
                case OTA.OTA_DOWNLOAD_GENERIC_ERROR:
                    Log.i(LOG_TAG, "Download error := " + val);
                    txt_result.setText("Code : OTA_DOWNLOAD_GENERIC_ERROR \n\n Error : " + val);
                    break;
                case OTA.OTA_VERIFY_SIGN_PERCENTAGE:
                    Log.i(LOG_TAG, "Verify sign percentage := " + val);
                    txt_result.setText("Code : OTA_VERIFY_SIGN_PERCENTAGE \n\n Percentage : " + val);
                    break;
                case OTA.OTA_VERIFY_SIGN_SUCCESS:
                    Log.i(LOG_TAG, "Verify sign success := " + val);
                    txt_result.setText("Code : OTA_VERIFY_SIGN_SUCCESS \n\n Info : " + val);
                    break;
                case OTA.OTA_VERIFY_SIGN_ERROR:
                    Log.i(LOG_TAG, "Verify sign error := " + val);
                    txt_result.setText("Code : OTA_VERIFY_SIGN_ERROR \n\n Error : " + val);
                    break;
                case OTA.OTA_VERIFY_FILE_ERROR:
                    Log.i(LOG_TAG, "Verify file error := " + val);
                    txt_result.setText("Code : OTA_VERIFY_FILE_ERROR \n\n Error : " + val);
                    break;
                case OTA.OTA_CHECK_STATUS_OLD:
                    Log.i(LOG_TAG, "OTA check : Version is old := " + val);
                    txt_result.setText("Code : OTA_CHECK_STATUS_OLD \n\n Status : " + val);
                    break;
                case OTA.OTA_CHECK_STATUS_NEW:
                    Log.i(LOG_TAG, "OTA Check : Version is new := " + val);
                    txt_result.setText("Code : OTA_CHECK_STATUS_NEW \n\n Status : " + val);
                    break;
                case OTA.OTA_CHECK_STATUS_SAME:
                    Log.i(LOG_TAG, "OTA Check : Version is same  := " + val);
                    txt_result.setText("Code : OTA_CHECK_STATUS_SAME \n\n Status : " + val);
                    break;
                case OTA.OTA_CHECK_STATUS_GENERIC_ERROR:
                    Log.i(LOG_TAG, "OTA Check : Status error  := " + val);
                    txt_result.setText("Code : OTA_CHECK_STATUS_GENERIC_ERROR \n\n Status : " + val);
                    break;
                case OTA.OTA_APPLY_FILE_ERROR:
                    Log.i(LOG_TAG, "OTA apply file error := " + val);
                    txt_result.setText("Code : OTA_APPLY_FILE_ERROR \n\n Status : " + val);
                    break;
                case OTA.OTA_APPLY_IN_PROGRESS:
                    Log.i(LOG_TAG, "OTA apply file progress := " + val);
                    txt_result.setText("Code : OTA_APPLY_IN_PROGRESS \n\n Status : " + val);
                    break;
                case AccountManager.TOKEN_VERIFY_FAIL:
                    Log.v(LOG_TAG, "Invalid accessToken");
                    txt_result.setText("INVALID TOKEN\n" + val);
                    Toast.makeText(OtaActivity.this, getResources().getString(R.string.invalid_token_msg), Toast.LENGTH_LONG).show();
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case OTA.OTA_VERSION_RESPONSE_AVAILABLE:
                    Log.v(LOG_TAG, "OTA_VERSION_RESPONSE_AVAILABLE");
                    txt_result.setText("OTA versions:\n" + val);
                    break;
                case OTA.GENERIC_ERROR:
                    Log.v(LOG_TAG, "OTA_GENERIC_ERROR");
                    txt_result.setText("OTA_GENERIC_ERROR: OTA Error:\n" + val);
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    Log.v(LOG_TAG, "TOKEN_VERIFY_RESPONSE_AVAILABLE");
                    txt_result.setText(val);
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    break;
                case OTA.OTA_DOWNLOAD_REMOTE_FILE_ALREADY_DOWNLOADED:
                    Log.v(LOG_TAG, "OTA_DOWNLOAD_REMOTE_FILE_ALREADY_DOWNLOADED");
                    txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_ALREADY_DOWNLOADED \n\n Status : " + val);
                    break;
                case OTA.OS360_RESPONSE_AVAILABLE:
                    Log.v(LOG_TAG, "OS360_RESPONSE_AVAILABLE");
                    txt_result.setText("Code : OS360_RESPONSE_AVAILABLE \n\n Status : " + val);
                    break;
                case OTA.EV_RESPONSE:
                    Log.v(LOG_TAG, "ELOVIEW_PORTAL_RESPONSE");
                    txt_result.setText("Code: ELOVIEW_PORTAL_RESPONSE: \n" + val);
                    break;
                case OTA.OS360_RESPONSE_UNAVAILABLE:
                    Log.v(LOG_TAG, "OS360_RESPONSE_UNAVAILABLE");
                    txt_result.setText("Code : OS360_RESPONSE_UNAVAILABLE \n\n Status : " + val);
                    break;
            }
        }
    };
    private String[] otaVersion;

    private static void sendMessage(Handler handler, int code) {
        Message msg = handler.obtainMessage();
        msg.what = code;
        Bundle bundle = new Bundle();
        bundle.putString(Integer.toString(code), "OTA Version field is empty");
        msg.setData(bundle);
        handler.sendMessage(msg);
    }

    BroadcastReceiver otaProgressReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if(showProgressFlag){ // only show progress dialog once when entering the activity
                runOnUiThread(()->{
                    otaProgressDialog.setTitle("OTA Progress");
                    otaProgressDialog.setMessage(intent.getStringExtra("status")+": "+intent.getIntExtra("progress",0));
                    if(!otaProgressDialog.isShowing()){
                        otaProgressDialog.show();
                    }else{
                        otaProgressDialog.getWindow().getDecorView().invalidate();
                    }
                });
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (isAndroidQDevice()) {
            setContentView(R.layout.acttivity_secure_ota_androidq);
        } else {
            setContentView(R.layout.activity_secure_ota);
        }
        initView();
        initListener();
        bt_account_manager = findViewById(R.id.btAccManagerOta);
    }

    @Override
    protected void onResume() {
        super.onResume();
        accessToken = AccountManagerActivity.accessToken;
        AccountManager.instance.verifyEloToken(OtaActivity.this, accessToken, otaHandler);
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setPositiveButton("Okay", (dialog, which) -> {
            showProgressFlag = false;
            dialog.dismiss();
        });
        otaProgressDialog = builder.setMessage("").create();
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_OTA_PROGRESS);
        registerReceiver(otaProgressReceiver, filter);
    }

    @Override
    protected void onStop() {
        super.onStop();
        unregisterReceiver(otaProgressReceiver);
    }

    private void initView() {
        returnMain = findViewById(R.id.button_return_main);
        clearOutPut = findViewById(R.id.clearOutPut);
        txt_result = findViewById(R.id.txt_result);
        secureCheckOTA = findViewById(R.id.button_chk_elo_ota_status);
        secureDownloadOTA = findViewById(R.id.button_start_elo_ota_download);
        secureVerifyOTA = findViewById(R.id.button_verify_elo_ota);
        secureApplyOTA = findViewById(R.id.button_apply_elo_ota);
        getAvailableVersions = findViewById(R.id.button_getAvailableVersions);
        secureDownloadOTAVersion = findViewById(R.id.button_start_elo_ota_version);
        downloadOtaFromUrl = findViewById(R.id.button_start_elo_ota_download_url);
        downloadOtaFromLocalPath = findViewById(R.id.button_select_ota_from_local_path);

        if (isAndroidQDevice()) {
            checkOtaStatusLocal = findViewById(R.id.button_chk_elo_ota_status_local);
            checkOS360Details = findViewById(R.id.button_chk_os360_details);
        }
        otaVersion = getResources().getStringArray(R.array.ota_version);
    }

    private void initListener() {
        clearOutPut.setOnClickListener(this);
        returnMain.setOnClickListener(this);
        if (!isAndroidQDevice()) {
            secureApplyOTA.setOnClickListener(this);
            secureVerifyOTA.setOnClickListener(this);
        } else {
            secureApplyOTA.setEnabled(false);
            secureVerifyOTA.setEnabled(false);
        }
        secureDownloadOTAVersion.setOnClickListener(this);
        downloadOtaFromUrl.setOnClickListener(this);
        secureDownloadOTA.setOnClickListener(this);
        secureCheckOTA.setOnClickListener(this);
        getAvailableVersions.setOnClickListener(this);
        downloadOtaFromLocalPath.setOnClickListener(this);

        if (isAndroidQDevice()) {
            checkOS360Details.setOnClickListener(v -> checkOS360DetailsForOTA());
            checkOtaStatusLocal.setOnClickListener(this);
        }

    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.clearOutPut:
                txt_result.setText("");
                break;

            case R.id.button_return_main:
                Intent i = new Intent(OtaActivity.this, MainActivity.class);
                i.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(i);
                break;
            case R.id.button_apply_elo_ota:
                hideKeyboard(OtaActivity.this);
                txt_result.setText("");
                OTA.instance.applyOTA(OtaActivity.this, accessToken, otaHandler);
                break;

            case R.id.button_verify_elo_ota:
                hideKeyboard(OtaActivity.this);
                txt_result.setText("");
                OTA.instance.verifyEloOTA(OtaActivity.this, accessToken, otaHandler);
                break;

            case R.id.button_start_elo_ota_version:
                downloadOTAVersion();
                break;
            case R.id.button_start_elo_ota_download_url:
                downloadOtaFromUrl();
                break;
            case R.id.button_select_ota_from_local_path:
                if (isAndroidQDevice()) {
                    downloadOTAFromLocal();
                } else {
                    Intent intent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
                    intent.addCategory(Intent.CATEGORY_OPENABLE);
                    intent.setType("*/*");
                    try {
                        startActivityForResult(intent, ACTIVITY_RESULT_SUCCESS);
                    } catch (android.content.ActivityNotFoundException ex) {
                        Toast.makeText(this, "Please install a File Manager.", Toast.LENGTH_SHORT).show();
                    }
                }
                break;
            case R.id.button_start_elo_ota_download:
                hideKeyboard(OtaActivity.this);
                txt_result.setText("");
                Log.v(LOG_TAG, "using default ota url");
                Toast.makeText(getApplicationContext(), "Using default OTA URL", Toast.LENGTH_LONG).show();
                if (isAndroidQDevice()) {
                    OTA.instance.downloadApplyABOTA(OtaActivity.this, accessToken, "", "", "", otaHandler);
                } else {
                    OTA.instance.startDownloadUpgradePackage(OtaActivity.this, accessToken, "", null,
                            "", otaHandler);
                }
                break;
            case R.id.button_chk_elo_ota_status:
                checkOTA();
                break;
            case R.id.button_chk_elo_ota_status_local:
                checkOtaStatusLocal();
                break;
            case R.id.button_getAvailableVersions:
                hideKeyboard(OtaActivity.this);
                txt_result.setText("");
                selectAvailableOTAVersion();
                break;
        }
    }

    private void checkOS360DetailsForOTA() {
        OTA.instance.getOS360Details(OtaActivity.this, accessToken, otaHandler);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ACTIVITY_RESULT_SUCCESS && resultCode == RESULT_OK) {
            final Uri selectedFile = data.getData();

            try {
                assert selectedFile != null;
                Log.d(TAG, selectedFile.toString());
                txt_result.setText(String.format(getResources().getString(R.string.select_file_msg), selectedFile));
                Toast.makeText(getApplicationContext(), "Using local OTA path", Toast.LENGTH_LONG).show();
                OTA.instance.startDownloadUpgradePackage(OtaActivity.this, accessToken, "", selectedFile,
                        "", otaHandler);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

    }

    public void selectAvailableOTAVersion() {
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setTitle("Select OTA Version");
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.setItems(otaVersion, (dialog, which) -> {
            switch (which) {
                case 0:
                    callAvailableOtaVersion(null);
                    break;
                case 1:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_OREO_AOSP);
                    break;
                case 2:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_OREO_GMS);
                    break;
                case 3:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_NOGUAT_AOSP);
                    break;
                case 4:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_KITKAT_AOSP);
                    break;
                case 5:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q_GMS_PERF);
                    break;
                case 6:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q_AOSP_PERF);
                    break;
                case 7:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q_GMS_VAL);
                    break;
                case 8:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q_AOSP_VAL);
                    break;
                case 9:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q1_GMS_PERF);
                    break;
                case 10:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q1_AOSP_PERF);
                    break;
                case 11:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q1_GMS_VAL);
                    break;
                case 12:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_Q1_AOSP_VAL);
                    break;
                case 13:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_7_INCH_PAY);
                    break;
                case 14:
                    callAvailableOtaVersion(AndroidVersion.ANDROID_M100);
                    break;
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void callAvailableOtaVersion(AndroidVersion androidVersion) {
        OTA.instance.getAvailableVersions(OtaActivity.this, accessToken, androidVersion, otaHandler);
    }

    private void checkOTA() {
        Log.v(LOG_TAG, "secureVerifyCheckOTA onClick");
        hideKeyboard(OtaActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setTitle("Enter OTA URL");
        final EditText input = new EditText(OtaActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_ota_status_url));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String statusUrl = input.getText().toString().trim();
            Log.v(LOG_TAG, "statusURL is: " + statusUrl);
            txt_result.setText("");
            OTA.instance.checkOTAStatus(OtaActivity.this, accessToken, statusUrl, otaHandler);

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();

        // Send full accessToken accessToken
    }

    private void checkOtaStatusLocal() {
        hideKeyboard(OtaActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setTitle("Enter OTA json file path containing the build properties");
        final EditText input = new EditText(OtaActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_ota_json_path));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String otaJsonPath = input.getText().toString().trim();
            Log.v(LOG_TAG, "OTA json file path is: " + otaJsonPath);
            txt_result.setText("");
            JSONObject jsonObject = null;
            if (otaJsonPath.endsWith("json")) {
                try {
                    File file = new File(otaJsonPath);
                    if (file.exists()) {
                        InputStream is = new FileInputStream(otaJsonPath);
                        String json = IOUtils.toString(is, StandardCharsets.UTF_8);
                        Log.d(TAG, json);
                        jsonObject = new JSONObject(json);
                    } else {
                        txt_result.setText("Given file does not exist");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (isAndroidQDevice() && jsonObject != null) {
                    OTA.instance.checkOTAStatus(OtaActivity.this, accessToken, jsonObject, otaHandler);
                } else {
                    txt_result.setText("This method is only for Elo 4.0 devices or json object might be null.");
                }

            } else {
                Toast.makeText(getApplicationContext(), "Please enter path to a valid json file", Toast.LENGTH_LONG).show();
            }

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    private void downloadOTAFromLocal() {
        hideKeyboard(OtaActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setTitle("Enter OTA File Path");
        final EditText input = new EditText(OtaActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_ota_path));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String otaPath = input.getText().toString().trim();
            Log.v(LOG_TAG, "OTA path is: " + otaPath);
            txt_result.setText("");
            if (!otaPath.isEmpty()) {
                if (isAndroidQDevice()) {
                    OTA.instance.downloadApplyABOTA(OtaActivity.this, accessToken, "", otaPath, "", otaHandler);
                }

            } else {
                Toast.makeText(getApplicationContext(), "Please enter an OTA path", Toast.LENGTH_LONG).show();
            }

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    private void downloadOtaFromUrl() {
        hideKeyboard(OtaActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setTitle("Enter OTA URL");
        final EditText input = new EditText(OtaActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_ota_download_url));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String downloadUrl = input.getText().toString().trim();
            Log.v(LOG_TAG, "downloadURL is: " + downloadUrl);
            txt_result.setText("");
            if (!downloadUrl.isEmpty()) {
                if (isAndroidQDevice()) {
                    if (Patterns.WEB_URL.matcher(downloadUrl).matches()) {
                        Log.v(LOG_TAG, "Using Patterns.WEB_URL for download");
                        OTA.instance.downloadApplyABOTA(OtaActivity.this, accessToken, downloadUrl, "", "", otaHandler);
                    } else {
                        Log.v(LOG_TAG, "Using user provided URL for download");
                        OTA.instance.downloadApplyABOTA(OtaActivity.this, accessToken, downloadUrl, "", "", otaHandler);
                    }
                } else {
                    if (Patterns.WEB_URL.matcher(downloadUrl).matches()) {
                        Log.v(LOG_TAG, "Using Patterns.WEB_URL for download");
                        OTA.instance.startDownloadUpgradePackage(OtaActivity.this, accessToken, downloadUrl, null, "", otaHandler);
                    } else {
                        Log.v(LOG_TAG, "Using user provided URL for download");
                        OTA.instance.startDownloadUpgradePackage(OtaActivity.this, accessToken, downloadUrl, null, "", otaHandler);
                    }
                }

            } else {
                Toast.makeText(getApplicationContext(), "Please enter an OTA download url", Toast.LENGTH_LONG).show();
            }

        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();

    }

    private void downloadOTAVersion() {
        hideKeyboard(OtaActivity.this);
        txt_result.setText("");
        AlertDialog.Builder builder = new AlertDialog.Builder(OtaActivity.this);
        builder.setTitle("Enter Version");
        final EditText input = new EditText(OtaActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_ota_specific_version));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String version = input.getText().toString().trim();
            Log.v(LOG_TAG, "Ota version is: " + version);
            txt_result.setText("");
            if (!version.isEmpty()) {
                Log.v(LOG_TAG, "Using user provided version for download");
                Toast.makeText(getApplicationContext(), "Using user provided OTA version", Toast.LENGTH_LONG).show();
                if (isAndroidQDevice()) {
                    OTA.instance.downloadApplyABOTA(OtaActivity.this, accessToken, "", "", version, otaHandler);
                } else {
                    OTA.instance.startDownloadUpgradePackage(OtaActivity.this, accessToken, "", null, version, otaHandler);
                }

            } else {
                Toast.makeText(getApplicationContext(), "Please enter a version", Toast.LENGTH_LONG).show();
                sendMessage(otaHandler, OTA.OTA_DOWNLOAD_GENERIC_ERROR);
            }
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void exitAppOta(View view) {
        moveTaskToBack(true);
    }

    public void accountManagerOta(View view) {
        Intent intent = new Intent(OtaActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }

    public void returnMainOta(View view) {
        Intent intent = new Intent(OtaActivity.this, MainActivity.class);
        startActivity(intent);
    }

    public void clearOutputOta(View view) {
        txt_result.setText("");
    }
}
