package com.eloview.homesdk.testapp;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.ArrayAdapter;

import androidx.appcompat.widget.AppCompatSpinner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiSelectSpinner extends AppCompatSpinner implements
        DialogInterface.OnMultiChoiceClickListener, DialogInterface.OnCancelListener, DialogInterface.OnDismissListener {
    private static final String TAG = "MultiSelectSpinner";
    private static boolean[] savedSelected;
    private List<String> items;
    private boolean[] selected;
    private String defaultText;
    private MultiSpinnerListener listener;

    public MultiSelectSpinner(Context context) {
        super(context);
        addItems();
    }

    public MultiSelectSpinner(Context arg0, AttributeSet arg1) {
        super(arg0, arg1);
        addItems();
    }

    public MultiSelectSpinner(Context arg0, AttributeSet arg1, int arg2) {
        super(arg0, arg1, arg2);
        addItems();
    }

    @Override
    public void onClick(DialogInterface dialog, int which, boolean isChecked) {
        selected[which] = isChecked;
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        StringBuilder spinnerBuffer = new StringBuilder();
        boolean someSelected = false;
        System.arraycopy(savedSelected, 0, selected, 0, items.size());
        for (int i = 0; i < items.size(); i++) {
            if (selected[i]) {
                spinnerBuffer.append(items.get(i));
                spinnerBuffer.append(", ");
                someSelected = true;
            }
        }
        String spinnerText;
        if (someSelected) {
            spinnerText = spinnerBuffer.toString();
            if (spinnerText.length() > 2)
                spinnerText = spinnerText.substring(0, spinnerText.length() - 2);
        } else {
            spinnerText = defaultText;
        }
        ArrayAdapter<String> adapter = new ArrayAdapter<>(getContext(),
                android.R.layout.simple_spinner_item,
                new String[]{spinnerText});
        setAdapter(adapter);
//        listener.onItemsSelected(selected);
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        onCancel(dialog);
    }

    public void onOk() {
        // refresh text on spinner
        StringBuilder spinnerBuffer = new StringBuilder();
        boolean someSelected = false;
        for (int i = 0; i < items.size(); i++) {
            if (selected[i]) {
                spinnerBuffer.append(items.get(i));
                spinnerBuffer.append(", ");
                someSelected = true;
            }
        }
        String spinnerText;
        if (someSelected) {
            spinnerText = spinnerBuffer.toString();
            if (spinnerText.length() > 2)
                spinnerText = spinnerText.substring(0, spinnerText.length() - 2);
        } else {
            spinnerText = defaultText;
        }
        ArrayAdapter<String> adapter = new ArrayAdapter<>(getContext(),
                android.R.layout.simple_spinner_item,
                new String[]{spinnerText});
        setAdapter(adapter);
        System.arraycopy(selected, 0, savedSelected, 0, items.size());
        listener.onItemsSelected(selected);
    }

    @Override
    public boolean performClick() {
        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
        builder.setMultiChoiceItems(
                items.toArray(new CharSequence[0]), selected, this);
        builder.setNegativeButton(android.R.string.cancel,
                (dialog, which) -> dialog.cancel());
        builder.setPositiveButton(android.R.string.ok,
                (dialog, which) -> onOk());
        builder.setOnCancelListener(this);
        builder.show();
        return true;
    }

    private void setItems(List<String> items, String allText,
                          MultiSpinnerListener listener) {
        this.items = items;
        this.defaultText = allText;
        this.listener = listener;

        // all selected by default
        selected = new boolean[items.size()];
        Arrays.fill(selected, false);
        savedSelected = new boolean[items.size()];
        Arrays.fill(savedSelected, false);

        // all text on the spinner
        ArrayAdapter<String> adapter = new ArrayAdapter<>(getContext(),
                android.R.layout.simple_spinner_item, new String[]{allText});
        setAdapter(adapter);
    }

    private void addItems() {
        List<String> mItems = new ArrayList<>();
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_A));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_B));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_C));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_D));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_HOME));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_POWER));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_VOLUME_UP));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_VOLUME_DOWN));
        mItems.add(KeyEvent.keyCodeToString(KeyEvent.KEYCODE_BACK));

        MultiSpinnerListener listener = selected -> Log.d(TAG, "Items Selected: " + Arrays.toString(selected));
        setItems(mItems, "Select Key to Listen to", listener);
    }

    public boolean[] getSelected() {
        return selected;
    }

    public List<String> getItems() {
        return items;
    }

    public interface MultiSpinnerListener {
        void onItemsSelected(boolean[] selected);
    }
}
