package com.eloview.homesdk.testapp;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.memoryManager.Memory;

public class MemoryActivity extends Activity {
    private String accessToken = "";
    private TextView txt_result;
    private Button bt_account_manager;
    final Handler memoryHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {

            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            switch (msg.what) {
                case AccountManager.TOKEN_VERIFY_FAIL:
                    val = "INVALID TOKEN\n" + val;
                    txt_result.setText(val);
                    Toast.makeText(MemoryActivity.this, getResources().getString(R.string.invalid_token_msg), Toast.LENGTH_SHORT).show();
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case Memory.MEMORY_INFO_CODE:
                    val = "MEMORY_INFO\n" + val;
                    txt_result.setText(val);
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    txt_result.setText(val);
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    txt_result.setText(val);
                    break;
            }

            return false;
        }
    });

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_memory);
        txt_result = findViewById(R.id.txt_result);
        bt_account_manager = findViewById(R.id.btAccManagerMemory);
    }

    @Override
    protected void onResume() {
        super.onResume();
        accessToken = AccountManagerActivity.accessToken;
        AccountManager.instance.verifyEloToken(MemoryActivity.this, accessToken, memoryHandler);
    }

    public void getMemoryInfo(View view) {
        Memory.instance.getMemoryInfo(getApplicationContext(), accessToken, memoryHandler);
    }

    public void returnMainMemory(View view) {
        Intent intent = new Intent(MemoryActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
    }

    public void clearOutputMemory(View view) {
        txt_result.setText("");
    }

    public void exitAppMemory(View view) {
        moveTaskToBack(true);
    }

    public void accountManagerMemory(View view) {
        Intent intent = new Intent(MemoryActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }
}
