package com.eloview.homesdk.testapp;

import static android.Manifest.permission.ACCESS_FINE_LOCATION;
import static android.Manifest.permission.ACCESS_NETWORK_STATE;
import static android.Manifest.permission.ACCESS_WIFI_STATE;
import static android.Manifest.permission.BLUETOOTH;
import static android.Manifest.permission.BLUETOOTH_ADMIN;
import static android.Manifest.permission.BLUETOOTH_PRIVILEGED;
import static android.Manifest.permission.CAMERA;
import static android.Manifest.permission.WRITE_EXTERNAL_STORAGE;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;

import com.eloview.homesdk.infoManager.Info;

public class MainActivity extends Activity implements View.OnClickListener {

    private static final int EXTERNAL_STORAGE_PERMISSION_CONSTANT = 100;
    private final String TAG = MainActivity.class.getSimpleName();
    private final String[] permissions = new String[]{
            WRITE_EXTERNAL_STORAGE, ACCESS_FINE_LOCATION, ACCESS_WIFI_STATE, ACCESS_NETWORK_STATE, CAMERA,BLUETOOTH,BLUETOOTH_PRIVILEGED,BLUETOOTH_ADMIN,BLUETOOTH_SERVICE,};
    private Button btn_ota_api, btn_package_api, btn_network_api,
            btn_system_api, btn_device_api, btn_memory_api, btn_peripheral_api, btn_eloview_api;
    private TextView app_sdk_version;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        btn_device_api = findViewById(R.id.btn_device_api);
        btn_memory_api = findViewById(R.id.btn_memory_api);
        btn_network_api = findViewById(R.id.btn_network_api);
        btn_ota_api = findViewById(R.id.btn_ota_api);
        btn_package_api = findViewById(R.id.btn_package_api);
        btn_system_api = findViewById(R.id.btn_system_api);
        btn_peripheral_api = findViewById(R.id.btn_peripheral_api);
        app_sdk_version = findViewById(R.id.app_sdk_version);
        btn_eloview_api = findViewById(R.id.btn_eloview_api);

        initView();
        checkDevicePermission();
    }

    private void initView() {

        // bind click listener
        btn_device_api.setOnClickListener(this);
        btn_memory_api.setOnClickListener(this);
        btn_network_api.setOnClickListener(this);
        btn_ota_api.setOnClickListener(this);
        btn_package_api.setOnClickListener(this);
        btn_system_api.setOnClickListener(this);
        btn_peripheral_api.setOnClickListener(this);
        btn_eloview_api.setOnClickListener(this);

        String sdk_version;
        if (Info.instance.isSDKSupported(this)) {
            sdk_version = "SDK Version: " + Info.instance.getSDKVersion(this);
        } else {
            sdk_version = "EloViewHome SDK is not supported on this device";
        }
        app_sdk_version.setText(sdk_version);

    }

    private void checkDevicePermission() {
        if (Build.VERSION.SDK_INT > 23) {
            if (hasPermissions(permissions)) {
                Log.d(TAG, "Permission is granted");
            } else {
                Log.d(TAG, "request Permissions");
                if (neverAskAgainSelected()) {
                    displayNeverAskAgainDialog();
                } else {
                    ActivityCompat.requestPermissions(this, permissions,
                            EXTERNAL_STORAGE_PERMISSION_CONSTANT);
                }
            }
        } else {
            Log.e(TAG, "Device below Marshmallow");
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.d(TAG, "in side  onRequestPermissionsResult");

        if (requestCode == EXTERNAL_STORAGE_PERMISSION_CONSTANT) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                Log.d(TAG, "Storage permissions granted");
            } else {
                Log.d(TAG, "Permissions decline so close activity");
                finish();
            }
        }
    }

    private boolean hasPermissions(String[] permissions) {
        if (getApplicationContext() != null && permissions != null) {
            for (String permission : permissions) {
                Log.d(TAG, "Permission: " + permission);
                if (ActivityCompat.checkSelfPermission(getApplicationContext(), permission) != PackageManager.PERMISSION_GRANTED) {
                    return false;
                }
            }
        }
        return true;
    }

    private void displayNeverAskAgainDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setMessage("Location and Storage permissions are needed for performing necessary tasks. Please permit these permissions through "
                + "the Settings screen.\n\nSelect Permissions -> Enable permission");
        builder.setCancelable(false);
        builder.setPositiveButton("Permit Manually", (dialog, which) -> {
            dialog.dismiss();
            Intent intent = new Intent();
            intent.setAction(android.provider.Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
            Uri uri = Uri.fromParts("package", getPackageName(), null);
            intent.setData(uri);
            startActivity(intent);
        });
        builder.setNegativeButton("Cancel", null);
        builder.show();
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    public boolean neverAskAgainSelected() {
        if (getApplicationContext() != null) {
            for (String permission : permissions) {
                if (shouldShowRequestPermissionRationale(permission)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onClick(View view) {
        Intent intent = null;
        switch (view.getId()) {
            case R.id.btn_device_api:
                intent = new Intent(MainActivity.this, InfoActivity.class);
                break;
            case R.id.btn_network_api:
                intent = new Intent(MainActivity.this, NetworkActivity.class);
                break;
            case R.id.btn_ota_api:
                intent = new Intent(MainActivity.this, OtaActivity.class);
                break;
            case R.id.btn_package_api:
                intent = new Intent(MainActivity.this, PackageActivity.class);
                break;
            case R.id.btn_system_api:
                intent = new Intent(MainActivity.this, SystemActivity.class);
                break;
            case R.id.btn_memory_api:
                intent = new Intent(MainActivity.this, MemoryActivity.class);
                break;
            case R.id.btn_peripheral_api:
                intent = new Intent(MainActivity.this, PeripheralActivity.class);
                break;
            case R.id.btn_eloview_api:
                intent = new Intent(MainActivity.this, EloViewActivity.class);
                break;
        }
        if (intent != null) {
            startActivity(intent);
        }
    }

    public void exitAppMain(View view) {
        moveTaskToBack(true);
    }
}