package com.eloview.homesdk.testapp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;

import com.eloview.homesdk.systemManager.System;

import java.lang.ref.WeakReference;
import java.util.Objects;

public class KeyReceiver extends BroadcastReceiver {
    private final static String TAG = "KeyReceiver";
    static WeakReference<Handler> mSystemHandler;

    public KeyReceiver(WeakReference<Handler> systemHandler) {
        mSystemHandler = systemHandler;
    }

    public KeyReceiver() {
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        Log.d(TAG, "onReceive: - > "+intent.getAction());
        if (Objects.equals(intent.getAction(), "com.elo.secure.action.INTERCEPT_KEY_EVENT")) {
            KeyEvent event = intent.getParcelableExtra("KEY_EVENT");
            if (event != null) {
                try {
                    Log.d(TAG, event.toString());
                    Message msg = mSystemHandler.get().obtainMessage();
                    msg.what = System.RECEIVE_KEY_EVENT;
                    Bundle bundle = new Bundle();
                    bundle.putString(Integer.toString(System.RECEIVE_KEY_EVENT), event.toString());
                    msg.setData(bundle);
                    mSystemHandler.get().sendMessage(msg);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}