package com.eloview.homesdk.testapp;

import static android.content.ContentValues.TAG;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.infoManager.Info;

import java.util.Iterator;
import java.util.Set;

public class InfoActivity extends Activity {

    public static final int UNREGISTERED_SUCCESSFULLY_CODE = 200;
    public static final int UNREGISTER_CTX_NULL_CODE = 201;
    public static final int UNREGISTERED_EXCEPTION_CODE = 202;
    public static final int REGISTERED_SUCCESSFULLY_CODE = 300;
    public static final int REGISTER_CTX_NULL_CODE = 301;
    public static final int REGISTERED_EXCEPTION_CODE = 302;
    private String accessToken = "";
    private TextView txt_result;
    final BroadcastReceiver mDeviceInfoReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.v(TAG, " onReceive DeviceInfoReceiver called");
            StringBuilder outputStr = new StringBuilder();
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                Set<String> keys = bundle.keySet();
                Iterator<String> it = keys.iterator();
                Log.e(TAG, "Dumping Intent start");
                while (it.hasNext()) {
                    String key = it.next();
                    Log.e(TAG, "[" + key + "=" + bundle.get(key) + "]");
                    outputStr.append("mDeviceInfoReceiver key:= ").append(key).append(" val:=").append(bundle.get(key)).append("\n");
                }
                Log.e(TAG, "Dumping Intent end");
            }
            txt_result.setText(outputStr.toString());
        }
    };
    private Button bt_account_manager;
    final Handler infoHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {

            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            switch (msg.what) {
                case AccountManager.TOKEN_VERIFY_FAIL:
                    val = "INVALID TOKEN\n" + val;
                    Toast.makeText(InfoActivity.this, getResources().getString(R.string.invalid_token_msg), Toast.LENGTH_SHORT).show();
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case Info.DEVICE_INFO_CODE:
                    val = "DEVICE INFO : \n" + val;
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    break;
            }
            txt_result.setText(val);
            return false;
        }
    });

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_info);
        txt_result = findViewById(R.id.txt_result);
        bt_account_manager = findViewById(R.id.btAccManagerInfo);
    }

    @Override
    protected void onResume() {
        super.onResume();
        accessToken = AccountManagerActivity.accessToken;
        AccountManager.instance.verifyEloToken(InfoActivity.this, accessToken, infoHandler);
    }

    public void getSDKVersion(View view) {
        txt_result.setText(Info.instance.getSDKVersion(getApplicationContext()));
    }

    public void isSDKVersionSupported(View view) {
        if (Info.instance.isSDKSupported(getApplicationContext())) {
            txt_result.setText(String.format(getResources().getString(R.string.info_sdk_supported), "TRUE"));
        } else {
            txt_result.setText(String.format(getResources().getString(R.string.info_sdk_supported), "FALSE"));
        }
    }

    public void getDeviceInfo(View view) {
        Info.instance.getDeviceInfo(getApplicationContext(), accessToken, infoHandler);
    }

    public void registerDeviceInfoReceiver(View view) {
        boolean stdAndroid = Util.readSystemProperty("persist.sys.stdandroid").equals("true");
        if (stdAndroid) {
            txt_result.setText("This feature is only applicable for Control and Core Mode.");
            Log.i(TAG, "This feature is only applicable for Control and Core Mode.");
            return;
        }
        int results = Info.instance.registerDeviceInfoReceiver(InfoActivity.this, mDeviceInfoReceiver);
        if (results == REGISTERED_SUCCESSFULLY_CODE) {
            txt_result.setText("Device Info Receiver registered successfully.");
        } else if (results == REGISTER_CTX_NULL_CODE) {
            txt_result.setText("Failed to register Device Info Manager.");
        } else if (results == REGISTERED_EXCEPTION_CODE) {
            txt_result.setText("Failed to register Device info Manager.");
        } else {
            txt_result.setText("Failed to register Device info Manager.");
        }
        Log.d(TAG, "registerDeviceInfoReceiver: " + results);
    }

    public void unregisterDeviceInfoReceiver(View view) {
        boolean stdAndroid = Util.readSystemProperty("persist.sys.stdandroid").equals("true");
        if (stdAndroid) {
            txt_result.setText(" This feature is only applicable for Control and Core Mode.");
            Log.i(TAG, " This feature is only applicable for Control and Core Mode.");
            return;
        }
        int result = Info.instance.unregisterDeviceInfoReceiver(InfoActivity.this, mDeviceInfoReceiver);
        Log.d(TAG, "unregisterDeviceInfoReceiver: " + result);
        if (result == UNREGISTERED_SUCCESSFULLY_CODE) {
            txt_result.setText("Device Info Receiver unregistered successfully.");
        } else if (result == UNREGISTER_CTX_NULL_CODE) {
            txt_result.setText("Failed to unregister Device info Manager.");
        } else if (result == UNREGISTERED_EXCEPTION_CODE) {
            txt_result.setText("Device Info Receiver is not registered.");
        } else {
            txt_result.setText("Failed to unregister Device info Manager.");
        }
        Log.d(TAG, "unregisterDeviceInfoReceiver: " + result);
    }

    public void returnMainInfo(View view) {
        Intent intent = new Intent(InfoActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
    }

    public void clearOutputInfo(View view) {
        txt_result.setText("");
    }

    public void exitAppInfo(View view) {
        moveTaskToBack(true);
    }

    public void accountManagerInfo(View view) {
        Intent intent = new Intent(InfoActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Info.instance.unregisterDeviceInfoReceiver(InfoActivity.this, mDeviceInfoReceiver);
    }
}
