package com.eloview.homesdk.testapp;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.InputType;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;
import com.eloview.homesdk.eloview.EloView;

public class EloViewActivity extends Activity {
    Button bt_enable_qs_wifi, bt_disable_qs_wifi, bt_enable_qs_bt, bt_disable_qs_bt, bt_android_home;
    private String accessToken = "";
    private TextView txt_result;
    private Button bt_account_manager;
    final Handler eloViewHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {

            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key);
            switch (msg.what) {
                case AccountManager.TOKEN_VERIFY_FAIL:
                    val = "INVALID TOKEN\n" + val;
                    Toast.makeText(EloViewActivity.this, getResources().getString(R.string.invalid_token_msg), Toast.LENGTH_SHORT).show();
                    txt_result.setText(val);
                    bt_account_manager.setBackgroundColor(Color.RED);
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    bt_account_manager.setBackgroundColor(Color.GREEN);
                    if (AccountManagerActivity.emailPass) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_email));
                    } else if (AccountManagerActivity.clientSecret) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth));
                    } else if (AccountManagerActivity.tokenFromApi) {
                        bt_account_manager.setText(getResources().getString(R.string.verified_by_auth_api));
                    }
                    txt_result.setText(val);
                    break;
                case EloView.OFFLINE_PLAY_CONTENT_CODE:
                    txt_result.setText(val);
                case EloView.GET_PLAY_CONTENT:
                    txt_result.setText(val);
                case EloView.GET_PLAY_CONTENT_STATUS:
                    txt_result.setText(val);
                case EloView.GET_DEVICE_ONLINE_STATUS:
                    txt_result.setText(val);
                case EloView.DEVICE_CLOUD_STATUS_CODE:
                case EloView.QS_WIFI_RESPONSE_CODE:
                case EloView.QS_BT_RESPONSE_CODE:
                    txt_result.setText(val);
                    break;
                default:
                    txt_result.setText("Action Not Supported");
            }
            return false;
        }
    });

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_eloview);
        txt_result = findViewById(R.id.txt_result);
        bt_account_manager = findViewById(R.id.btAccManagerEloView);
        bt_enable_qs_wifi = findViewById(R.id.button_enable_qs_wifi);
        bt_disable_qs_wifi = findViewById(R.id.button_disable_qs_wifi);
        bt_enable_qs_bt = findViewById(R.id.button_enable_qs_bt);
        bt_disable_qs_bt = findViewById(R.id.button_disable_qs_bt);
        bt_android_home = findViewById(R.id.button_switch_to_android_home);
        bt_enable_qs_wifi.setOnClickListener(view -> toggleWifi(true));
        bt_disable_qs_wifi.setOnClickListener(view -> toggleWifi(false));
        bt_enable_qs_bt.setOnClickListener(view -> toggleBt(true));
        bt_disable_qs_bt.setOnClickListener(view -> toggleBt(false));
        bt_android_home.setOnClickListener(view -> switchToAndroidHomeMode(true));
    }

    @Override
    protected void onResume() {
        super.onResume();
        accessToken = AccountManagerActivity.accessToken;
        AccountManager.instance.verifyEloToken(EloViewActivity.this, accessToken, eloViewHandler);
    }

    @Override
    protected void onPause() {
        super.onPause();
        EloView.instance.unregisterEloViewAPIListener(EloViewActivity.this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        EloView.instance.unregisterEloViewAPIListener(EloViewActivity.this);
    }

    public void setOfflinePlayContent(View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder(EloViewActivity.this);
        builder.setTitle("Enter package name");
        final EditText input = new EditText(EloViewActivity.this);
        input.setInputType(InputType.TYPE_CLASS_TEXT);
        input.setHint(getResources().getString(R.string.hint_pkg_name));
        builder.setView(input);
        builder.setPositiveButton("OK", (dialog, which) -> {
            String pkgName = input.getText().toString().trim();
            txt_result.setText("");
            EloView.instance.setOfflinePlayContent(getApplicationContext(), accessToken, pkgName, eloViewHandler);
        });
        builder.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
        builder.show();
    }

    public void getOfflinePlayContent(View view) {
        EloView.instance.getPlayContent(getApplicationContext(), accessToken, eloViewHandler);
    }

    public void getOfflinePlayContentStatus(View view) {
        EloView.instance.getPlayContentStatus(getApplicationContext(), accessToken, eloViewHandler);
    }

    public void accountManagerEloView(View view) {
        Intent intent = new Intent(EloViewActivity.this, AccountManagerActivity.class);
        startActivity(intent);
    }

    public void returnMainEloView(View view) {
        Intent intent = new Intent(EloViewActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
    }

    public void clearOutputEloView(View view) {
        txt_result.setText("");
    }

    public void exitAppEloView(View view) {
        moveTaskToBack(true);
    }

    public void getDeviceOnlineStatus(View view) {
        EloView.instance.getDeviceCloudStatus(getApplicationContext(), accessToken, eloViewHandler);
    }

    private void toggleWifi(Boolean value) {
        EloView.instance.toggleWifi(getApplicationContext(), accessToken, eloViewHandler, value);
    }

    private void toggleBt(Boolean value) {
        EloView.instance.toggleBT(getApplicationContext(), accessToken, eloViewHandler, value);
    }

    private void switchToAndroidHomeMode(Boolean value) {
        EloView.instance.switchToAndroidHomeMode(getApplicationContext(), accessToken, eloViewHandler);
    }
}