package com.eloview.homesdk.testapp;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.eloview.homesdk.networkManager.ESTConfig;

public class ESTCertificateActivity extends AppCompatActivity {

    private final int ACTIVITY_RESULT_SUCCESS = 123;
    private EditText etAlias, etEstUrl, etPort, etUsername, etPassword, etCertificatePath;
    private String selectedFilePath = "";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_est_certificate);
        init();
    }

    public void init() {
        etAlias = findViewById(R.id.etAlias);
        etEstUrl = findViewById(R.id.etEstUrl);
        etPort = findViewById(R.id.etPort);
        etUsername = findViewById(R.id.etUsername);
        etPassword = findViewById(R.id.etPassword);
        etCertificatePath = findViewById(R.id.etCertificatePath);
    }

    public void apply(View view) {
        String alias = etAlias.getText().toString();
        String estUrl = etEstUrl.getText().toString();
        String port = etPort.getText().toString();
        String username = etUsername.getText().toString();
        String password = etPassword.getText().toString();

        // if user added path manually
        selectedFilePath = etCertificatePath.getText().toString();

//        ESTConfig estConfig = new ESTConfig("192.168.48.28", "8085", "estuser", "estpwd", "test", "/sdcard/cacert.pem", "");
        ESTConfig estConfig = new ESTConfig();
        estConfig.setAlias(alias);
        estConfig.setUrl(estUrl);
        estConfig.setPort(port);
        estConfig.setEstUsername(username);
        estConfig.setEstPassword(password);
        estConfig.setCertificateFilePath(selectedFilePath);

        Intent intent = new Intent();
        intent.putExtra("est", estConfig);
        setResult(RESULT_OK, intent);
        finish();
    }

    public void cancel(View view) {
        setResult(RESULT_CANCELED);
        finish();
    }

    public void selectFile(View view) {
        Intent intent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        intent.setType("*/*");
        try {
            startActivityForResult(intent, ACTIVITY_RESULT_SUCCESS);
        } catch (android.content.ActivityNotFoundException ex) {
            Toast.makeText(this, "Please install a File Manager.", Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ACTIVITY_RESULT_SUCCESS && resultCode == RESULT_OK) {
            final Uri selectedFile = data.getData();
            try {
                selectedFilePath = FileUtils.getRealPath(getApplicationContext(), selectedFile);
                if (!selectedFilePath.endsWith(".pem")) {
                    selectedFilePath = "";
                    Toast.makeText(this, "Please select valid file (ex. abc.pem)", Toast.LENGTH_SHORT).show();
                }
            } catch (Exception e) {
                e.printStackTrace();
                selectedFilePath = "";
                Toast.makeText(this, "Can not select the file", Toast.LENGTH_SHORT).show();
            }
            etCertificatePath.setText(selectedFilePath);
        }
    }
}
