package com.eloview.homesdk.testapp;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.eloview.homesdk.networkManager.CertificateConfig;
import com.eloview.homesdk.networkManager.CertificateType;

public class CertificateActivity extends AppCompatActivity {

    private static final String TAG = "CertActivity";
    private final int ACTIVITY_RESULT_SUCCESS = 123;
    private EditText etCertName, etPassword, etCertificatePath;
    private RadioButton rbCA;
    private String selectedFilePath = "";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_install_certificate);
        init();
    }

    public void init() {
        rbCA = findViewById(R.id.rbCA);
        etCertName = findViewById(R.id.etCertName);
        etPassword = findViewById(R.id.etPassword);
        etCertificatePath = findViewById(R.id.etCertificatePath);
    }

    public void apply(View view) {
        String certName = etCertName.getText().toString();
        String password = etPassword.getText().toString();

        // if user added path manually
        selectedFilePath = etCertificatePath.getText().toString();
        if (!(selectedFilePath.contains(".pem") || selectedFilePath.contains(".cer") || selectedFilePath.contains(".crt") || selectedFilePath.contains(".key") || selectedFilePath.contains(".p12"))) {
            Intent intent = new Intent();
            intent.putExtra("result", "Invalid certificate format");
            setResult(RESULT_OK, intent);
            finish();
        }

        CertificateType certificateType;
        if (rbCA.isChecked()) {
            certificateType = CertificateType.CA_CERTIFICATE;
        } else {
            certificateType = CertificateType.USER_CERTIFICATE;
        }

        CertificateConfig certificateConfig = new CertificateConfig(selectedFilePath, certName, certificateType);

        if (!password.isEmpty()) {
            certificateConfig.setUserCertPwd(password);
        }

        Intent intent = new Intent();
        intent.putExtra("certificate", certificateConfig);
        setResult(RESULT_OK, intent);
        finish();
    }

    public void cancel(View view) {
        setResult(RESULT_CANCELED);
        finish();
    }

    public void selectFile(View view) {
        Intent intent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        intent.setType("*/*");
        try {
            startActivityForResult(intent, ACTIVITY_RESULT_SUCCESS);
        } catch (android.content.ActivityNotFoundException ex) {
            Toast.makeText(this, "Please install a File Manager.", Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.d(TAG, "requestCode: " + requestCode + "resulCode: " + resultCode);
        if (requestCode == ACTIVITY_RESULT_SUCCESS && resultCode == RESULT_OK) {
            final Uri selectedFile = data.getData();
            selectedFilePath = FileUtils.getRealPath(getApplicationContext(), selectedFile);
            etCertificatePath.setText(selectedFilePath);
        }
    }
}
