package com.eloview.homesdk.testapp;

import static com.eloview.homesdk.testapp.Util.hideKeyboard;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.method.ScrollingMovementMethod;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eloview.homesdk.accountManager.AccountManager;

import java.util.Properties;

public class AccountManagerActivity extends Activity {

    public static String accessToken = "";
    public static boolean emailPass = false, clientSecret = false, verifyFromFile = false, tokenFromApi = false;
    private final String TAG = AccountManagerActivity.class.getSimpleName();
    //OauthHandler to get the auth configure status
    final Handler oAuthHandler = new Handler(msg -> {
        Bundle b = msg.getData();
        String key = Integer.toString(msg.what);
        String val = b.getString(key, "");
        Log.d(TAG, "handleMessage: " + val);
        switch (msg.what) {
            case AccountManager.SETUP_OAUTH_SUCCESS:
                findViewById(R.id.btnGetToken).setEnabled(true);
                findViewById(R.id.btnGetToken).setClickable(true);
                findViewById(R.id.btnLogout).setVisibility(View.VISIBLE);
                Log.d(TAG, "handleMessage: SETUP_OAUTH_SUCCESS" + val);
                break;

            case AccountManager.SETUP_OAUTH_ERROR:
                findViewById(R.id.btnLogout).setVisibility(View.GONE);
                findViewById(R.id.btnGetToken).setEnabled(true);
                findViewById(R.id.btnGetToken).setClickable(true);
                Log.d(TAG, "handleMessage: SETUP_OAUTH_ERROR" + val);
                break;
        }
        return true;
    });
    public String isResealed;
    private TextView txt_result;
    private EditText etEmail, etPassword, etClientId, etSecretKey;
    private boolean isPolaris = false;
    private Spinner spinner_env;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_accountmanager);
        txt_result = findViewById(R.id.txt_result);
        etEmail = findViewById(R.id.etEmail);
        etPassword = findViewById(R.id.etPassword);
        etClientId = findViewById(R.id.etClientId);
        etSecretKey = findViewById(R.id.etSecretKey);
        spinner_env = findViewById(R.id.spinner_env);
        txt_result.setMovementMethod(new ScrollingMovementMethod());
        // if is polaris true then only we need to configure auth manager here
        // only for polaris env.
        String env = AccountManager.instance.getEnvironment(getApplicationContext());
        adjustLayout();
        if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            isResealed = Settings.Secure.getString(getApplicationContext().getContentResolver(), "elo_is_reseal");
            if (isResealed != null && isResealed.equalsIgnoreCase("true")) {
                AccountManager.instance.selectEnvironment(AccountManagerActivity.this, "", true);
                isPolaris = AccountManager.instance.isPolaris(this);
                Log.d("isPolaris", String.valueOf(isPolaris));
                if (isPolaris) {
                    AccountManager.instance.configureOAuthHostedUI(this, oAuthHandler);
                }
                adjustLayout();
            } else {
                String prop = AccountManager.getProperty();
                String[] list = getResources().getStringArray(R.array.environments);
                ArrayAdapter<String> adapter = new ArrayAdapter<>(this, R.layout.spinner_item, list);
                spinner_env.setAdapter(adapter);
                switch (prop) {
                    case "sdk_qa.properties":
                        spinner_env.setSelection(1);
                        break;
                    case "sdk_sfp.properties":
                        spinner_env.setSelection(2);
                        break;
                    case "sdk_polaris_elodev.properties":
                        spinner_env.setSelection(3);
                        break;
                    case "sdk_polaris_stg.properties":
                        spinner_env.setSelection(4);
                        break;
                    case "sdk_polaris_production.properties":
                        spinner_env.setSelection(5);
                        break;
                    case "sdk_polaris_qa.properties":
                        spinner_env.setSelection(6);
                        break;
                    default:
                        spinner_env.setSelection(0);
                        break;
                }

            }
        } else {
            spinner_env.setVisibility(View.GONE);
            AccountManager.instance.selectEnvironment(AccountManagerActivity.this, env, false);
        }

        spinner_env.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                String selectedItem = spinner_env.getSelectedItem().toString();
                Toast.makeText(AccountManagerActivity.this, selectedItem + " Selected", Toast.LENGTH_LONG).show();
                Log.d(TAG, selectedItem + " selected.");
                String prop;
                switch (selectedItem) {
                    case "qa":
                        prop = "sdk_qa.properties";
                        break;
                    case "sfp":
                        prop = "sdk_sfp.properties";
                        break;
                    case "polaris_elo_dev":
                        prop = "sdk_polaris_elodev.properties";
                        break;
                    case "polaris_staging":
                        prop = "sdk_polaris_stg.properties";
                        break;
                    case "polaris_production":
                        prop = "sdk_polaris_production.properties";
                        break;
                    case "polaris_qa":
                        prop = "sdk_polaris_qa.properties";
                        break;
                    default:
                        prop = "sdk.properties";
                }
                if (!prop.equals(AccountManager.getProperty())) {
                    accessToken = "";
                }
                if (selectedItem.contains("polaris")) {
                    isPolaris = true;
                    AccountManager.instance.selectEnvironment(AccountManagerActivity.this, prop, false);
                    adjustLayout();
                    Toast.makeText(AccountManagerActivity.this, R.string.configurin_env, Toast.LENGTH_SHORT).show();
                    AccountManager.instance.configureOAuthHostedUI(AccountManagerActivity.this, oAuthHandler);
                } else {
                    isPolaris = false;
                    adjustLayout();
                    AccountManager.instance.selectEnvironment(AccountManagerActivity.this, prop, false);
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
    }

    //always call adjust layout before configureOAuthHostedUI and selectEnvironment
    private void adjustLayout() {
        if (isPolaris) {
            etEmail.setEnabled(false);
            etPassword.setEnabled(false);
            etEmail.setVisibility(View.GONE);
            etPassword.setVisibility(View.GONE);

            findViewById(R.id.btnLogout).setVisibility(View.GONE);
            findViewById(R.id.btnGetToken).setEnabled(false);
            findViewById(R.id.btnGetToken).setClickable(false);
            findViewById(R.id.tvNote).setVisibility(View.VISIBLE);
        } else {
            etEmail.setEnabled(true);
            etPassword.setEnabled(true);
            etEmail.setVisibility(View.VISIBLE);
            etPassword.setVisibility(View.VISIBLE);

            findViewById(R.id.btnLogout).setVisibility(View.GONE);
            findViewById(R.id.btnGetToken).setEnabled(true);
            findViewById(R.id.btnGetToken).setClickable(true);
            findViewById(R.id.tvNote).setVisibility(View.GONE);
        }
        if (isResealed != null && isResealed.equalsIgnoreCase("true")) {
            findViewById(R.id.tvNote).setVisibility(View.GONE);
            spinner_env.setVisibility(View.GONE);
        }
    }

    public void logoutAccount(View view) {
        AccountManager.instance.logoutOAuth();
    }

    public void getAccessTokenEdtTxt(View view) {
        hideKeyboard(this);
        AccountManager.instance.getEloAccessToken(getApplicationContext(),
                etEmail.getText().toString(), etPassword.getText().toString(), accessTokenHandler);
    }

    public void verifyOAuthTokenEdtTxt(View view) {
        AccountManager.instance.getEloOAuthToken(getApplicationContext(),
                etClientId.getText().toString(), etSecretKey.getText().toString(), accessTokenHandler);
    }

    public void verifyTokenFile(View view) {
        verifyFromFile = true;
        Properties credentials = new Properties();
        try {
            credentials.load(getApplicationContext().getAssets().open("com.eloview.homesdk.testapp_jwt.prop"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        accessToken = credentials.getProperty("jwt");
        emailPass = false;
        clientSecret = false;
        tokenFromApi = false;
        AccountManager.instance.verifyEloToken(getApplicationContext(), accessToken, accessTokenHandler);
    }

    public void verifyTokenEdtTxt(View view) {
        hideKeyboard(this);
        AccountManager.instance.verifyEloToken(getApplicationContext(),
                accessToken, accessTokenHandler);
    }

    public void exitAppAccount(View view) {
        moveTaskToBack(true);
    }

    public void clearOutputAccManager(View view) {
        txt_result.setText("");
    }

    public void returnMainAccount(View view) {
        Intent intent = new Intent(AccountManagerActivity.this, MainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        startActivity(intent);
    }

    @Override
    protected void onStop() {
        super.onStop();
        //To stop the auth executor
        if (isPolaris)
            AccountManager.instance.stopOAuth();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        //To destroy the auth services
        if (isPolaris)
            AccountManager.instance.destroyOAuth();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == AccountManager.REQUEST_AUTH_LOGIN) {
            if (resultCode == Activity.RESULT_OK) {
                AccountManager.instance.onOAuthActivityResult(getApplicationContext(), data, accessTokenHandler);
            }
        } else if (requestCode == AccountManager.REQUEST_AUTH_LOGOUT) {
            //for logout the auth manager
            if (resultCode == Activity.RESULT_OK) {
                accessToken = "";
                emailPass = false;
                tokenFromApi = false;
                clientSecret = false;
                txt_result.setText("Logout successful!");
            }
        }
    }

    final Handler accessTokenHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(@NonNull Message msg) {
            Bundle b = msg.getData();
            String key = Integer.toString(msg.what);
            String val = b.getString(key, "");
            Log.d(TAG, "handleMessage: " + val);
            switch (msg.what) {
                case AccountManager.ACCESS_TOKEN_VALID:
                    accessToken = val;
                    emailPass = true;
                    clientSecret = false;
                    tokenFromApi = false;
                    Log.d(TAG, "handleMessage: accessToken >> " + accessToken);
                    if (verifyFromFile) {
                        verifyFromFile = false;
                        AccountManager.instance.verifyEloToken(getApplicationContext(), accessToken, accessTokenHandler);
                    } else {
                        txt_result.setText(val);
                    }
                    break;
                case AccountManager.TOKEN_VERIFY_FAIL:
                    Log.d(TAG, "handleMessage: Invalid Token");
                    val = "INVALID TOKEN\n" + val;
                    txt_result.setText(val);
                    break;
                case AccountManager.ACCESS_TOKEN_INVALID:
                    Log.d(TAG, "handleMessage: Failed to get aN access accessToken");
                    txt_result.setText(val);
                    break;
                case AccountManager.TOKEN_VERIFY_SUCCESS:
                    Log.d(TAG, "handleMessage: accessToken >> " + val);
                    SystemActivity.isTokenVerified = true;
                    txt_result.setText(val);
                    break;
                case AccountManager.OAUTH_TOKEN_VALID:
                    clientSecret = true;
                    emailPass = false;
                    tokenFromApi = false;
                    Log.d(TAG, "handleMessage: oAuthToken >> " + val);
                    accessToken = val;
                    AccountManager.instance.verifyEloToken(getApplicationContext(), accessToken, accessTokenHandler);
                    break;
                case AccountManager.OAUTH_TOKEN_INVALID:
                    Log.d(TAG, "handleMessage: Failed to get an oAuth accessToken");
                    txt_result.setText(val);
                    break;
                case AccountManager.API_ACCESS_TOKEN_VALID:
                    clientSecret = false;
                    emailPass = false;
                    tokenFromApi = true;
                    Log.d(TAG, "handleMessage: ApiAccessToken >> " + val);
                    txt_result.setText(val);
                    accessToken = val;
                    AccountManager.instance.verifyEloToken(getApplicationContext(), accessToken, accessTokenHandler);
                    break;
                case AccountManager.API_ACCESS_TOKEN_INVALID:
                    Log.d(TAG, "handleMessage: Failed to get ApiAccessToken");
                    break;
                case AccountManager.GENERIC_ERROR:
                    txt_result.setText(val);
                    break;
            }
            return true;
        }
    });


}
