package com.example.eloViewSDKTestApp;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.eloview.sdk.EloSecureUtil;

public class OtaActivity extends Activity {

	private static final String LOG_TAG = "OtaActivity";
	private static final int EXTERNAL_STORAGE_PERMISSION_CONSTANT = 100;
	private Button downloadOTA, verifyOTA, returnMain, checkOTA, applyOTA,
			clearOutPut;
	private EditText edt_checkStatusUrl, edt_downloadOtaUrl;
	private static TextView txt_result;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_ota);
		if(Build.VERSION.SDK_INT>23) {
			if (checkSelfPermission(android.Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED) {
				Log.v(LOG_TAG, "Permission is granted");

			} else {
				Log.v(LOG_TAG, "request Permissions");
				ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, EXTERNAL_STORAGE_PERMISSION_CONSTANT);
			}
		}
		checkOTA = (Button) findViewById(R.id.button_check_ota);
		applyOTA = (Button) findViewById(R.id.button_apply_ota);
		downloadOTA = (Button) findViewById(R.id.button_download_ota);
		verifyOTA = (Button) findViewById(R.id.button_verify_ota);
		returnMain = (Button) findViewById(R.id.button_return_main);
		edt_checkStatusUrl = (EditText) findViewById(R.id.edt_checkStatusUrl);
		edt_downloadOtaUrl = (EditText) findViewById(R.id.edt_downloadOtaUrl);
		clearOutPut = (Button) findViewById(R.id.clearOutPut);
		txt_result = (TextView) findViewById(R.id.txt_result);

		clearOutPut.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				txt_result.setText("");
			}
		});

		checkOTA.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				hideKeyboard(OtaActivity.this);
				txt_result.setText("");
				String statusUrl = getStatusUrl();
				if (!statusUrl.isEmpty()) {
					EloSecureUtil.checkOTAStatus(OtaActivity.this, statusUrl, handler);
				} else {
					Toast.makeText(getApplicationContext(), "Please fill the OTA status details.", Toast.LENGTH_LONG).show();
				}
			}
		});

		downloadOTA.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				hideKeyboard(OtaActivity.this);
				txt_result.setText("");
				String downloadUrl = getDownloadUrl();
				if (!downloadUrl.isEmpty()) {
					if(downloadUrl.startsWith("file:///")){
						EloSecureUtil.startDownloadUpgradePackage(OtaActivity.this, downloadUrl, handler);
					}else if(Patterns.WEB_URL.matcher(downloadUrl).matches()) {
						EloSecureUtil.startDownloadUpgradePackage(OtaActivity.this, downloadUrl, handler);
					}else {
						Toast.makeText(getApplicationContext(), "Please enter valid OTA download url", Toast.LENGTH_LONG).show();
					}
				} else {
					Toast.makeText(getApplicationContext(), "Please fill the download OTA details", Toast.LENGTH_LONG).show();
				}
			}
		});

		verifyOTA.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				hideKeyboard(OtaActivity.this);
				txt_result.setText("");
				EloSecureUtil.verifyOTA(OtaActivity.this, handler);
			}
		});

		applyOTA.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				hideKeyboard(OtaActivity.this);
				txt_result.setText("");
				EloSecureUtil.applyOTA(OtaActivity.this, handler);
			}
		});

		returnMain.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});


	}

	@Override
	public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
		super.onRequestPermissionsResult(requestCode, permissions, grantResults);
		Log.v(LOG_TAG,"in side  onRequestPermissionsResult");

		if (requestCode == EXTERNAL_STORAGE_PERMISSION_CONSTANT) {
			if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
				Log.v(LOG_TAG,"Storage permissions granted");
			}else {
				Log.v(LOG_TAG,"Permissions decline so close activity");
				finish();
			}
		}
	}

	private void hideKeyboard(Context mContext) {
		InputMethodManager imm = (InputMethodManager) mContext
				.getSystemService(Context.INPUT_METHOD_SERVICE);
		imm.hideSoftInputFromWindow(((Activity) mContext).getWindow()
				.getCurrentFocus().getWindowToken(), 0);
	}

	public static Handler handler = new Handler() {
		public void handleMessage(Message msg) {
			super.handleMessage(msg);
			Bundle b = msg.getData();
			String key = Integer.toString(msg.what);
			String val = b.getString(key);
			switch (msg.what) {
				case EloSecureUtil.OTA_DOWNLOAD_REMOTE_FILE_PERCENTAGE:
					Log.i(LOG_TAG, "Remote file download percentage := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_PERCENTAGE \n\n Percentage : "  + val);
					break;
				case EloSecureUtil.OTA_DOWNLOAD_REMOTE_FILE_SUCCESS:
					Log.i(LOG_TAG, "Remote file download success := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_SUCCESS \n\n Info : " + val);
					break;
				case EloSecureUtil.OTA_DOWNLOAD_REMOTE_FILE_ERROR:
					Log.i(LOG_TAG, "Remote file download error := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_REMOTE_FILE_ERROR \n\n Error : " + val);
					break;
				case EloSecureUtil.OTA_DOWNLOAD_LOCAL_FILE_PERCENTAGE:
					Log.i(LOG_TAG, "Local file download percentage := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_LOCAL_FILE_PERCENTAGE \n\n Percentage : " + val);
					break;
				case EloSecureUtil.OTA_DOWNLOAD_LOCAL_FILE_SUCCESS:
					Log.i(LOG_TAG, "Local file download success := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_LOCAL_FILE_SUCCESS \n\n Info : " + val);
					break;
				case EloSecureUtil.OTA_DOWNLOAD_LOCAL_FILE_ERROR:
					Log.i(LOG_TAG, "Local file download error := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_LOCAL_FILE_ERROR \n\n Error : " + val);
					break;
				case EloSecureUtil.OTA_DOWNLOAD_GENERIC_ERROR:
					Log.i(LOG_TAG, "Download error := " + val);
					txt_result.setText("Code : OTA_DOWNLOAD_GENERIC_ERROR \n\n Error : " + val);
					break;
				case EloSecureUtil.OTA_VERIFY_SIGN_PERCENTAGE:
					Log.i(LOG_TAG, "Verify sign percentage := " + val);
					txt_result.setText("Code : OTA_VERIFY_SIGN_PERCENTAGE \n\n Percentage : " + val);
					break;
				case EloSecureUtil.OTA_VERIFY_SIGN_SUCCESS:
					Log.i(LOG_TAG, "Verify sign success := " + val);
					txt_result.setText("Code : OTA_VERIFY_SIGN_SUCCESS \n\n Info : " + val);
					break;
				case EloSecureUtil.OTA_VERIFY_SIGN_ERROR:
					Log.i(LOG_TAG, "Verify sign error := " + val);
					txt_result.setText("Code : OTA_VERIFY_SIGN_ERROR \n\n Error : " + val);
					break;
				case EloSecureUtil.OTA_VERIFY_FILE_ERROR:
					Log.i(LOG_TAG, "Verify file error := " + val);
					txt_result.setText("Code : OTA_VERIFY_FILE_ERROR \n\n Error : " + val);
					break;
				case EloSecureUtil.OTA_CHECK_STATUS_OLD:
					Log.i(LOG_TAG, "OTA check : Version is old := " + val);
					txt_result.setText("Code : OTA_CHECK_STATUS_OLD \n\n Status : " + val);
					break;
				case EloSecureUtil.OTA_CHECK_STATUS_NEW:
					Log.i(LOG_TAG, "OTA Check : Version is new := " + val);
					txt_result.setText("Code : OTA_CHECK_STATUS_NEW \n\n Status : " + val);
					break;
				case EloSecureUtil.OTA_CHECK_STATUS_SAME:
					Log.i(LOG_TAG, "OTA Check : Version is same  := " + val);
					txt_result.setText("Code : OTA_CHECK_STATUS_SAME \n\n Status : " + val);
					break;
				case EloSecureUtil.OTA_CHECK_STATUS_GENERIC_ERROR:
					Log.i(LOG_TAG, "OTA Check : Status error  := " + val);
					txt_result.setText("Code : OTA_CHECK_STATUS_GENERIC_ERROR \n\n Status : " + val);
					break;
				case EloSecureUtil.OTA_APPLY_FILE_ERROR:
					Log.i(LOG_TAG, "OTA apply file error := " + val);
					txt_result.setText("Code : OTA_APPLY_FILE_ERROR \n\n Status : " + val);
					break;
				case EloSecureUtil.OTA_APPLY_IN_PROGRESS:
					Log.i(LOG_TAG, "OTA apply file progress := " + val);
					txt_result.setText("Code : OTA_APPLY_IN_PROGRESS \n\n Status : " + val);
					break;
			}
		}
	};

	public String getStatusUrl() {
		return edt_checkStatusUrl.getText().toString().trim();
	}

	public String getDownloadUrl() {
		return edt_downloadOtaUrl.getText().toString().trim();
	}
}