package com.example.eloViewSDKTestApp;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import com.eloview.sdk.EloSecureUtil;

/**
 * Created by elo on 6/19/18.
 */
public class OrientationActivity extends Activity {

    private static final String LOG_TAG = "OrientationActivity";
    private TextView txt_result;
    private Context mContext;
    private StringBuilder outputStr = new StringBuilder();
    private Button returnMain, clearOutPut;
    private Button getOrientation, setOrientation;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_orientation);
        mContext = OrientationActivity.this;
        init();
    }

    private void init() {
        returnMain = (Button) findViewById(R.id.button_return_main);
        clearOutPut = (Button) findViewById(R.id.clearOutPut);
        getOrientation = (Button) findViewById(R.id.button_get_orientation);
        setOrientation = (Button) findViewById(R.id.button_set_orientation);
        txt_result = (TextView) findViewById(R.id.txt_result);
        clearOutPut.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                txt_result.setText("");
                outputStr.setLength(0);
            }
        });
        returnMain.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        getOrientation.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String orientationType = EloSecureUtil.getOrientation(mContext);
                txt_result.setText("getOrientation Orientation Type:= " + orientationType);
            }
        });
        setOrientation.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Get RadioGroup by id.
                RadioGroup radiogroup = (RadioGroup) findViewById(R.id.radiogroup_orientation);
                // Get user selected radio button id.
                int checkedRadioBtnId = radiogroup.getCheckedRadioButtonId();
                // Get user selected RadioButton object by id.
                RadioButton radioButton = (RadioButton) findViewById(checkedRadioBtnId);
                // Get the RadioButton text.
                String selectText = (String) radioButton.getText();

                Boolean ret = EloSecureUtil.setOrientation(mContext,selectText);
                txt_result.setText("setOrientation ret:= " + ret + " Orientation Type:= " + selectText );
            }
        });
    }
}
