package com.example.eloViewSDKTestApp;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Toast;

import com.eloview.sdk.EloSecureUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class MainActivity extends AppCompatActivity {

	public static final String SET_DEVICE_BRIGHTNESS = "com.elotouch.ic.athens.SET_BRIGHTNESS";
	public static final String GET_DEVICE_BRIGHTNESS = "com.elotouch.ic.athens.GET_BRIGHTNESS";
	private static final String SET_LOCALE = "android.intent.action.SET_LOCALE";
	private static final String GET_LOCALE = "android.intent.action.GET_LOCALE";
	public static final String SET_DEVICE_VOLUME = "com.elotouch.ic.athens.SET_VOLUME";
	public static final String GET_DEVICE_VOLUME = "com.elotouch.ic.athens.GET_VOLUME";
	public static final String GET_DEVICE_SERIAL_NUMBER = "com.elotouch.ic.athens.SERIAL_NUMBER";
	public static final String GET_DEVICE_ADDRESS = "com.elotouch.ic.athens.ADDRESS";
	public static final String SET_DEVICE_DISPLAY_ON = "com.elotouch.ic.athens.SET_DISPLAY_ON";
	public static final String SET_DEVICE_DISPLAY_OFF = "com.elotouch.ic.athens.SET_DISPLAY_OFF";
	public static final String ELO_DOWNLOADED_FOLDER = "/sdcard/elo/downloaded_content/";
	private static final String ELO_SCREEN_CAP_FOLDER = "/sdcard/elo/screenshot/ic-screenshot.png";
	EditText brightness, volume, SerialNumber, address , locale;
	Button setBrightness, getBrightness, setVolume, getVolume, getSerialNumber;
	Button setLocale, getLocale;
	Button getAddress, displayOn, displayOff, reboot, tstPkgInstall, apkUninstall,
			screenshot, sdkVersion, sdkAvailable,  verifyOTA, verifyHeapSize, verifyDeviceInfo,
			verifyDevicePortStatus, verifyOrientation;

	public static final Handler handler = new Handler();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		brightness = (EditText) findViewById(R.id.brightness_editText);
		volume = (EditText) findViewById(R.id.volume_editText);
		locale = (EditText) findViewById(R.id.locale_editText);
		SerialNumber = (EditText) findViewById(R.id.serial_number_editText);
		address = (EditText) findViewById(R.id.address_editText);
		setBrightness = (Button) findViewById(R.id.set_brightness);
		getBrightness = (Button) findViewById(R.id.get_brightness);
		setVolume = (Button) findViewById(R.id.set_Volume);
		getVolume = (Button) findViewById(R.id.get_Volume);
		setLocale = (Button) findViewById(R.id.set_locale);
		getLocale = (Button) findViewById(R.id.get_locale);
		getSerialNumber = (Button) findViewById(R.id.get_Serial_Number);
		getAddress = (Button) findViewById(R.id.get_address);
		displayOn = (Button) findViewById(R.id.display_on);
		displayOff = (Button) findViewById(R.id.display_off);
		reboot = (Button) findViewById(R.id.reboot);
		tstPkgInstall = (Button) findViewById(R.id.tst_pkg_install);
		screenshot = (Button) findViewById(R.id.screenshot_button);
		sdkVersion = (Button) findViewById(R.id.sdk_version);
		sdkAvailable = (Button) findViewById(R.id.sdk_available);
		verifyOTA = (Button) findViewById(R.id.verify_ota_api);
		verifyHeapSize = (Button) findViewById(R.id.verify_heap_size_api);
		verifyDeviceInfo = (Button) findViewById(R.id.verify_device_info_api);
		verifyDevicePortStatus = (Button) findViewById(R.id.verify_device_port_status_api);
		verifyOrientation = (Button) findViewById(R.id.verify_orientation);

		final String uri = ELO_DOWNLOADED_FOLDER + "EloviewDemoApp.apk";
		File f = new File(uri);
		if (!f.exists()) {
			AssetManager assetManager = MainActivity.this.getAssets();
			InputStream in = null;
			OutputStream out = null;
			try {
				in = assetManager.open("EloviewDemoApp.apk");
				out = new FileOutputStream(uri);
				byte[] buffer = new byte[1024];
				int read;
				while ((read = in.read(buffer)) != -1) {
					out.write(buffer, 0, read);

				}
				in.close();
				in = null;
				out.flush();
				out.close();
				out = null;
			} catch (IOException e) {
				Log.e("Eloview_Demo_App",
						"Error in copying EloviewDemoApp apk " + e);
			}
		}

		setBrightness.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {

				if (brightness.length() != 0) {
					int brightnessValue = Integer.parseInt(brightness.getText().toString().trim());
					if(brightnessValue<=100){
						EloSecureUtil.setBrightness(getApplicationContext(),brightnessValue);
						brightness.setText("");
					}else{
						Toast.makeText(getApplicationContext(), "Please enter valid range", Toast.LENGTH_SHORT).show();
					}

				}
			}
		});

		getBrightness.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				int brightnessValue = EloSecureUtil.getBrightness(getApplicationContext());
				brightness.setText("" + brightnessValue);
				brightness.setSelection(brightness.getText().length());
			}
		});

		setVolume.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				if (volume.length() != 0) {
					int volumeValue = Integer.parseInt(volume.getText().toString().trim());
					if(volumeValue<=100){
						EloSecureUtil.setVolume(getApplicationContext(),volumeValue);
						volume.setText("");
					}else{
						Toast.makeText(getApplicationContext(), "Please enter valid range", Toast.LENGTH_SHORT).show();
					}

				}
			}
		});

		getVolume.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				int volumeValue = EloSecureUtil
						.getVolume(getApplicationContext());
				volume.setText("" + volumeValue);
				volume.setSelection(volume.getText().length());
			}
		});

		setLocale.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				EloSecureUtil.setLocale(getApplicationContext(), locale.getText().toString());
			}
		});

		final BroadcastReceiver mGetLocale = new BroadcastReceiver() {
			public void onReceive(android.content.Context context, Intent intent) {
				String localeValue = getResultData();
				Log.i("MainActivity", "Locale Value : " + localeValue);
				locale.setText(localeValue);
			};
		};

		getLocale.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				EloSecureUtil.getLocale(getApplicationContext(), mGetLocale);
			}
		});

		final BroadcastReceiver mGetSerialNumber = new BroadcastReceiver() {
			public void onReceive(android.content.Context context, Intent intent) {
				Bundle b = getResultExtras(true);
				String serialNumberValue = b.getString("SERIAL_NUMBER", "");
				Log.i("MainActivity", "Serial Number Value : "
						+ serialNumberValue);
				SerialNumber.setText(serialNumberValue);
			};
		};
		getSerialNumber.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				EloSecureUtil.getSerialNumber(getApplicationContext(),
						mGetSerialNumber);
			}
		});
		final BroadcastReceiver mAddress = new BroadcastReceiver() {
			public void onReceive(android.content.Context context, Intent intent) {

				Bundle b = getResultExtras(true);
				String addressValue = b.getString("ADDRESS", "");
				Log.i("MainActivity", "ADDRESS Value : " + addressValue);
				if (addressValue.length() != 0) {
					address.setText(addressValue);
				} else {
					address.setText("No address is set to device");
				}
			};
		};
		getAddress.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				EloSecureUtil.getAddress(getApplicationContext(), mAddress);

			}
		});
		displayOff.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				EloSecureUtil.screenTurnOff(getApplicationContext(), 0);
			}
		});
		displayOn.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				EloSecureUtil.screenTurnOn(getApplicationContext(), 0);
			}
		});
		reboot.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				EloSecureUtil.silentReboot(getApplicationContext());

			}
		});

		sdkVersion.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				sdkVersion.setText("Version " + EloSecureUtil.getSDKVersion());
			}
		});

		sdkAvailable.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Boolean res = EloSecureUtil
						.isEloViewSDKExists(getApplicationContext());
				sdkAvailable.setText(res ? "SDK Available" : "SDK Not Available");
			}
		});

		verifyOTA.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, OtaActivity.class);
				MainActivity.this.startActivity(intent);
			}
		});

		tstPkgInstall.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, EloViewInstallActivity.class);
				MainActivity.this.startActivity(intent);
			}
		});

		verifyHeapSize.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, HeapSizeActivity.class);
				MainActivity.this.startActivity(intent);
			}
		});

		verifyDeviceInfo.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, DeviceInfoActivity.class);
				MainActivity.this.startActivity(intent);
			}
		});

		verifyDevicePortStatus.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, DevicePortStatusActivity.class);
				MainActivity.this.startActivity(intent);
			}
		});

		verifyOrientation.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MainActivity.this, OrientationActivity.class);
				MainActivity.this.startActivity(intent);
			}
		});

		final BroadcastReceiver mScreenshotReceiver = new BroadcastReceiver() {

			@Override
			public void onReceive(Context context, Intent intent) {
				Log.e("eloViewSDKTestApp",
						"Screenshot receive at BroadcastReceiver");
				screenshotDialog(MainActivity.this);

			}
		};

		screenshot.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				hideKeyboard(MainActivity.this);
				EloSecureUtil.captureScreenShot(getApplicationContext(),
						mScreenshotReceiver);
			}
		});
	}

	private boolean isDeviceParis() {
		String match = "PayPoint";
		String model =  Build.MODEL;

		if (model.toLowerCase().contains(match.toLowerCase())) {
			return true;
		}

		return false;
	}

	private void hideKeyboard(Context mContext) {
		InputMethodManager imm = (InputMethodManager) mContext
				.getSystemService(Context.INPUT_METHOD_SERVICE);
		imm.hideSoftInputFromWindow(((Activity) mContext).getWindow()
				.getCurrentFocus().getWindowToken(), 0);
	}

	ImageView screenshotImage;

	void screenshotDialog(Context ctx) {

		final Dialog dialog = new Dialog(ctx, R.style.CustomTheme);
		dialog.getWindow();
		dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
		dialog.setContentView(R.layout.dialog_image_view);
		dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
		dialog.getWindow().setSoftInputMode(
				WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
		dialog.getWindow().setDimAmount(0.3f);
		screenshotImage = (ImageView) dialog
				.findViewById(R.id.image_screenshot);
		if(!isDeviceParis()){
			File file = new File(ELO_SCREEN_CAP_FOLDER);
			if (file.exists()) {
				Bitmap bmpExternal = BitmapFactory
						.decodeFile(ELO_SCREEN_CAP_FOLDER);
				screenshotImage.setImageBitmap(bmpExternal);
			}
		}else{
			View v1 = getWindow().getDecorView().getRootView();
			v1.setDrawingCacheEnabled(true);
			Bitmap bitmap = Bitmap.createBitmap(v1.getDrawingCache());
			v1.setDrawingCacheEnabled(false);
			screenshotImage.setImageBitmap(bitmap);
		}

		screenshotImage.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				dialog.dismiss();

			}
		});
		dialog.show();

		handler.postDelayed(new Runnable() {
			@Override
			public void run() {
				dialog.dismiss();
			}
		}, 4000L);
	}

	public static boolean isCurrentActivity(Context ctx,
																					String classQualifiedName) {
		ActivityManager mngr = (ActivityManager) ctx
				.getSystemService(ACTIVITY_SERVICE);
		List<ActivityManager.RunningTaskInfo> taskList = mngr
				.getRunningTasks(10);
		if (taskList != null && taskList.size() > 0) {
			if (taskList.get(0).topActivity.getClassName().equals(
					classQualifiedName)) {
				return true;
			}
		}
		return false;
	}
}
