package com.example.eloViewSDKTestApp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.eloview.sdk.EloSecureUtil;

public class HeapSizeActivity extends Activity {

	private static final String LOG_TAG = "HeapSizeActivity";
	private Button btn_setHeapGrowthLimit, btn_setHeapSize, btn_getHeapGrowthLimit, btn_getHeapSize , btn_returnMain , btn_clearOutPut;
	private EditText edt_heapSizeGrowthLimit, edt_heapSize;
	private static TextView txt_result;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_heapsize);
		btn_setHeapGrowthLimit = (Button) findViewById(R.id.button_set_heap_growth_limit);
		btn_setHeapSize = (Button) findViewById(R.id.button_set_heap_size);
		btn_getHeapGrowthLimit = (Button) findViewById(R.id.button_get_heap_growth_limit);
		btn_getHeapSize = (Button) findViewById(R.id.button_get_heap_size);
		btn_returnMain = (Button) findViewById(R.id.button_return_main);
		btn_clearOutPut = (Button) findViewById(R.id.clearOutPut);

		edt_heapSizeGrowthLimit = (EditText) findViewById(R.id.edt_heapSizeGrowthLimit);
		edt_heapSize = (EditText) findViewById(R.id.edt_heapSize);

		txt_result = (TextView) findViewById(R.id.txt_result);

		btn_clearOutPut.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.i(LOG_TAG, "Inside clearOutPut()");
				clearFields();
			}
		});

		btn_setHeapGrowthLimit.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.i(LOG_TAG, "Inside set heap growth limit");
				try {
					int ret = EloSecureUtil.setHeapGrowthLimit(HeapSizeActivity.this,Integer.valueOf(edt_heapSizeGrowthLimit.getText().toString()));
					if (ret == 0) {
						txt_result.setText("Set Heap Growth Limit Success");
					} else if (ret == -2){
                        txt_result.setText("Operation is not supported for this Android version");
                    } else {
						txt_result.setText("Set Heap Growth Limit Failure");
					}
				} catch (NumberFormatException e) {
					Log.i(LOG_TAG, "Inside set heap growth limit  - NumberFormatException");
					txt_result.setText("Inside set heap growth limit  - NumberFormatException");
				}
			}
		});

		btn_setHeapSize.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.i(LOG_TAG, "Inside set heap size");
				try {
					int ret = EloSecureUtil.setHeapSize(HeapSizeActivity.this,Integer.valueOf(edt_heapSize.getText().toString()));
					if (ret == 0) {
						txt_result.setText("Set Heap Size Success");
					} else if (ret == -2){
                        txt_result.setText("Operation is not supported for this Android version");
                    } else {
						txt_result.setText("Set Heap Size Failure");
					}
				} catch (NumberFormatException e) {
					Log.i(LOG_TAG, "Inside set heap size - NumberFormatException");
					txt_result.setText("Inside set heap size - NumberFormatException");
				}
			}
		});

		btn_getHeapGrowthLimit.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.i(LOG_TAG, "Inside get heap growth limit");
				clearFields();
				txt_result.setText(EloSecureUtil.getHeapGrowthLimit(HeapSizeActivity.this));
			}
		});

		btn_getHeapSize.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.i(LOG_TAG, "Inside get heap size");
				clearFields();
				String heapSize=EloSecureUtil.getHeapSize(HeapSizeActivity.this);
				if (!heapSize.endsWith("mb")){
					txt_result.setText(heapSize+"b");
				}else {
					txt_result.setText(heapSize);

				}

			}
		});

		btn_returnMain.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.i(LOG_TAG, "Inside return to main");
				finish();
			}
		});
	}

	private void clearFields() {
		edt_heapSizeGrowthLimit.setText("");
		edt_heapSize.setText("");
		txt_result.setText("");
	}

}
