package com.example.eloViewSDKTestApp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.widget.Toast;

public class EloViewSDKTestAppReceiver extends BroadcastReceiver {

	@Override
	public void onReceive(Context context, Intent intent) {
		

		String action = intent.getAction();
		 if(Intent.ACTION_PACKAGE_ADDED.equals(action)){
			 String packageName =intent.getData().getSchemeSpecificPart();
			 if(packageName.equals("com.elotouch.eloviewdemoapp")){
			 PackageManager pManager = context.getPackageManager();
				Intent launchIntent = pManager.getLaunchIntentForPackage(packageName);
				launchIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
						| Intent.FLAG_ACTIVITY_NEW_TASK);
				context.startActivity(launchIntent);
			 }
		 
		 }
		 else if((Intent.ACTION_PACKAGE_REMOVED.equals(action))){
			 String packageName =intent.getData().getSchemeSpecificPart();
			 if(packageName.equals("com.elotouch.eloviewdemoapp") && MainActivity.isCurrentActivity(context, "com.example.eloViewSDKTestApp.MainActivity")){
				 Toast.makeText(context, "Application Uninstall Successfully", Toast.LENGTH_SHORT).show();
			 }
			 
			 
		 }
	}
	

}
