package com.example.eloViewSDKTestApp;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.eloview.sdk.EloSecureUtil;

public class EloViewInstallActivity extends Activity {
	public static final String ELO_DOWNLOADED_FOLDER = "/sdcard/elo/downloaded_content/";


	private static final String LOG_TAG = "EloViewInstallActivity";
	private TextView title;
	private Button installButton;
	private Button uninstallButton;
	private Button goBackButton;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_eloviewinstall);

		installButton = (Button) findViewById(R.id.install_apk_button);
		uninstallButton = (Button) findViewById(R.id.uninstall_apk_button);
		goBackButton = (Button) findViewById(R.id.button_return_main);

		installButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				EloSecureUtil.silentPackageInstall(getApplicationContext(),
						ELO_DOWNLOADED_FOLDER + "EloviewDemoApp.apk");
			}
		});

		uninstallButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				EloSecureUtil.silentPackageUninstall(getApplicationContext(),
						"com.elotouch.eloviewdemoapp");
			}
		});

		goBackButton.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});
	}
}
