package com.example.eloViewSDKTestApp;

import android.app.Activity;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;
import com.eloview.sdk.EloSecureUtil;
import org.json.JSONException;
import org.json.JSONObject;
import java.util.ArrayList;
import java.util.List;


public class DevicePortStatusActivity extends Activity {

	private static final String LOG_TAG = "DevicePortStatus";
	/* This is device type list which indicates list of devices supports USB enabled disabled feature.
	 * The device type name helps in getting JSON object, which we get from  GetDevicePortStatus API call
	 */
	private static final String[] deviceTypeNameList = {"iseries2", "iseries2val", "paypoint2", "puckpanel", "linford"};
	/* Below array lists holds Toggle button object, so that we can easy perform multiple UI
	 * operation  on these toggle buttons.
	 */
	List<ToggleButton> getToggleButtonList = new ArrayList<ToggleButton>();
	List<ToggleButton> setToggleButtonList = new ArrayList<ToggleButton>();
	/* This flag is useful in mGetDevicePortStatusReceiver by which we come to know 
	 * whether to update Get USB port API Output or Set USB port API Output box
	 */

	private static final String usbPortJsonString= "{\"port1\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port2\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port3\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port4\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port5\":{\"value\":\"Disabled\",\"type\":\"USB\"},\"port6\":{\"value\":\"Disabled\",\"type\":\"USB\"}}";
	JSONObject setDevicePortjson = new JSONObject();
	JSONObject usb1 = new JSONObject();
	JSONObject usb2 = new JSONObject();
	JSONObject usb3 = new JSONObject();
	JSONObject usb4 = new JSONObject();
	JSONObject usb5 = new JSONObject();
	JSONObject usb6 = new JSONObject();
	private Button returnMain, clearOutPut;
	private Button getDevicePortStatus, setDevicePortStatus,getMaxPortCount;
	private TextView txtGetResult, txtSetResult,txtGetMaxPortResult;
	ToggleButton toggleButtonGet1, toggleButtonGet2, toggleButtonGet3, toggleButtonGet4, toggleButtonGet5, toggleButtonGet6;
	ToggleButton toggleButtonSet1, toggleButtonSet2, toggleButtonSet3, toggleButtonSet4, toggleButtonSet5, toggleButtonSet6;


	private static final String ACTION_SET_DEVICE_PORTS = "android.intent.action.SET_DEVICE_PORTS";
	private static final String ACTION_GET_DEVICE_PORTS = "android.intent.action.GET_DEVICE_PORTS";
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		Log.d(LOG_TAG, "DevicePortStatusActivity: onCreate()");
		setContentView(R.layout.activity_deviceportstatus);
		try {
			setDevicePortjson= new JSONObject(usbPortJsonString);
		} catch (JSONException e) {

		}
		InitializedUI();
		SetClickListener();
	}

	@Override
	protected void onResume() {
		super.onResume();
		Log.d(LOG_TAG, "DevicePortStatusActivity: onResume()");

	}
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);

	}

	@Override
	protected void onPause() {
		super.onPause();
		Log.d(LOG_TAG, "DevicePortStatusActivity: onPause()");

	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.e(LOG_TAG, "DevicePortStatusActivity: onDestroy()");
	}
	/**
	 * Initialized all UI component
	 */

	void InitializedUI() {
		returnMain = (Button) findViewById(R.id.button_return_main);
		clearOutPut = (Button) findViewById(R.id.clearOutPut);
		getDevicePortStatus = (Button) findViewById(R.id.button_get_device_port_status);
		setDevicePortStatus = (Button) findViewById(R.id.button_set_device_port_status);
		getMaxPortCount = (Button)findViewById(R.id.button_get_max_port);
		txtGetResult = (TextView) findViewById(R.id.txt_result);
		txtSetResult = (TextView) findViewById(R.id.txt_set_result);
		txtGetMaxPortResult=(TextView) findViewById(R.id.txt_max_port_result);

		toggleButtonGet1 = (ToggleButton) findViewById(R.id.toggleButtonGet1);
		getToggleButtonList.add(toggleButtonGet1);
		toggleButtonGet2 = (ToggleButton) findViewById(R.id.toggleButtonGet2);
		getToggleButtonList.add(toggleButtonGet2);
		toggleButtonGet3 = (ToggleButton) findViewById(R.id.toggleButtonGet3);
		getToggleButtonList.add(toggleButtonGet3);
		toggleButtonGet4 = (ToggleButton) findViewById(R.id.toggleButtonGet4);
		getToggleButtonList.add(toggleButtonGet4);
		toggleButtonGet5 = (ToggleButton) findViewById(R.id.toggleButtonGet5);
		getToggleButtonList.add(toggleButtonGet5);
		toggleButtonGet6 = (ToggleButton) findViewById(R.id.toggleButtonGet6);
		getToggleButtonList.add(toggleButtonGet6);

		toggleButtonSet1 = (ToggleButton) findViewById(R.id.toggleButtonSet1);
		setToggleButtonList.add(toggleButtonSet1);
		toggleButtonSet2 = (ToggleButton) findViewById(R.id.toggleButtonSet2);
		setToggleButtonList.add(toggleButtonSet2);
		toggleButtonSet3 = (ToggleButton) findViewById(R.id.toggleButtonSet3);
		setToggleButtonList.add(toggleButtonSet3);
		toggleButtonSet4 = (ToggleButton) findViewById(R.id.toggleButtonSet4);
		setToggleButtonList.add(toggleButtonSet4);
		toggleButtonSet5 = (ToggleButton) findViewById(R.id.toggleButtonSet5);
		setToggleButtonList.add(toggleButtonSet5);
		toggleButtonSet6 = (ToggleButton) findViewById(R.id.toggleButtonSet6);
		setToggleButtonList.add(toggleButtonSet6);


		SetToggleButtonVisibilitybyDeviceType();

	}

	private void SetClickListener() {
		returnMain.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});

		toggleButtonSet1.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

				try {
					if (isChecked) {
						usb1.put("value", "Enabled");
					} else {
						usb1.put("value", "Disabled");
					}

					usb1.put("type", "USB");
					setDevicePortjson.put("port1", usb1);
					txtSetResult.setText(setDevicePortjson.toString());
				} catch (JSONException e) {

				}
			}
		});
		toggleButtonSet2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

				try {
					if (isChecked) {
						usb2.put("value", "Enabled");
					} else {
						usb2.put("value", "Disabled");
					}

					usb2.put("type", "USB");
					setDevicePortjson.put("port2", usb2);
					txtSetResult.setText(setDevicePortjson.toString());
				} catch (JSONException e) {

				}
			}
		});
		toggleButtonSet3.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

				try {
					if (isChecked) {
						usb3.put("value", "Enabled");
					} else {
						usb3.put("value", "Disabled");
					}

					usb3.put("type", "USB");
					setDevicePortjson.put("port3", usb3);
					txtSetResult.setText(setDevicePortjson.toString());
				} catch (JSONException e) {

				}
			}
		});
		toggleButtonSet4.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

				try {
					if (isChecked) {
						usb4.put("value", "Enabled");
					} else {
						usb4.put("value", "Disabled");
					}

					usb4.put("type", "USB");
					setDevicePortjson.put("port4", usb4);
					txtSetResult.setText(setDevicePortjson.toString());
				} catch (JSONException e) {

				}
			}
		});
		toggleButtonSet5.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

				try {
					if (isChecked) {
						usb5.put("value", "Enabled");
					} else {
						usb5.put("value", "Disabled");
					}

					usb5.put("type", "USB");
					setDevicePortjson.put("port5", usb5);
					txtSetResult.setText(setDevicePortjson.toString());
				} catch (JSONException e) {

				}
			}
		});
		toggleButtonSet6.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

				try {
					if (isChecked) {
						usb6.put("value", "Enabled");
					} else {
						usb6.put("value", "Disabled");
					}

					usb6.put("type", "USB");
					setDevicePortjson.put("port6", usb6);
					txtSetResult.setText(setDevicePortjson.toString());
				} catch (JSONException e) {

				}
			}
		});
		setDevicePortStatus.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.d(LOG_TAG, "@@@@@@@@@@@@@ setDevicePortStatus @@@@@@@@@@@@");
				int portResult = -1;
				String outputstring = txtSetResult.getText().toString().trim();
				if (! outputstring.isEmpty()) {
						portResult = EloSecureUtil.setDevicePortsJSON(DevicePortStatusActivity.this, outputstring.toString());

				}
				if(portResult==0){
					txtSetResult.setText(setDevicePortjson.toString());
				}else {
					Toast.makeText(DevicePortStatusActivity.this,"Not able to set USB Port",Toast.LENGTH_SHORT).show();
				}

			}
		});

		getDevicePortStatus.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Log.d(LOG_TAG, "!!!!!!!!! getDevicePortStatus !!!!!!!!!!!!!!!!!!!");
				EloSecureUtil.getDevicePortsStatusJSON(DevicePortStatusActivity.this, mGetDevicePortStatusReceiver);

			}
		});
		getMaxPortCount.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				txtGetMaxPortResult.setText(EloSecureUtil.getMaxUSBport()+"");
			}
		});
	}

	/**
	 * This BroadcastReceiver comes into action when ever we make call to any of below function.
	 *
	 * 1) EloSecureUtil.getDevicePortsStatusJSON(DevicePortStatusActivity.this, mGetDevicePortStatusReceiver);
	 * 2) EloSecureUtil.setDevicePortsJSON(DevicePortStatusActivity.this, <JSON String>);
	 *
	 *  We required to maintain flag (UsbPortSetApiCallFlag) so that when activity start
	 *  we can initialize set API button UI States.
	 */
	BroadcastReceiver mGetDevicePortStatusReceiver = new BroadcastReceiver() {
		public void onReceive(android.content.Context context, Intent intent) {

		 if(intent.getAction().equalsIgnoreCase(ACTION_GET_DEVICE_PORTS)) {
				Log.d(LOG_TAG, "DevicePortStatusActivity: !!!ACTION_GET_DEVICE_PORTS!!!");
				String devicePortStatus = getResultData();
				Log.d(LOG_TAG, "DevicePortStatusActivity: devicePortStatus:=  " + devicePortStatus);
				if (devicePortStatus!=null && !devicePortStatus.isEmpty() && !devicePortStatus.equals("UNKNOWN_HW")) {
					try {
						JSONObject devicePortJson = new JSONObject(devicePortStatus);
						for (String key : deviceTypeNameList) {
							if (devicePortJson.has(key)) {
								JSONObject portValueJson = devicePortJson.getJSONObject(key);
								Log.e(LOG_TAG, portValueJson.toString());
								txtGetResult.setText(devicePortStatus);
								GetPortApiToggleButtonValues(portValueJson);
								break;
							}
						}

					} catch (JSONException Exception) {
						Log.e(LOG_TAG,Exception.toString());
					}
				} else {
					Log.e(LOG_TAG, "set UNKNOWN_HW");
					txtSetResult.setText("This device does not support USB On OFF feature");
					txtGetResult.setText("This device does not support USB On OFF feature");
					getDevicePortStatus.setClickable(false);
					setDevicePortStatus.setClickable(false);
					clearOutPut.setClickable(false);
				}

			}else if(intent.getAction().equalsIgnoreCase(ACTION_SET_DEVICE_PORTS)) {
				Log.d(LOG_TAG, "DevicePortStatusActivity: @@@ACTION_SET_DEVICE_PORTS@@@");
			}

		}
	};
	private void GetPortApiToggleButtonValues(JSONObject portValueJson) {

		for (int portKey = 0; portKey < portValueJson.length(); portKey++) {
			try {
				JSONObject portValue = portValueJson.getJSONObject("port" + (portKey + 1));
				if (portValue.getString("value").equals("Enabled")) {
					Log.e(LOG_TAG, "port" + (portKey + 1) + " :" + portValue.getString("value"));
					getToggleButtonList.get(portKey).setChecked(true);
				} else {
					Log.e(LOG_TAG, "port" + (portKey + 1) + " :" + portValue.getString("value"));
					getToggleButtonList.get(portKey).setChecked(false);
				}
			} catch (JSONException Exception) {
				Log.e(LOG_TAG,Exception.toString());
			}
		}

	}


	private void SetToggleButtonVisibilitybyDeviceType() {
		int initializedIndex=EloSecureUtil.getMaxUSBport();
		//Excute the for loop to set visibility of toggle button.
		for (int buttonIndex = initializedIndex; buttonIndex < getToggleButtonList.size(); buttonIndex++) {
			getToggleButtonList.get(buttonIndex).setVisibility(View.GONE);
			setToggleButtonList.get(buttonIndex).setVisibility(View.GONE);
			setDevicePortjson.remove("port"+(buttonIndex+1));
		}

		if(initializedIndex==0) {
			txtSetResult.setText("This device does not support USB On OFF feature");
			txtGetResult.setText("This device does not support USB On OFF feature");
			getDevicePortStatus.setClickable(false);
			setDevicePortStatus.setClickable(false);
			clearOutPut.setClickable(false);
		}else {
			txtSetResult.setText(setDevicePortjson.toString());

			clearOutPut.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					txtGetResult.setText("");
				}
			});
		}
		Log.e(LOG_TAG, "port" + setDevicePortjson.toString());

	}
}
