package com.example.eloViewSDKTestApp;

import java.io.StringReader;
import java.util.Properties;

import android.Manifest;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.eloview.sdk.EloSecureUtil;

public class DeviceInfoActivity extends Activity {

	private static final String LOG_TAG = "DeviceInfoActivity";
    private static final int EXTERNAL_STORAGE_PERMISSION_CONSTANT = 101;
    private Button returnMain, clearOutPut;
	private Button getDeviceInfoAsync, getDeviceInfoSync,
			registerDeviceInfoReceiver, unregisterDeviceInfoReceiver;
	private TextView txt_result;
	private Context mContext;
	private StringBuilder outputStr = new StringBuilder();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_deviceinfo);
		mContext = DeviceInfoActivity.this;
		init();
		if(Build.VERSION.SDK_INT>23) {
            if (checkSelfPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED) {
                Log.v(LOG_TAG, "Permission is granted");

            } else {
                Log.v(LOG_TAG, "request Permissions");
                this.requestPermissions(new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, EXTERNAL_STORAGE_PERMISSION_CONSTANT);
            }
        }
	}

	private void init() {
		returnMain = (Button) findViewById(R.id.button_return_main);
		clearOutPut = (Button) findViewById(R.id.clearOutPut);
		getDeviceInfoAsync = (Button) findViewById(R.id.button_get_device_info_async);
		getDeviceInfoSync = (Button) findViewById(R.id.button_get_device_info_sync);
		registerDeviceInfoReceiver = (Button) findViewById(R.id.button_deviceinfo_receiver_register);
		unregisterDeviceInfoReceiver = (Button) findViewById(R.id.button_deviceinfo_receiver_unregister);
		txt_result = (TextView) findViewById(R.id.txt_result);
		clearOutPut.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				txt_result.setText("");
				outputStr.setLength(0);
			}
		});
		returnMain.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});
		getDeviceInfoAsync.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				boolean ret = EloSecureUtil.getDeviceInfo(mContext, msgHandler);
				if (ret) {
					Log.i(LOG_TAG, "No error found while calling getDeviceInfo");
				} else {
					Log.i(LOG_TAG, "Error found while calling getDeviceInfo");
				}
			}
		});
		getDeviceInfoSync.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				String ret = EloSecureUtil.getDeviceInfo(mContext);
				txt_result.setText(ret);
				parseProp(ret, "device_name");
			}
		});
		registerDeviceInfoReceiver.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				boolean ret = EloSecureUtil.registerDeviceInfoReceiver(
						mContext, mDeviceInfoReceiver);
				if (ret) {
					txt_result
							.setText("Device info receiver registered successfully");
					Log.i(LOG_TAG,
							"Device info receiver registered successfully");
				} else {
					txt_result
							.setText("Error while registering device info receiver");
					Log.e(LOG_TAG,
							"Error while registering device info receiver");
				}
			}
		});
		unregisterDeviceInfoReceiver.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				boolean ret = EloSecureUtil.unregisterDeviceInfoReceiver(
						mContext, mDeviceInfoReceiver);
				if (ret) {
					txt_result
							.setText("Device info receiver unregistered successfully");
					Log.i(LOG_TAG,
							"Device info receiver unregistered successfully");
				} else {
					txt_result
							.setText("Error while unregistering device info receiver");
					Log.e(LOG_TAG,
							"Error while unregistering device info receiver");
				}
			}
		});
	}

	Handler msgHandler = new Handler() {
		public void handleMessage(Message msg) {
			super.handleMessage(msg);
			Bundle b = msg.getData();
			String key = Integer.toString(msg.what);
			String val = b.getString(key);
			switch (msg.what) {
			case EloSecureUtil.ELO_GET_DEVICE_INFO:
				txt_result.setText(val);
				parseProp(val, "device_name");
				break;
			default:
				Log.i(LOG_TAG, "No match found");
				break;
			}
		}
	};

	private static void parseProp(String str, String key) {
		try {
			final Properties prop = new Properties();
			prop.load(new StringReader(str));
			if (prop.containsKey(key)) {
				Log.i(LOG_TAG,
						"parseProp key:= " + key + " val:= "
								+ prop.getProperty("device_name"));
			}
		} catch (Exception e) {
			Log.e(LOG_TAG, "Exception while parsing prop");
		}
	}

	final BroadcastReceiver mDeviceInfoReceiver = new BroadcastReceiver() {
		@Override
		public void onReceive(Context context, Intent intent) {
			Log.v(LOG_TAG, " onReceive DeviceInfoReceiver called");
			Bundle bundle = intent.getExtras();
			Log.e(LOG_TAG,"Size:"+bundle.size());
			outputStr.setLength(0);
			for (String key : bundle.keySet()) {
				Log.e(LOG_TAG, key + " = " + bundle.get(key));
				outputStr.append( key + " = " + bundle.get(key) +"\n");
			}

			txt_result.setText(outputStr);
		}
	};

	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.i(LOG_TAG, "Just avoid leak ...");
		EloSecureUtil.unregisterDeviceInfoReceiver(mContext,
				mDeviceInfoReceiver);
	}

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.v(LOG_TAG,"in side  onRequestPermissionsResult");

        if (requestCode == EXTERNAL_STORAGE_PERMISSION_CONSTANT) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                Log.v(LOG_TAG,"Storage permissions granted");
            }else {
                Log.v(LOG_TAG,"Permissions decline so close activity");
                finish();
            }
        }
    }
}