package com.elotouch.miami.testapp.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.elotouch.miami.testapp.MainActivity;
import com.elotouch.miami.testapp.R;

import java.util.Arrays;
import java.util.List;

/**
 * Created by elo on 28/7/16.
 */
public class TabHostAdapter  extends BaseAdapter{

    private Activity activity;
    private LayoutInflater inflater;
    private List<String> tabHostList;

    int textViewCount = 6;
    TextView[] titleTextView = new TextView[textViewCount];
    TextView[] baseLineTextView = new TextView[textViewCount];
    public  TabHostAdapter(Activity activity, String[] tabHostList){

        this.activity=activity;
        this.tabHostList= Arrays.asList(tabHostList);

    }
    @Override
    public int getCount() {
        return tabHostList.size();
    }

    @Override
    public View getView(int position, View convertView, ViewGroup viewGroup) {


        if (inflater == null)
            inflater = (LayoutInflater) activity
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        if (convertView == null)
            convertView = inflater.inflate(R.layout.tab_host_list_item, null);

        final TextView title = (TextView) convertView.findViewById(R.id.bottom_tital);

        TextView baseLine = (TextView) convertView.findViewById(R.id.base_line);

        title.setText(tabHostList.get(position));
        title.setTag(position);
        baseLine.setVisibility(View.INVISIBLE);

        titleTextView[position]=title;
        baseLineTextView[position]=baseLine;


        title.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                setcheck((int)title.getTag());
                MainActivity.getViewPager().setCurrentItem((int)title.getTag());
            }
        });



        return convertView;
    }

    @Override
    public long getItemId(int i) {
        return 0;
    }

    @Override
    public Object getItem(int i) {
        return null;
    }



    public void  setcheck (int position ){



        for (int item=0 ; item<titleTextView.length ;item++)
        {
            if (item==position)
            {
                titleTextView[item].setTextColor(activity.getResources().getColor(R.color.elo_blue_color));
                baseLineTextView[item].setVisibility(View.VISIBLE);
            }
            else
            {
                titleTextView[item].setTextColor(activity.getResources().getColor(R.color.elo_light_gray_color));
                baseLineTextView[item].setVisibility(View.INVISIBLE);
            }
        }
    }
}
