package com.elotouch.miami.testapp.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.elotouch.miami.testapp.R;
import com.elotouch.miami.testapp.pojos.ElementInfo;

import java.util.ArrayList;

/**
 * Created by elo on 22/8/16.
 */
public class PeripheralSpinnerAdapter extends ArrayAdapter<ElementInfo> {

    LayoutInflater inflater;
    ArrayList<ElementInfo> objects;
    ViewHolder holder = null;

    public PeripheralSpinnerAdapter(Context context, int textViewResourceId, ArrayList<ElementInfo> objects) {
        super(context, textViewResourceId, objects);
        inflater = ((Activity) context).getLayoutInflater();
        this.objects = objects;
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return getCustomView(position, convertView, parent);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        return getCustomView(position, convertView, parent);
    }

    @Override
    public int getCount() {
        return super.getCount();//==0? 0:super.getCount()-1;
    }

    public View getCustomView(int position, View convertView, ViewGroup parent) {

        ElementInfo listItem = objects.get(position);
        View row = convertView;

        if (null == row) {
            holder = new ViewHolder();
            row = inflater.inflate(R.layout.spinner_list_item, parent, false);
            holder.itemName = (TextView) row.findViewById(R.id.list_item_name);
            row.setTag(holder);
        } else {
            holder = (ViewHolder) row.getTag();
        }

        if (position == 0) {
            holder.itemName.setText("");
            holder.itemName.setHint(listItem.itemName);
        } else {
            holder.itemName.setText(listItem.itemName);
        }

        return row;
    }

    static class ViewHolder {
        TextView itemName;
    }


}
