package com.elotouch.miami.testapp;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.constraint.Group;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Switch;

import com.elo.device.enums.BcrEnableControl;
import com.elo.device.inventory.Inventory;

import java.util.Timer;
import java.util.TimerTask;


public class Scanner extends Fragment {

	public static EditText barcodeOutput;
	public static Button mBtnKeyboardMode;
	private MainActivity mainActivity;
	private View rootView;
	private Group advancedGroup;
	private Switch advancedSwitch;

	private static final String TAG = "Scanner" ;
	private Timer timer = new Timer();
	private final long DELAY = 500; // in ms
	private boolean gotScanValue=false;

	@Override
	public void onAttach(Context context) {
		super.onAttach(context);
		mainActivity = (MainActivity) getActivity();
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		Inventory inventory = mainActivity.getInventory();

		rootView = inflater.inflate(R.layout.fragment_scanner, container, false);
		mBtnKeyboardMode = (Button) rootView.findViewById(R.id.fragment_scanner_btn_keyboard_mode);

		barcodeOutput = (EditText) rootView.findViewById(R.id.barcodeOutputText);
	    barcodeOutput.setCustomSelectionActionModeCallback(new ActionMode.Callback() {

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {

                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
            }

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {

                return false;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {

                return false;
            }

		});

	    advancedSwitch = (Switch) rootView.findViewById(R.id.advanced_mode);
		if (inventory.barCodeReaderSupportsVComMode()) {
			advancedGroup = (Group) rootView.findViewById(R.id.advanced_group);
		} else {
			advancedGroup = (Group) rootView.findViewById(R.id.no_advanced_group);
		}
		advancedSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
				advancedGroup.setVisibility(isChecked ? View.VISIBLE : View.GONE);
			}
		});

		if (inventory.barCodeReaderEnableControl() == BcrEnableControl.TOGGLE) {
			rootView.findViewById(R.id.toggle_scanner_button).setVisibility(View.VISIBLE);
		}

		return rootView;
	}

	@Override
	public void onResume() {
		super.onResume();
		if (mainActivity.getInventory().barCodeReaderSupportsVComMode()) {
			if (MainActivity.isKeyBoardModeOn == true) {
				mBtnKeyboardMode.setAlpha(0.5f);
				mBtnKeyboardMode.setEnabled(false);
			} else {
				mBtnKeyboardMode.setAlpha(1.0f);
				mBtnKeyboardMode.setEnabled(true);
			}
		}
	}

    @Override
	public void setMenuVisibility(boolean menuVisible) {
		super.setMenuVisibility(menuVisible);
		if(menuVisible){
						try{
							  barcodeOutput.setEnabled(true);
								barcodeOutput.setText("");
								barcodeOutput.requestFocus();
						}catch (Exception ex){
								Log.e(TAG, ex.toString());
						}
		}else {

		}
	}
    @Override
	public void onActivityCreated(@Nullable Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);

		InputMethodManager imm = (InputMethodManager)getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
		imm.hideSoftInputFromWindow(barcodeOutput.getWindowToken(), 0);


		barcodeOutput.addTextChangedListener(new TextWatcher() {
	        @Override
	        public void beforeTextChanged(CharSequence s, int start, int count,
	                int after) {
                if(gotScanValue){
	        		timer = new Timer();
	                timer.schedule(new TimerTask() {
	                    @Override
	                    public void run() {

	                    	getActivity().runOnUiThread(new Runnable() {

								@Override
								public void run() {
									barcodeOutput.setText("");

								}
							});
	                    }

	                }, DELAY);
	        		Log.e(TAG, "clear the value : "+barcodeOutput.getText());

	        	}
	        }
	        @Override
	        public void onTextChanged(final CharSequence s, int start, int before,
	                int count) {
	        	gotScanValue=false;
	        	if(timer != null)
	                timer.cancel();


	        }
	        @Override
	        public void afterTextChanged(final Editable s) {
/*** (doing this stuff in barcodeOutput.setOnClickListener())
	            //avoid triggering event when text is too short
	            if (s.length() >= 2) {

	                timer = new Timer();
	                timer.schedule(new TimerTask() {
	                    @Override
	                    public void run() {

	                    	getActivity().runOnUiThread(new Runnable() {

								@Override
								public void run() {
									barcodeOutput.setEnabled(false);
								}
							});

	                    	gotScanValue=true;
	                    	Log.e(TAG, "Got Value");
	                    }

	                }, 100);
	            } */
	        }
	    });

		getActivity().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN | WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
  }

}