package com.elotouch.miami.testapp;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.elo.device.inventory.Inventory;


public class PrinterFragment extends Fragment {

    public static TextView paperStatus;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_printer, container, false);
        paperStatus = (TextView) rootView.findViewById(R.id.textViewPaperStatus);

        // Hide buttons if they aren't relevant
        Inventory inventory = ((MainActivity) getActivity()).getInventory();
        if (!inventory.isPrinterPaperOutSupported()) {
            rootView.findViewById(R.id.paper_status_label).setVisibility(View.GONE);
            rootView.findViewById(R.id.textViewPaperStatus).setVisibility(View.GONE);
            rootView.findViewById(R.id.checkPaper).setVisibility(View.GONE);
        }

        if (!inventory.isPrinterChineseModeSupported()) {
            rootView.findViewById(R.id.chinese_mode_label).setVisibility(View.GONE);
            rootView.findViewById(R.id.chinese_mode_state).setVisibility(View.GONE);
            rootView.findViewById(R.id.chinese_mode_toggle).setVisibility(View.GONE);
        }

        return rootView;
    }

}
