package com.elotouch.miami.testapp;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class MsrFragment extends Fragment {
    View rootView;
    public EditText magstripeCode;
    private TextView tv_status;
    private TextView tv_mode;
    private Button btn_toggleMsrMode;

    enum MsrMode {
        KEYBOARD,
        HID,
        UNKNOWN
    };

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.fragment_msr, container, false);

        magstripeCode = (EditText) rootView.findViewById(R.id.magstripe_code);
        tv_status = (TextView) rootView.findViewById(R.id.msr_status);
        tv_mode = (TextView) rootView.findViewById(R.id.msr_mode);
        btn_toggleMsrMode = (Button) rootView.findViewById(R.id.toggle_msr_mode);

        return rootView;
    }

    public void updateMsrModeDisplay(boolean connectionStatus, MsrMode mode) {

        if(connectionStatus) {
            tv_status.setText("Connected");
            tv_status.setTextColor(getResources().getColor(R.color.elo_blue_color));
        } else {
            tv_status.setText("Disconnected");
            tv_status.setTextColor(getResources().getColor(R.color.elo_red));
        }

        switch(mode) {
            case KEYBOARD:
                tv_mode.setText("Keyboard");
                tv_mode.setTextColor(getResources().getColor(R.color.elo_blue_color));
                break;

            case HID:
                tv_mode.setText("HID");
                tv_mode.setTextColor(getResources().getColor(R.color.elo_blue_color));
                break;

            default:
                tv_mode.setText("Unknown");
                tv_mode.setTextColor(getResources().getColor(R.color.elo_red));
        }
    }

    public void clearText() {
        magstripeCode.setText("");
    }

    public void setText(String s) {
        magstripeCode.setText(s);
    }

    public void enableToggleModeButton(boolean enabled){
        btn_toggleMsrMode.setEnabled(enabled);
    }
}