package com.elotouch.miami.testapp;

import android.app.ActionBar;
import android.app.DialogFragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.InputType;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

import com.elo.device.DeviceManager;
import com.elo.device.ProductInfo;
import com.elo.device.enums.BcrEnableControl;
import com.elo.device.enums.EloPlatform;
import com.elo.device.inventory.PrinterSupported;
import com.elo.device.peripherals.BarCodeReader.BarcodeReadCallback;
import com.elo.device.exceptions.UnsupportedPeripheralMethodException;
import com.elo.device.inventory.Inventory;
import com.elotouch.miami.testapp.apiadapter.MsrAdapter;
import com.elotouch.miami.testapp.adapter.TabHostAdapter;
import com.elotouch.miami.testapp.apiadapter.ActivityMonitor;
import com.elotouch.miami.testapp.apiadapter.ApiAdapter;
import com.elotouch.miami.testapp.apiadapter.ApiAdapterFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

import static com.elotouch.miami.testapp.CashDrawer.mCashDrawerStatusTextView;
import static com.elotouch.miami.testapp.PrinterFragment.paperStatus;
import static com.elotouch.miami.testapp.Scanner.barcodeOutput;
import static com.elotouch.miami.testapp.Scanner.mBtnKeyboardMode;

public class MainActivity extends FragmentActivity implements
        ActionBar.TabListener {

    private static final String ACTION_GET_DEVICE_PROPERTIES = "android.intent.action.GET_DEVICE_PROPERTIES";

    public static ProductInfo   productInfo;
    private ApiAdapter apiAdapter;
    private Inventory inventory;

    private static String TAG = "miamitestapp";
    Timer timer;

    public static ViewPager getViewPager() {
        return mViewPager;
    }

    private CashDrawer          cashDrawerFragment  = new CashDrawer();
    private CFDFragment         cfdFragment         = new CFDFragment();
    private PrinterFragment     printerFragment     = new PrinterFragment();
    private Scanner             scannerFragment     = new Scanner();
    private MsrFragment         msrFragment         = new MsrFragment();
    private FTDIFragment        ftdiFragment        = new FTDIFragment();

    ArrayList<Fragment> mFragmentList;

    ArrayList<Fragment> createAllFragments() {
        ArrayList<Fragment> l = new ArrayList<>();
        l.add(cashDrawerFragment);
        l.add(cfdFragment);
        l.add(printerFragment);
        l.add(scannerFragment);
        l.add(msrFragment);
        l.add(ftdiFragment);
        return l;
    }

    private FragmentPagerAdapter mFragmentPagerAdapter = new FragmentPagerAdapter(getSupportFragmentManager()) {
        @Override
        public Fragment getItem(int index) {
            return mFragmentList.get(index);
        }

        @Override
        public int getCount() {
            return mFragmentList.size();
        }
    };

    public static ViewPager mViewPager;
    private TabHostAdapter mTabHostAdapter;
    private LinearLayout bottomLayout;
    public int lastPosition=0,currentPosition=0;

    // should be in the order of the fragments added to pager
    String[] mTabTitles = {
            "Cash Drawer",
            "CFD",
            "Printer",
            "Scanner",
            "MSR",
            "FTDI"
    };
    public static boolean isKeyBoardModeOn = false;
    private boolean isCashDrawerSensorReversed;

    private ViewPager.OnPageChangeListener mPageChangeListener = new ViewPager.OnPageChangeListener() {
            public void onPageScrollStateChanged(int state) {
                // If user changes pages, hide the keyboard.  If we do it when he starts dragging,
                // it's even better UX.  We won't get the DRAG notify if he selects the page from
                // the bottom, but if the keyboard is visible, it will block that option anyway.
                if (state == ViewPager.SCROLL_STATE_DRAGGING) {
                    hideKeyboard();
                }
            }

        public void onPageScrolled( int position, float positionOffset, int positionOffsetPixels) {

        }

        public void onPageSelected(int position) {
            mTabHostAdapter.setcheck(position);


            lastPosition=currentPosition;
            currentPosition=position;
            Log.e(TAG,"lastPosition: "+lastPosition +" | currentPosition: "+currentPosition);
            ProcessLastTab(lastPosition);
            ProcessCurrentTab(currentPosition);
        }

    };

    void initTabsView()
    {
            mViewPager = (ViewPager) findViewById(R.id.pager);
            bottomLayout = (LinearLayout) findViewById(R.id.bottom_layout);

            if (mFragmentList == null)
                mFragmentList = createAllFragments();

            mTabHostAdapter = new TabHostAdapter(this, mTabTitles);

            for (int i = 0; i < mTabHostAdapter.getCount(); i++) {
                View item = mTabHostAdapter.getView(i, null, null);
                bottomLayout.addView(item);
            }

            mViewPager.setAdapter(mFragmentPagerAdapter);
            mViewPager.setOnPageChangeListener(mPageChangeListener);
            mTabHostAdapter.setcheck(0);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG, "onCreate ");

        setContentView(R.layout.activity_main);

        inventory = DeviceManager.getInventory(this);
        if (!inventory.isEloSdkSupported()) {
            Toast.makeText(this, "Platform not recognized or supported, sorry", Toast.LENGTH_LONG).show();
            return;

        }

        productInfo = DeviceManager.getPlatformInfo();
        EloPlatform platform = productInfo.eloPlatform;

        apiAdapter = ApiAdapterFactory.getInstance(this).getApiAdapter(inventory);
        if (apiAdapter == null) {
            // We're not running on a supported platform.  This is a common customer scenario where
            // the APK may be written for multiple vendor platforms.  In our case, we can't do much
            Log.d(TAG, "Cannot find support for this platform");
            Toast.makeText(this, "Cannot find support for this platform", Toast.LENGTH_LONG).show();
            return;
        }

        // Initialization
        initTabsView();
    }

    @Override
    protected void onResume() {
        super.onResume();
        apiAdapter.getActivityMonitor().onActivityEvent(ActivityMonitor.EVENT_ON_RESUME);

        if (inventory.barCodeReaderSupportsKeyboardMode() && inventory.barCodeReaderSupportsVComMode()) {
            isKeyBoardModeOn = apiAdapter.isBarCodeReaderKbdMode();
        }

        ProcessCurrentTab(currentPosition);
    }

    @Override
    protected void onPause() {
        super.onPause();
        apiAdapter.getActivityMonitor().onActivityEvent(ActivityMonitor.EVENT_ON_PAUSE);

        if (timer != null) {
            timer.cancel();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        apiAdapter.getActivityMonitor().onActivityEvent(ActivityMonitor.EVENT_ON_START);
    }

    @Override
    protected void onStop() {
        super.onStop();
        apiAdapter.getActivityMonitor().onActivityEvent(ActivityMonitor.EVENT_ON_STOP);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mViewPager = null;
    }

    @Override
    public void onTabReselected(ActionBar.Tab arg0, FragmentTransaction arg1) {
    }

    @Override
    public void onTabSelected(ActionBar.Tab tab, FragmentTransaction ft) {
        mViewPager.setCurrentItem(tab.getPosition());
    }

    @Override
    public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction ft) {
    }

    public ApiAdapter getApiAdapter() {
        return apiAdapter;
    }

    public void turnBcrOn() {
        if (inventory.barCodeReaderEnableControl() == BcrEnableControl.FULL) {
            if (inventory.barCodeReaderSupportsVComMode()) {
                if (!isKeyBoardModeOn) {
                    // Can't do much otherwise
                    apiAdapter.setBarCodeReaderCallback(callback);
                    apiAdapter.setBarCodeReaderEnabled(true);
                }
            } else {
                if (!apiAdapter.isBarCodeReaderEnabled()) {
                    apiAdapter.setBarCodeReaderEnabled(true);
                }
            }
        }
    }

    public void turnBcrOff() {
        if (inventory.barCodeReaderEnableControl() == BcrEnableControl.FULL) {
            if (inventory.barCodeReaderSupportsVComMode()) {
                if (!isKeyBoardModeOn) {
                    // Can't do much otherwise
                    apiAdapter.setBarCodeReaderEnabled(false);
                    apiAdapter.setBarCodeReaderCallback(null);
                }
            } else {
                if (apiAdapter.isBarCodeReaderEnabled()) {
                    apiAdapter.setBarCodeReaderEnabled(false);
                }
            }
        }
    }

    public void toggleBcr() {
        if (inventory.barCodeReaderEnableControl() == BcrEnableControl.FULL) {
            if (apiAdapter.isBarCodeReaderEnabled()) {
                turnBcrOff();
            } else {
                turnBcrOn();
            }
        } else if (inventory.barCodeReaderEnableControl() == BcrEnableControl.TOGGLE) {
            apiAdapter.setBarCodeReaderEnabled(true);   // Conventionally, this is toggle
        } else {
            // No toggle control; can't do anything
        }
    }

    private void setCashDrawerStatus(boolean open) {
        if (isCashDrawerSensorReversed) {
            open = !open;
        }

        if (open) {
            mCashDrawerStatusTextView.setText("Open");
            mCashDrawerStatusTextView.setTextColor(getResources().getColor(R.color.elo_red));
        } else {
            mCashDrawerStatusTextView.setText("Close");
            mCashDrawerStatusTextView.setTextColor(getResources().getColor(R.color.elo_green));
        }
    }

    // Some fragments need access to the inventory, so let them use ours.
    public Inventory getInventory() {
        return inventory;
    }

    public MsrAdapter.MsrCallback msrCb = new MsrAdapter.MsrCallback() {
        @Override
        public void onCardSwipe(final String cardData) {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    Log.d(TAG, "Card swiped, data = " + cardData);
                    msrFragment.setText(Utils.maskString(cardData));
                }
            });
        }
    };

    public void ProcessCurrentTab(int currentPosition){

        switch (currentPosition) {
            case 0:     // Cash Drawer
                if (!inventory.hasCashDrawer()) break;

                if (inventory.isCashDrawerStateReadable()) {
                    timer = new Timer();
                    timer.schedule(new TimerTask() {
                        @Override
                        public void run() {
                            MainActivity.this.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    setCashDrawerStatus(apiAdapter.isCashDrawerOpen());
                                }
                            });
                            Log.e(TAG, "Check Cash Drawer Status");
                        }
                    }, 1000, 1000);
                }
                break;

            case 1:     // CFD
                if (!inventory.hasCfd()) break;

                AsyncTask.execute(new Runnable() {
                    @Override
                    public void run() {
                        apiAdapter.cfdSetBacklight(true);
                        apiAdapter.cfdClear();
                        apiAdapter.cfdSetLine(1, "ELO TOUCH");
                        apiAdapter.cfdSetLine(2, "PAYPOINT");
                    }
                });
                break;

            case 2:     // Printer
                if (!inventory.hasPrinter()) break;

                if (inventory.isPrinterPaperOutSupported()) {
                    // we update paper status after a small delay to keep the animation smooth
                    new Timer().schedule(new TimerTask() {
                        @Override
                        public void run() {
                            MainActivity.this.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    updatePaperStatus();
                                }
                            });
                            Log.e(TAG, "Check Paper Status");
                        }
                    }, 250);
                }
                break;

            case 3:     // Scanner
                if (!inventory.hasBarCodeReader()) break;

                if (barcodeOutput != null) {
                    barcodeOutput.setEnabled(true);
                    barcodeOutput.setText("");
                    barcodeOutput.requestFocus();
                }
                if (inventory.barCodeReaderEnableControl() == BcrEnableControl.FULL) {
                    AsyncTask.execute(new Runnable() {
                        @Override
                        public void run() {
                            turnBcrOn();
                        }
                    });
                }
                break;

            case 4:     // MSR
                if (!inventory.hasMsr()) break;
                apiAdapter.startMSR(msrCb);
                updateMsrModeDisplay();
                msrOutputSetFocus();

                break;

            case 5:     // FTDI
                break;
        }
    }

    public void msrOutputSetFocus() {
        EditText et = (EditText) findViewById(R.id.magstripe_code);
        et.requestFocus();
        et.setInputType(InputType.TYPE_NULL);
    }

    public void updateMsrModeDisplay() {

        boolean connected = false;
        MsrFragment.MsrMode mode = MsrFragment.MsrMode.UNKNOWN;

        if(inventory.hasMsr()) {
            connected = true;
            if (apiAdapter.isMsrInKbMode())             mode = MsrFragment.MsrMode.KEYBOARD;
            else if(apiAdapter.isMsrInHidMode())        mode = MsrFragment.MsrMode.HID;
        }

        msrFragment.updateMsrModeDisplay(connected, mode);
    }

    public void ProcessLastTab(int lastPosition){


        switch (lastPosition) {
            case 0:     // Cash Drawer
                if (!inventory.hasCashDrawer()) break;

                if (inventory.isCashDrawerStateReadable()) {
                    Log.e(TAG, "STOP Checking Cash Drawer Status");
                    if (timer != null)
                        timer.cancel();
                }
                break;
            case 1:     // CFD
                if (!inventory.hasCfd()) break;

                AsyncTask.execute(new Runnable() {
                    @Override
                    public void run() {
                        apiAdapter.cfdSetBacklight(false);
                        apiAdapter.cfdClear();
                    }
                });
                break;
            case 2:     // Printer
                if (!inventory.hasPrinter()) break;

                break;
            case 3:     // Scanner
                if (!inventory.hasBarCodeReader()) break;

                if (inventory.barCodeReaderEnableControl() == BcrEnableControl.FULL) {
                    AsyncTask.execute(new Runnable() {
                        @Override
                        public void run() {
                            turnBcrOff();
                        }
                    });
                }
                break;

            case 4:     // MSR
                if (!inventory.hasMsr()) break;
                apiAdapter.stopMSR();

                break;

            case 5:     // FTDI
                break;
        }
    }



    public void OnClickCashDrawerButton(View v) {
        try {
            apiAdapter.openCashDrawer();
        } catch (RuntimeException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
            return;
        }
    }

    public void onClickCashDrawerSensorReverse(View v) {
        CheckBox checkBox = (CheckBox) v;
        isCashDrawerSensorReversed = checkBox.isChecked();
    }

    public void OnClickPrintBarCodeButton(View v) {
        if (!inventory.hasPrinter()) {
            Toast.makeText(this, "Printer not connected", Toast.LENGTH_SHORT).show();
            return;
        }

        String barCodeToPrint = "1234567890";
        try {
            apiAdapter.printBarcode(barCodeToPrint);
        } catch (RuntimeException | IOException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
        }
    }

    public void onClickPrintReceiptButton (View v) {
        if (!inventory.hasPrinter()) {
            Toast.makeText(this, "Printer not connected", Toast.LENGTH_SHORT).show();
            return;
        }

        try {
            apiAdapter.printDemo();
        } catch (RuntimeException | IOException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
        }
    }

    public void onClickPrintImageButton (View v) {
        if (!inventory.hasPrinter()) {
            Toast.makeText(this, "Printer not connected", Toast.LENGTH_SHORT).show();
            return;
        }

        Bitmap imageToPrint = BitmapFactory.decodeResource(getResources(), R.drawable.elo_logo_bw);

        try {
            apiAdapter.printImage(imageToPrint, 0, 0, imageToPrint.getHeight(), imageToPrint.getWidth());    // TODO: implement scaling and offset
        } catch (RuntimeException | IOException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
        }
    }

    public void OnClickCheckPaperButton (View v) {
        if (!inventory.hasPrinter()) {
            Toast.makeText(this, "Printer not connected", Toast.LENGTH_SHORT).show();
            return;
        }

        if (inventory.isPrinterPaperOutSupported()) {
            updatePaperStatus();
        }
    }

    private void updatePaperStatus() {
        try {
            if (apiAdapter.hasPaper()) {
                paperStatus.setText("OK");
                paperStatus.setTextColor(getResources().getColor(R.color.elo_green));
            } else {
                paperStatus.setText("Out");
                paperStatus.setTextColor(getResources().getColor(R.color.elo_red));
            }

        } catch (IOException e) {
            Toast.makeText(MainActivity.this, "IOError occured trying to check for paper", Toast.LENGTH_SHORT).show();
        }
    }

    public void chineseModeToggle (View v) {
        try {
            apiAdapter.setChineseMode(((ToggleButton) v).isChecked());
        } catch (UnsupportedPeripheralMethodException e) {
            Toast.makeText(MainActivity.this, "Chinese Mode is not supported for this printer", Toast.LENGTH_SHORT).show();
        }
    }


    public void onClickOutputClear(View v) {
        barcodeOutput.setText("");
        barcodeOutput.setEnabled(true);
        if (!inventory.barCodeReaderSupportsVComMode()) {
            barcodeOutput.requestFocus();
        }
    }

    public void OnClickKeyBoardModeButton(View view) {
        if (inventory.barCodeReaderCanSetKeyboardMode()) {
            BcrKeyboardModeDialog fragment = new BcrKeyboardModeDialog();
            fragment.setOkayListener(new BcrKeyboardModeDialog.OkayListener() {
                @Override
                public void onOkayPressed() {
                    if (apiAdapter.isBarCodeReaderKbdMode()) {
                        Log.d(TAG, "Keyboard Mode is already On");
                    } else {
                        Log.d(TAG, "Setting Keyboard Mode");
                        apiAdapter.setBarCodeReaderKbdMode();
                        mBtnKeyboardMode.setEnabled(false);
                        mBtnKeyboardMode.setAlpha(0.5f);
                    }
                }
            });
            fragment.show(getFragmentManager(), null);
        }
    }

    public void onClickRecoveryBarcodeButton(View view) {
        if (!inventory.hasPrinter()) {
            Toast.makeText(this, "Printer not connected", Toast.LENGTH_SHORT).show();
            return;
        }
        if (inventory.getPrinterDeviceType() == PrinterSupported.RONGTA) {
            Toast.makeText(this, "This Printer can not print recovery barcode, refer SDK documentation to get recovery barcode", Toast.LENGTH_LONG).show();
            return;
        }
        try {
            Bitmap recoveryImage = BitmapFactory.decodeStream(getAssets().open("special_barcode_vcom_mode.png"));

            apiAdapter.print(getString(R.string.recovery_warning_1));
            apiAdapter.printImage(recoveryImage, 0, 0, recoveryImage.getHeight() / 2, recoveryImage.getWidth() / 2);
            apiAdapter.print(getString(R.string.recovery_warning_2));
            apiAdapter.cutPaper();
        } catch (IOException e) {
            Toast.makeText(this, "Unable to prepare barcode image", Toast.LENGTH_SHORT).show();
        } catch (RuntimeException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_SHORT).show();
        }
    }

    public void OnClickScannerInputTextBox(View view) {
        hideKeyboard();
        Log.e(TAG, "barcodeOutput clicked");
        Log.e(TAG, "Disabling Scanner input");
        view.setEnabled(false);
        turnBcrOn();		// on SDK 1.0, this API works as toggle button
    }

    public void hideKeyboard()
    {
        View view = getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) this.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void onClickToggleScannerButton(View view) {
        Log.d(TAG, "Toggling Barcode Reader");
        toggleBcr();
    }

    public void onClickTurnOn(View view) {
        Log.d(TAG, "Turning on Barcode Reader");
        apiAdapter.setBarCodeReaderEnabled(true);
    }

    public void onClickTurnOff(View view) {
        Log.d(TAG, "Turning off Barcode Reader");
        apiAdapter.setBarCodeReaderEnabled(false);
    }

    public void onClickInstallCallback(View view) {
        Log.d(TAG, "Installing Barcode Reader Callback");
        apiAdapter.setBarCodeReaderCallback(callback);
    }

    public void onClickUninstallCallback(View view) {
        Log.d(TAG, "Uninstalling Barcode Reader Callback");
        apiAdapter.setBarCodeReaderCallback(null);
    }

    public void onClickSendCommand(View view) {
        Log.d(TAG, "Sending command");
        EditText etCommand = (EditText) findViewById(R.id.command_input);
        byte[] command = etCommand.getText().toString().getBytes();
        byte[] reply = apiAdapter.sendCommand(command);
        if (reply != null) {
            TextView tvReply = (TextView) findViewById(R.id.command_output);
            tvReply.setText(convertToString(reply, reply.length));
        }
    }

    public void onClickClearMsrData(View view) {
        msrFragment.clearText();
    }

    private void toggleMsrMode() {
        if(apiAdapter.isMsrInKbMode()) {
            Log.d(TAG, "MSR in keyboard mode, setting it to HID mode");
            apiAdapter.setMsrHidMode();
        }
        else if(apiAdapter.isMsrInHidMode()) {
            Log.d(TAG, "MSR in HID mode, setting it to Keyboard mode");
            apiAdapter.setMsrKbMode();
        }
        else {
            Log.d(TAG, "MSR is in unknown state");
        }
        apiAdapter.stopMSR();
        apiAdapter.startMSR(msrCb);
    }

    public void onClickChangeMsrMode(View view) {
        Log.d(TAG, "ChangeMsrMode button clicked");

        msrFragment.enableToggleModeButton(false);

        toggleMsrMode();

        new Timer().schedule(new TimerTask() {
            @Override
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        updateMsrModeDisplay();
                        msrFragment.enableToggleModeButton(true);
                    }
                });
            }
        }, 2000);
    }

    private BarcodeReadCallback callback = new BarcodeReadCallback() {
        @Override
        public void onBarcodeRead(byte[] bytes) {
            String output;
            try {
                output = new String(bytes, "US-ASCII");
            } catch (UnsupportedEncodingException e) {
                output = "--UnReadable--";
            }
            final String outputCopy = output;
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    barcodeOutput.setText(outputCopy);
                }
            });

        }
    };

    private String[] AsciiTab = {
            "<NUL>", "<SOH>", "<STX>", "<ETX>", "<EOT>", "<ENQ>", "<ACK>", "<BEL>",	"<BS>",  "<HT>",  "<LF>",  "<VT>",
            "<FF>",  "<CR>",  "<SO>",  "<SI>",	"<DLE>", "<DC1>", "<DC2>", "<DC3>", "<DC4>", "<NAK>", "<SYN>", "<ETB>",
            "<CAN>", "<EM>",  "<SUB>", "<ESC>", "<FS>",  "<GS>",  "<RS>",  "<US>",	"<SP>",  "<DEL>",
    };

    public String convertToString(byte[] data, int length)
    {
        StringBuilder sb = new StringBuilder();

        for (int i = 0; i < length; i++) {
            final int c = (int)data[i] & 0xFF;    // Convert to unsigned
            if (c < 0x20) {
                sb.append(AsciiTab[c]);
            }  else if (c >= 0x7F) {
                sb.append('<').append(c).append('>');
            } else {
                sb.append((char)c);
            }
        }

        return sb.toString();
    }

}
