package com.elotouch.miami.testapp;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.elotouch.miami.testapp.adapter.PeripheralSpinnerAdapter;
import com.elotouch.miami.testapp.pojos.ElementInfo;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

import com.elo.device.enums.FTDIFlag;

public class FTDIFragment extends Fragment {
    private String TAG = "FTDI";
    private View mRootViewFTDI;
    private PeripheralSpinnerAdapter mSpinnerListAdapter = null;
    private Spinner mFTDISpinner;
    private Button mGetDeviceList;
    private Button mWriteData;
    private EditText etWritingData = null;
    Handler mHandler = new Handler();

    private TextView mFTDIStatusTextView = null;
    private TextView mFTDIDataTextView = null;
    private MainActivity mainActivity = null;
    private ArrayList<ElementInfo> mUSBList = new ArrayList<ElementInfo>();
    private String[] mUSBNameList = {"NA"};
    private int mFD = -1;
    private ElementInfo selectedUSB = null;
    private Thread readThread = null;
    private  final  String SELECT_DEVICE = "Select Device";
    private ElementInfo selectDevice = null;


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Log.i(TAG, "Inside onCreateView");
        selectDevice = new ElementInfo();
        selectDevice.setData(SELECT_DEVICE);
        mRootViewFTDI = inflater.inflate(R.layout.fragment_ftdi, container, false);
        initFragmentView(mRootViewFTDI);
        return mRootViewFTDI;
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onPause() {
        super.onPause();

    }
    @Override
    public void onStop() {
        super.onStop();
        Log.i(TAG, "Inside onStop FTDI-Stopping");
    }

    void initFragmentView(View view) {

        mainActivity = (MainActivity) getActivity();

        mFTDIStatusTextView = (TextView) view.findViewById(R.id.ftdi_status_txt);
        mFTDIDataTextView = (TextView) view.findViewById(R.id.dataval_txt);
        etWritingData = (EditText) view.findViewById(R.id.ftdi_writing_data);
        etWritingData.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

            @Override
            public void afterTextChanged(Editable editable) {
                if  ( editable.length() > 0 &&
                        selectedUSB != null && !selectedUSB.itemName.equals(SELECT_DEVICE) ) {
                    mWriteData.setEnabled(true);
                    mWriteData.setAlpha(1);
                }
                else {
                    mWriteData.setEnabled(false);
                    mWriteData.setAlpha(.5f);
                }
            }
        });
        etWritingData.setEnabled(false);


        mSpinnerListAdapter = new PeripheralSpinnerAdapter(getActivity(), R.layout.spinner_list_item, mUSBList);
        mFTDISpinner = (Spinner) view.findViewById(R.id.ftdiSpinner);
        mFTDISpinner.setAdapter(mSpinnerListAdapter);
        mFTDISpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> arg0, View arg1, int position, long id) {
                Log.i(TAG, "Position:= " + position + " Value:= " + arg0.getItemAtPosition(position));
                selectedUSB = mUSBList.get(position);
                if(!selectedUSB.itemName.equals(SELECT_DEVICE)) {
                    updateStatus("FTDI testing on " + selectedUSB.itemName);
                    etWritingData.setEnabled(true);
                    if(!TextUtils.isEmpty(etWritingData.getText().toString())) {
                        mWriteData.setEnabled(true);
                        mWriteData.setAlpha(1);
                    }
                } else {
                    Log.v(TAG,"Please select device");
                    mWriteData.setAlpha(.5f);
                    mWriteData.setEnabled(false);
                    etWritingData.setEnabled(false);

                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                Log.i(TAG, "Nothing Selected");
            }
        });

        mGetDeviceList = (Button) view.findViewById(R.id.getDeviceList);
        mGetDeviceList.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String str[] = mainActivity.getApiAdapter().getFtdiDevicesList();
                mUSBList.clear();
                mSpinnerListAdapter.clear();
                mFTDISpinner.setAdapter(mSpinnerListAdapter);
                mUSBList.add(selectDevice);
                for (String s : str) {
                    ElementInfo element = new ElementInfo();
                    element.setData(s);
                    mUSBList.add(element);
                }
                mSpinnerListAdapter.notifyDataSetChanged();
                mFTDIStatusTextView.setText("Retrieved USB list ... Please Select Device");
            }
        });


        mWriteData = (Button) view.findViewById(R.id.ftdi_write);
        mWriteData.setEnabled(false);
        mWriteData.setAlpha(.5f);
        mWriteData.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ftdiWrite();
            }});

    }

    private Handler mStatushandler = new Handler() {
        public void handleMessage(Message msg) {
            String displayMsg = msg.getData().getString("message");
            if ((null != displayMsg)) {
                mFTDIStatusTextView.setText(displayMsg);
            }
        }
    };

    private void updateStatus(String str) {
        Message msgObj = null;
        msgObj = mStatushandler.obtainMessage();
        Bundle b = new Bundle();
        b.putString("message", str);
        msgObj.setData(b);
        mStatushandler.sendMessage(msgObj);
    }

    private Handler mDatahandler = new Handler() {
        public void handleMessage(Message msg) {
            String displayMsg = msg.getData().getString("message");
            if ((null != displayMsg)) {
                mFTDIDataTextView.setText(displayMsg);
            }
        }
    };

    private void updateData(String str) {
        Message msgObj = null;
        msgObj = mDatahandler.obtainMessage();
        Bundle b = new Bundle();
        b.putString("message", str);
        msgObj.setData(b);
        mDatahandler.sendMessage(msgObj);
    }

    private void ftdiWrite() {
        new Thread(new Runnable() {
             @Override
            public void run() {
                final String editTextData = etWritingData.getText().toString()+"\n";
                final byte[] data = editTextData.getBytes(StandardCharsets.US_ASCII);
                byte[] temp = new byte[data.length];
                byte[] dataOut = new byte[data.length];
                final char [] rchar = new char[data.length];
                try {
                    int flag = ( FTDIFlag.CS8 | FTDIFlag.PNONE | FTDIFlag.S1 );
                    int fd = mainActivity.getApiAdapter().ftdiOpen(selectedUSB.itemName, 9600, flag);
                    Log.i(TAG, "ttyUSB_open : open device  " + selectedUSB.itemName);
                    Log.i(TAG, "ttyUSB_open : open device Fd " + fd);
                    if (fd != -1) {
                        mainActivity.getApiAdapter().ftdiWrite(fd, data, data.length);
                        int lenOut = 0;
                        while (lenOut < data.length) {
                            int delta =  mainActivity.getApiAdapter().ftdiRead(fd, temp);
                            if (delta == -1) return ;
                            System.arraycopy(temp,0,dataOut,lenOut,delta);
                            lenOut += delta;
                        }

                        for(int i=0; i<data.length; i++) {
                            rchar[i] = (char)dataOut[i];
                        }


                        mHandler.post(new Runnable() {
                            @Override
                            public void run() {
                                mFTDIDataTextView.setText(String.copyValueOf(rchar,0,data.length));
                            }
                        });

                        mainActivity.getApiAdapter().ftdiClose(fd);
                        updateStatus("Test Completed, Start Again");
                    } else {
                        Log.e(TAG, "Unable to get FD for the path" + selectedUSB.itemName);
                        updateStatus("Invalid FD, Please click Open");
                    }
                } catch (Exception e) {
                    Log.e(TAG, "ttyUSB device Exception - " + selectedUSB.itemName + " !!!" , e);
                }
            }
        }).start();
    }

}
