package com.elotouch.miami.testapp;


import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;


public class CashDrawer extends Fragment {

    public static TextView mCashDrawerStatusTextView;
    private static String TAG = "CashDrawer";
    View rootViewCashDrawer;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        Log.i(TAG, "Inside onCreateView");
        rootViewCashDrawer = inflater.inflate(R.layout.fragment_cash_drawer, container, false);
        mCashDrawerStatusTextView = (TextView) rootViewCashDrawer.findViewById(R.id.cashdrawer_status_txt);

        MainActivity activity = (MainActivity) getActivity();
        if (activity.getInventory().isCashDrawerOpenSenseSettable()) {
            // Some cash drawers indicate open with high voltage, others with low.  We can't tell
            // programmatically, so give the user a way to reverse the indicator.
            //
            // In a normal customer app, this would be settable in a configuration section.  The
            // app would actually go to the printer and configure it there, so that the printer
            // reports the correct value.  But this is just a test app, so we can take shortcuts.
            CheckBox checkBox = (CheckBox) rootViewCashDrawer.findViewById(R.id.cashdrawer_reverse_sensor);
            checkBox.setVisibility(View.VISIBLE);
        }

        return rootViewCashDrawer;
    }

}
