package com.elotouch.miami.testapp;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.DialogInterface;
import android.os.Bundle;

/**
 * Created by elo on 1/16/18.
 */

public class BcrKeyboardModeDialog extends DialogFragment {

    private OkayListener listener;

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        // Use the Builder class for convenient dialog construction
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        builder.setMessage(R.string.set_keyboard_mode_warning)
                .setPositiveButton(R.string.okay_set_keyboard_mode, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        if (listener != null) {
                            listener.onOkayPressed();
                        }
                        dismiss();
                    }
                })
                .setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dismiss();
                    }
                });

        // Create the AlertDialog object and return it
        return builder.create();
    }

    public void setOkayListener(OkayListener listener) {
        this.listener = listener;
    }

    interface OkayListener {
        public void onOkayPressed();
    }
}
