#include <string.h>
#include <jni.h>
#include <stdio.h>
#include <fcntl.h>
#include <termios.h>

int termios_baudrate(jint baudrate) {
    switch (baudrate) {
        case 50:       return B50;
        case 75:       return B75;
        case 110:      return B110;
        case 134:      return B134;
        case 150:      return B150;
        case 200:      return B200;
        case 300:      return B300;
        case 600:      return B600;
        case 1200:     return B1200;
        case 1800:     return B1800;
        case 2400:     return B2400;
        case 4800:     return B4800;
        case 9600:     return B9600;
        case 19200:    return B19200;
        case 38400:    return B38400;
        case 57600:    return B57600;
        case 115200:   return B115200;
        case 230400:   return B230400;
        case 460800:   return B460800;
        case 500000:   return B500000;
        case 576000:   return B576000;
        case 921600:   return B921600;
        case 1000000:  return B1000000;
        case 1152000:  return B1152000;
        case 1500000:  return B1500000;
        case 2000000:  return B2000000;
        case 2500000:  return B2500000;
        case 3000000:  return B3000000;
        case 3500000:  return B3500000;
        case 4000000:  return B4000000;
        default:       return -1;
    }
}

JNIEXPORT int JNICALL
Java_com_elotouch_miami_testapp_apiadapter_FtdiAdapter1_10_open(JNIEnv *env,jobject thisObj,jstring devName, jint speed,jint flag) {

    const char *devname = (*env)->GetStringUTFChars(env, devName, 0);
    int fd = open(devname,O_RDWR );
    if(fd == -1)
        return -1;

    int tio_baudrate = termios_baudrate(speed);
    if(tio_baudrate == -1)
        return -1;

    struct termios tio;
    tcflush(fd , TCIFLUSH);
    if (tcgetattr(fd, &tio))
        memset(&tio, 0, sizeof(tio));

    cfsetispeed(&tio, tio_baudrate);
    cfsetospeed(&tio, tio_baudrate);

    // These flags are required to be set to perform 
    tio.c_cflag &= ~(CSIZE|CSTOPB|PARENB|PARODD|CMSPAR);
    tio.c_cflag &= ~PARENB;
    tio.c_cflag &= ~CSTOPB;
    tio.c_cflag &= ~CSIZE;
    tio.c_cflag |= CS8;
    tio.c_cflag |= (CLOCAL | CREAD);
    tio.c_cflag &= ~CRTSCTS;

    // any extra flags supplied by user
    tio.c_cflag |= flag;
    tcflush(fd, TCOFLUSH);

    if (tcsetattr(fd, TCSANOW, &tio)==-1) {
        return -1;
    }
    return fd;
}

JNIEXPORT int JNICALL
Java_com_elotouch_miami_testapp_apiadapter_FtdiAdapter1_10_write(JNIEnv *env,jobject thisObj,jint fd,jbyteArray buffer, jint length) {

    jbyte* buf = (jbyte *)malloc(length);
    if (!buf) {
        return -1;
    }
    (*env)->GetByteArrayRegion(env,buffer, 0, length, buf);
    jint ret = write(fd, buf, length);
    free(buf);
    if (ret < 0){
        return -1;
    }
    return ret;
}


JNIEXPORT int JNICALL
Java_com_elotouch_miami_testapp_apiadapter_FtdiAdapter1_10_read(JNIEnv *env,jobject thisObj,jint fd,jbyteArray buffer, jint length) {
    jbyte* buf = (jbyte *)malloc(length);
    if (!buf) {
        return -1;
    }
    int ret = read(fd, buf, length);
    if (ret < 0) {
        free(buf);
        return -1;
    }
    else if (ret > 0) {
        (*env)->SetByteArrayRegion(env,buffer, 0, ret, buf);
    }
    free(buf);
    return ret;

}

JNIEXPORT int JNICALL
Java_com_elotouch_miami_testapp_apiadapter_FtdiAdapter1_10_close(JNIEnv *env,jobject thisObj,jint fd) {
    return close(fd);
}
